/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.Entity;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.HasEntityId;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.model.ToStringHelper;

public abstract class EntityClassification<E extends Entity<String>, K, V extends Number>
extends Classification<K, V>
implements HasEntityId,
HasEntityRegistry<E> {
    private E entity = null;
    private Value<V> entityValue = null;

    protected EntityClassification(Classification.Type type, ValueMap<K, V> values) {
        super(type, values);
    }

    @Override
    protected ToStringHelper toStringHelper() {
        ToStringHelper helper = super.toStringHelper().add("entityId", (Object)this.getEntityId());
        return helper;
    }

    public void put(E entity, K key, Value<V> value) {
        Classification.Type type = this.getType();
        if (this.entityValue == null || type.compareValues(value, this.entityValue) > 0) {
            this.setEntity(entity);
            this.entityValue = value;
        }
        this.put(key, value);
    }

    @Override
    public String getEntityId() {
        E entity = this.getEntity();
        return EntityUtil.getId(entity, this);
    }

    public E getEntity() {
        return this.entity;
    }

    protected void setEntity(E entity) {
        if (entity == null) {
            throw new IllegalArgumentException();
        }
        this.entity = entity;
    }
}

