/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collection;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.TypeUtil;

public class ContinuousValue
extends FieldValue {
    ContinuousValue(DataType dataType, Object value) {
        super(dataType, value);
    }

    @Override
    public OpType getOpType() {
        return OpType.CONTINUOUS;
    }

    @Override
    public int compareToString(String string) {
        try {
            return super.compareToString(string);
        }
        catch (NumberFormatException nfeDefault) {
            Number number;
            try {
                number = (Number)TypeUtil.parse(DataType.DOUBLE, string);
            }
            catch (NumberFormatException nfeDouble) {
                throw nfeDefault;
            }
            return ((Comparable)TypeUtil.cast(DataType.DOUBLE, (Object)this.asNumber())).compareTo(number);
        }
    }

    @Override
    public int compareToValue(FieldValue value) {
        return super.compareToValue(value);
    }

    public static ContinuousValue create(DataType dataType, Object value) {
        if (value instanceof Collection) {
            return new ContinuousValue(dataType, value);
        }
        switch (dataType) {
            case INTEGER: {
                return new ContinuousInteger((Integer)value);
            }
            case FLOAT: {
                return new ContinuousFloat((Float)value);
            }
            case DOUBLE: {
                return new ContinuousDouble((Double)value);
            }
        }
        return new ContinuousValue(dataType, value);
    }

    private static class ContinuousDouble
    extends ContinuousValue
    implements FieldValue.Scalar {
        ContinuousDouble(Double value) {
            super(DataType.DOUBLE, value);
        }

        @Override
        public Number asNumber() {
            return (Number)this.getValue();
        }

        @Override
        public Double asDouble() {
            return (Double)this.getValue();
        }
    }

    private static class ContinuousFloat
    extends ContinuousValue
    implements FieldValue.Scalar {
        ContinuousFloat(Float value) {
            super(DataType.FLOAT, value);
        }

        @Override
        public Number asNumber() {
            return (Number)this.getValue();
        }

        @Override
        public Float asFloat() {
            return (Float)this.getValue();
        }
    }

    private static class ContinuousInteger
    extends ContinuousValue
    implements FieldValue.Scalar {
        ContinuousInteger(Integer value) {
            super(DataType.INTEGER, value);
        }

        @Override
        public Number asNumber() {
            return (Number)this.getValue();
        }

        @Override
        public Integer asInteger() {
            return (Integer)this.getValue();
        }
    }
}

