/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.DataType;
import org.jpmml.evaluator.AbstractComputable;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.HasPrediction;
import org.jpmml.evaluator.Report;
import org.jpmml.evaluator.ReportUtil;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.Value;

public class Regression<V extends Number>
extends AbstractComputable
implements HasPrediction {
    private Value<V> value = null;
    private Object result = null;

    protected Regression(Value<V> value) {
        this.setValue(value);
    }

    @Override
    public Object getResult() {
        if (this.result == null) {
            throw new EvaluationException("Regression result has not been computed");
        }
        return this.result;
    }

    protected void setResult(Object result) {
        this.result = result;
    }

    protected void computeResult(DataType dataType) {
        Value<V> value = this.getValue();
        Object result = TypeUtil.cast(dataType, value.getValue());
        this.setResult(result);
    }

    @Override
    public Object getPrediction() {
        return this.getResult();
    }

    @Override
    public Report getPredictionReport() {
        Value<V> value = this.getValue();
        return ReportUtil.getReport(value);
    }

    public Value<V> getValue() {
        return this.value;
    }

    private void setValue(Value<V> value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.value = value;
    }
}

