/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.tree;

import org.dmg.pmml.DataType;
import org.dmg.pmml.tree.Node;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.HasEntityId;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.ToStringHelper;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.Vote;

public abstract class NodeVote
extends Vote
implements HasEntityId,
HasEntityRegistry<Node> {
    private Node node = null;

    NodeVote(Node node) {
        this.setNode(node);
    }

    @Override
    protected void computeResult(DataType dataType) {
        Node node = this.getNode();
        Object result = TypeUtil.parse(dataType, node.getScore());
        this.setResult(result);
    }

    @Override
    protected ToStringHelper toStringHelper() {
        ToStringHelper helper = super.toStringHelper().add("entityId", this.getEntityId());
        return helper;
    }

    @Override
    public String getEntityId() {
        Node node = this.getNode();
        return EntityUtil.getId(node, this);
    }

    public Node getNode() {
        return this.node;
    }

    private void setNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this.node = node;
    }
}

