/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jpmml.evaluator.KeyValueAggregator;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.Vector;

public abstract class VoteAggregator<K, V extends Number>
extends KeyValueAggregator<K, V> {
    public VoteAggregator() {
        super(0);
    }

    public ValueMap<K, V> sumMap() {
        Function function = new Function<Vector<V>, Value<V>>(){

            public Value<V> apply(Vector<V> values) {
                return values.sum();
            }
        };
        return new ValueMap(this.asTransformedMap(function));
    }

    public Set<K> getWinners() {
        LinkedHashSet result = new LinkedHashSet();
        ValueMap<K, V> sumMap = this.sumMap();
        Value maxValue = (Value)Collections.max(sumMap.values());
        Set entries = sumMap.entrySet();
        for (Map.Entry entry : entries) {
            Object key = entry.getKey();
            Value value = (Value)entry.getValue();
            if (maxValue.compareTo(value) != 0) continue;
            result.add(key);
        }
        return result;
    }
}

