/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;

public class OrdinalValue
extends FieldValue {
    private List<?> ordering = null;

    OrdinalValue(DataType dataType, Object value) {
        super(dataType, value);
    }

    @Override
    public OpType getOpType() {
        return OpType.ORDINAL;
    }

    @Override
    public int compareToString(String string) {
        List<?> ordering = this.getOrdering();
        if (ordering == null) {
            return super.compareToString(string);
        }
        return OrdinalValue.compare(ordering, this.getValue(), this.parseValue(string));
    }

    @Override
    public int compareToValue(FieldValue value) {
        List<?> ordering = this.getOrdering();
        if (ordering == null) {
            return super.compareToValue(value);
        }
        return OrdinalValue.compare(ordering, this.getValue(), value.getValue());
    }

    @Override
    public int hashCode() {
        List<?> ordering = this.getOrdering();
        if (ordering == null) {
            return super.hashCode();
        }
        return 31 * super.hashCode() + ordering.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OrdinalValue) {
            OrdinalValue that = (OrdinalValue)object;
            return super.equals(object) && Objects.equals(this.getOrdering(), that.getOrdering());
        }
        return false;
    }

    public List<?> getOrdering() {
        return this.ordering;
    }

    public void setOrdering(List<?> ordering) {
        this.ordering = ordering;
    }

    public static OrdinalValue create(DataType dataType, Object value) {
        if (value instanceof Collection) {
            return new OrdinalValue(dataType, value);
        }
        switch (dataType) {
            case STRING: {
                return new OrdinalString(value);
            }
        }
        return new OrdinalValue(dataType, value);
    }

    private static int compare(List<?> ordering, Object left, Object right) {
        int rightIndex;
        int leftIndex = ordering.indexOf(left);
        if ((leftIndex | (rightIndex = ordering.indexOf(right))) < 0) {
            throw new EvaluationException();
        }
        return leftIndex - rightIndex;
    }

    private static class OrdinalString
    extends OrdinalValue
    implements FieldValue.Scalar {
        OrdinalString(Object value) {
            super(DataType.STRING, value);
        }

        @Override
        public String asString() {
            return (String)this.getValue();
        }
    }
}

