/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.List;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.Row;
import org.jpmml.evaluator.CacheUtil;
import org.w3c.dom.Element;

public class InlineTableUtil {
    private static final LoadingCache<InlineTable, Table<Integer, String, String>> contentCache = CacheUtil.buildLoadingCache(new CacheLoader<InlineTable, Table<Integer, String, String>>(){

        public Table<Integer, String, String> load(InlineTable inlineTable) {
            return Tables.unmodifiableTable(InlineTableUtil.parse(inlineTable));
        }
    });

    private InlineTableUtil() {
    }

    public static Table<Integer, String, String> getContent(InlineTable inlineTable) {
        return CacheUtil.getValue(inlineTable, contentCache);
    }

    static Table<Integer, String, String> parse(InlineTable inlineTable) {
        HashBasedTable result = HashBasedTable.create();
        Integer rowKey = 1;
        List rows = inlineTable.getRows();
        for (Row row : rows) {
            List cells = row.getContent();
            for (Object cell : cells) {
                if (!(cell instanceof Element)) continue;
                Element element = (Element)cell;
                result.put((Object)rowKey, (Object)element.getTagName(), (Object)element.getTextContent());
            }
            rowKey = rowKey + 1;
        }
        return result;
    }
}

