/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.InvalidFeatureException;

public class IndexableUtil {
    private IndexableUtil() {
    }

    public static <K, E extends PMMLObject> E find(K key, List<E> elements) {
        for (PMMLObject element : elements) {
            if (!key.equals(IndexableUtil.ensureKey(element))) continue;
            return (E)element;
        }
        return null;
    }

    public static <K, E extends PMMLObject> List<K> keys(List<E> elements) {
        ArrayList<K> result = new ArrayList<K>(elements.size());
        for (PMMLObject element : elements) {
            result.add(IndexableUtil.ensureKey(element));
        }
        return result;
    }

    public static <K, E extends PMMLObject> ImmutableMap<K, E> buildMap(List<E> elements) {
        LinkedHashMap<K, PMMLObject> result = new LinkedHashMap<K, PMMLObject>();
        for (PMMLObject element : elements) {
            K key = IndexableUtil.ensureKey(element);
            if (result.containsKey(key)) {
                throw new InvalidFeatureException(element);
            }
            result.put(key, element);
        }
        return ImmutableMap.copyOf(result);
    }

    private static <K, E extends PMMLObject> K ensureKey(E element) {
        Object key = ((Indexable)element).getKey();
        if (key == null) {
            throw new InvalidFeatureException(element);
        }
        return (K)key;
    }
}

