/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.TypeCheckException;

public class FunctionRegistry {
    private static final Map<String, Function> functions = new LinkedHashMap<String, Function>();
    private static final Map<String, Class<?>> functionClazzes = new LinkedHashMap();

    private FunctionRegistry() {
    }

    public static Function getFunction(String name) {
        Class<?> functionClazz;
        if (name == null) {
            return null;
        }
        if (functions.containsKey(name)) {
            Function function = functions.get(name);
            return function;
        }
        if (functionClazzes.containsKey(name)) {
            functionClazz = functionClazzes.get(name);
        } else {
            functionClazz = FunctionRegistry.loadFunctionClass(name);
            functionClazzes.put(name, functionClazz);
        }
        if (functionClazz != null) {
            Function function;
            try {
                function = (Function)functionClazz.newInstance();
            }
            catch (ExceptionInInitializerError | IllegalAccessException | InstantiationException e) {
                throw (EvaluationException)new EvaluationException().initCause(e);
            }
            return function;
        }
        return null;
    }

    public static void putFunction(Function function) {
        FunctionRegistry.putFunction(function.getName(), function);
    }

    public static void putFunction(String name, Function function) {
        functions.put(Objects.requireNonNull(name), function);
    }

    public static void putFunction(String name, Class<? extends Function> functionClazz) {
        functionClazzes.put(Objects.requireNonNull(name), FunctionRegistry.checkClass(functionClazz));
    }

    public static void removeFunction(String name) {
        functions.remove(name);
        functionClazzes.remove(name);
    }

    private static Class<?> loadFunctionClass(String name) {
        Class<?> clazz;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = FunctionRegistry.class.getClassLoader();
            }
            clazz = classLoader.loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        return FunctionRegistry.checkClass(clazz);
    }

    private static Class<?> checkClass(Class<?> clazz) {
        if (!Function.class.isAssignableFrom(clazz)) {
            throw new TypeCheckException(Function.class, clazz);
        }
        return clazz;
    }
}

