/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class CsvUtil {
    private CsvUtil() {
    }

    public static Table readTable(InputStream is) throws IOException {
        return CsvUtil.readTable(is, null);
    }

    public static Table readTable(InputStream is, String separator) throws IOException {
        Table table = new Table();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
            String line;
            Splitter splitter = null;
            while ((line = reader.readLine()) != null) {
                if (line.trim().equals("")) {
                    break;
                }
                if (separator == null) {
                    separator = CsvUtil.getSeparator(line);
                }
                if (splitter == null) {
                    splitter = Splitter.on((String)separator);
                }
                ArrayList row = Lists.newArrayList((Iterable)splitter.split((CharSequence)line));
                table.add(row);
            }
        }
        table.setSeparator(separator);
        return table;
    }

    public static void writeTable(Table table, OutputStream os) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));){
            Joiner joiner = Joiner.on((String)table.getSeparator());
            for (int i = 0; i < table.size(); ++i) {
                List row = (List)table.get(i);
                if (i > 0) {
                    writer.write(10);
                }
                writer.write(joiner.join((Iterable)row));
            }
        }
    }

    private static String getSeparator(String line) {
        String[] separators;
        for (String separator : separators = new String[]{"\t", ";", ","}) {
            String[] cells = line.split(separator);
            if (cells.length <= 1) continue;
            return separator;
        }
        throw new IllegalArgumentException();
    }

    public static class Table
    extends ArrayList<List<String>> {
        private String separator = null;

        public Table() {
            super(1024);
        }

        public String getSeparator() {
            return this.separator;
        }

        public void setSeparator(String separator) {
            this.separator = separator;
        }
    }
}

