/*
 * Decompiled with CFR 0.152.
 */
package org.jeometry.geom3D.algorithm.delaunay.clarkson;

import java.util.ArrayList;
import java.util.List;
import org.jeometry.factory.JeometryFactory;
import org.jeometry.geom3D.point.Point3D;
import org.jeometry.geom3D.point.Point3DContainer;
import org.jeometry.geom3D.primitive.indexed.IndexedTetrahedron;

public class DelaunayTetrahedron<T extends Point3D>
implements IndexedTetrahedron<T> {
    List<DelaunayTetrahedron<T>> neighbors = null;
    private boolean[] convexFaces = null;
    private boolean infinite = false;
    private IndexedTetrahedron<T> tetrahedron = null;

    public DelaunayTetrahedron(int vertex1, int vertex2, int vertex3, int vertex4, Point3DContainer<T> source) {
        this(vertex1, vertex2, vertex3, vertex4, true, source);
        this.convexFaces = new boolean[4];
    }

    public DelaunayTetrahedron(int base1, int base2, int base3, int top, boolean validate, Point3DContainer<T> source) {
        this.tetrahedron = JeometryFactory.createIndexedTetrahedron((int)base1, (int)base2, (int)base3, (int)top, source);
        this.neighbors = new ArrayList<DelaunayTetrahedron<T>>(4);
        this.convexFaces = new boolean[4];
    }

    public DelaunayTetrahedron<T> getNeighbor(int vertexIndex) {
        if (vertexIndex > -1 && vertexIndex < 4) {
            return this.neighbors.get(vertexIndex);
        }
        return null;
    }

    public Point3DContainer<T> getVerticesSource() {
        return this.tetrahedron.getVerticesSource();
    }

    public void setVerticesSource(Point3DContainer<T> verticesSource) {
        this.tetrahedron.setVerticesSource(verticesSource);
    }

    public int getVertexIndice(int position) {
        return this.tetrahedron.getVertexIndice(position);
    }

    public Point3D getVertex(int position) {
        return this.tetrahedron.getVertex(position);
    }

    public int getVertexIndex(Point3D vertex) {
        return this.tetrahedron.getVertexIndex(vertex);
    }

    public int[] getVerticesArray() {
        return this.tetrahedron.getVerticesArray();
    }

    public void setNeighbor(int vertexIndex, DelaunayTetrahedron<T> tetrahedron) {
        if (vertexIndex > -1 && vertexIndex < 4) {
            this.neighbors.set(vertexIndex, tetrahedron);
        }
    }

    public boolean isVertex(Point3D point) {
        return this.getVertex(0) == point || this.getVertex(1) == point || this.getVertex(2) == point || this.getVertex(3) == point;
    }

    public boolean isConvexHullFace(int index) {
        boolean convexHull = false;
        if (index >= 0 && index <= 3) {
            convexHull = this.convexFaces[index];
        }
        return convexHull;
    }

    public void setConvexHullFace(int index, boolean isConxehHull) {
        if (index >= 0 && index <= 3) {
            this.convexFaces[index] = isConxehHull;
        }
    }

    public int[] getConvexHullFaces() {
        int i;
        int count = 0;
        int[] faces = null;
        for (i = 0; i < this.convexFaces.length; ++i) {
            if (!this.convexFaces[i]) continue;
            ++count;
        }
        faces = new int[count];
        count = 0;
        for (i = 0; i < this.convexFaces.length; ++i) {
            if (!this.convexFaces[i]) continue;
            faces[count] = i;
            ++count;
        }
        return faces;
    }

    public boolean isConvexHull() {
        return this.convexFaces != null && (this.convexFaces[0] || this.convexFaces[1] || this.convexFaces[2] || this.convexFaces[3]);
    }

    public boolean isInfinite() {
        return this.infinite;
    }

    public void setInfinite(boolean infinite) {
        this.infinite = infinite;
    }
}

