/*
 * Decompiled with CFR 0.152.
 */
package org.jeometry.geom3D.algorithm.delaunay.clarkson;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.jeometry.factory.JeometryFactory;
import org.jeometry.geom3D.algorithm.bounds.AxisAlignedBoundingBox;
import org.jeometry.geom3D.algorithm.delaunay.clarkson.DelaunayClarkson;
import org.jeometry.geom3D.algorithm.delaunay.clarkson.DelaunayException;
import org.jeometry.geom3D.algorithm.delaunay.clarkson.DelaunayTetrahedralization;
import org.jeometry.geom3D.algorithm.delaunay.clarkson.DelaunayTetrahedron;
import org.jeometry.geom3D.point.Point3D;
import org.jeometry.geom3D.point.Point3DContainer;
import org.jeometry.geom3D.primitive.Box;

public class DelaunayClarkson3D<T extends Point3D>
extends DelaunayClarkson {
    private Point3D[] ifinitePoints = null;
    private int originalPointCount = -1;
    private boolean filterInfinite = false;
    private boolean generateInfinite = true;

    public boolean isGenerateInfinite() {
        return this.generateInfinite;
    }

    public void setGenerateInfinite(boolean generateInfinite) {
        this.generateInfinite = generateInfinite;
    }

    public boolean isFilterInfinite() {
        return this.filterInfinite;
    }

    public void setFilterInfinite(boolean filterInfinite) {
        this.filterInfinite = filterInfinite;
    }

    public DelaunayTetrahedralization<T> compute(Point3DContainer<T> points, float scale) throws DelaunayException {
        if (points != null && points.size() > 3) {
            Point3D pt;
            Iterator iter;
            this.originalPointCount = points.size();
            LinkedHashMap<Integer, DelaunayTetrahedron<T>> map = new LinkedHashMap<Integer, DelaunayTetrahedron<T>>();
            double[][] samples = null;
            int i = 0;
            if (this.isGenerateInfinite()) {
                samples = new double[3][points.size() + 8];
                iter = points.iterator();
                pt = null;
                i = 0;
                while (iter.hasNext()) {
                    pt = (Point3D)iter.next();
                    samples[0][i] = pt.getX();
                    samples[1][i] = pt.getY();
                    samples[2][i] = pt.getZ();
                    ++i;
                }
                Box box = AxisAlignedBoundingBox.computeAxisAlignedBoundingBox(points);
                double boxXMax = box.getMax().getX() * (double)scale * 10.0;
                double boxYMax = box.getMax().getY() * (double)scale * 10.0;
                double boxZMax = box.getMax().getZ() * (double)scale * 10.0;
                double boxXMin = box.getMin().getX() * (double)scale * 10.0;
                double boxYMin = box.getMin().getY() * (double)scale * 10.0;
                double boxZMin = box.getMin().getZ() * (double)scale * 10.0;
                this.ifinitePoints = new Point3D[8];
                this.ifinitePoints[0] = JeometryFactory.createPoint3D((double)boxXMin, (double)boxYMin, (double)boxZMin);
                this.ifinitePoints[1] = JeometryFactory.createPoint3D((double)boxXMin, (double)boxYMin, (double)boxZMax);
                this.ifinitePoints[2] = JeometryFactory.createPoint3D((double)boxXMin, (double)boxYMax, (double)boxZMin);
                this.ifinitePoints[3] = JeometryFactory.createPoint3D((double)boxXMin, (double)boxYMax, (double)boxZMax);
                this.ifinitePoints[4] = JeometryFactory.createPoint3D((double)boxXMax, (double)boxYMin, (double)boxZMin);
                this.ifinitePoints[5] = JeometryFactory.createPoint3D((double)boxXMax, (double)boxYMin, (double)boxZMax);
                this.ifinitePoints[6] = JeometryFactory.createPoint3D((double)boxXMax, (double)boxYMax, (double)boxZMin);
                this.ifinitePoints[7] = JeometryFactory.createPoint3D((double)boxXMax, (double)boxYMax, (double)boxZMax);
                samples[0][points.size()] = boxXMin;
                samples[1][points.size()] = boxYMin;
                samples[2][points.size()] = boxZMin;
                samples[0][points.size() + 1] = boxXMin;
                samples[1][points.size() + 1] = boxYMin;
                samples[2][points.size() + 1] = boxZMax;
                samples[0][points.size() + 2] = boxXMin;
                samples[1][points.size() + 2] = boxYMax;
                samples[2][points.size() + 2] = boxZMin;
                samples[0][points.size() + 3] = boxXMin;
                samples[1][points.size() + 3] = boxYMax;
                samples[2][points.size() + 3] = boxZMax;
                samples[0][points.size() + 4] = boxXMax;
                samples[1][points.size() + 4] = boxYMin;
                samples[2][points.size() + 4] = boxZMin;
                samples[0][points.size() + 5] = boxXMax;
                samples[1][points.size() + 5] = boxYMin;
                samples[2][points.size() + 5] = boxZMax;
                samples[0][points.size() + 6] = boxXMax;
                samples[1][points.size() + 6] = boxYMax;
                samples[2][points.size() + 6] = boxZMin;
                samples[0][points.size() + 7] = boxXMax;
                samples[1][points.size() + 7] = boxYMax;
                samples[2][points.size() + 7] = boxZMax;
            } else {
                samples = new double[3][points.size()];
                iter = points.iterator();
                pt = null;
                i = 0;
                while (iter.hasNext()) {
                    pt = (Point3D)iter.next();
                    samples[0][i] = pt.getX();
                    samples[1][i] = pt.getY();
                    samples[2][i] = pt.getZ();
                    ++i;
                }
            }
            System.out.print("Computing delaunay");
            long s = System.currentTimeMillis();
            this.compute(samples, scale);
            System.out.println("  [" + (double)(System.currentTimeMillis() - s) / 1000.0 + "s]");
            System.out.print("Generating tetrahedra");
            s = System.currentTimeMillis();
            DelaunayTetrahedralization<T> result = new DelaunayTetrahedralization<T>(points, this.getSimplexes().length);
            DelaunayTetrahedron<T> tetrahedron = null;
            for (i = 0; i < this.getSimplexes().length; ++i) {
                tetrahedron = new DelaunayTetrahedron<T>(this.getSimplexes()[i][0], this.getSimplexes()[i][1], this.getSimplexes()[i][2], this.getSimplexes()[i][3], true, points);
                map.put(i, tetrahedron);
                tetrahedron.setInfinite(this.isInfinite(this.getSimplexes()[i]));
                tetrahedron = this.isFilterInfinite() && !tetrahedron.isInfinite() ? result.addTetrahedron(tetrahedron) : result.addTetrahedron(tetrahedron);
            }
            for (i = 0; i < this.getVertices().length - 8; ++i) {
                if (this.getVertices()[i] != null) {
                    for (int j = 0; j < this.getVertices()[i].length; ++j) {
                        tetrahedron = (DelaunayTetrahedron)map.get(this.getVertices()[i][j]);
                        if (!(this.getVertices()[i][j] <= -1 || this.isFilterInfinite() && tetrahedron.isInfinite())) {
                            result.addIndicentTetrahedron(points.get(i), tetrahedron);
                        }
                        tetrahedron = null;
                    }
                    continue;
                }
                result.addIndicentTetrahedron(points.get(i), (DelaunayTetrahedron)null);
            }
            ArrayList neighbors = new ArrayList(4);
            DelaunayTetrahedron candidate = null;
            int index = -1;
            for (i = 0; i < this.getNeighbors().length; ++i) {
                tetrahedron = (DelaunayTetrahedron<T>)map.get(i);
                if (this.getNeighbors()[i] != null && this.getNeighbors()[i].length > 0) {
                    for (int j = 0; j < 4; ++j) {
                        if (this.getNeighbors()[i][j] > -1) {
                            candidate = (DelaunayTetrahedron)map.get(this.getNeighbors()[i][j]);
                            index = this.getDifferentVertex(tetrahedron, candidate);
                            if (this.isFilterInfinite()) {
                                if (!candidate.isInfinite()) {
                                    neighbors.set(index, candidate);
                                    continue;
                                }
                                neighbors.set(index, null);
                                tetrahedron.setConvexHullFace(index, true);
                                continue;
                            }
                            neighbors.set(index, candidate);
                            continue;
                        }
                        neighbors.set(j, null);
                    }
                    result.setNeighbors(tetrahedron, neighbors);
                    continue;
                }
                result.setNeighbors(tetrahedron, null);
            }
            System.out.println("  [" + (double)(System.currentTimeMillis() - s) / 1000.0 + "s]");
            neighbors.set(0, null);
            neighbors.set(1, null);
            neighbors.set(2, null);
            neighbors.set(3, null);
            neighbors = null;
            return result;
        }
        throw new DelaunayException("Cannot triangulate less than 3 points");
    }

    private int getDifferentVertex(DelaunayTetrahedron<T> t1, DelaunayTetrahedron<T> t2) {
        int index = -1;
        for (int i = 0; i < 4 && index == -1; ++i) {
            if (t1.getVertexIndice(i) == t2.getVertexIndice(0) || t1.getVertexIndice(i) == t2.getVertexIndice(1) || t1.getVertexIndice(i) == t2.getVertexIndice(2) || t1.getVertexIndice(i) == t2.getVertexIndice(3)) continue;
            index = i;
        }
        return index;
    }

    private boolean isInfinite(int[] indices) {
        boolean infinite = false;
        infinite = indices != null ? indices[0] >= this.originalPointCount || indices[1] >= this.originalPointCount || indices[2] >= this.originalPointCount || indices[3] >= this.originalPointCount : false;
        return infinite;
    }
}

