/*
 * Decompiled with CFR 0.152.
 */
package org.jeometry.geom3D.algorithm.delaunay.clarkson;

import org.jeometry.geom3D.algorithm.delaunay.clarkson.DelaunayException;

public class DelaunayClarkson {
    protected double[][] samples = null;
    private int[][] simplexes;
    private int[][] vertices;
    private int[][] neighbors;
    private int[][] Edges;
    private int NumEdges;
    private static final double DBL_MANT_DIG = 53.0;
    private static final double FLT_RADIX = 2.0;
    private static final double DBL_EPSILON = 2.220446049250313E-16;
    private static final double ln2 = Math.log(2.0);
    private static final int INFINITY = -2;
    private static final int NOVAL = -1;
    private double[][] site_blocks;
    private int[][] a3s;
    private int a3size;
    private int nts = 0;
    private static final int max_blocks = 10000;
    private static final int Nobj = 10000;
    private static final int MAXDIM = 8;
    private int dim;
    private int p;
    private long pnum;
    private int rdim;
    private int cdim;
    private int exact_bits;
    private double b_err_min;
    private double b_err_min_sq;
    private double ldetbound = 0.0;
    private int failcount = 0;
    private int lscale;
    private double max_scale;
    private int nsb = 0;
    private int nbb = 0;
    private int ss = 8;
    private int ss2 = 2000;
    private long vnum = -1L;
    private final int[] voidp = new int[1];
    private final int[] voidp_bn = new int[1];
    private int[][] bbt_next = new int[10000][];
    private int[][] bbt_next_bn = new int[10000][];
    private int[][] bbt_ref_count = new int[10000][];
    private int[][] bbt_lscale = new int[10000][];
    private double[][] bbt_sqa = new double[10000][];
    private double[][] bbt_sqb = new double[10000][];
    private double[][][] bbt_vecs = new double[10000][][];
    private int ttbp;
    private int ttbp_bn;
    private int ib;
    private int ib_bn;
    private int basis_s_list = -1;
    private int basis_s_list_bn;
    private int pnb = -1;
    private int pnb_bn;
    private int b = -1;
    private int b_bn;
    private int[][] sbt_next = new int[10000][];
    private int[][] sbt_next_bn = new int[10000][];
    private long[][] sbt_visit = new long[10000][];
    private short[][] sbt_mark = new short[10000][];
    private int[][] sbt_normal = new int[10000][];
    private int[][] sbt_normal_bn = new int[10000][];
    private int[][] sbt_peak_vert = new int[10000][];
    private int[][] sbt_peak_simp = new int[10000][];
    private int[][] sbt_peak_simp_bn = new int[10000][];
    private int[][] sbt_peak_basis = new int[10000][];
    private int[][] sbt_peak_basis_bn = new int[10000][];
    private int[][][] sbt_neigh_vert = new int[10000][][];
    private int[][][] sbt_neigh_simp = new int[10000][][];
    private int[][][] sbt_neigh_simp_bn = new int[10000][][];
    private int[][][] sbt_neigh_basis = new int[10000][][];
    private int[][][] sbt_neigh_basis_bn = new int[10000][][];
    private int simplex_list = -1;
    private int simplex_list_bn;
    private int ch_root;
    private int ch_root_bn;
    private int ns;
    private int ns_bn;
    private int[] st = new int[this.ss + 8 + 1];
    private int[] st_bn = new int[this.ss + 8 + 1];
    private int[] st2 = new int[this.ss2 + 8 + 1];
    private int[] st2_bn = new int[this.ss2 + 8 + 1];

    public double[][] getSamples() {
        return this.samples;
    }

    public void setSamples(double[][] samples) {
        this.samples = samples;
    }

    public int[][] getSimplexes() {
        return this.simplexes;
    }

    public int[][] getVertices() {
        return this.vertices;
    }

    public int[][] getNeighbors() {
        return this.neighbors;
    }

    private int new_block_basis_s() {
        int i;
        this.bbt_next[this.nbb] = new int[10000];
        this.bbt_next_bn[this.nbb] = new int[10000];
        this.bbt_ref_count[this.nbb] = new int[10000];
        this.bbt_lscale[this.nbb] = new int[10000];
        this.bbt_sqa[this.nbb] = new double[10000];
        this.bbt_sqb[this.nbb] = new double[10000];
        this.bbt_vecs[this.nbb] = new double[2 * this.rdim][];
        for (i = 0; i < 2 * this.rdim; ++i) {
            this.bbt_vecs[this.nbb][i] = new double[10000];
        }
        for (i = 0; i < 10000; ++i) {
            this.bbt_next[this.nbb][i] = i + 1;
            this.bbt_next_bn[this.nbb][i] = this.nbb;
            this.bbt_ref_count[this.nbb][i] = 0;
            this.bbt_lscale[this.nbb][i] = 0;
            this.bbt_sqa[this.nbb][i] = 0.0;
            this.bbt_sqb[this.nbb][i] = 0.0;
            for (int j = 0; j < 2 * this.rdim; ++j) {
                this.bbt_vecs[this.nbb][j][i] = 0.0;
            }
        }
        this.bbt_next[this.nbb][9999] = -1;
        this.basis_s_list = 0;
        this.basis_s_list_bn = this.nbb++;
        return this.basis_s_list;
    }

    private int reduce_inner(int v, int v_bn, int s, int s_bn, int k) {
        int i;
        double Sb = 0.0;
        this.bbt_sqa[v_bn][v] = 0.0;
        for (i = 0; i < this.rdim; ++i) {
            double[] dArray = this.bbt_sqa[v_bn];
            int n = v;
            dArray[n] = dArray[n] + this.bbt_vecs[v_bn][i][v] * this.bbt_vecs[v_bn][i][v];
        }
        this.bbt_sqb[v_bn][v] = this.bbt_sqa[v_bn][v];
        if (k <= 1) {
            for (i = 0; i < this.rdim; ++i) {
                this.bbt_vecs[v_bn][i][v] = this.bbt_vecs[v_bn][this.rdim + i][v];
            }
            return 1;
        }
        for (int j = 0; j < 250; ++j) {
            double scale;
            int l;
            double dd;
            int q_bn;
            int q;
            int i2;
            int xx = this.rdim;
            for (i2 = 0; i2 < this.rdim; ++i2) {
                this.bbt_vecs[v_bn][i2][v] = this.bbt_vecs[v_bn][this.rdim + i2][v];
            }
            for (i2 = k - 1; i2 > 0; --i2) {
                q = this.sbt_neigh_basis[s_bn][i2][s];
                q_bn = this.sbt_neigh_basis_bn[s_bn][i2][s];
                dd = 0.0;
                for (l = 0; l < this.rdim; ++l) {
                    dd -= this.bbt_vecs[q_bn][l][q] * this.bbt_vecs[v_bn][l][v];
                }
                dd /= this.bbt_sqb[q_bn][q];
                for (l = 0; l < this.rdim; ++l) {
                    double[] dArray = this.bbt_vecs[v_bn][l];
                    int n = v;
                    dArray[n] = dArray[n] + dd * this.bbt_vecs[q_bn][this.rdim + l][q];
                }
            }
            this.bbt_sqb[v_bn][v] = 0.0;
            for (i2 = 0; i2 < this.rdim; ++i2) {
                double[] dArray = this.bbt_sqb[v_bn];
                int n = v;
                dArray[n] = dArray[n] + this.bbt_vecs[v_bn][i2][v] * this.bbt_vecs[v_bn][i2][v];
            }
            this.bbt_sqa[v_bn][v] = 0.0;
            for (i2 = 0; i2 < this.rdim; ++i2) {
                double[] dArray = this.bbt_sqa[v_bn];
                int n = v;
                dArray[n] = dArray[n] + this.bbt_vecs[v_bn][this.rdim + i2][v] * this.bbt_vecs[v_bn][this.rdim + i2][v];
            }
            if (2.0 * this.bbt_sqb[v_bn][v] >= this.bbt_sqa[v_bn][v]) {
                return 1;
            }
            if (j < 10) {
                double labound = Math.floor(Math.log(this.bbt_sqa[v_bn][v]) / ln2) / 2.0;
                this.max_scale = (double)this.exact_bits - labound - 0.66 * (double)(k - 2) - 1.0;
                if (this.max_scale < 1.0) {
                    this.max_scale = 1.0;
                }
                if (j == 0) {
                    this.ldetbound = 0.0;
                    Sb = 0.0;
                    for (int l2 = k - 1; l2 > 0; --l2) {
                        q = this.sbt_neigh_basis[s_bn][l2][s];
                        q_bn = this.sbt_neigh_basis_bn[s_bn][l2][s];
                        Sb += this.bbt_sqb[q_bn][q];
                        this.ldetbound += Math.floor(Math.log(this.bbt_sqb[q_bn][q]) / ln2) / 2.0 + 1.0;
                        this.ldetbound -= (double)this.bbt_lscale[q_bn][q];
                    }
                }
            }
            if (this.ldetbound - (double)this.bbt_lscale[v_bn][v] + Math.floor(Math.log(this.bbt_sqb[v_bn][v]) / ln2) / 2.0 + 1.0 < 0.0) {
                scale = 0.0;
            } else {
                this.lscale = (int)(Math.log(2.0 * Sb / (this.bbt_sqb[v_bn][v] + this.bbt_sqa[v_bn][v] * this.b_err_min)) / ln2) / 2;
                if ((double)this.lscale > this.max_scale) {
                    this.lscale = (int)this.max_scale;
                } else if (this.lscale < 0) {
                    this.lscale = 0;
                }
                int[] nArray = this.bbt_lscale[v_bn];
                int n = v;
                nArray[n] = nArray[n] + this.lscale;
                double d = scale = this.lscale < 20 ? (double)(1 << this.lscale) : Math.pow(2.0, this.lscale);
            }
            while (xx < 2 * this.rdim) {
                double[] dArray = this.bbt_vecs[v_bn][xx++];
                int n = v;
                dArray[n] = dArray[n] * scale;
            }
            for (i2 = k - 1; i2 > 0; --i2) {
                q = this.sbt_neigh_basis[s_bn][i2][s];
                q_bn = this.sbt_neigh_basis_bn[s_bn][i2][s];
                dd = 0.0;
                for (l = 0; l < this.rdim; ++l) {
                    dd -= this.bbt_vecs[q_bn][l][q] * this.bbt_vecs[v_bn][this.rdim + l][v];
                }
                dd /= this.bbt_sqb[q_bn][q];
                dd = Math.floor(dd + 0.5);
                for (l = 0; l < this.rdim; ++l) {
                    double[] dArray = this.bbt_vecs[v_bn][this.rdim + l];
                    int n = v;
                    dArray[n] = dArray[n] + dd * this.bbt_vecs[q_bn][this.rdim + l][q];
                }
            }
        }
        if (this.failcount++ < 10) {
            System.out.println("reduce_inner failed!");
        }
        return 0;
    }

    private int reduce(int[] v, int[] v_bn, int rp, int s, int s_bn, int k) {
        if (v[0] == -1) {
            v[0] = this.basis_s_list != -1 ? this.basis_s_list : this.new_block_basis_s();
            v_bn[0] = this.basis_s_list_bn;
            this.basis_s_list = this.bbt_next[v_bn[0]][v[0]];
            this.basis_s_list_bn = this.bbt_next_bn[v_bn[0]][v[0]];
            this.bbt_ref_count[v_bn[0]][v[0]] = 1;
        } else {
            this.bbt_lscale[v_bn[0]][v[0]] = 0;
        }
        if (rp == -2) {
            this.bbt_next[v_bn[0]][v[0]] = this.bbt_next[this.ib_bn][this.ib];
            this.bbt_next_bn[v_bn[0]][v[0]] = this.bbt_next_bn[this.ib_bn][this.ib];
            this.bbt_ref_count[v_bn[0]][v[0]] = this.bbt_ref_count[this.ib_bn][this.ib];
            this.bbt_lscale[v_bn[0]][v[0]] = this.bbt_lscale[this.ib_bn][this.ib];
            this.bbt_sqa[v_bn[0]][v[0]] = this.bbt_sqa[this.ib_bn][this.ib];
            this.bbt_sqb[v_bn[0]][v[0]] = this.bbt_sqb[this.ib_bn][this.ib];
            for (int i = 0; i < 2 * this.rdim; ++i) {
                this.bbt_vecs[v_bn[0]][i][v[0]] = this.bbt_vecs[this.ib_bn][i][this.ib];
            }
        } else {
            int i;
            double sum = 0.0;
            int sbt_nv = this.sbt_neigh_vert[s_bn][0][s];
            if (sbt_nv == -2) {
                for (i = 0; i < this.dim; ++i) {
                    double d = this.site_blocks[i][rp];
                    this.bbt_vecs[v_bn[0]][i][v[0]] = d;
                    this.bbt_vecs[v_bn[0]][i + this.rdim][v[0]] = d;
                }
            } else {
                for (i = 0; i < this.dim; ++i) {
                    double d = this.site_blocks[i][rp] - this.site_blocks[i][sbt_nv];
                    this.bbt_vecs[v_bn[0]][i][v[0]] = d;
                    this.bbt_vecs[v_bn[0]][i + this.rdim][v[0]] = d;
                }
            }
            for (i = 0; i < this.dim; ++i) {
                sum += this.bbt_vecs[v_bn[0]][i][v[0]] * this.bbt_vecs[v_bn[0]][i][v[0]];
            }
            this.bbt_vecs[v_bn[0]][2 * this.rdim - 1][v[0]] = sum;
            this.bbt_vecs[v_bn[0]][this.rdim - 1][v[0]] = sum;
        }
        return this.reduce_inner(v[0], v_bn[0], s, s_bn, k);
    }

    private void get_basis_sede(int s, int s_bn) {
        int q_bn;
        int q;
        int k;
        int[] curt = new int[1];
        int[] curt_bn = new int[1];
        if (this.sbt_neigh_vert[s_bn][0][s] == -2 && this.cdim > 1) {
            int t_vert = this.sbt_neigh_vert[s_bn][0][s];
            int t_simp = this.sbt_neigh_simp[s_bn][0][s];
            int t_simp_bn = this.sbt_neigh_simp_bn[s_bn][0][s];
            int t_basis = this.sbt_neigh_basis[s_bn][0][s];
            int t_basis_bn = this.sbt_neigh_basis_bn[s_bn][0][s];
            this.sbt_neigh_vert[s_bn][0][s] = this.sbt_neigh_vert[s_bn][k][s];
            this.sbt_neigh_simp[s_bn][0][s] = this.sbt_neigh_simp[s_bn][k][s];
            this.sbt_neigh_simp_bn[s_bn][0][s] = this.sbt_neigh_simp_bn[s_bn][k][s];
            this.sbt_neigh_basis[s_bn][0][s] = this.sbt_neigh_basis[s_bn][k][s];
            this.sbt_neigh_basis_bn[s_bn][0][s] = this.sbt_neigh_basis_bn[s_bn][k][s];
            this.sbt_neigh_vert[s_bn][k][s] = t_vert;
            this.sbt_neigh_simp[s_bn][k][s] = t_simp;
            this.sbt_neigh_simp_bn[s_bn][k][s] = t_simp_bn;
            this.sbt_neigh_basis[s_bn][k][s] = t_basis;
            this.sbt_neigh_basis_bn[s_bn][k][s] = t_basis_bn;
            q = this.sbt_neigh_basis[s_bn][0][s];
            q_bn = this.sbt_neigh_basis_bn[s_bn][0][s];
            if (q != -1) {
                int[] nArray = this.bbt_ref_count[q_bn];
                int n = q;
                nArray[n] = nArray[n] - 1;
                if (nArray[n] == 0) {
                    this.bbt_next[q_bn][q] = this.basis_s_list;
                    this.bbt_next_bn[q_bn][q] = this.basis_s_list_bn;
                    this.bbt_ref_count[q_bn][q] = 0;
                    this.bbt_lscale[q_bn][q] = 0;
                    this.bbt_sqa[q_bn][q] = 0.0;
                    this.bbt_sqb[q_bn][q] = 0.0;
                    for (int j = 0; j < 2 * this.rdim; ++j) {
                        this.bbt_vecs[q_bn][j][q] = 0.0;
                    }
                    this.basis_s_list = q;
                    this.basis_s_list_bn = q_bn;
                }
            }
            this.sbt_neigh_basis[s_bn][0][s] = this.ttbp;
            this.sbt_neigh_basis_bn[s_bn][0][s] = this.ttbp_bn;
            int[] nArray = this.bbt_ref_count[this.ttbp_bn];
            int n = this.ttbp;
            nArray[n] = nArray[n] + 1;
        } else if (this.sbt_neigh_basis[s_bn][0][s] == -1) {
            this.sbt_neigh_basis[s_bn][0][s] = this.ttbp;
            this.sbt_neigh_basis_bn[s_bn][0][s] = this.ttbp_bn;
            int[] nArray = this.bbt_ref_count[this.ttbp_bn];
            int n = this.ttbp;
            nArray[n] = nArray[n] + 1;
        } else {
            for (k = 1; k < this.cdim && this.sbt_neigh_basis[s_bn][k][s] != -1; ++k) {
            }
        }
        while (k < this.cdim) {
            q = this.sbt_neigh_basis[s_bn][k][s];
            q_bn = this.sbt_neigh_basis_bn[s_bn][k][s];
            if (q != -1) {
                int[] nArray = this.bbt_ref_count[q_bn];
                int n = q;
                nArray[n] = nArray[n] - 1;
                if (nArray[n] == 0) {
                    this.bbt_next[q_bn][q] = this.basis_s_list;
                    this.bbt_next_bn[q_bn][q] = this.basis_s_list_bn;
                    this.bbt_ref_count[q_bn][q] = 0;
                    this.bbt_lscale[q_bn][q] = 0;
                    this.bbt_sqa[q_bn][q] = 0.0;
                    this.bbt_sqb[q_bn][q] = 0.0;
                    for (int j = 0; j < 2 * this.rdim; ++j) {
                        this.bbt_vecs[q_bn][j][q] = 0.0;
                    }
                    this.basis_s_list = q;
                    this.basis_s_list_bn = q_bn;
                }
            }
            this.sbt_neigh_basis[s_bn][k][s] = -1;
            curt[0] = this.sbt_neigh_basis[s_bn][k][s];
            curt_bn[0] = this.sbt_neigh_basis_bn[s_bn][k][s];
            this.reduce(curt, curt_bn, this.sbt_neigh_vert[s_bn][k][s], s, s_bn, k);
            this.sbt_neigh_basis[s_bn][k][s] = curt[0];
            this.sbt_neigh_basis_bn[s_bn][k][s] = curt_bn[0];
            ++k;
        }
    }

    private int sees(int rp, int s, int s_bn) {
        int l;
        int i;
        int q_bn;
        int q;
        int[] curt = new int[1];
        int[] curt_bn = new int[1];
        if (this.b == -1) {
            this.b = this.basis_s_list != -1 ? this.basis_s_list : this.new_block_basis_s();
            this.b_bn = this.basis_s_list_bn;
            this.basis_s_list = this.bbt_next[this.b_bn][this.b];
            this.basis_s_list_bn = this.bbt_next_bn[this.b_bn][this.b];
        } else {
            this.bbt_lscale[this.b_bn][this.b] = 0;
        }
        if (this.cdim == 0) {
            return 0;
        }
        if (this.sbt_normal[s_bn][s] == -1) {
            int j;
            int m;
            this.get_basis_sede(s, s_bn);
            if (this.rdim == 3 && this.cdim == 3) {
                this.sbt_normal[s_bn][s] = this.basis_s_list != -1 ? this.basis_s_list : this.new_block_basis_s();
                this.sbt_normal_bn[s_bn][s] = this.basis_s_list_bn;
                q = this.sbt_normal[s_bn][s];
                q_bn = this.sbt_normal_bn[s_bn][s];
                this.basis_s_list = this.bbt_next[q_bn][q];
                this.basis_s_list_bn = this.bbt_next_bn[q_bn][q];
                int q1 = this.sbt_neigh_basis[s_bn][1][s];
                int q1_bn = this.sbt_neigh_basis_bn[s_bn][1][s];
                int q2 = this.sbt_neigh_basis[s_bn][2][s];
                int q2_bn = this.sbt_neigh_basis_bn[s_bn][2][s];
                this.bbt_ref_count[q_bn][q] = 1;
                this.bbt_vecs[q_bn][0][q] = this.bbt_vecs[q1_bn][1][q1] * this.bbt_vecs[q2_bn][2][q2] - this.bbt_vecs[q1_bn][2][q1] * this.bbt_vecs[q2_bn][1][q2];
                this.bbt_vecs[q_bn][1][q] = this.bbt_vecs[q1_bn][2][q1] * this.bbt_vecs[q2_bn][0][q2] - this.bbt_vecs[q1_bn][0][q1] * this.bbt_vecs[q2_bn][2][q2];
                this.bbt_vecs[q_bn][2][q] = this.bbt_vecs[q1_bn][0][q1] * this.bbt_vecs[q2_bn][1][q2] - this.bbt_vecs[q1_bn][1][q1] * this.bbt_vecs[q2_bn][0][q2];
                this.bbt_sqb[q_bn][q] = 0.0;
                for (i = 0; i < this.rdim; ++i) {
                    double[] dArray = this.bbt_sqb[q_bn];
                    int n = q;
                    dArray[n] = dArray[n] + this.bbt_vecs[q_bn][i][q] * this.bbt_vecs[q_bn][i][q];
                }
                for (i = this.cdim + 1; i > 0; --i) {
                    m = i > 1 ? this.sbt_neigh_vert[this.ch_root_bn][i - 2][this.ch_root] : -2;
                    for (j = 0; j < this.cdim && m != this.sbt_neigh_vert[s_bn][j][s]; ++j) {
                    }
                    if (j < this.cdim || (m == -2 ? this.bbt_vecs[q_bn][2][q] > -this.b_err_min : this.sees(m, s, s_bn) == 0)) continue;
                    this.bbt_vecs[q_bn][0][q] = -this.bbt_vecs[q_bn][0][q];
                    this.bbt_vecs[q_bn][1][q] = -this.bbt_vecs[q_bn][1][q];
                    this.bbt_vecs[q_bn][2][q] = -this.bbt_vecs[q_bn][2][q];
                    break;
                }
            } else {
                for (i = this.cdim + 1; i > 0; --i) {
                    m = i > 1 ? this.sbt_neigh_vert[this.ch_root_bn][i - 2][this.ch_root] : -2;
                    for (j = 0; j < this.cdim && m != this.sbt_neigh_vert[s_bn][j][s]; ++j) {
                    }
                    if (j < this.cdim) continue;
                    curt[0] = this.sbt_normal[s_bn][s];
                    curt_bn[0] = this.sbt_normal_bn[s_bn][s];
                    this.reduce(curt, curt_bn, m, s, s_bn, this.cdim);
                    int n = curt[0];
                    this.sbt_normal[s_bn][s] = n;
                    q = n;
                    int n2 = curt_bn[0];
                    this.sbt_normal_bn[s_bn][s] = n2;
                    q_bn = n2;
                    if (this.bbt_sqb[q_bn][q] == 0.0) {
                        continue;
                    }
                    break;
                }
            }
            for (i = 0; i < this.cdim; ++i) {
                q = this.sbt_neigh_basis[s_bn][i][s];
                q_bn = this.sbt_neigh_basis_bn[s_bn][i][s];
                if (q != -1) {
                    int[] nArray = this.bbt_ref_count[q_bn];
                    int n = q;
                    nArray[n] = nArray[n] - 1;
                    if (nArray[n] == 0) {
                        this.bbt_next[q_bn][q] = this.basis_s_list;
                        this.bbt_next_bn[q_bn][q] = this.basis_s_list_bn;
                        this.bbt_ref_count[q_bn][q] = 0;
                        this.bbt_lscale[q_bn][q] = 0;
                        this.bbt_sqa[q_bn][q] = 0.0;
                        this.bbt_sqb[q_bn][q] = 0.0;
                        for (int l2 = 0; l2 < 2 * this.rdim; ++l2) {
                            this.bbt_vecs[q_bn][l2][q] = 0.0;
                        }
                        this.basis_s_list = q;
                        this.basis_s_list_bn = q_bn;
                    }
                }
                this.sbt_neigh_basis[s_bn][i][s] = -1;
            }
        }
        if (rp == -2) {
            this.bbt_next[this.b_bn][this.b] = this.bbt_next[this.ib_bn][this.ib];
            this.bbt_next_bn[this.b_bn][this.b] = this.bbt_next_bn[this.ib_bn][this.ib];
            this.bbt_ref_count[this.b_bn][this.b] = this.bbt_ref_count[this.ib_bn][this.ib];
            this.bbt_lscale[this.b_bn][this.b] = this.bbt_lscale[this.ib_bn][this.ib];
            this.bbt_sqa[this.b_bn][this.b] = this.bbt_sqa[this.ib_bn][this.ib];
            this.bbt_sqb[this.b_bn][this.b] = this.bbt_sqb[this.ib_bn][this.ib];
            for (i = 0; i < 2 * this.rdim; ++i) {
                this.bbt_vecs[this.b_bn][i][this.b] = this.bbt_vecs[this.ib_bn][i][this.ib];
            }
        } else {
            double sum = 0.0;
            int sbt_nv = this.sbt_neigh_vert[s_bn][0][s];
            if (sbt_nv == -2) {
                for (l = 0; l < this.dim; ++l) {
                    double d = this.site_blocks[l][rp];
                    this.bbt_vecs[this.b_bn][l][this.b] = d;
                    this.bbt_vecs[this.b_bn][l + this.rdim][this.b] = d;
                }
            } else {
                for (l = 0; l < this.dim; ++l) {
                    double d = this.site_blocks[l][rp] - this.site_blocks[l][sbt_nv];
                    this.bbt_vecs[this.b_bn][l][this.b] = d;
                    this.bbt_vecs[this.b_bn][l + this.rdim][this.b] = d;
                }
            }
            for (l = 0; l < this.dim; ++l) {
                sum += this.bbt_vecs[this.b_bn][l][this.b] * this.bbt_vecs[this.b_bn][l][this.b];
            }
            double d = sum;
            this.bbt_vecs[this.b_bn][this.rdim - 1][this.b] = d;
            this.bbt_vecs[this.b_bn][2 * this.rdim - 1][this.b] = d;
        }
        q = this.sbt_normal[s_bn][s];
        q_bn = this.sbt_normal_bn[s_bn][s];
        for (int i2 = 0; i2 < 3; ++i2) {
            double sum = 0.0;
            double dd = 0.0;
            for (l = 0; l < this.rdim; ++l) {
                dd += this.bbt_vecs[this.b_bn][l][this.b] * this.bbt_vecs[q_bn][l][q];
            }
            if (dd == 0.0) {
                return 0;
            }
            for (l = 0; l < this.rdim; ++l) {
                sum += this.bbt_vecs[this.b_bn][l][this.b] * this.bbt_vecs[this.b_bn][l][this.b];
            }
            double dds = dd * dd / this.bbt_sqb[q_bn][q] / sum;
            if (dds > this.b_err_min_sq) {
                return dd < 0.0 ? 1 : 0;
            }
            this.get_basis_sede(s, s_bn);
            this.reduce_inner(this.b, this.b_bn, s, s_bn, this.cdim);
        }
        return 0;
    }

    private int new_block_simplex() {
        int i;
        this.sbt_next[this.nsb] = new int[10000];
        this.sbt_next_bn[this.nsb] = new int[10000];
        this.sbt_visit[this.nsb] = new long[10000];
        this.sbt_mark[this.nsb] = new short[10000];
        this.sbt_normal[this.nsb] = new int[10000];
        this.sbt_normal_bn[this.nsb] = new int[10000];
        this.sbt_peak_vert[this.nsb] = new int[10000];
        this.sbt_peak_simp[this.nsb] = new int[10000];
        this.sbt_peak_simp_bn[this.nsb] = new int[10000];
        this.sbt_peak_basis[this.nsb] = new int[10000];
        this.sbt_peak_basis_bn[this.nsb] = new int[10000];
        this.sbt_neigh_vert[this.nsb] = new int[this.rdim][];
        this.sbt_neigh_simp[this.nsb] = new int[this.rdim][];
        this.sbt_neigh_simp_bn[this.nsb] = new int[this.rdim][];
        this.sbt_neigh_basis[this.nsb] = new int[this.rdim][];
        this.sbt_neigh_basis_bn[this.nsb] = new int[this.rdim][];
        for (i = 0; i < this.rdim; ++i) {
            this.sbt_neigh_vert[this.nsb][i] = new int[10000];
            this.sbt_neigh_simp[this.nsb][i] = new int[10000];
            this.sbt_neigh_simp_bn[this.nsb][i] = new int[10000];
            this.sbt_neigh_basis[this.nsb][i] = new int[10000];
            this.sbt_neigh_basis_bn[this.nsb][i] = new int[10000];
        }
        for (i = 0; i < 10000; ++i) {
            this.sbt_next[this.nsb][i] = i + 1;
            this.sbt_next_bn[this.nsb][i] = this.nsb;
            this.sbt_visit[this.nsb][i] = 0L;
            this.sbt_mark[this.nsb][i] = 0;
            this.sbt_normal[this.nsb][i] = -1;
            this.sbt_peak_vert[this.nsb][i] = -1;
            this.sbt_peak_simp[this.nsb][i] = -1;
            this.sbt_peak_basis[this.nsb][i] = -1;
            for (int j = 0; j < this.rdim; ++j) {
                this.sbt_neigh_vert[this.nsb][j][i] = -1;
                this.sbt_neigh_simp[this.nsb][j][i] = -1;
                this.sbt_neigh_basis[this.nsb][j][i] = -1;
            }
        }
        this.sbt_next[this.nsb][9999] = -1;
        this.simplex_list = 0;
        this.simplex_list_bn = this.nsb++;
        return this.simplex_list;
    }

    private void visit_triang_gen(int s, int s_bn, int whichfunc, int[] ret, int[] ret_bn) {
        int tms = 0;
        --this.vnum;
        if (s != -1) {
            this.st2[tms] = s;
            this.st2_bn[tms] = s_bn;
            ++tms;
        }
        while (tms != 0) {
            if (tms > this.ss2) {
                this.ss2 += this.ss2;
                int[] newst2 = new int[this.ss2 + 8 + 1];
                int[] newst2_bn = new int[this.ss2 + 8 + 1];
                System.arraycopy(this.st2, 0, newst2, 0, this.st2.length);
                System.arraycopy(this.st2_bn, 0, newst2_bn, 0, this.st2_bn.length);
                this.st2 = newst2;
                this.st2_bn = newst2_bn;
            }
            int t = this.st2[--tms];
            int t_bn = this.st2_bn[tms];
            if (t == -1 || this.sbt_visit[t_bn][t] == this.vnum) continue;
            this.sbt_visit[t_bn][t] = this.vnum;
            if (whichfunc == 1) {
                int v_bn;
                int v;
                if (this.sbt_peak_vert[t_bn][t] == -1) {
                    v = t;
                    v_bn = t_bn;
                } else {
                    v = -1;
                    v_bn = -1;
                }
                if (v != -1) {
                    ret[0] = v;
                    ret_bn[0] = v_bn;
                    return;
                }
            } else {
                int[] vfp = new int[this.cdim];
                if (t != -1) {
                    int j;
                    for (j = 0; j < this.cdim; ++j) {
                        vfp[j] = this.sbt_neigh_vert[t_bn][j][t];
                    }
                    for (j = 0; j < this.cdim; ++j) {
                        this.a3s[j][this.nts] = vfp[j] == -2 ? -1 : vfp[j];
                    }
                    ++this.nts;
                    if (this.nts > this.a3size) {
                        this.a3size += this.a3size;
                        int[][] newa3s = new int[this.rdim][this.a3size + 8 + 1];
                        for (int i = 0; i < this.rdim; ++i) {
                            System.arraycopy(this.a3s[i], 0, newa3s[i], 0, this.a3s[i].length);
                        }
                        this.a3s = newa3s;
                    }
                }
            }
            for (int i = 0; i < this.cdim; ++i) {
                int j = this.sbt_neigh_simp[t_bn][i][t];
                int j_bn = this.sbt_neigh_simp_bn[t_bn][i][t];
                if (j == -1 || this.sbt_visit[j_bn][j] == this.vnum) continue;
                this.st2[tms] = j;
                this.st2_bn[tms] = j_bn;
                ++tms;
            }
        }
        ret[0] = -1;
    }

    private void connect(int s, int s_bn) {
        int xfi;
        int i;
        if (s == -1) {
            return;
        }
        for (i = 0; this.sbt_neigh_vert[s_bn][i][s] != this.p && i < this.cdim; ++i) {
        }
        if (this.sbt_visit[s_bn][s] == this.pnum) {
            return;
        }
        this.sbt_visit[s_bn][s] = this.pnum;
        int ccj = this.sbt_peak_simp[s_bn][s];
        int ccj_bn = this.sbt_peak_simp_bn[s_bn][s];
        for (xfi = 0; (this.sbt_neigh_simp[ccj_bn][xfi][ccj] != s || this.sbt_neigh_simp_bn[ccj_bn][xfi][ccj] != s_bn) && xfi < this.cdim; ++xfi) {
        }
        for (i = 0; i < this.cdim; ++i) {
            int l;
            if (this.p == this.sbt_neigh_vert[s_bn][i][s]) continue;
            int sb = this.sbt_peak_simp[s_bn][s];
            int sb_bn = this.sbt_peak_simp_bn[s_bn][s];
            int sf = this.sbt_neigh_simp[s_bn][i][s];
            int sf_bn = this.sbt_neigh_simp_bn[s_bn][i][s];
            int xf = this.sbt_neigh_vert[ccj_bn][xfi][ccj];
            if (this.sbt_peak_vert[sf_bn][sf] == -1) {
                for (l = 0; this.sbt_neigh_vert[ccj_bn][l][ccj] != this.sbt_neigh_vert[s_bn][i][s] && l < this.cdim; ++l) {
                }
                sf_bn = this.sbt_neigh_simp_bn[ccj_bn][l][ccj];
                sf = this.sbt_neigh_simp[ccj_bn][l][ccj];
                if (this.sbt_peak_vert[sf_bn][sf] != -1) {
                    continue;
                }
            } else {
                int tf;
                int tf_bn;
                do {
                    int xb = xf;
                    for (l = 0; (this.sbt_neigh_simp[sf_bn][l][sf] != sb || this.sbt_neigh_simp_bn[sf_bn][l][sf] != sb_bn) && l < this.cdim; ++l) {
                    }
                    xf = this.sbt_neigh_vert[sf_bn][l][sf];
                    sb = sf;
                    sb_bn = sf_bn;
                    for (l = 0; this.sbt_neigh_vert[sb_bn][l][sb] != xb && l < this.cdim; ++l) {
                    }
                } while (this.sbt_peak_vert[sf_bn = (tf_bn = this.sbt_neigh_simp_bn[sf_bn][l][sf])][sf = (tf = this.sbt_neigh_simp[sf_bn][l][sf])] != -1);
            }
            this.sbt_neigh_simp[s_bn][i][s] = sf;
            this.sbt_neigh_simp_bn[s_bn][i][s] = sf_bn;
            for (l = 0; this.sbt_neigh_vert[sf_bn][l][sf] != xf && l < this.cdim; ++l) {
            }
            this.sbt_neigh_simp[sf_bn][l][sf] = s;
            this.sbt_neigh_simp_bn[sf_bn][l][sf] = s_bn;
            this.connect(sf, sf_bn);
        }
    }

    private void make_facets(int seen, int seen_bn, int[] ret, int[] ret_bn) {
        if (seen == -1) {
            ret[0] = -1;
            return;
        }
        this.sbt_peak_vert[seen_bn][seen] = this.p;
        for (int i = 0; i < this.cdim; ++i) {
            int q_bn;
            int q;
            int j;
            int n_bn = this.sbt_neigh_simp_bn[seen_bn][i][seen];
            int n = this.sbt_neigh_simp[seen_bn][i][seen];
            if (this.pnum != this.sbt_visit[n_bn][n]) {
                this.sbt_visit[n_bn][n] = this.pnum;
                if (this.sees(this.p, n, n_bn) != 0) {
                    this.make_facets(n, n_bn, this.voidp, this.voidp_bn);
                }
            }
            if (this.sbt_peak_vert[n_bn][n] != -1) continue;
            this.ns = this.simplex_list != -1 ? this.simplex_list : this.new_block_simplex();
            this.ns_bn = this.simplex_list_bn;
            this.simplex_list = this.sbt_next[this.ns_bn][this.ns];
            this.simplex_list_bn = this.sbt_next_bn[this.ns_bn][this.ns];
            this.sbt_next[this.ns_bn][this.ns] = this.sbt_next[seen_bn][seen];
            this.sbt_next_bn[this.ns_bn][this.ns] = this.sbt_next_bn[seen_bn][seen];
            this.sbt_visit[this.ns_bn][this.ns] = this.sbt_visit[seen_bn][seen];
            this.sbt_mark[this.ns_bn][this.ns] = this.sbt_mark[seen_bn][seen];
            this.sbt_normal[this.ns_bn][this.ns] = this.sbt_normal[seen_bn][seen];
            this.sbt_normal_bn[this.ns_bn][this.ns] = this.sbt_normal_bn[seen_bn][seen];
            this.sbt_peak_vert[this.ns_bn][this.ns] = this.sbt_peak_vert[seen_bn][seen];
            this.sbt_peak_simp[this.ns_bn][this.ns] = this.sbt_peak_simp[seen_bn][seen];
            this.sbt_peak_simp_bn[this.ns_bn][this.ns] = this.sbt_peak_simp_bn[seen_bn][seen];
            this.sbt_peak_basis[this.ns_bn][this.ns] = this.sbt_peak_basis[seen_bn][seen];
            this.sbt_peak_basis_bn[this.ns_bn][this.ns] = this.sbt_peak_basis_bn[seen_bn][seen];
            for (j = 0; j < this.rdim; ++j) {
                this.sbt_neigh_vert[this.ns_bn][j][this.ns] = this.sbt_neigh_vert[seen_bn][j][seen];
                this.sbt_neigh_simp[this.ns_bn][j][this.ns] = this.sbt_neigh_simp[seen_bn][j][seen];
                this.sbt_neigh_simp_bn[this.ns_bn][j][this.ns] = this.sbt_neigh_simp_bn[seen_bn][j][seen];
                this.sbt_neigh_basis[this.ns_bn][j][this.ns] = this.sbt_neigh_basis[seen_bn][j][seen];
                this.sbt_neigh_basis_bn[this.ns_bn][j][this.ns] = this.sbt_neigh_basis_bn[seen_bn][j][seen];
            }
            for (j = 0; j < this.cdim; ++j) {
                q = this.sbt_neigh_basis[seen_bn][j][seen];
                q_bn = this.sbt_neigh_basis_bn[seen_bn][j][seen];
                if (q == -1) continue;
                int[] nArray = this.bbt_ref_count[q_bn];
                int n2 = q;
                nArray[n2] = nArray[n2] + 1;
            }
            this.sbt_visit[this.ns_bn][this.ns] = 0L;
            this.sbt_peak_vert[this.ns_bn][this.ns] = -1;
            this.sbt_normal[this.ns_bn][this.ns] = -1;
            this.sbt_peak_simp[this.ns_bn][this.ns] = seen;
            this.sbt_peak_simp_bn[this.ns_bn][this.ns] = seen_bn;
            q = this.sbt_neigh_basis[this.ns_bn][i][this.ns];
            q_bn = this.sbt_neigh_basis_bn[this.ns_bn][i][this.ns];
            if (q != -1) {
                int[] nArray = this.bbt_ref_count[q_bn];
                int n3 = q;
                nArray[n3] = nArray[n3] - 1;
                if (nArray[n3] == 0) {
                    this.bbt_next[q_bn][q] = this.basis_s_list;
                    this.bbt_next_bn[q_bn][q] = this.basis_s_list_bn;
                    this.bbt_ref_count[q_bn][q] = 0;
                    this.bbt_lscale[q_bn][q] = 0;
                    this.bbt_sqa[q_bn][q] = 0.0;
                    this.bbt_sqb[q_bn][q] = 0.0;
                    for (int l = 0; l < 2 * this.rdim; ++l) {
                        this.bbt_vecs[q_bn][l][q] = 0.0;
                    }
                    this.basis_s_list = q;
                    this.basis_s_list_bn = q_bn;
                }
            }
            this.sbt_neigh_basis[this.ns_bn][i][this.ns] = -1;
            this.sbt_neigh_vert[this.ns_bn][i][this.ns] = this.p;
            for (j = 0; (this.sbt_neigh_simp[n_bn][j][n] != seen || this.sbt_neigh_simp_bn[n_bn][j][n] != seen_bn) && j < this.cdim; ++j) {
            }
            int n4 = this.ns;
            this.sbt_neigh_simp[n_bn][j][n] = n4;
            this.sbt_neigh_simp[seen_bn][i][seen] = n4;
            this.sbt_neigh_simp_bn[seen_bn][i][seen] = this.ns_bn;
            this.sbt_neigh_simp_bn[n_bn][j][n] = this.ns_bn;
        }
        ret[0] = this.ns;
        ret_bn[0] = this.ns_bn;
    }

    private void extend_simplices(int s, int s_bn, int[] ret, int[] ret_bn) {
        int j;
        if (this.sbt_visit[s_bn][s] == this.pnum) {
            if (this.sbt_peak_vert[s_bn][s] != -1) {
                ret[0] = this.sbt_neigh_simp[s_bn][this.cdim - 1][s];
                ret_bn[0] = this.sbt_neigh_simp_bn[s_bn][this.cdim - 1][s];
            } else {
                ret[0] = s;
                ret_bn[0] = s_bn;
            }
            return;
        }
        this.sbt_visit[s_bn][s] = this.pnum;
        this.sbt_neigh_vert[s_bn][this.cdim - 1][s] = this.p;
        int q = this.sbt_normal[s_bn][s];
        int q_bn = this.sbt_normal_bn[s_bn][s];
        if (q != -1) {
            int[] nArray = this.bbt_ref_count[q_bn];
            int n = q;
            nArray[n] = nArray[n] - 1;
            if (nArray[n] == 0) {
                this.bbt_next[q_bn][q] = this.basis_s_list;
                this.bbt_next_bn[q_bn][q] = this.basis_s_list_bn;
                this.bbt_ref_count[q_bn][q] = 0;
                this.bbt_lscale[q_bn][q] = 0;
                this.bbt_sqa[q_bn][q] = 0.0;
                this.bbt_sqb[q_bn][q] = 0.0;
                for (j = 0; j < 2 * this.rdim; ++j) {
                    this.bbt_vecs[q_bn][j][q] = 0.0;
                }
                this.basis_s_list = q;
                this.basis_s_list_bn = q_bn;
            }
        }
        this.sbt_normal[s_bn][s] = -1;
        q = this.sbt_neigh_basis[s_bn][0][s];
        q_bn = this.sbt_neigh_basis_bn[s_bn][0][s];
        if (q != -1) {
            int[] nArray = this.bbt_ref_count[q_bn];
            int n = q;
            nArray[n] = nArray[n] - 1;
            if (nArray[n] == 0) {
                this.bbt_next[q_bn][q] = this.basis_s_list;
                this.bbt_ref_count[q_bn][q] = 0;
                this.bbt_lscale[q_bn][q] = 0;
                this.bbt_sqa[q_bn][q] = 0.0;
                this.bbt_sqb[q_bn][q] = 0.0;
                for (j = 0; j < 2 * this.rdim; ++j) {
                    this.bbt_vecs[q_bn][j][q] = 0.0;
                }
                this.basis_s_list = q;
                this.basis_s_list_bn = q_bn;
            }
        }
        this.sbt_neigh_basis[s_bn][0][s] = -1;
        if (this.sbt_peak_vert[s_bn][s] == -1) {
            int[] esretp = new int[1];
            int[] esretp_bn = new int[1];
            this.extend_simplices(this.sbt_peak_simp[s_bn][s], this.sbt_peak_simp_bn[s_bn][s], esretp, esretp_bn);
            this.sbt_neigh_simp[s_bn][this.cdim - 1][s] = esretp[0];
            this.sbt_neigh_simp_bn[s_bn][this.cdim - 1][s] = esretp_bn[0];
            ret[0] = s;
            ret_bn[0] = s_bn;
            return;
        }
        int ns = this.simplex_list != -1 ? this.simplex_list : this.new_block_simplex();
        int ns_bn = this.simplex_list_bn;
        this.simplex_list = this.sbt_next[ns_bn][ns];
        this.simplex_list_bn = this.sbt_next_bn[ns_bn][ns];
        this.sbt_next[ns_bn][ns] = this.sbt_next[s_bn][s];
        this.sbt_next_bn[ns_bn][ns] = this.sbt_next_bn[s_bn][s];
        this.sbt_visit[ns_bn][ns] = this.sbt_visit[s_bn][s];
        this.sbt_mark[ns_bn][ns] = this.sbt_mark[s_bn][s];
        this.sbt_normal[ns_bn][ns] = this.sbt_normal[s_bn][s];
        this.sbt_normal_bn[ns_bn][ns] = this.sbt_normal_bn[s_bn][s];
        this.sbt_peak_vert[ns_bn][ns] = this.sbt_peak_vert[s_bn][s];
        this.sbt_peak_simp[ns_bn][ns] = this.sbt_peak_simp[s_bn][s];
        this.sbt_peak_simp_bn[ns_bn][ns] = this.sbt_peak_simp_bn[s_bn][s];
        this.sbt_peak_basis[ns_bn][ns] = this.sbt_peak_basis[s_bn][s];
        this.sbt_peak_basis_bn[ns_bn][ns] = this.sbt_peak_basis_bn[s_bn][s];
        for (j = 0; j < this.rdim; ++j) {
            this.sbt_neigh_vert[ns_bn][j][ns] = this.sbt_neigh_vert[s_bn][j][s];
            this.sbt_neigh_simp[ns_bn][j][ns] = this.sbt_neigh_simp[s_bn][j][s];
            this.sbt_neigh_simp_bn[ns_bn][j][ns] = this.sbt_neigh_simp_bn[s_bn][j][s];
            this.sbt_neigh_basis[ns_bn][j][ns] = this.sbt_neigh_basis[s_bn][j][s];
            this.sbt_neigh_basis_bn[ns_bn][j][ns] = this.sbt_neigh_basis_bn[s_bn][j][s];
        }
        for (j = 0; j < this.cdim; ++j) {
            q = this.sbt_neigh_basis[s_bn][j][s];
            q_bn = this.sbt_neigh_basis_bn[s_bn][j][s];
            if (q == -1) continue;
            int[] nArray = this.bbt_ref_count[q_bn];
            int n = q;
            nArray[n] = nArray[n] + 1;
        }
        this.sbt_neigh_simp[s_bn][this.cdim - 1][s] = ns;
        this.sbt_neigh_simp_bn[s_bn][this.cdim - 1][s] = ns_bn;
        this.sbt_peak_vert[ns_bn][ns] = -1;
        this.sbt_peak_simp[ns_bn][ns] = s;
        this.sbt_peak_simp_bn[ns_bn][ns] = s_bn;
        this.sbt_neigh_vert[ns_bn][this.cdim - 1][ns] = this.sbt_peak_vert[s_bn][s];
        this.sbt_neigh_simp[ns_bn][this.cdim - 1][ns] = this.sbt_peak_simp[s_bn][s];
        this.sbt_neigh_simp_bn[ns_bn][this.cdim - 1][ns] = this.sbt_peak_simp_bn[s_bn][s];
        this.sbt_neigh_basis[ns_bn][this.cdim - 1][ns] = this.sbt_peak_basis[s_bn][s];
        this.sbt_neigh_basis_bn[ns_bn][this.cdim - 1][ns] = this.sbt_peak_basis_bn[s_bn][s];
        q = this.sbt_peak_basis[s_bn][s];
        q_bn = this.sbt_peak_basis_bn[s_bn][s];
        if (q != -1) {
            int[] nArray = this.bbt_ref_count[q_bn];
            int n = q;
            nArray[n] = nArray[n] + 1;
        }
        for (int i = 0; i < this.cdim; ++i) {
            int[] esretp = new int[1];
            int[] esretp_bn = new int[1];
            this.extend_simplices(this.sbt_neigh_simp[ns_bn][i][ns], this.sbt_neigh_simp_bn[ns_bn][i][ns], esretp, esretp_bn);
            this.sbt_neigh_simp[ns_bn][i][ns] = esretp[0];
            this.sbt_neigh_simp_bn[ns_bn][i][ns] = esretp_bn[0];
        }
        ret[0] = ns;
        ret_bn[0] = ns_bn;
    }

    private void search(int root, int root_bn, int[] ret, int[] ret_bn) {
        int i;
        int tms = 0;
        this.st[tms] = this.sbt_peak_simp[root_bn][root];
        this.st_bn[tms] = this.sbt_peak_simp_bn[root_bn][root];
        ++tms;
        this.sbt_visit[root_bn][root] = this.pnum;
        if (this.sees(this.p, root, root_bn) == 0) {
            for (i = 0; i < this.cdim; ++i) {
                this.st[tms] = this.sbt_neigh_simp[root_bn][i][root];
                this.st_bn[tms] = this.sbt_neigh_simp_bn[root_bn][i][root];
                ++tms;
            }
        }
        while (tms != 0) {
            int s;
            int s_bn;
            if (tms > this.ss) {
                this.ss += this.ss;
                int[] newst = new int[this.ss + 8 + 1];
                int[] newst_bn = new int[this.ss + 8 + 1];
                System.arraycopy(this.st, 0, newst, 0, this.st.length);
                System.arraycopy(this.st_bn, 0, newst_bn, 0, this.st_bn.length);
                this.st = newst;
                this.st_bn = newst_bn;
            }
            if (this.sbt_visit[s_bn = this.st_bn[--tms]][s = this.st[tms]] == this.pnum) continue;
            this.sbt_visit[s_bn][s] = this.pnum;
            if (this.sees(this.p, s, s_bn) == 0) continue;
            if (this.sbt_peak_vert[s_bn][s] == -1) {
                ret[0] = s;
                ret_bn[0] = s_bn;
                return;
            }
            for (i = 0; i < this.cdim; ++i) {
                this.st[tms] = this.sbt_neigh_simp[s_bn][i][s];
                this.st_bn[tms] = this.sbt_neigh_simp_bn[s_bn][i][s];
                ++tms;
            }
        }
        ret[0] = -1;
    }

    public void compute(double[][] samples, float scale) throws DelaunayException {
        boolean positive;
        int i;
        int i2;
        int q_bn;
        int q;
        int j;
        int i3;
        this.simplexes = null;
        this.vertices = null;
        this.neighbors = null;
        this.Edges = null;
        this.NumEdges = 0;
        int[] retp = new int[1];
        int[] retp_bn = new int[1];
        int[] ret2p = new int[1];
        int[] ret2p_bn = new int[1];
        int[] curt = new int[1];
        int[] curt_bn = new int[1];
        int s_num = 0;
        this.samples = samples;
        this.dim = samples.length;
        int nrs = samples[0].length;
        for (i3 = 1; i3 < this.dim; ++i3) {
            nrs = Math.min(nrs, samples[i3].length);
        }
        if (nrs <= this.dim) {
            throw new DelaunayException("DelaunayClarkson: not enough samples");
        }
        if (this.dim > 8) {
            throw new DelaunayException("DelaunayClarkson: dimension bound MAXDIM exceeded");
        }
        this.site_blocks = new double[this.dim][nrs];
        for (j = 0; j < this.dim; ++j) {
            System.arraycopy(samples[j], 0, this.site_blocks[j], 0, nrs);
        }
        for (j = 0; j < this.dim; ++j) {
            for (int kk = 0; kk < nrs; ++kk) {
                this.site_blocks[j][kk] = (double)scale * samples[j][kk];
            }
        }
        this.exact_bits = (int)(53.0 * Math.log(2.0) / ln2);
        this.b_err_min = 1.0950316209346055E-11;
        this.b_err_min_sq = this.b_err_min * this.b_err_min;
        this.cdim = 0;
        this.rdim = this.dim + 1;
        if (this.rdim > 8) {
            throw new DelaunayException("dimension bound MAXDIM exceeded; rdim=" + this.rdim + "; dim=" + this.dim);
        }
        this.pnb = this.basis_s_list != -1 ? this.basis_s_list : this.new_block_basis_s();
        this.pnb_bn = this.basis_s_list_bn;
        this.basis_s_list = this.bbt_next[this.pnb_bn][this.pnb];
        this.basis_s_list_bn = this.bbt_next_bn[this.pnb_bn][this.pnb];
        this.bbt_next[this.pnb_bn][this.pnb] = -1;
        this.ttbp = this.basis_s_list != -1 ? this.basis_s_list : this.new_block_basis_s();
        this.ttbp_bn = this.basis_s_list_bn;
        this.basis_s_list = this.bbt_next[this.ttbp_bn][this.ttbp];
        this.basis_s_list_bn = this.bbt_next_bn[this.ttbp_bn][this.ttbp];
        this.bbt_next[this.ttbp_bn][this.ttbp] = -1;
        this.bbt_ref_count[this.ttbp_bn][this.ttbp] = 1;
        this.bbt_lscale[this.ttbp_bn][this.ttbp] = -1;
        this.bbt_sqa[this.ttbp_bn][this.ttbp] = 0.0;
        this.bbt_sqb[this.ttbp_bn][this.ttbp] = 0.0;
        for (j = 0; j < 2 * this.rdim; ++j) {
            this.bbt_vecs[this.ttbp_bn][j][this.ttbp] = 0.0;
        }
        int root = -1;
        this.p = -2;
        this.ib = this.basis_s_list != -1 ? this.basis_s_list : this.new_block_basis_s();
        this.ib_bn = this.basis_s_list_bn;
        this.basis_s_list = this.bbt_next[this.ib_bn][this.ib];
        this.basis_s_list_bn = this.bbt_next_bn[this.ib_bn][this.ib];
        this.bbt_ref_count[this.ib_bn][this.ib] = 1;
        this.bbt_vecs[this.ib_bn][this.rdim - 1][this.ib] = 1.0;
        this.bbt_vecs[this.ib_bn][2 * this.rdim - 1][this.ib] = 1.0;
        this.bbt_sqb[this.ib_bn][this.ib] = 1.0;
        this.bbt_sqa[this.ib_bn][this.ib] = 1.0;
        root = this.simplex_list != -1 ? this.simplex_list : this.new_block_simplex();
        int root_bn = this.simplex_list_bn;
        this.simplex_list = this.sbt_next[root_bn][root];
        this.simplex_list_bn = this.sbt_next_bn[root_bn][root];
        this.ch_root = root;
        this.ch_root_bn = root_bn;
        int s = this.simplex_list != -1 ? this.simplex_list : this.new_block_simplex();
        int s_bn = this.simplex_list_bn;
        this.simplex_list = this.sbt_next[s_bn][s];
        this.simplex_list_bn = this.sbt_next_bn[s_bn][s];
        this.sbt_next[s_bn][s] = this.sbt_next[root_bn][root];
        this.sbt_next_bn[s_bn][s] = this.sbt_next_bn[root_bn][root];
        this.sbt_visit[s_bn][s] = this.sbt_visit[root_bn][root];
        this.sbt_mark[s_bn][s] = this.sbt_mark[root_bn][root];
        this.sbt_normal[s_bn][s] = this.sbt_normal[root_bn][root];
        this.sbt_normal_bn[s_bn][s] = this.sbt_normal_bn[root_bn][root];
        this.sbt_peak_vert[s_bn][s] = this.sbt_peak_vert[root_bn][root];
        this.sbt_peak_simp[s_bn][s] = this.sbt_peak_simp[root_bn][root];
        this.sbt_peak_simp_bn[s_bn][s] = this.sbt_peak_simp_bn[root_bn][root];
        this.sbt_peak_basis[s_bn][s] = this.sbt_peak_basis[root_bn][root];
        this.sbt_peak_basis_bn[s_bn][s] = this.sbt_peak_basis_bn[root_bn][root];
        for (i3 = 0; i3 < this.rdim; ++i3) {
            this.sbt_neigh_vert[s_bn][i3][s] = this.sbt_neigh_vert[root_bn][i3][root];
            this.sbt_neigh_simp[s_bn][i3][s] = this.sbt_neigh_simp[root_bn][i3][root];
            this.sbt_neigh_simp_bn[s_bn][i3][s] = this.sbt_neigh_simp_bn[root_bn][i3][root];
            this.sbt_neigh_basis[s_bn][i3][s] = this.sbt_neigh_basis[root_bn][i3][root];
            this.sbt_neigh_basis_bn[s_bn][i3][s] = this.sbt_neigh_basis_bn[root_bn][i3][root];
        }
        for (i3 = 0; i3 < this.cdim; ++i3) {
            q = this.sbt_neigh_basis[root_bn][i3][root];
            q_bn = this.sbt_neigh_basis_bn[root_bn][i3][root];
            if (q == -1) continue;
            int[] nArray = this.bbt_ref_count[q_bn];
            int n = q;
            nArray[n] = nArray[n] + 1;
        }
        this.sbt_peak_vert[root_bn][root] = this.p;
        this.sbt_peak_simp[root_bn][root] = s;
        this.sbt_peak_simp_bn[root_bn][root] = s_bn;
        this.sbt_peak_simp[s_bn][s] = root;
        this.sbt_peak_simp_bn[s_bn][s] = root_bn;
        while (this.cdim < this.rdim) {
            boolean oof = false;
            this.p = s_num == 0 ? 0 : ++this.p;
            for (i2 = 0; i2 < this.dim; ++i2) {
                this.site_blocks[i2][this.p] = Math.floor(this.site_blocks[i2][this.p] + 0.5);
            }
            this.pnum = (++s_num * this.dim - 1) / this.dim + 2;
            ++this.cdim;
            this.sbt_neigh_vert[root_bn][this.cdim - 1][root] = this.sbt_peak_vert[root_bn][root];
            q = this.sbt_neigh_basis[root_bn][this.cdim - 1][root];
            q_bn = this.sbt_neigh_basis_bn[root_bn][this.cdim - 1][root];
            if (q != -1) {
                int[] nArray = this.bbt_ref_count[q_bn];
                int n = q;
                nArray[n] = nArray[n] - 1;
                if (nArray[n] == 0) {
                    this.bbt_next[q_bn][q] = this.basis_s_list;
                    this.bbt_next_bn[q_bn][q] = this.basis_s_list_bn;
                    this.bbt_ref_count[q_bn][q] = 0;
                    this.bbt_lscale[q_bn][q] = 0;
                    this.bbt_sqa[q_bn][q] = 0.0;
                    this.bbt_sqb[q_bn][q] = 0.0;
                    for (int l = 0; l < 2 * this.rdim; ++l) {
                        this.bbt_vecs[q_bn][l][q] = 0.0;
                    }
                    this.basis_s_list = q;
                    this.basis_s_list_bn = q_bn;
                }
            }
            this.sbt_neigh_basis[root_bn][this.cdim - 1][root] = -1;
            this.get_basis_sede(root, root_bn);
            if (this.sbt_neigh_vert[root_bn][0][root] == -2) {
                oof = true;
            } else {
                curt[0] = this.pnb;
                curt_bn[0] = this.pnb_bn;
                this.reduce(curt, curt_bn, this.p, root, root_bn, this.cdim);
                this.pnb = curt[0];
                this.pnb_bn = curt_bn[0];
                if (this.bbt_sqa[this.pnb_bn][this.pnb] != 0.0) {
                    oof = true;
                } else {
                    --this.cdim;
                }
            }
            if (oof) {
                this.extend_simplices(root, root_bn, this.voidp, this.voidp_bn);
                continue;
            }
            this.search(root, root_bn, retp, retp_bn);
            this.make_facets(retp[0], retp_bn[0], ret2p, ret2p_bn);
            this.connect(ret2p[0], ret2p_bn[0]);
        }
        for (i3 = s_num; i3 < nrs; ++i3) {
            ++this.p;
            ++s_num;
            for (int j2 = 0; j2 < this.dim; ++j2) {
                this.site_blocks[j2][this.p] = Math.floor(this.site_blocks[j2][this.p] + 0.5);
            }
            this.pnum = (s_num * this.dim - 1) / this.dim + 2;
            this.search(root, root_bn, retp, retp_bn);
            this.make_facets(retp[0], retp_bn[0], ret2p, ret2p_bn);
            this.connect(ret2p[0], ret2p_bn[0]);
        }
        this.a3size = this.rdim * nrs;
        this.a3s = new int[this.rdim][this.a3size + 8 + 1];
        this.visit_triang_gen(root, root_bn, 1, retp, retp_bn);
        this.visit_triang_gen(retp[0], retp_bn[0], 0, this.voidp, this.voidp_bn);
        this.site_blocks = null;
        this.st = null;
        this.st_bn = null;
        this.st2 = null;
        this.st2_bn = null;
        this.sbt_next = null;
        this.sbt_next_bn = null;
        this.sbt_visit = null;
        this.sbt_mark = null;
        this.sbt_normal = null;
        this.sbt_normal_bn = null;
        this.sbt_peak_vert = null;
        this.sbt_peak_simp = null;
        this.sbt_peak_simp_bn = null;
        this.sbt_peak_basis = null;
        this.sbt_peak_basis_bn = null;
        this.sbt_neigh_vert = null;
        this.sbt_neigh_simp = null;
        this.sbt_neigh_simp_bn = null;
        this.sbt_neigh_basis = null;
        this.sbt_neigh_basis_bn = null;
        this.bbt_next = null;
        this.bbt_next_bn = null;
        this.bbt_ref_count = null;
        this.bbt_lscale = null;
        this.bbt_sqa = null;
        this.bbt_sqb = null;
        this.bbt_vecs = null;
        int[] nverts = new int[nrs];
        for (i2 = 0; i2 < nrs; ++i2) {
            nverts[i2] = 0;
        }
        int ntris = 0;
        for (i = 0; i < this.nts; ++i) {
            int j3;
            positive = true;
            for (j3 = 0; j3 < this.rdim; ++j3) {
                if (this.a3s[j3][i] >= 0) continue;
                positive = false;
            }
            if (!positive) continue;
            ++ntris;
            for (j3 = 0; j3 < this.rdim; ++j3) {
                int n = this.a3s[j3][i];
                nverts[n] = nverts[n] + 1;
            }
        }
        this.vertices = new int[nrs][];
        for (i = 0; i < nrs; ++i) {
            this.vertices[i] = new int[nverts[i]];
        }
        for (i = 0; i < nrs; ++i) {
            nverts[i] = 0;
        }
        this.simplexes = new int[ntris][this.rdim];
        int itri = 0;
        for (int i4 = 0; i4 < this.nts; ++i4) {
            int j4;
            positive = true;
            for (j4 = 0; j4 < this.rdim; ++j4) {
                if (this.a3s[j4][i4] >= 0) continue;
                positive = false;
            }
            if (!positive) continue;
            for (j4 = 0; j4 < this.rdim; ++j4) {
                int n = this.a3s[j4][i4];
                int n2 = nverts[n];
                nverts[n] = n2 + 1;
                this.vertices[this.a3s[j4][i4]][n2] = itri;
                this.simplexes[itri][j4] = this.a3s[j4][i4];
            }
            ++itri;
        }
        this.a3s = null;
        this.finish_triang(samples);
    }

    public boolean valid() {
        int k;
        int k2;
        int j;
        int i;
        int i2;
        int dim = this.samples.length;
        int dim1 = dim + 1;
        int ntris = this.simplexes.length;
        int nrs = this.samples[0].length;
        for (i2 = 1; i2 < dim; ++i2) {
            nrs = Math.min(nrs, this.samples[i2].length);
        }
        for (i2 = 0; i2 < ntris; ++i2) {
            if (this.simplexes[i2].length >= dim1) continue;
            System.out.println("Bad triangulation dimension: " + this.simplexes[i2].length + " (should be " + dim1 + ")");
            return false;
        }
        for (i2 = 0; i2 < ntris; ++i2) {
            for (int j2 = 0; j2 < dim1; ++j2) {
                if (this.simplexes[i2][j2] >= 0 && this.simplexes[i2][j2] < nrs) continue;
                System.out.println("Illegal vertice found: " + this.simplexes[i2][j2] + " for triangle " + i2);
                return false;
            }
        }
        int[] nverts = new int[nrs];
        for (i = 0; i < nrs; ++i) {
            nverts[i] = 0;
        }
        for (i = 0; i < ntris; ++i) {
            for (j = 0; j < dim1; ++j) {
                int n = this.simplexes[i][j];
                nverts[n] = nverts[n] + 1;
            }
        }
        for (i = 0; i < nrs; ++i) {
            if (nverts[i] != 0) continue;
            System.out.println("Point " + i + " is not in any triangle.");
            return false;
        }
        for (i = 0; i < ntris; ++i) {
            for (j = i + 1; j < ntris; ++j) {
                boolean[] m = new boolean[dim1];
                for (int mi = 0; mi < dim1; ++mi) {
                    m[mi] = false;
                }
                for (k2 = 0; k2 < dim1; ++k2) {
                    for (int l = 0; l < dim1; ++l) {
                        if (this.simplexes[i][k2] != this.simplexes[j][l] || m[l]) continue;
                        m[l] = true;
                    }
                }
                boolean mtot = true;
                for (k = 0; k < dim1; ++k) {
                    if (m[k]) continue;
                    mtot = false;
                }
                if (!mtot) continue;
                return false;
            }
        }
        if (this.neighbors != null) {
            for (i = 0; i < ntris; ++i) {
                for (j = 0; j < dim1; ++j) {
                    if (this.neighbors[i][j] == -1) continue;
                    boolean found = false;
                    for (k2 = 0; k2 < dim1; ++k2) {
                        if (this.neighbors[this.neighbors[i][j]][k2] != i) continue;
                        found = true;
                    }
                    if (!found) {
                        return false;
                    }
                    int sb = 0;
                    for (k = 0; k < dim1; ++k) {
                        for (int l = 0; l < dim1; ++l) {
                            if (this.simplexes[i][k] != this.simplexes[this.neighbors[i][j]][l]) continue;
                            ++sb;
                        }
                    }
                    if (sb == dim) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void improve(int pass) throws DelaunayException {
        int dim = this.samples.length;
        int dim1 = dim + 1;
        if (this.simplexes[0].length != dim1) {
            throw new DelaunayException("Delaunay.improve: samples dimension does not match");
        }
        if (dim > 2) {
            throw new DelaunayException("Delaunay.improve: dimension must be 2!");
        }
        int ntris = this.simplexes.length;
        int nrs = this.samples[0].length;
        for (int i = 1; i < dim; ++i) {
            nrs = Math.min(nrs, this.samples[i].length);
        }
        double[] samp0 = this.samples[0];
        double[] samp1 = this.samples[1];
        boolean eflipped = false;
        for (int p = 0; p < pass; ++p) {
            eflipped = false;
            boolean[] edge = new boolean[this.NumEdges];
            for (int i = 0; i < this.NumEdges; ++i) {
                edge[i] = true;
            }
            for (int t = 0; t < ntris; ++t) {
                int[] trit = this.simplexes[t];
                int[] walkt = this.neighbors[t];
                int[] edgest = this.Edges[t];
                for (int e = 0; e < 2; ++e) {
                    int curedge = edgest[e];
                    if (!edge[curedge]) continue;
                    int t2 = walkt[e];
                    if (t2 >= 0) {
                        boolean sig;
                        int[] trit2 = this.simplexes[t2];
                        int[] walkt2 = this.neighbors[t2];
                        int[] edgest2 = this.Edges[t2];
                        int f = walkt2[0] == t ? 0 : (walkt2[1] == t ? 1 : 2);
                        int A = (e + 2) % 3;
                        int B = (A + 1) % 3;
                        int C = (B + 1) % 3;
                        int D = (f + 2) % 3;
                        double ax = samp0[trit[A]];
                        double ay = samp1[trit[A]];
                        double bx = samp0[trit[B]];
                        double by = samp1[trit[B]];
                        double cx = samp0[trit[C]];
                        double cy = samp1[trit[C]];
                        double dx = samp0[trit2[D]];
                        double dy = samp1[trit2[D]];
                        double abx = ax - bx;
                        double aby = ay - by;
                        double acx = ax - cx;
                        double acy = ay - cy;
                        double dbx = dx - bx;
                        double dby = dy - by;
                        double dcx = dx - cx;
                        double dcy = dy - cy;
                        double Q = abx * acx + aby * acy;
                        double R = dbx * abx + dby * aby;
                        double S = acx * dcx + acy * dcy;
                        double T = dbx * dcx + dby * dcy;
                        boolean QD = abx * acy - aby * acx >= 0.0;
                        boolean RD = dbx * aby - dby * abx >= 0.0;
                        boolean SD = acx * dcy - acy * dcx >= 0.0;
                        boolean TD = dcx * dby - dcy * dbx >= 0.0;
                        boolean bl = sig = (QD ? 1 : 0) + (RD ? 1 : 0) + (SD ? 1 : 0) + (TD ? 1 : 0) < 2;
                        boolean d = QD == sig ? true : (RD == sig ? false : (SD == sig ? false : (TD == sig ? true : (Q < 0.0 && T < 0.0 || R > 0.0 && S > 0.0 ? true : (R < 0.0 && S < 0.0 || Q > 0.0 && T > 0.0 ? false : (Q < 0.0 ? Q : T) < (R < 0.0 ? R : S))))));
                        if (d) {
                            int i;
                            int val;
                            int e4;
                            int e3;
                            int w4;
                            int w3;
                            eflipped = true;
                            int n1 = trit[A];
                            int n2 = trit[B];
                            int n3 = trit[C];
                            int n4 = trit2[D];
                            int w1 = walkt[A];
                            int w2 = walkt[C];
                            int e1 = edgest[A];
                            int e2 = edgest[C];
                            if (trit2[(D + 1) % 3] == trit[C]) {
                                w3 = walkt2[D];
                                w4 = walkt2[(D + 2) % 3];
                                e3 = edgest2[D];
                                e4 = edgest2[(D + 2) % 3];
                            } else {
                                w3 = walkt2[(D + 2) % 3];
                                w4 = walkt2[D];
                                e3 = edgest2[(D + 2) % 3];
                                e4 = edgest2[D];
                            }
                            trit[0] = n1;
                            trit[1] = n2;
                            trit[2] = n4;
                            trit2[0] = n1;
                            trit2[1] = n4;
                            trit2[2] = n3;
                            walkt[0] = w1;
                            walkt[1] = w4;
                            walkt[2] = t2;
                            walkt2[0] = t;
                            walkt2[1] = w3;
                            walkt2[2] = w2;
                            if (w2 >= 0) {
                                val = this.neighbors[w2][0] == t ? 0 : (this.neighbors[w2][1] == t ? 1 : 2);
                                this.neighbors[w2][val] = t2;
                            }
                            if (w4 >= 0) {
                                val = this.neighbors[w4][0] == t2 ? 0 : (this.neighbors[w4][1] == t2 ? 1 : 2);
                                this.neighbors[w4][val] = t;
                            }
                            edgest[0] = e1;
                            edgest[1] = e4;
                            edgest2[1] = e3;
                            edgest2[2] = e2;
                            int[] vertn1 = this.vertices[n1];
                            int[] vertn2 = this.vertices[n2];
                            int[] vertn3 = this.vertices[n3];
                            int[] vertn4 = this.vertices[n4];
                            int ln1 = vertn1.length;
                            int ln2 = vertn2.length;
                            int ln3 = vertn3.length;
                            int ln4 = vertn4.length;
                            int[] tn1 = new int[ln1 + 1];
                            int[] tn2 = new int[ln2 - 1];
                            int[] tn3 = new int[ln3 - 1];
                            int[] tn4 = new int[ln4 + 1];
                            System.arraycopy(vertn1, 0, tn1, 0, ln1);
                            tn1[ln1] = t2;
                            int c = 0;
                            for (i = 0; i < ln2; ++i) {
                                if (vertn2[i] == t2) continue;
                                tn2[c++] = vertn2[i];
                            }
                            c = 0;
                            for (i = 0; i < ln3; ++i) {
                                if (vertn3[i] == t) continue;
                                tn3[c++] = vertn3[i];
                            }
                            System.arraycopy(vertn4, 0, tn4, 0, ln4);
                            tn4[ln4] = t;
                            this.vertices[n1] = tn1;
                            this.vertices[n2] = tn2;
                            this.vertices[n3] = tn3;
                            this.vertices[n4] = tn4;
                        }
                    }
                    edge[curedge] = false;
                }
            }
            if (!eflipped) break;
        }
    }

    private void finish_triang(double[][] samples) throws DelaunayException {
        block30: {
            int j;
            int i;
            int i2;
            int mdim = this.simplexes[0].length - 1;
            int mdim1 = mdim + 1;
            int dim = samples.length;
            int ntris = this.simplexes.length;
            int nrs = samples[0].length;
            for (i2 = 1; i2 < dim; ++i2) {
                nrs = Math.min(nrs, samples[i2].length);
            }
            if (this.vertices == null) {
                this.vertices = new int[nrs][];
                int[] nverts = new int[nrs];
                for (i = 0; i < ntris; ++i) {
                    for (j = 0; j < mdim1; ++j) {
                        int n = this.simplexes[i][j];
                        nverts[n] = nverts[n] + 1;
                    }
                }
                for (i = 0; i < nrs; ++i) {
                    this.vertices[i] = new int[nverts[i]];
                    nverts[i] = 0;
                }
                for (i = 0; i < ntris; ++i) {
                    for (j = 0; j < mdim1; ++j) {
                        int n = this.simplexes[i][j];
                        int n2 = nverts[n];
                        nverts[n] = n2 + 1;
                        this.vertices[this.simplexes[i][j]][n2] = i;
                    }
                }
            }
            if (this.neighbors == null && mdim <= 3) {
                this.neighbors = new int[ntris][mdim1];
                for (i2 = 0; i2 < ntris; ++i2) {
                    block7: for (int j2 = 0; j2 < mdim1; ++j2) {
                        int v1 = j2;
                        int v2 = (v1 + 1) % mdim1;
                        this.neighbors[i2][j2] = -1;
                        for (int k = 0; k < this.vertices[this.simplexes[i2][v1]].length; ++k) {
                            int temp = this.vertices[this.simplexes[i2][v1]][k];
                            if (temp == i2) continue;
                            for (int l = 0; l < this.vertices[this.simplexes[i2][v2]].length; ++l) {
                                if (mdim == 2) {
                                    if (temp != this.vertices[this.simplexes[i2][v2]][l]) continue;
                                    this.neighbors[i2][j2] = temp;
                                    continue block7;
                                }
                                int temp2 = this.vertices[this.simplexes[i2][v2]][l];
                                int v3 = (v2 + 1) % mdim1;
                                if (temp != temp2) continue;
                                for (int m = 0; m < this.vertices[this.simplexes[i2][v3]].length; ++m) {
                                    if (temp != this.vertices[this.simplexes[i2][v3]][m]) continue;
                                    this.neighbors[i2][j2] = temp;
                                    continue block7;
                                }
                            }
                        }
                    }
                }
            }
            if (this.Edges != null || mdim > 3) break block30;
            int edim = 3 * (mdim - 1);
            this.Edges = new int[ntris][edim];
            for (i = 0; i < ntris; ++i) {
                for (j = 0; j < edim; ++j) {
                    this.Edges[i][j] = -1;
                }
            }
            this.NumEdges = 0;
            if (mdim == 2) {
                for (i = 0; i < ntris; ++i) {
                    for (j = 0; j < 3; ++j) {
                        if (this.Edges[i][j] >= 0) continue;
                        int othtri = this.neighbors[i][j];
                        if (othtri >= 0) {
                            int cside = -1;
                            for (int k = 0; k < 3; ++k) {
                                if (this.neighbors[othtri][k] != i) continue;
                                cside = k;
                            }
                            if (cside != -1) {
                                this.Edges[othtri][cside] = this.NumEdges;
                            } else {
                                throw new DelaunayException("Delaunay.finish_triang: error in triangulation!");
                            }
                        }
                        this.Edges[i][j] = this.NumEdges++;
                    }
                }
            } else {
                int[] ptlook1 = new int[]{0, 0, 0, 1, 1, 2};
                int[] ptlook2 = new int[]{1, 2, 3, 2, 3, 3};
                for (int i3 = 0; i3 < ntris; ++i3) {
                    for (int j3 = 0; j3 < 6; ++j3) {
                        if (this.Edges[i3][j3] >= 0) continue;
                        int endpt1 = this.simplexes[i3][ptlook1[j3]];
                        int endpt2 = this.simplexes[i3][ptlook2[j3]];
                        int[] set = new int[this.vertices[endpt1].length];
                        int setlen = 0;
                        block18: for (int p1 = 0; p1 < this.vertices[endpt1].length; ++p1) {
                            int temp = this.vertices[endpt1][p1];
                            for (int p2 = 0; p2 < this.vertices[endpt2].length; ++p2) {
                                if (temp != this.vertices[endpt2][p2]) continue;
                                set[setlen++] = temp;
                                continue block18;
                            }
                        }
                        for (int kk = 0; kk < setlen; ++kk) {
                            int k = set[kk];
                            for (int l = 0; l < edim; ++l) {
                                if ((this.simplexes[k][ptlook1[l]] != endpt1 || this.simplexes[k][ptlook2[l]] != endpt2) && (this.simplexes[k][ptlook1[l]] != endpt2 || this.simplexes[k][ptlook2[l]] != endpt1)) continue;
                                this.Edges[k][l] = this.NumEdges;
                            }
                        }
                        this.Edges[i3][j3] = this.NumEdges++;
                    }
                }
            }
        }
    }

    public String toString() {
        return this.sampleString(null);
    }

    private String sampleString(double[][] samples) {
        int j;
        int i;
        StringBuffer s = new StringBuffer("");
        if (samples != null) {
            s.append("\nsamples " + samples[0].length + "\n");
            for (i = 0; i < samples[0].length; ++i) {
                s.append("  " + i + " -> " + samples[0][i] + " " + samples[1][i] + " " + samples[2][i] + "\n");
            }
            s.append("\n");
        }
        s.append("\nTri (triangles -> vertices) " + this.simplexes.length + "\n");
        for (i = 0; i < this.simplexes.length; ++i) {
            s.append("  " + i + " -> ");
            for (j = 0; j < this.simplexes[i].length; ++j) {
                s.append(" " + this.simplexes[i][j]);
            }
            s.append("\n");
        }
        s.append("\nVertices (vertices -> triangles) " + this.vertices.length + "\n");
        for (i = 0; i < this.vertices.length; ++i) {
            s.append("  " + i + " -> ");
            for (j = 0; j < this.vertices[i].length; ++j) {
                s.append(" " + this.vertices[i][j]);
            }
            s.append("\n");
        }
        if (this.neighbors != null) {
            s.append("\nWalk (triangles -> triangles) " + this.neighbors.length + "\n");
            for (i = 0; i < this.neighbors.length; ++i) {
                s.append("  " + i + " -> ");
                for (j = 0; j < this.neighbors[i].length; ++j) {
                    s.append(" " + this.neighbors[i][j]);
                }
                s.append("\n");
            }
        }
        if (this.Edges != null) {
            s.append("\nEdges (triangles -> global edges) " + this.Edges.length + "\n");
            for (i = 0; i < this.Edges.length; ++i) {
                s.append("  " + i + " -> ");
                for (j = 0; j < this.Edges[i].length; ++j) {
                    s.append(" " + this.Edges[i][j]);
                }
                s.append("\n");
            }
        }
        return s.toString();
    }
}

