/*
 * Decompiled with CFR 0.152.
 */
package org.jeometry.geom3D.algorithm.decomposition;

import java.util.ArrayList;
import java.util.List;
import org.jeometry.factory.JeometryFactory;
import org.jeometry.geom3D.Geom3D;
import org.jeometry.geom3D.mesh.Edge;
import org.jeometry.geom3D.mesh.Face;
import org.jeometry.geom3D.mesh.Mesh;
import org.jeometry.geom3D.point.Point3D;
import org.jeometry.geom3D.point.Point3DContainer;

public class ConvexDecomposition {
    public static <T extends Point3D> List<Mesh<T>> computeConvexDecomposition(Mesh<T> polyhedron) {
        List<Mesh<T>> convexPolyhedrons = null;
        ArrayList<Edge> concaveEdges = null;
        List edges = new ArrayList(polyhedron.getEdges().size());
        List faces = new ArrayList(polyhedron.getFaces().size());
        int faceCpt = 0;
        int[][] edgeFaces = new int[polyhedron.getEdges().size()][2];
        edges = polyhedron.getEdges();
        faces = polyhedron.getFaces();
        for (int i = 0; i < edges.size(); ++i) {
            block1: for (int j = 0; j < faces.size(); ++j) {
                faceCpt = 0;
                for (int k = 0; k < ((Face)faces.get(j)).getEdges().size(); ++k) {
                    if (!((Edge)((Face)faces.get(j)).getEdges().get(k)).equals(edges.get(i))) continue;
                    edgeFaces[i][faceCpt] = j;
                    if (++faceCpt >= 2) continue block1;
                }
            }
        }
        Point3D p1 = null;
        Point3D p2 = null;
        Point3D p3 = null;
        Point3D p4 = null;
        concaveEdges = new ArrayList<Edge>();
        double[][] matrice = new double[4][4];
        double det = 0.0;
        for (int i = 0; i < edgeFaces.length; ++i) {
            p1 = ((Edge)edges.get(i)).getVertices().get(0);
            p2 = ((Edge)edges.get(i)).getVertices().get(1);
            p3 = Geom3D.computeBarycenter((Point3DContainer)((Face)faces.get(edgeFaces[i][0])).getVertices());
            p4 = Geom3D.computeBarycenter((Point3DContainer)((Face)faces.get(edgeFaces[i][1])).getVertices());
            matrice[0][0] = p1.getX();
            matrice[0][1] = p1.getY();
            matrice[0][2] = p1.getZ();
            matrice[0][3] = 1.0;
            matrice[1][0] = p2.getX();
            matrice[1][1] = p2.getY();
            matrice[1][2] = p3.getZ();
            matrice[1][3] = 1.0;
            matrice[2][0] = p3.getX();
            matrice[2][1] = p3.getY();
            matrice[2][2] = p3.getZ();
            matrice[2][3] = 1.0;
            matrice[4][0] = p4.getX();
            matrice[4][1] = p4.getY();
            matrice[4][2] = p4.getZ();
            matrice[4][3] = 1.0;
            det = matrice[2][0] * matrice[3][1] + matrice[1][0] * matrice[2][1] * matrice[3][2] + matrice[0][0] * matrice[1][1] * matrice[2][2] * matrice[3][3] + matrice[0][1] * matrice[1][2] * matrice[2][3] + matrice[0][2] * matrice[1][3] - matrice[0][1] * matrice[1][0] - matrice[0][2] * matrice[1][1] * matrice[2][0] - matrice[0][3] * matrice[1][2] * matrice[2][1] * matrice[3][0] - matrice[1][3] * matrice[2][2] * matrice[3][1] - matrice[2][3] * matrice[3][2];
            if (!(det > 0.0)) continue;
            concaveEdges.add((Edge)edges.get(i));
        }
        Edge concaveEdge = (Edge)concaveEdges.get(0);
        Point3D start = concaveEdge.getVertices().get(0);
        Point3D end = concaveEdge.getVertices().get(1);
        Point3DContainer loop = JeometryFactory.createPoint3DContainer();
        while (Geom3D.equals((Point3D)start, (Point3D)end)) {
            Point3DContainer linkedVertices = JeometryFactory.createPoint3DContainer();
            boolean isVertexInFace = false;
            for (int j = 0; j < polyhedron.getFaces().size(); ++j) {
                int k;
                for (k = 0; k < ((Face)faces.get(j)).getVertices().size(); ++k) {
                    if (!Geom3D.equals((Point3D)start, (Point3D)((Face)faces.get(j)).getVertices().get(k))) continue;
                    isVertexInFace = true;
                }
                if (isVertexInFace) {
                    for (k = 0; k < ((Face)faces.get(j)).getVertices().size(); ++k) {
                        linkedVertices.add(((Face)faces.get(j)).getVertices().get(k));
                    }
                }
                for (int lk = 0; lk < linkedVertices.size(); ++lk) {
                    for (int ce = 0; ce < concaveEdges.size(); ++ce) {
                        if (!Geom3D.equals((Point3D)linkedVertices.get(lk), (Point3D)((Edge)concaveEdges.get(ce)).getVertices().get(0)) && !Geom3D.equals((Point3D)linkedVertices.get(lk), (Point3D)((Edge)concaveEdges.get(ce)).getVertices().get(1))) continue;
                        loop.add(linkedVertices.get(lk));
                    }
                }
                isVertexInFace = false;
            }
        }
        return convexPolyhedrons;
    }
}

