/*
 * Decompiled with CFR 0.152.
 */
package org.jeometry.geom3D.algorithm.bounds;

import java.util.Collection;
import org.jeometry.factory.JeometryFactory;
import org.jeometry.geom3D.mesh.Mesh;
import org.jeometry.geom3D.point.Point3D;
import org.jeometry.geom3D.point.Point3DContainer;
import org.jeometry.geom3D.primitive.Box;

public class AxisAlignedBoundingBox {
    public static Box computeAxisAlignedBoundingBox(Collection<? extends Point3D> points) {
        Point3D pMax = null;
        Point3D pMin = null;
        Object var3_3 = null;
        Box polyhedron = null;
        if (points == null || points.size() < 3) {
            polyhedron = null;
        } else {
            pMax = JeometryFactory.createPoint3D((double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY);
            pMin = JeometryFactory.createPoint3D((double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY);
            for (Point3D point3D : points) {
                if (pMin.getX() > point3D.getX()) {
                    pMin.setX(point3D.getX());
                }
                if (pMin.getY() > point3D.getY()) {
                    pMin.setY(point3D.getY());
                }
                if (pMin.getZ() > point3D.getZ()) {
                    pMin.setZ(point3D.getZ());
                }
                if (pMax.getX() < point3D.getX()) {
                    pMax.setX(point3D.getX());
                }
                if (pMax.getY() < point3D.getY()) {
                    pMax.setY(point3D.getY());
                }
                if (pMax.getZ() < point3D.getZ()) {
                    pMax.setZ(point3D.getZ());
                }
                Object var3_6 = null;
            }
            polyhedron = JeometryFactory.createBox((Point3D)pMin, (Point3D)pMax);
        }
        return polyhedron;
    }

    public static Box computeAxisAlignedBoundingBox(Point3DContainer<?> points) {
        Point3D pMax = null;
        Point3D pMin = null;
        Point3D pt = null;
        Box polyhedron = null;
        if (points == null || points.size() < 3) {
            polyhedron = null;
        } else {
            pMax = JeometryFactory.createPoint3D((double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY);
            pMin = JeometryFactory.createPoint3D((double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY);
            for (int i = 0; i < points.size(); ++i) {
                pt = points.get(i);
                if (pMin.getX() > pt.getX()) {
                    pMin.setX(pt.getX());
                }
                if (pMin.getY() > pt.getY()) {
                    pMin.setY(pt.getY());
                }
                if (pMin.getZ() > pt.getZ()) {
                    pMin.setZ(pt.getZ());
                }
                if (pMax.getX() < pt.getX()) {
                    pMax.setX(pt.getX());
                }
                if (pMax.getY() < pt.getY()) {
                    pMax.setY(pt.getY());
                }
                if (pMax.getZ() < pt.getZ()) {
                    pMax.setZ(pt.getZ());
                }
                pt = null;
            }
            polyhedron = JeometryFactory.createBox((Point3D)pMin, (Point3D)pMax);
        }
        return polyhedron;
    }

    public static Box computeAxisAlignedBoundingBox(Mesh<?> polyhedron) {
        if (polyhedron == null) {
            return null;
        }
        return AxisAlignedBoundingBox.computeAxisAlignedBoundingBox(polyhedron.getVertices());
    }
}

