// line 1 "Scanner.java.rl"
package org.joox.selector;

import java.util.LinkedList;
import java.util.List;

/**
 * A selectors scanner as defined by
 * <a href="http://www.w3.org/TR/css3-selectors/#w3cselgrammar">Selectors Level 3 specification</a>.
 * <p/>
 * This implementation uses the <a href="http://www.complang.org/ragel/">Ragel State Machine Compiler</a>.
 * <p/>
 * Use the following command to generate the Java code for the scanner:
 * <br/>
 * <pre>
 * ragel -J Scanner.java.rl -o ../java/se/fishtank/css/selectors/scanner/Scanner.java
 * </pre>
 *
 * @author Christer Sandberg
 */
@SuppressWarnings("all")
public class Scanner {

	/** The input to scan. */
	private final String input;

	/**
	 * Create a new scanner instance with the specified {@code input}.
	 */
	public Scanner(CharSequence input) {
	    Assert.notNull(input, "input is null!");
	    this.input = input.toString();
	}


// line 45 "../java/se/fishtank/css/selectors/scanner/Scanner.java"
private static byte[] init__Scanner_actions_0()
{
	return new byte [] {
	    0,    1,    0,    1,    1,    1,    2,    1,    3,    1,    4,    1,
	    5,    1,    6,    1,    7,    1,    8,    1,    9,    1,   12,    1,
	   13,    1,   14,    1,   15,    1,   16,    2,    1,    0,    2,    1,
	    9,    2,    2,    9,    2,    3,    0,    2,    4,   15,    2,    4,
	   16,    2,    6,    9,    2,    8,   15,    2,    8,   16,    2,   10,
	   17,    2,   11,   18,    2,   12,   15,    2,   12,   16,    2,   15,
	    5,    2,   15,    7,    2,   15,   16,    2,   16,    4,    2,   16,
	    8,    2,   16,   12,    2,   16,   15,    3,    4,   15,    5,    3,
	    4,   15,    7,    3,    4,   15,   16,    3,    8,   15,    5,    3,
	    8,   15,    7,    3,    8,   15,   16,    3,   12,   15,    5,    3,
	   12,   15,    7,    3,   12,   15,   16,    3,   15,   11,   18,    3,
	   15,   16,    5,    3,   15,   16,    7,    3,   16,    4,   15,    3,
	   16,    8,   15,    3,   16,   12,   15,    3,   16,   15,    5,    3,
	   16,   15,    7,    4,    4,   15,   11,   18,    4,    4,   15,   16,
	    5,    4,    4,   15,   16,    7,    4,    8,   15,   11,   18,    4,
	    8,   15,   16,    5,    4,    8,   15,   16,    7,    4,   12,   15,
	   11,   18,    4,   12,   15,   16,    5,    4,   12,   15,   16,    7,
	    4,   16,    4,   15,    5,    4,   16,    4,   15,    7,    4,   16,
	    8,   15,    5,    4,   16,    8,   15,    7,    4,   16,   12,   15,
	    5,    4,   16,   12,   15,    7,    4,   16,   15,   11,   18
	};
}

private static final byte _Scanner_actions[] = init__Scanner_actions_0();


private static short[] init__Scanner_key_offsets_0()
{
	return new short [] {
	    0,    0,   17,   28,   39,   56,   65,   73,   84,   92,  102,  105,
	  112,  116,  128,  136,  157,  167,  168,  182,  196,  203,  207,  211,
	  233,  241,  261,  281,  301,  321,  341,  349,  356,  378,  386,  406,
	  426,  446,  466,  486,  494,  502,  517,  528,  547,  566,  585,  604,
	  623,  638,  649,  674,  699,  724,  749,  774,  795,  801,  806,  811,
	  817,  818,  819,  820,  824,  825,  826,  837,  848,  857,  865,  876,
	  887,  898,  909,  917,  928,  939,  948,  956,  967,  975,  985,  988,
	  995,  999, 1011, 1019, 1040, 1050, 1051, 1065, 1079, 1086, 1090, 1094,
	 1116, 1124, 1144, 1164, 1184, 1204, 1224, 1232, 1239, 1261, 1269, 1289,
	 1309, 1329, 1349, 1369, 1377, 1385, 1400, 1411, 1430, 1449, 1468, 1487,
	 1506, 1521, 1532, 1557, 1582, 1607, 1632, 1657, 1678, 1684, 1689, 1694,
	 1700, 1701, 1702, 1703, 1707, 1708, 1709, 1720, 1731, 1740, 1748, 1759,
	 1770, 1781, 1792, 1803, 1814, 1822, 1833, 1850, 1861, 1880, 1884, 1893,
	 1901, 1920, 1930, 1938, 1958, 1968, 1971, 1978, 1982, 1990, 2002, 2010,
	 2031, 2041, 2042, 2056, 2070, 2077, 2081, 2085, 2107, 2115, 2135, 2155,
	 2175, 2195, 2215, 2223, 2230, 2252, 2260, 2280, 2300, 2320, 2340, 2360,
	 2368, 2376, 2391, 2402, 2421, 2440, 2459, 2478, 2497, 2512, 2523, 2548,
	 2573, 2598, 2623, 2648, 2669, 2675, 2680, 2685, 2691, 2692, 2693, 2694,
	 2698, 2699, 2700, 2711, 2735, 2759, 2783, 2807, 2831, 2851, 2872, 2893,
	 2912, 2923, 2946, 2969, 2992, 3015, 3038, 3057, 3068, 3091, 3114, 3137,
	 3160, 3183, 3202, 3210, 3218, 3237, 3248, 3271, 3294, 3317, 3340, 3363,
	 3382, 3404, 3425, 3447, 3458, 3480, 3503, 3514, 3541, 3565, 3588, 3611,
	 3638, 3662, 3689, 3716, 3743, 3770, 3793, 3820, 3847, 3874, 3901, 3924,
	 3946, 3972, 3995, 4017, 4039, 4065, 4088, 4114, 4140, 4166, 4192, 4214,
	 4240, 4266, 4292, 4318, 4340, 4364, 4388, 4411, 4437, 4460, 4482, 4504,
	 4530, 4553, 4579, 4605, 4631, 4657, 4679, 4705, 4731, 4757, 4783, 4805,
	 4831, 4854, 4876, 4898, 4924, 4947, 4973, 4999, 5025, 5051, 5073, 5099,
	 5125, 5151, 5177, 5199, 5221, 5244, 5255, 5282, 5306, 5329, 5352, 5379,
	 5403, 5430, 5457, 5484, 5511, 5534, 5561, 5588, 5615, 5642, 5665, 5687,
	 5713, 5736, 5758, 5780, 5806, 5829, 5855, 5881, 5907, 5933, 5955, 5981,
	 6007, 6033, 6059, 6081, 6105, 6129, 6152, 6178, 6201, 6223, 6245, 6271,
	 6294, 6320, 6346, 6372, 6398, 6420, 6446, 6472, 6498, 6524, 6546, 6572,
	 6595, 6617, 6639, 6665, 6688, 6714, 6740, 6766, 6792, 6814, 6840, 6866,
	 6892, 6918, 6940, 6951, 6973, 6999, 7022, 7048, 7074, 7100, 7126, 7148
	};
}

private static final short _Scanner_key_offsets[] = init__Scanner_key_offsets_0();


private static char[] init__Scanner_trans_keys_0()
{
	return new char [] {
	   32,   35,   42,   45,   46,   58,   91,   92,   95,    9,   13,   65,
	   90,   97,  122,  128,  255,   45,   92,   95,   48,   57,   65,   90,
	   97,  122,  128,  255,   45,   92,   95,   48,   57,   65,   90,   97,
	  122,  128,  255,   32,   35,   42,   45,   46,   58,   91,   92,   95,
	    9,   13,   65,   90,   97,  122,  128,  255,   45,   92,   95,   65,
	   90,   97,  122,  128,  255,   92,   95,   65,   90,   97,  122,  128,
	  255,   45,   58,   92,   95,  110,   65,   90,   97,  122,  128,  255,
	   92,   95,   65,   90,   97,  122,  128,  255,   32,   43,   45,  101,
	  110,  111,    9,   13,   48,   57,  110,   48,   57,   32,   41,  110,
	    9,   13,   48,   57,   32,   41,    9,   13,   32,   45,   92,   95,
	    9,   13,   65,   90,   97,  122,  128,  255,   92,   95,   65,   90,
	   97,  122,  128,  255,   32,   36,   42,   45,   61,   92,   93,   94,
	   95,  124,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,
	  255,   32,   36,   42,   61,   93,   94,  124,  126,    9,   13,   61,
	   32,   34,   39,   45,   92,   95,    9,   13,   65,   90,   97,  122,
	  128,  255,   32,   34,   39,   45,   92,   95,    9,   13,   65,   90,
	   97,  122,  128,  255,    9,   34,   92,   32,  126,  128,  255,   32,
	   93,    9,   13,   32,   93,    9,   13,   12,   13,   34,   92,    9,
	   10,   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,   97,
	  102,  103,  126,  128,  255,   34,   92,    9,   10,   32,  126,  128,
	  255,   34,   92,    9,   13,   32,   47,   48,   57,   58,   64,   65,
	   70,   71,   96,   97,  102,  103,  126,  128,  255,   34,   92,    9,
	   13,   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,   97,
	  102,  103,  126,  128,  255,   34,   92,    9,   13,   32,   47,   48,
	   57,   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,
	  255,   34,   92,    9,   13,   32,   47,   48,   57,   58,   64,   65,
	   70,   71,   96,   97,  102,  103,  126,  128,  255,   34,   92,    9,
	   13,   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,   97,
	  102,  103,  126,  128,  255,   34,   92,    9,   13,   32,  126,  128,
	  255,    9,   39,   92,   32,  126,  128,  255,   12,   13,   39,   92,
	    9,   10,   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,
	   97,  102,  103,  126,  128,  255,   39,   92,    9,   10,   32,  126,
	  128,  255,   39,   92,    9,   13,   32,   47,   48,   57,   58,   64,
	   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,   39,   92,
	    9,   13,   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,
	   97,  102,  103,  126,  128,  255,   39,   92,    9,   13,   32,   47,
	   48,   57,   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,
	  128,  255,   39,   92,    9,   13,   32,   47,   48,   57,   58,   64,
	   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,   39,   92,
	    9,   13,   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,
	   97,  102,  103,  126,  128,  255,   39,   92,    9,   13,   32,  126,
	  128,  255,   92,   95,   65,   90,   97,  122,  128,  255,   32,   45,
	   92,   93,   95,    9,   13,   48,   57,   65,   90,   97,  122,  128,
	  255,   32,   45,  126,   48,   57,   65,   70,   97,  102,  128,  255,
	   32,   45,   92,   93,   95,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   45,   92,   93,   95,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   45,   92,   93,   95,    9,   13,   48,   57,   65,
	   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   45,   92,
	   93,   95,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   45,   92,   93,   95,    9,   13,   48,
	   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,
	   45,   92,   93,   95,    9,   13,   48,   57,   65,   90,   97,  122,
	  128,  255,   32,   45,  126,   48,   57,   65,   70,   97,  102,  128,
	  255,   32,   36,   42,   45,   61,   92,   93,   94,   95,  124,  126,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   36,   42,   45,   61,   92,   93,   94,   95,  124,
	  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,
	  122,  128,  255,   32,   36,   42,   45,   61,   92,   93,   94,   95,
	  124,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   36,   42,   45,   61,   92,   93,   94,
	   95,  124,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   36,   42,   45,   61,   92,   93,
	   94,   95,  124,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   36,   42,   45,   61,   92,
	   93,   94,   95,  124,  126,    9,   13,   48,   57,   65,   90,   97,
	  122,  128,  255,   32,   41,   43,   45,    9,   13,   32,   43,   45,
	    9,   13,   32,    9,   13,   48,   57,   32,   41,    9,   13,   48,
	   57,  118,  101,  110,   32,   41,    9,   13,  100,  100,   32,   45,
	  126,   48,   57,   65,   70,   97,  102,  128,  255,   32,   45,  126,
	   48,   57,   65,   70,   97,  102,  128,  255,   45,   92,   95,   65,
	   90,   97,  122,  128,  255,   92,   95,   65,   90,   97,  122,  128,
	  255,   32,   45,  126,   48,   57,   65,   70,   97,  102,  128,  255,
	   32,   45,  126,   48,   57,   65,   70,   97,  102,  128,  255,   32,
	   45,  126,   48,   57,   65,   70,   97,  102,  128,  255,   32,   45,
	  126,   48,   57,   65,   70,   97,  102,  128,  255,   92,   95,   65,
	   90,   97,  122,  128,  255,   32,   45,  126,   48,   57,   65,   70,
	   97,  102,  128,  255,   32,   45,  126,   48,   57,   65,   70,   97,
	  102,  128,  255,   45,   92,   95,   65,   90,   97,  122,  128,  255,
	   92,   95,   65,   90,   97,  122,  128,  255,   45,   58,   92,   95,
	  110,   65,   90,   97,  122,  128,  255,   92,   95,   65,   90,   97,
	  122,  128,  255,   32,   43,   45,  101,  110,  111,    9,   13,   48,
	   57,  110,   48,   57,   32,   41,  110,    9,   13,   48,   57,   32,
	   41,    9,   13,   32,   45,   92,   95,    9,   13,   65,   90,   97,
	  122,  128,  255,   92,   95,   65,   90,   97,  122,  128,  255,   32,
	   36,   42,   45,   61,   92,   93,   94,   95,  124,  126,    9,   13,
	   48,   57,   65,   90,   97,  122,  128,  255,   32,   36,   42,   61,
	   93,   94,  124,  126,    9,   13,   61,   32,   34,   39,   45,   92,
	   95,    9,   13,   65,   90,   97,  122,  128,  255,   32,   34,   39,
	   45,   92,   95,    9,   13,   65,   90,   97,  122,  128,  255,    9,
	   34,   92,   32,  126,  128,  255,   32,   93,    9,   13,   32,   93,
	    9,   13,   12,   13,   34,   92,    9,   10,   32,   47,   48,   57,
	   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,
	   34,   92,    9,   10,   32,  126,  128,  255,   34,   92,    9,   13,
	   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,   97,  102,
	  103,  126,  128,  255,   34,   92,    9,   13,   32,   47,   48,   57,
	   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,
	   34,   92,    9,   13,   32,   47,   48,   57,   58,   64,   65,   70,
	   71,   96,   97,  102,  103,  126,  128,  255,   34,   92,    9,   13,
	   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,   97,  102,
	  103,  126,  128,  255,   34,   92,    9,   13,   32,   47,   48,   57,
	   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,
	   34,   92,    9,   13,   32,  126,  128,  255,    9,   39,   92,   32,
	  126,  128,  255,   12,   13,   39,   92,    9,   10,   32,   47,   48,
	   57,   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,
	  255,   39,   92,    9,   10,   32,  126,  128,  255,   39,   92,    9,
	   13,   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,   97,
	  102,  103,  126,  128,  255,   39,   92,    9,   13,   32,   47,   48,
	   57,   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,
	  255,   39,   92,    9,   13,   32,   47,   48,   57,   58,   64,   65,
	   70,   71,   96,   97,  102,  103,  126,  128,  255,   39,   92,    9,
	   13,   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,   97,
	  102,  103,  126,  128,  255,   39,   92,    9,   13,   32,   47,   48,
	   57,   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,
	  255,   39,   92,    9,   13,   32,  126,  128,  255,   92,   95,   65,
	   90,   97,  122,  128,  255,   32,   45,   92,   93,   95,    9,   13,
	   48,   57,   65,   90,   97,  122,  128,  255,   32,   45,  126,   48,
	   57,   65,   70,   97,  102,  128,  255,   32,   45,   92,   93,   95,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   45,   92,   93,   95,    9,   13,   48,   57,   65,
	   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   45,   92,
	   93,   95,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   45,   92,   93,   95,    9,   13,   48,
	   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,
	   45,   92,   93,   95,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   45,   92,   93,   95,    9,
	   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   45,  126,
	   48,   57,   65,   70,   97,  102,  128,  255,   32,   36,   42,   45,
	   61,   92,   93,   94,   95,  124,  126,    9,   13,   48,   57,   65,
	   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   36,   42,
	   45,   61,   92,   93,   94,   95,  124,  126,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   36,
	   42,   45,   61,   92,   93,   94,   95,  124,  126,    9,   13,   48,
	   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,
	   36,   42,   45,   61,   92,   93,   94,   95,  124,  126,    9,   13,
	   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,
	   32,   36,   42,   45,   61,   92,   93,   94,   95,  124,  126,    9,
	   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,
	  255,   32,   36,   42,   45,   61,   92,   93,   94,   95,  124,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   41,
	   43,   45,    9,   13,   32,   43,   45,    9,   13,   32,    9,   13,
	   48,   57,   32,   41,    9,   13,   48,   57,  118,  101,  110,   32,
	   41,    9,   13,  100,  100,   32,   45,  126,   48,   57,   65,   70,
	   97,  102,  128,  255,   32,   45,  126,   48,   57,   65,   70,   97,
	  102,  128,  255,   45,   92,   95,   65,   90,   97,  122,  128,  255,
	   92,   95,   65,   90,   97,  122,  128,  255,   32,   45,  126,   48,
	   57,   65,   70,   97,  102,  128,  255,   32,   45,  126,   48,   57,
	   65,   70,   97,  102,  128,  255,   32,   45,  126,   48,   57,   65,
	   70,   97,  102,  128,  255,   32,   45,  126,   48,   57,   65,   70,
	   97,  102,  128,  255,   32,   45,  126,   48,   57,   65,   70,   97,
	  102,  128,  255,   32,   45,  126,   48,   57,   65,   70,   97,  102,
	  128,  255,   92,   95,   65,   90,   97,  122,  128,  255,   32,   45,
	  126,   48,   57,   65,   70,   97,  102,  128,  255,   32,   35,   42,
	   45,   46,   58,   91,   92,   95,    9,   13,   65,   90,   97,  122,
	  128,  255,   45,   92,   95,   48,   57,   65,   90,   97,  122,  128,
	  255,   32,   35,   41,   45,   46,   58,   91,   92,   95,    9,   13,
	   48,   57,   65,   90,   97,  122,  128,  255,   32,   41,    9,   13,
	   45,   92,   95,   65,   90,   97,  122,  128,  255,   92,   95,   65,
	   90,   97,  122,  128,  255,   32,   35,   41,   45,   46,   58,   91,
	   92,   95,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,
	   45,   92,   95,  110,   65,   90,   97,  122,  128,  255,   92,   95,
	   65,   90,   97,  122,  128,  255,   32,   35,   40,   41,   45,   46,
	   58,   91,   92,   95,    9,   13,   48,   57,   65,   90,   97,  122,
	  128,  255,   32,   43,   45,  101,  110,  111,    9,   13,   48,   57,
	  110,   48,   57,   32,   41,  110,    9,   13,   48,   57,   32,   41,
	    9,   13,   32,   35,   41,   46,   58,   91,    9,   13,   32,   45,
	   92,   95,    9,   13,   65,   90,   97,  122,  128,  255,   92,   95,
	   65,   90,   97,  122,  128,  255,   32,   36,   42,   45,   61,   92,
	   93,   94,   95,  124,  126,    9,   13,   48,   57,   65,   90,   97,
	  122,  128,  255,   32,   36,   42,   61,   93,   94,  124,  126,    9,
	   13,   61,   32,   34,   39,   45,   92,   95,    9,   13,   65,   90,
	   97,  122,  128,  255,   32,   34,   39,   45,   92,   95,    9,   13,
	   65,   90,   97,  122,  128,  255,    9,   34,   92,   32,  126,  128,
	  255,   32,   93,    9,   13,   32,   93,    9,   13,   12,   13,   34,
	   92,    9,   10,   32,   47,   48,   57,   58,   64,   65,   70,   71,
	   96,   97,  102,  103,  126,  128,  255,   34,   92,    9,   10,   32,
	  126,  128,  255,   34,   92,    9,   13,   32,   47,   48,   57,   58,
	   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,   34,
	   92,    9,   13,   32,   47,   48,   57,   58,   64,   65,   70,   71,
	   96,   97,  102,  103,  126,  128,  255,   34,   92,    9,   13,   32,
	   47,   48,   57,   58,   64,   65,   70,   71,   96,   97,  102,  103,
	  126,  128,  255,   34,   92,    9,   13,   32,   47,   48,   57,   58,
	   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,   34,
	   92,    9,   13,   32,   47,   48,   57,   58,   64,   65,   70,   71,
	   96,   97,  102,  103,  126,  128,  255,   34,   92,    9,   13,   32,
	  126,  128,  255,    9,   39,   92,   32,  126,  128,  255,   12,   13,
	   39,   92,    9,   10,   32,   47,   48,   57,   58,   64,   65,   70,
	   71,   96,   97,  102,  103,  126,  128,  255,   39,   92,    9,   10,
	   32,  126,  128,  255,   39,   92,    9,   13,   32,   47,   48,   57,
	   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,
	   39,   92,    9,   13,   32,   47,   48,   57,   58,   64,   65,   70,
	   71,   96,   97,  102,  103,  126,  128,  255,   39,   92,    9,   13,
	   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,   97,  102,
	  103,  126,  128,  255,   39,   92,    9,   13,   32,   47,   48,   57,
	   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,
	   39,   92,    9,   13,   32,   47,   48,   57,   58,   64,   65,   70,
	   71,   96,   97,  102,  103,  126,  128,  255,   39,   92,    9,   13,
	   32,  126,  128,  255,   92,   95,   65,   90,   97,  122,  128,  255,
	   32,   45,   92,   93,   95,    9,   13,   48,   57,   65,   90,   97,
	  122,  128,  255,   32,   45,  126,   48,   57,   65,   70,   97,  102,
	  128,  255,   32,   45,   92,   93,   95,    9,   13,   48,   57,   65,
	   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   45,   92,
	   93,   95,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   45,   92,   93,   95,    9,   13,   48,
	   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,
	   45,   92,   93,   95,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   45,   92,   93,   95,    9,
	   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,
	  255,   32,   45,   92,   93,   95,    9,   13,   48,   57,   65,   90,
	   97,  122,  128,  255,   32,   45,  126,   48,   57,   65,   70,   97,
	  102,  128,  255,   32,   36,   42,   45,   61,   92,   93,   94,   95,
	  124,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   36,   42,   45,   61,   92,   93,   94,
	   95,  124,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   36,   42,   45,   61,   92,   93,
	   94,   95,  124,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   36,   42,   45,   61,   92,
	   93,   94,   95,  124,  126,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   36,   42,   45,   61,
	   92,   93,   94,   95,  124,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   36,   42,   45,
	   61,   92,   93,   94,   95,  124,  126,    9,   13,   48,   57,   65,
	   90,   97,  122,  128,  255,   32,   41,   43,   45,    9,   13,   32,
	   43,   45,    9,   13,   32,    9,   13,   48,   57,   32,   41,    9,
	   13,   48,   57,  118,  101,  110,   32,   41,    9,   13,  100,  100,
	   32,   45,  126,   48,   57,   65,   70,   97,  102,  128,  255,   32,
	   35,   40,   41,   45,   46,   58,   91,   92,   95,    9,   13,   48,
	   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,
	   35,   40,   41,   45,   46,   58,   91,   92,   95,    9,   13,   48,
	   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,
	   35,   40,   41,   45,   46,   58,   91,   92,   95,    9,   13,   48,
	   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,
	   35,   40,   41,   45,   46,   58,   91,   92,   95,    9,   13,   48,
	   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,
	   35,   40,   41,   45,   46,   58,   91,   92,   95,    9,   13,   48,
	   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,
	   35,   40,   41,   45,   46,   58,   91,   92,   95,    9,   13,   48,
	   57,   65,   90,   97,  122,  128,  255,   32,   35,   40,   41,   45,
	   46,   58,   91,   92,   95,  111,    9,   13,   48,   57,   65,   90,
	   97,  122,  128,  255,   32,   35,   40,   41,   45,   46,   58,   91,
	   92,   95,  116,    9,   13,   48,   57,   65,   90,   97,  122,  128,
	  255,   32,   35,   41,   45,   46,   58,   91,   92,   95,    9,   13,
	   48,   57,   65,   90,   97,  122,  128,  255,   32,   45,  126,   48,
	   57,   65,   70,   97,  102,  128,  255,   32,   35,   41,   45,   46,
	   58,   91,   92,   95,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   41,   45,   46,   58,
	   91,   92,   95,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   35,   41,   45,   46,   58,   91,
	   92,   95,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   41,   45,   46,   58,   91,   92,
	   95,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,
	  122,  128,  255,   32,   35,   41,   45,   46,   58,   91,   92,   95,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   35,   41,   45,   46,   58,   91,   92,   95,    9,
	   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   45,  126,
	   48,   57,   65,   70,   97,  102,  128,  255,   32,   35,   41,   45,
	   46,   58,   91,   92,   95,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   35,   41,   45,   46,
	   58,   91,   92,   95,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   41,   45,   46,   58,
	   91,   92,   95,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   35,   41,   45,   46,   58,   91,
	   92,   95,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   41,   45,   46,   58,   91,   92,
	   95,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,
	  122,  128,  255,   32,   35,   41,   45,   46,   58,   91,   92,   95,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   41,   46,   58,   91,    9,   13,   92,   95,   65,   90,   97,  122,
	  128,  255,   32,   35,   41,   45,   46,   58,   91,   92,   95,    9,
	   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   45,  126,
	   48,   57,   65,   70,   97,  102,  128,  255,   32,   35,   41,   45,
	   46,   58,   91,   92,   95,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   35,   41,   45,   46,
	   58,   91,   92,   95,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   41,   45,   46,   58,
	   91,   92,   95,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   35,   41,   45,   46,   58,   91,
	   92,   95,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   41,   45,   46,   58,   91,   92,
	   95,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,
	  122,  128,  255,   32,   35,   41,   45,   46,   58,   91,   92,   95,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   42,   43,
	   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   65,
	   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,
	  122,  128,  255,   32,   35,   43,   44,   46,   58,   62,   91,  126,
	    9,   13,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,
	   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,
	  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,
	   35,   43,   44,   46,   58,   62,   91,  126,    9,   13,   32,   35,
	   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,
	   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,
	  255,   32,   35,   40,   42,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,
	  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,
	   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,
	  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,
	   35,   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   35,   40,   42,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,
	  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   35,   40,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   40,   43,
	   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,
	   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,
	   35,   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,
	  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   35,   40,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,
	   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,
	   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,
	  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,
	   32,   35,   42,   43,   44,   45,   46,   58,   62,   91,   92,   95,
	  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,
	   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,
	   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,
	   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,
	   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,
	   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,
	   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   42,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,
	  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   40,   43,
	   44,   45,   46,   58,   62,   91,   92,   95,  111,  126,    9,   13,
	   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   40,   43,
	   44,   45,   46,   58,   62,   91,   92,   95,  116,  126,    9,   13,
	   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   40,   43,
	   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,
	   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,
	   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,
	   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   42,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,
	   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   42,   43,   44,   45,
	   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,
	   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,
	   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,
	   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   43,
	   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,
	   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,
	   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,
	   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,
	  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,
	  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,
	   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,
	   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,
	  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,
	  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,
	  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,
	   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,
	   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   35,   42,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,
	   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,
	  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   42,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,
	  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,
	   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,
	   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   43,
	   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,
	   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,
	   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,
	   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,
	   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,
	   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,
	   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,
	   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,
	  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,
	  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,
	  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,
	  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,
	  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,
	   32,   35,   43,   44,   46,   58,   62,   91,  126,    9,   13,   32,
	   35,   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   35,   40,   42,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,
	  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,
	  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,
	   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,
	  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,
	  122,  128,  255,   32,   35,   40,   42,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,
	  122,  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   40,   43,   44,   45,
	   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,
	   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   40,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,
	   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,
	  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,
	  122,  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,
	  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   35,   40,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   40,   43,
	   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,
	   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,
	   35,   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,
	  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,
	  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,
	   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,
	   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,
	  255,   32,   35,   42,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,
	   42,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,
	   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,
	   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,
	   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,
	   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,
	   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,
	  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,
	  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,
	  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,
	  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,
	   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,
	   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   43,
	   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,
	   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,
	   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,
	   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   40,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  111,  126,    9,
	   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   40,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  116,  126,    9,
	   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   40,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,
	   42,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,
	   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,
	   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,
	   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,
	   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,
	   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   35,   42,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   42,   43,
	   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,
	   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,
	   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,
	   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,
	  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   35,   42,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,
	   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,
	   97,  122,  128,  255,   32,   35,   43,   44,   46,   58,   62,   91,
	  126,    9,   13,   32,   35,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,
	  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,
	  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,
	  122,  128,  255,   32,   35,   42,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,
	  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   90,   97,  122,  128,  255,    0
	};
}

private static final char _Scanner_trans_keys[] = init__Scanner_trans_keys_0();


private static byte[] init__Scanner_single_lengths_0()
{
	return new byte [] {
	    0,    9,    3,    3,    9,    3,    2,    5,    2,    6,    1,    3,
	    2,    4,    2,   11,    8,    1,    6,    6,    3,    2,    2,    4,
	    2,    2,    2,    2,    2,    2,    2,    3,    4,    2,    2,    2,
	    2,    2,    2,    2,    2,    5,    3,    5,    5,    5,    5,    5,
	    5,    3,   11,   11,   11,   11,   11,   11,    4,    3,    1,    2,
	    1,    1,    1,    2,    1,    1,    3,    3,    3,    2,    3,    3,
	    3,    3,    2,    3,    3,    3,    2,    5,    2,    6,    1,    3,
	    2,    4,    2,   11,    8,    1,    6,    6,    3,    2,    2,    4,
	    2,    2,    2,    2,    2,    2,    2,    3,    4,    2,    2,    2,
	    2,    2,    2,    2,    2,    5,    3,    5,    5,    5,    5,    5,
	    5,    3,   11,   11,   11,   11,   11,   11,    4,    3,    1,    2,
	    1,    1,    1,    2,    1,    1,    3,    3,    3,    2,    3,    3,
	    3,    3,    3,    3,    2,    3,    9,    3,    9,    2,    3,    2,
	    9,    4,    2,   10,    6,    1,    3,    2,    6,    4,    2,   11,
	    8,    1,    6,    6,    3,    2,    2,    4,    2,    2,    2,    2,
	    2,    2,    2,    3,    4,    2,    2,    2,    2,    2,    2,    2,
	    2,    5,    3,    5,    5,    5,    5,    5,    5,    3,   11,   11,
	   11,   11,   11,   11,    4,    3,    1,    2,    1,    1,    1,    2,
	    1,    1,    3,   10,   10,   10,   10,   10,   10,   11,   11,    9,
	    3,    9,    9,    9,    9,    9,    9,    3,    9,    9,    9,    9,
	    9,    9,    6,    2,    9,    3,    9,    9,    9,    9,    9,    9,
	   12,   13,   12,    9,   12,   13,    9,   13,   14,   13,   13,   13,
	   14,   13,   13,   13,   13,   13,   13,   13,   13,   13,   13,   12,
	   12,   13,   12,   12,   12,   13,   12,   12,   12,   12,   12,   12,
	   12,   12,   12,   12,   14,   14,   13,   12,   13,   12,   12,   12,
	   13,   12,   12,   12,   12,   12,   12,   12,   12,   12,   12,   12,
	   13,   12,   12,   12,   13,   12,   12,   12,   12,   12,   12,   12,
	   12,   12,   12,   12,   13,    9,   13,   14,   13,   13,   13,   14,
	   13,   13,   13,   13,   13,   13,   13,   13,   13,   13,   12,   12,
	   13,   12,   12,   12,   13,   12,   12,   12,   12,   12,   12,   12,
	   12,   12,   12,   14,   14,   13,   12,   13,   12,   12,   12,   13,
	   12,   12,   12,   12,   12,   12,   12,   12,   12,   12,   12,   13,
	   12,   12,   12,   13,   12,   12,   12,   12,   12,   12,   12,   12,
	   12,   12,    9,   12,   12,   13,   12,   12,   12,   12,   12,    0
	};
}

private static final byte _Scanner_single_lengths[] = init__Scanner_single_lengths_0();


private static byte[] init__Scanner_range_lengths_0()
{
	return new byte [] {
	    0,    4,    4,    4,    4,    3,    3,    3,    3,    2,    1,    2,
	    1,    4,    3,    5,    1,    0,    4,    4,    2,    1,    1,    9,
	    3,    9,    9,    9,    9,    9,    3,    2,    9,    3,    9,    9,
	    9,    9,    9,    3,    3,    5,    4,    7,    7,    7,    7,    7,
	    5,    4,    7,    7,    7,    7,    7,    5,    1,    1,    2,    2,
	    0,    0,    0,    1,    0,    0,    4,    4,    3,    3,    4,    4,
	    4,    4,    3,    4,    4,    3,    3,    3,    3,    2,    1,    2,
	    1,    4,    3,    5,    1,    0,    4,    4,    2,    1,    1,    9,
	    3,    9,    9,    9,    9,    9,    3,    2,    9,    3,    9,    9,
	    9,    9,    9,    3,    3,    5,    4,    7,    7,    7,    7,    7,
	    5,    4,    7,    7,    7,    7,    7,    5,    1,    1,    2,    2,
	    0,    0,    0,    1,    0,    0,    4,    4,    3,    3,    4,    4,
	    4,    4,    4,    4,    3,    4,    4,    4,    5,    1,    3,    3,
	    5,    3,    3,    5,    2,    1,    2,    1,    1,    4,    3,    5,
	    1,    0,    4,    4,    2,    1,    1,    9,    3,    9,    9,    9,
	    9,    9,    3,    2,    9,    3,    9,    9,    9,    9,    9,    3,
	    3,    5,    4,    7,    7,    7,    7,    7,    5,    4,    7,    7,
	    7,    7,    7,    5,    1,    1,    2,    2,    0,    0,    0,    1,
	    0,    0,    4,    7,    7,    7,    7,    7,    5,    5,    5,    5,
	    4,    7,    7,    7,    7,    7,    5,    4,    7,    7,    7,    7,
	    7,    5,    1,    3,    5,    4,    7,    7,    7,    7,    7,    5,
	    5,    4,    5,    1,    5,    5,    1,    7,    5,    5,    5,    7,
	    5,    7,    7,    7,    7,    5,    7,    7,    7,    7,    5,    5,
	    7,    5,    5,    5,    7,    5,    7,    7,    7,    7,    5,    7,
	    7,    7,    7,    5,    5,    5,    5,    7,    5,    5,    5,    7,
	    5,    7,    7,    7,    7,    5,    7,    7,    7,    7,    5,    7,
	    5,    5,    5,    7,    5,    7,    7,    7,    7,    5,    7,    7,
	    7,    7,    5,    5,    5,    1,    7,    5,    5,    5,    7,    5,
	    7,    7,    7,    7,    5,    7,    7,    7,    7,    5,    5,    7,
	    5,    5,    5,    7,    5,    7,    7,    7,    7,    5,    7,    7,
	    7,    7,    5,    5,    5,    5,    7,    5,    5,    5,    7,    5,
	    7,    7,    7,    7,    5,    7,    7,    7,    7,    5,    7,    5,
	    5,    5,    7,    5,    7,    7,    7,    7,    5,    7,    7,    7,
	    7,    5,    1,    5,    7,    5,    7,    7,    7,    7,    5,    0
	};
}

private static final byte _Scanner_range_lengths[] = init__Scanner_range_lengths_0();


private static short[] init__Scanner_index_offsets_0()
{
	return new short [] {
	    0,    0,   14,   22,   30,   44,   51,   57,   66,   72,   81,   84,
	   90,   94,  103,  109,  126,  136,  138,  149,  160,  166,  170,  174,
	  188,  194,  206,  218,  230,  242,  254,  260,  266,  280,  286,  298,
	  310,  322,  334,  346,  352,  358,  369,  377,  390,  403,  416,  429,
	  442,  453,  461,  480,  499,  518,  537,  556,  573,  579,  584,  588,
	  593,  595,  597,  599,  603,  605,  607,  615,  623,  630,  636,  644,
	  652,  660,  668,  674,  682,  690,  697,  703,  712,  718,  727,  730,
	  736,  740,  749,  755,  772,  782,  784,  795,  806,  812,  816,  820,
	  834,  840,  852,  864,  876,  888,  900,  906,  912,  926,  932,  944,
	  956,  968,  980,  992,  998, 1004, 1015, 1023, 1036, 1049, 1062, 1075,
	 1088, 1099, 1107, 1126, 1145, 1164, 1183, 1202, 1219, 1225, 1230, 1234,
	 1239, 1241, 1243, 1245, 1249, 1251, 1253, 1261, 1269, 1276, 1282, 1290,
	 1298, 1306, 1314, 1322, 1330, 1336, 1344, 1358, 1366, 1381, 1385, 1392,
	 1398, 1413, 1421, 1427, 1443, 1452, 1455, 1461, 1465, 1473, 1482, 1488,
	 1505, 1515, 1517, 1528, 1539, 1545, 1549, 1553, 1567, 1573, 1585, 1597,
	 1609, 1621, 1633, 1639, 1645, 1659, 1665, 1677, 1689, 1701, 1713, 1725,
	 1731, 1737, 1748, 1756, 1769, 1782, 1795, 1808, 1821, 1832, 1840, 1859,
	 1878, 1897, 1916, 1935, 1952, 1958, 1963, 1967, 1972, 1974, 1976, 1978,
	 1982, 1984, 1986, 1994, 2012, 2030, 2048, 2066, 2084, 2100, 2117, 2134,
	 2149, 2157, 2174, 2191, 2208, 2225, 2242, 2257, 2265, 2282, 2299, 2316,
	 2333, 2350, 2365, 2373, 2379, 2394, 2402, 2419, 2436, 2453, 2470, 2487,
	 2502, 2520, 2538, 2556, 2567, 2585, 2604, 2615, 2636, 2656, 2675, 2694,
	 2715, 2735, 2756, 2777, 2798, 2819, 2838, 2859, 2880, 2901, 2922, 2941,
	 2959, 2979, 2998, 3016, 3034, 3054, 3073, 3093, 3113, 3133, 3153, 3171,
	 3191, 3211, 3231, 3251, 3269, 3289, 3309, 3328, 3348, 3367, 3385, 3403,
	 3423, 3442, 3462, 3482, 3502, 3522, 3540, 3560, 3580, 3600, 3620, 3638,
	 3658, 3677, 3695, 3713, 3733, 3752, 3772, 3792, 3812, 3832, 3850, 3870,
	 3890, 3910, 3930, 3948, 3966, 3985, 3996, 4017, 4037, 4056, 4075, 4096,
	 4116, 4137, 4158, 4179, 4200, 4219, 4240, 4261, 4282, 4303, 4322, 4340,
	 4360, 4379, 4397, 4415, 4435, 4454, 4474, 4494, 4514, 4534, 4552, 4572,
	 4592, 4612, 4632, 4650, 4670, 4690, 4709, 4729, 4748, 4766, 4784, 4804,
	 4823, 4843, 4863, 4883, 4903, 4921, 4941, 4961, 4981, 5001, 5019, 5039,
	 5058, 5076, 5094, 5114, 5133, 5153, 5173, 5193, 5213, 5231, 5251, 5271,
	 5291, 5311, 5329, 5340, 5358, 5378, 5397, 5417, 5437, 5457, 5477, 5495
	};
}

private static final short _Scanner_index_offsets[] = init__Scanner_index_offsets_0();


private static short[] init__Scanner_indicies_0()
{
	return new short [] {
	    0,    2,    3,    4,    5,    6,    8,    9,    7,    0,    7,    7,
	    7,    1,   10,   11,   10,   10,   10,   10,   10,    1,   12,   13,
	   12,   12,   12,   12,   12,    1,   14,   15,   16,   17,   18,   19,
	   21,   22,   20,   14,   20,   20,   20,    1,   23,   25,   24,   24,
	   24,   24,    1,   27,   26,   26,   26,   26,    1,   28,   29,   31,
	   30,   32,   30,   30,   30,    1,   34,   33,   33,   33,   33,    1,
	   35,   36,   36,   38,   39,   40,   35,   37,    1,   42,   41,    1,
	   43,   44,   42,   43,   41,    1,   45,   46,   45,    1,   21,   47,
	   49,   48,   21,   48,   48,   48,    1,   51,   50,   50,   50,   50,
	    1,   52,   53,   53,   50,   54,   51,   55,   53,   50,   53,   53,
	   52,   50,   50,   50,   50,    1,   56,   57,   57,   58,   59,   57,
	   57,   57,   56,    1,   60,    1,   61,   62,   63,   64,   66,   65,
	   61,   65,   65,   65,    1,   67,   68,   69,   70,   72,   71,   67,
	   71,   71,   71,    1,   73,   74,   75,   73,   73,    1,   76,   77,
	   76,    1,   78,   59,   78,    1,   73,   79,   74,   75,   73,   73,
	   80,   73,   80,   73,   80,   73,   73,    1,   74,   75,   73,   73,
	   73,    1,   74,   75,   73,   73,   81,   73,   81,   73,   81,   73,
	   73,    1,   74,   75,   73,   73,   82,   73,   82,   73,   82,   73,
	   73,    1,   74,   75,   73,   73,   83,   73,   83,   73,   83,   73,
	   73,    1,   74,   75,   73,   73,   84,   73,   84,   73,   84,   73,
	   73,    1,   74,   75,   73,   73,   85,   73,   85,   73,   85,   73,
	   73,    1,   74,   75,   73,   73,   73,    1,   86,   74,   87,   86,
	   86,    1,   86,   88,   74,   87,   86,   86,   89,   86,   89,   86,
	   89,   86,   86,    1,   74,   87,   86,   86,   86,    1,   74,   87,
	   86,   86,   90,   86,   90,   86,   90,   86,   86,    1,   74,   87,
	   86,   86,   91,   86,   91,   86,   91,   86,   86,    1,   74,   87,
	   86,   86,   92,   86,   92,   86,   92,   86,   86,    1,   74,   87,
	   86,   86,   93,   86,   93,   86,   93,   86,   86,    1,   74,   87,
	   86,   86,   94,   86,   94,   86,   94,   86,   86,    1,   74,   87,
	   86,   86,   86,    1,   96,   95,   95,   95,   95,    1,   76,   95,
	   96,   77,   95,   76,   95,   95,   95,   95,    1,   95,   95,   95,
	   97,   97,   97,   95,    1,   98,   95,   96,   77,   95,   98,   99,
	   99,   95,   99,   95,   95,    1,   98,   95,   96,   77,   95,   98,
	  100,  100,   95,  100,   95,   95,    1,   98,   95,   96,   77,   95,
	   98,  101,  101,   95,  101,   95,   95,    1,   98,   95,   96,   77,
	   95,   98,  102,  102,   95,  102,   95,   95,    1,   98,   95,   96,
	   77,   95,   98,  103,  103,   95,  103,   95,   95,    1,   98,   95,
	   96,   77,   95,   98,   95,   95,   95,   95,    1,   50,   50,   50,
	  104,  104,  104,   50,    1,  105,   53,   53,   50,   54,   51,   55,
	   53,   50,   53,   53,  105,  106,  106,   50,  106,   50,   50,    1,
	  105,   53,   53,   50,   54,   51,   55,   53,   50,   53,   53,  105,
	  107,  107,   50,  107,   50,   50,    1,  105,   53,   53,   50,   54,
	   51,   55,   53,   50,   53,   53,  105,  108,  108,   50,  108,   50,
	   50,    1,  105,   53,   53,   50,   54,   51,   55,   53,   50,   53,
	   53,  105,  109,  109,   50,  109,   50,   50,    1,  105,   53,   53,
	   50,   54,   51,   55,   53,   50,   53,   53,  105,  110,  110,   50,
	  110,   50,   50,    1,  105,   53,   53,   50,   54,   51,   55,   53,
	   50,   53,   53,  105,   50,   50,   50,   50,    1,  111,   44,  112,
	  112,  111,    1,  111,  112,  112,  111,    1,  112,  112,  113,    1,
	   43,   44,   43,  113,    1,  114,    1,  115,    1,  116,    1,   43,
	   44,   43,    1,  117,    1,  116,    1,   33,   33,   33,  118,  118,
	  118,   33,    1,  119,  119,  119,  120,  120,  120,  119,    1,  121,
	  123,  122,  122,  122,  122,    1,  123,  122,  122,  122,  122,    1,
	  122,  122,  122,  124,  124,  124,  122,    1,  125,  125,  125,  126,
	  126,  126,  125,    1,   26,   26,   26,  127,  127,  127,   26,    1,
	  128,  128,  128,  129,  129,  129,  128,    1,  130,  125,  125,  125,
	  125,    1,  131,  131,  131,  132,  132,  132,  131,    1,  133,  133,
	  133,  134,  134,  134,  133,    1,  135,  137,  136,  136,  136,  136,
	    1,  139,  138,  138,  138,  138,    1,  140,  141,  143,  142,  144,
	  142,  142,  142,    1,  146,  145,  145,  145,  145,    1,  147,  148,
	  148,  150,  151,  152,  147,  149,    1,  154,  153,    1,  155,  156,
	  154,  155,  153,    1,  157,  158,  157,    1,  159,  160,  162,  161,
	  159,  161,  161,  161,    1,  164,  163,  163,  163,  163,    1,  165,
	  166,  166,  163,  167,  164,  168,  166,  163,  166,  166,  165,  163,
	  163,  163,  163,    1,  169,  170,  170,  171,  172,  170,  170,  170,
	  169,    1,  173,    1,  174,  175,  176,  177,  179,  178,  174,  178,
	  178,  178,    1,  180,  181,  182,  183,  185,  184,  180,  184,  184,
	  184,    1,  186,  187,  188,  186,  186,    1,  189,  190,  189,    1,
	  191,  172,  191,    1,  186,  192,  187,  188,  186,  186,  193,  186,
	  193,  186,  193,  186,  186,    1,  187,  188,  186,  186,  186,    1,
	  187,  188,  186,  186,  194,  186,  194,  186,  194,  186,  186,    1,
	  187,  188,  186,  186,  195,  186,  195,  186,  195,  186,  186,    1,
	  187,  188,  186,  186,  196,  186,  196,  186,  196,  186,  186,    1,
	  187,  188,  186,  186,  197,  186,  197,  186,  197,  186,  186,    1,
	  187,  188,  186,  186,  198,  186,  198,  186,  198,  186,  186,    1,
	  187,  188,  186,  186,  186,    1,  199,  187,  200,  199,  199,    1,
	  199,  201,  187,  200,  199,  199,  202,  199,  202,  199,  202,  199,
	  199,    1,  187,  200,  199,  199,  199,    1,  187,  200,  199,  199,
	  203,  199,  203,  199,  203,  199,  199,    1,  187,  200,  199,  199,
	  204,  199,  204,  199,  204,  199,  199,    1,  187,  200,  199,  199,
	  205,  199,  205,  199,  205,  199,  199,    1,  187,  200,  199,  199,
	  206,  199,  206,  199,  206,  199,  199,    1,  187,  200,  199,  199,
	  207,  199,  207,  199,  207,  199,  199,    1,  187,  200,  199,  199,
	  199,    1,  209,  208,  208,  208,  208,    1,  189,  208,  209,  190,
	  208,  189,  208,  208,  208,  208,    1,  208,  208,  208,  210,  210,
	  210,  208,    1,  211,  208,  209,  190,  208,  211,  212,  212,  208,
	  212,  208,  208,    1,  211,  208,  209,  190,  208,  211,  213,  213,
	  208,  213,  208,  208,    1,  211,  208,  209,  190,  208,  211,  214,
	  214,  208,  214,  208,  208,    1,  211,  208,  209,  190,  208,  211,
	  215,  215,  208,  215,  208,  208,    1,  211,  208,  209,  190,  208,
	  211,  216,  216,  208,  216,  208,  208,    1,  211,  208,  209,  190,
	  208,  211,  208,  208,  208,  208,    1,  163,  163,  163,  217,  217,
	  217,  163,    1,  218,  166,  166,  163,  167,  164,  168,  166,  163,
	  166,  166,  218,  219,  219,  163,  219,  163,  163,    1,  218,  166,
	  166,  163,  167,  164,  168,  166,  163,  166,  166,  218,  220,  220,
	  163,  220,  163,  163,    1,  218,  166,  166,  163,  167,  164,  168,
	  166,  163,  166,  166,  218,  221,  221,  163,  221,  163,  163,    1,
	  218,  166,  166,  163,  167,  164,  168,  166,  163,  166,  166,  218,
	  222,  222,  163,  222,  163,  163,    1,  218,  166,  166,  163,  167,
	  164,  168,  166,  163,  166,  166,  218,  223,  223,  163,  223,  163,
	  163,    1,  218,  166,  166,  163,  167,  164,  168,  166,  163,  166,
	  166,  218,  163,  163,  163,  163,    1,  224,  156,  225,  225,  224,
	    1,  224,  225,  225,  224,    1,  225,  225,  226,    1,  155,  156,
	  155,  226,    1,  227,    1,  228,    1,  229,    1,  155,  156,  155,
	    1,  230,    1,  229,    1,  145,  145,  145,  231,  231,  231,  145,
	    1,  232,  232,  232,  233,  233,  233,  232,    1,  234,  236,  235,
	  235,  235,  235,    1,  236,  235,  235,  235,  235,    1,  235,  235,
	  235,  237,  237,  237,  235,    1,  238,  238,  238,  239,  239,  239,
	  238,    1,  138,  138,  138,  240,  240,  240,  138,    1,  241,  241,
	  241,  242,  242,  242,  241,    1,  243,  243,  243,  244,  244,  244,
	  243,    1,  245,  245,  245,  246,  246,  246,  245,    1,  248,  247,
	  247,  247,  247,    1,  247,  247,  247,  249,  249,  249,  247,    1,
	  250,  251,  252,  253,  254,  255,  257,  258,  256,  250,  256,  256,
	  256,    1,  259,  260,  259,  259,  259,  259,  259,    1,  261,  262,
	  263,  264,  265,  266,  267,  268,  264,  261,  264,  264,  264,  264,
	    1,  269,  270,  269,    1,  271,  273,  272,  272,  272,  272,    1,
	  275,  274,  274,  274,  274,    1,  276,  277,  278,  274,  279,  280,
	  281,  275,  274,  276,  274,  274,  274,  274,    1,  282,  284,  283,
	  285,  283,  283,  283,    1,  287,  286,  286,  286,  286,    1,  288,
	  289,  290,  291,  286,  292,  293,  294,  287,  286,  288,  286,  286,
	  286,  286,    1,  295,  296,  296,  298,  299,  300,  295,  297,    1,
	  302,  301,    1,  303,  304,  302,  303,  301,    1,  305,  306,  305,
	    1,  307,  251,  308,  254,  255,  257,  307,    1,  257,  309,  311,
	  310,  257,  310,  310,  310,    1,  313,  312,  312,  312,  312,    1,
	  314,  315,  315,  312,  316,  313,  317,  315,  312,  315,  315,  314,
	  312,  312,  312,  312,    1,  318,  319,  319,  320,  321,  319,  319,
	  319,  318,    1,  322,    1,  323,  324,  325,  326,  328,  327,  323,
	  327,  327,  327,    1,  329,  330,  331,  332,  334,  333,  329,  333,
	  333,  333,    1,  335,  336,  337,  335,  335,    1,  338,  339,  338,
	    1,  340,  321,  340,    1,  335,  341,  336,  337,  335,  335,  342,
	  335,  342,  335,  342,  335,  335,    1,  336,  337,  335,  335,  335,
	    1,  336,  337,  335,  335,  343,  335,  343,  335,  343,  335,  335,
	    1,  336,  337,  335,  335,  344,  335,  344,  335,  344,  335,  335,
	    1,  336,  337,  335,  335,  345,  335,  345,  335,  345,  335,  335,
	    1,  336,  337,  335,  335,  346,  335,  346,  335,  346,  335,  335,
	    1,  336,  337,  335,  335,  347,  335,  347,  335,  347,  335,  335,
	    1,  336,  337,  335,  335,  335,    1,  348,  336,  349,  348,  348,
	    1,  348,  350,  336,  349,  348,  348,  351,  348,  351,  348,  351,
	  348,  348,    1,  336,  349,  348,  348,  348,    1,  336,  349,  348,
	  348,  352,  348,  352,  348,  352,  348,  348,    1,  336,  349,  348,
	  348,  353,  348,  353,  348,  353,  348,  348,    1,  336,  349,  348,
	  348,  354,  348,  354,  348,  354,  348,  348,    1,  336,  349,  348,
	  348,  355,  348,  355,  348,  355,  348,  348,    1,  336,  349,  348,
	  348,  356,  348,  356,  348,  356,  348,  348,    1,  336,  349,  348,
	  348,  348,    1,  358,  357,  357,  357,  357,    1,  338,  357,  358,
	  339,  357,  338,  357,  357,  357,  357,    1,  357,  357,  357,  359,
	  359,  359,  357,    1,  360,  357,  358,  339,  357,  360,  361,  361,
	  357,  361,  357,  357,    1,  360,  357,  358,  339,  357,  360,  362,
	  362,  357,  362,  357,  357,    1,  360,  357,  358,  339,  357,  360,
	  363,  363,  357,  363,  357,  357,    1,  360,  357,  358,  339,  357,
	  360,  364,  364,  357,  364,  357,  357,    1,  360,  357,  358,  339,
	  357,  360,  365,  365,  357,  365,  357,  357,    1,  360,  357,  358,
	  339,  357,  360,  357,  357,  357,  357,    1,  312,  312,  312,  366,
	  366,  366,  312,    1,  367,  315,  315,  312,  316,  313,  317,  315,
	  312,  315,  315,  367,  368,  368,  312,  368,  312,  312,    1,  367,
	  315,  315,  312,  316,  313,  317,  315,  312,  315,  315,  367,  369,
	  369,  312,  369,  312,  312,    1,  367,  315,  315,  312,  316,  313,
	  317,  315,  312,  315,  315,  367,  370,  370,  312,  370,  312,  312,
	    1,  367,  315,  315,  312,  316,  313,  317,  315,  312,  315,  315,
	  367,  371,  371,  312,  371,  312,  312,    1,  367,  315,  315,  312,
	  316,  313,  317,  315,  312,  315,  315,  367,  372,  372,  312,  372,
	  312,  312,    1,  367,  315,  315,  312,  316,  313,  317,  315,  312,
	  315,  315,  367,  312,  312,  312,  312,    1,  373,  304,  374,  374,
	  373,    1,  373,  374,  374,  373,    1,  374,  374,  375,    1,  303,
	  304,  303,  375,    1,  376,    1,  377,    1,  378,    1,  303,  304,
	  303,    1,  379,    1,  378,    1,  286,  286,  286,  380,  380,  380,
	  286,    1,  381,  289,  290,  291,  286,  292,  293,  294,  287,  286,
	  381,  382,  382,  286,  382,  286,  286,    1,  381,  289,  290,  291,
	  286,  292,  293,  294,  287,  286,  381,  383,  383,  286,  383,  286,
	  286,    1,  381,  289,  290,  291,  286,  292,  293,  294,  287,  286,
	  381,  384,  384,  286,  384,  286,  286,    1,  381,  289,  290,  291,
	  286,  292,  293,  294,  287,  286,  381,  385,  385,  286,  385,  286,
	  286,    1,  381,  289,  290,  291,  286,  292,  293,  294,  287,  286,
	  381,  386,  386,  286,  386,  286,  286,    1,  381,  289,  290,  291,
	  286,  292,  293,  294,  287,  286,  381,  286,  286,  286,  286,    1,
	  288,  289,  290,  291,  286,  292,  293,  294,  287,  286,  387,  288,
	  286,  286,  286,  286,    1,  288,  289,  290,  291,  286,  292,  293,
	  294,  287,  286,  388,  288,  286,  286,  286,  286,    1,  288,  289,
	  291,  286,  292,  293,  294,  287,  286,  288,  286,  286,  286,  286,
	    1,  274,  274,  274,  389,  389,  389,  274,    1,  390,  277,  278,
	  274,  279,  280,  281,  275,  274,  390,  391,  391,  274,  391,  274,
	  274,    1,  390,  277,  278,  274,  279,  280,  281,  275,  274,  390,
	  392,  392,  274,  392,  274,  274,    1,  390,  277,  278,  274,  279,
	  280,  281,  275,  274,  390,  393,  393,  274,  393,  274,  274,    1,
	  390,  277,  278,  274,  279,  280,  281,  275,  274,  390,  394,  394,
	  274,  394,  274,  274,    1,  390,  277,  278,  274,  279,  280,  281,
	  275,  274,  390,  395,  395,  274,  395,  274,  274,    1,  390,  277,
	  278,  274,  279,  280,  281,  275,  274,  390,  274,  274,  274,  274,
	    1,  264,  264,  264,  396,  396,  396,  264,    1,  397,  262,  263,
	  264,  265,  266,  267,  268,  264,  397,  398,  398,  264,  398,  264,
	  264,    1,  397,  262,  263,  264,  265,  266,  267,  268,  264,  397,
	  399,  399,  264,  399,  264,  264,    1,  397,  262,  263,  264,  265,
	  266,  267,  268,  264,  397,  400,  400,  264,  400,  264,  264,    1,
	  397,  262,  263,  264,  265,  266,  267,  268,  264,  397,  401,  401,
	  264,  401,  264,  264,    1,  397,  262,  263,  264,  265,  266,  267,
	  268,  264,  397,  402,  402,  264,  402,  264,  264,    1,  397,  262,
	  263,  264,  265,  266,  267,  268,  264,  397,  264,  264,  264,  264,
	    1,  403,  404,  405,  406,  407,  408,  403,    1,  410,  409,  409,
	  409,  409,    1,  403,  404,  405,  409,  406,  407,  408,  410,  409,
	  403,  409,  409,  409,  409,    1,  409,  409,  409,  411,  411,  411,
	  409,    1,  412,  404,  405,  409,  406,  407,  408,  410,  409,  412,
	  413,  413,  409,  413,  409,  409,    1,  412,  404,  405,  409,  406,
	  407,  408,  410,  409,  412,  414,  414,  409,  414,  409,  409,    1,
	  412,  404,  405,  409,  406,  407,  408,  410,  409,  412,  415,  415,
	  409,  415,  409,  409,    1,  412,  404,  405,  409,  406,  407,  408,
	  410,  409,  412,  416,  416,  409,  416,  409,  409,    1,  412,  404,
	  405,  409,  406,  407,  408,  410,  409,  412,  417,  417,  409,  417,
	  409,  409,    1,  412,  404,  405,  409,  406,  407,  408,  410,  409,
	  412,  409,  409,  409,  409,    1,  418,  419,  420,  421,  243,  422,
	  423,  420,  424,  425,  243,  420,  418,  243,  243,  243,  243,    1,
	  426,   15,   16,  427,  428,   17,   18,   19,  427,   21,   22,   20,
	  427,  426,   20,   20,   20,    1,  418,  429,  420,  421,  131,  430,
	  431,  420,  432,  433,  131,  420,  418,  131,  131,  131,  131,    1,
	  434,  435,  436,  437,  438,  439,  436,  440,  436,  434,    1,  441,
	  442,  443,  444,   26,  445,  446,  443,  447,   27,   26,  443,  441,
	   26,   26,   26,   26,    1,  448,  449,  450,  451,  452,   33,  453,
	  454,  451,  455,   34,   33,  451,  448,   33,   33,   33,   33,    1,
	  456,   15,  457,  458,   18,   19,  457,   21,  457,  456,    1,  459,
	  449,  450,  451,  452,   33,  453,  454,  451,  455,   34,   33,  451,
	  459,  460,  460,   33,  460,   33,   33,    1,  448,  449,  450,   16,
	  451,  452,  461,  453,  454,  451,  455,  463,  462,  451,  448,   33,
	  462,  462,  462,    1,  448,  449,  450,  451,  452,   33,  453,  454,
	  451,  455,  464,  119,  451,  448,   33,  119,  119,  119,    1,  465,
	  466,  450,  467,  468,  119,  469,  470,  467,  471,  464,  119,  467,
	  465,  119,  119,  119,  119,    1,  472,  466,  450,  467,  468,  119,
	  469,  470,  467,  471,  464,  119,  467,  472,  473,  473,  119,  473,
	  119,  119,    1,  465,  466,  450,   16,  467,  468,  462,  469,  470,
	  467,  471,  463,  462,  467,  465,  119,  462,  462,  462,    1,  472,
	  466,  450,  467,  468,  119,  469,  470,  467,  471,  464,  119,  467,
	  472,  474,  474,  119,  474,  119,  119,    1,  472,  466,  450,  467,
	  468,  119,  469,  470,  467,  471,  464,  119,  467,  472,  475,  475,
	  119,  475,  119,  119,    1,  472,  466,  450,  467,  468,  119,  469,
	  470,  467,  471,  464,  119,  467,  472,  476,  476,  119,  476,  119,
	  119,    1,  472,  466,  450,  467,  468,  119,  469,  470,  467,  471,
	  464,  119,  467,  472,  477,  477,  119,  477,  119,  119,    1,  472,
	  466,  450,  467,  468,  119,  469,  470,  467,  471,  464,  119,  467,
	  472,  119,  119,  119,  119,    1,  459,  449,  450,  451,  452,   33,
	  453,  454,  451,  455,   34,   33,  451,  459,  478,  478,   33,  478,
	   33,   33,    1,  459,  449,  450,  451,  452,   33,  453,  454,  451,
	  455,   34,   33,  451,  459,  479,  479,   33,  479,   33,   33,    1,
	  459,  449,  450,  451,  452,   33,  453,  454,  451,  455,   34,   33,
	  451,  459,  480,  480,   33,  480,   33,   33,    1,  459,  449,  450,
	  451,  452,   33,  453,  454,  451,  455,   34,   33,  451,  459,  481,
	  481,   33,  481,   33,   33,    1,  459,  449,  450,  451,  452,   33,
	  453,  454,  451,  455,   34,   33,  451,  459,   33,   33,   33,   33,
	    1,  456,   15,  457,  458,  122,   18,   19,  457,   21,  123,  122,
	  457,  456,  122,  122,  122,  122,    1,  482,   15,  457,  458,  122,
	   18,   19,  457,   21,  123,  122,  457,  482,  483,  483,  122,  483,
	  122,  122,    1,  456,   15,   16,  457,  458,  484,   18,   19,  457,
	   21,   22,   20,  457,  456,  122,   20,   20,   20,    1,  456,   15,
	  457,  458,  122,   18,   19,  457,   21,  130,  125,  457,  456,  122,
	  125,  125,  125,    1,  434,  435,  436,  437,  125,  438,  439,  436,
	  440,  130,  125,  436,  434,  125,  125,  125,  125,    1,  485,  435,
	  436,  437,  125,  438,  439,  436,  440,  130,  125,  436,  485,  486,
	  486,  125,  486,  125,  125,    1,  434,  435,   16,  436,  437,   20,
	  438,  439,  436,  440,   22,   20,  436,  434,  125,   20,   20,   20,
	    1,  485,  435,  436,  437,  125,  438,  439,  436,  440,  130,  125,
	  436,  485,  487,  487,  125,  487,  125,  125,    1,  485,  435,  436,
	  437,  125,  438,  439,  436,  440,  130,  125,  436,  485,  488,  488,
	  125,  488,  125,  125,    1,  485,  435,  436,  437,  125,  438,  439,
	  436,  440,  130,  125,  436,  485,  489,  489,  125,  489,  125,  125,
	    1,  485,  435,  436,  437,  125,  438,  439,  436,  440,  130,  125,
	  436,  485,  490,  490,  125,  490,  125,  125,    1,  485,  435,  436,
	  437,  125,  438,  439,  436,  440,  130,  125,  436,  485,  125,  125,
	  125,  125,    1,  482,   15,  457,  458,  122,   18,   19,  457,   21,
	  123,  122,  457,  482,  491,  491,  122,  491,  122,  122,    1,  482,
	   15,  457,  458,  122,   18,   19,  457,   21,  123,  122,  457,  482,
	  492,  492,  122,  492,  122,  122,    1,  482,   15,  457,  458,  122,
	   18,   19,  457,   21,  123,  122,  457,  482,  493,  493,  122,  493,
	  122,  122,    1,  482,   15,  457,  458,  122,   18,   19,  457,   21,
	  123,  122,  457,  482,  494,  494,  122,  494,  122,  122,    1,  482,
	   15,  457,  458,  122,   18,   19,  457,   21,  123,  122,  457,  482,
	  122,  122,  122,  122,    1,  448,  449,  450,  451,  452,   33,  453,
	  454,  451,  455,   34,   33,  495,  451,  448,   33,   33,   33,   33,
	    1,  448,  449,  450,  451,  452,   33,  453,  454,  451,  455,   34,
	   33,  496,  451,  448,   33,   33,   33,   33,    1,  448,  449,  497,
	  451,  452,   33,  453,  454,  451,  455,   34,   33,  451,  448,   33,
	   33,   33,   33,    1,  498,  442,  443,  444,   26,  445,  446,  443,
	  447,   27,   26,  443,  498,  499,  499,   26,  499,   26,   26,    1,
	  441,  442,   16,  443,  444,  500,  445,  446,  443,  447,  502,  501,
	  443,  441,   26,  501,  501,  501,    1,  441,  442,  443,  444,   26,
	  445,  446,  443,  447,  503,  128,  443,  441,   26,  128,  128,  128,
	    1,  504,  505,  506,  507,  128,  508,  509,  506,  510,  503,  128,
	  506,  504,  128,  128,  128,  128,    1,  511,  505,  506,  507,  128,
	  508,  509,  506,  510,  503,  128,  506,  511,  512,  512,  128,  512,
	  128,  128,    1,  504,  505,   16,  506,  507,  501,  508,  509,  506,
	  510,  502,  501,  506,  504,  128,  501,  501,  501,    1,  511,  505,
	  506,  507,  128,  508,  509,  506,  510,  503,  128,  506,  511,  513,
	  513,  128,  513,  128,  128,    1,  511,  505,  506,  507,  128,  508,
	  509,  506,  510,  503,  128,  506,  511,  514,  514,  128,  514,  128,
	  128,    1,  511,  505,  506,  507,  128,  508,  509,  506,  510,  503,
	  128,  506,  511,  515,  515,  128,  515,  128,  128,    1,  511,  505,
	  506,  507,  128,  508,  509,  506,  510,  503,  128,  506,  511,  516,
	  516,  128,  516,  128,  128,    1,  511,  505,  506,  507,  128,  508,
	  509,  506,  510,  503,  128,  506,  511,  128,  128,  128,  128,    1,
	  498,  442,  443,  444,   26,  445,  446,  443,  447,   27,   26,  443,
	  498,  517,  517,   26,  517,   26,   26,    1,  498,  442,  443,  444,
	   26,  445,  446,  443,  447,   27,   26,  443,  498,  518,  518,   26,
	  518,   26,   26,    1,  498,  442,  443,  444,   26,  445,  446,  443,
	  447,   27,   26,  443,  498,  519,  519,   26,  519,   26,   26,    1,
	  498,  442,  443,  444,   26,  445,  446,  443,  447,   27,   26,  443,
	  498,  520,  520,   26,  520,   26,   26,    1,  498,  442,  443,  444,
	   26,  445,  446,  443,  447,   27,   26,  443,  498,   26,   26,   26,
	   26,    1,  521,  429,  420,  421,  131,  430,  431,  420,  432,  433,
	  131,  420,  521,  522,  522,  131,  522,  131,  131,    1,  418,  429,
	   16,  420,  421,  523,  430,  431,  420,  432,  525,  524,  420,  418,
	  131,  524,  524,  524,    1,  418,  429,  420,  421,  131,  430,  431,
	  420,  432,  526,  133,  420,  418,  131,  133,  133,  133,    1,  527,
	  528,  529,  530,  133,  531,  532,  529,  533,  526,  133,  529,  527,
	  133,  133,  133,  133,    1,  534,  528,  529,  530,  133,  531,  532,
	  529,  533,  526,  133,  529,  534,  535,  535,  133,  535,  133,  133,
	    1,  527,  528,   16,  529,  530,  524,  531,  532,  529,  533,  525,
	  524,  529,  527,  133,  524,  524,  524,    1,  534,  528,  529,  530,
	  133,  531,  532,  529,  533,  526,  133,  529,  534,  536,  536,  133,
	  536,  133,  133,    1,  534,  528,  529,  530,  133,  531,  532,  529,
	  533,  526,  133,  529,  534,  537,  537,  133,  537,  133,  133,    1,
	  534,  528,  529,  530,  133,  531,  532,  529,  533,  526,  133,  529,
	  534,  538,  538,  133,  538,  133,  133,    1,  534,  528,  529,  530,
	  133,  531,  532,  529,  533,  526,  133,  529,  534,  539,  539,  133,
	  539,  133,  133,    1,  534,  528,  529,  530,  133,  531,  532,  529,
	  533,  526,  133,  529,  534,  133,  133,  133,  133,    1,  521,  429,
	  420,  421,  131,  430,  431,  420,  432,  433,  131,  420,  521,  540,
	  540,  131,  540,  131,  131,    1,  521,  429,  420,  421,  131,  430,
	  431,  420,  432,  433,  131,  420,  521,  541,  541,  131,  541,  131,
	  131,    1,  521,  429,  420,  421,  131,  430,  431,  420,  432,  433,
	  131,  420,  521,  542,  542,  131,  542,  131,  131,    1,  521,  429,
	  420,  421,  131,  430,  431,  420,  432,  433,  131,  420,  521,  543,
	  543,  131,  543,  131,  131,    1,  521,  429,  420,  421,  131,  430,
	  431,  420,  432,  433,  131,  420,  521,  131,  131,  131,  131,    1,
	  441,  544,  443,  444,  138,  545,  546,  443,  547,  139,  138,  443,
	  441,  138,  138,  138,  138,    1,  448,  548,  549,  451,  452,  145,
	  550,  551,  451,  552,  146,  145,  451,  448,  145,  145,  145,  145,
	    1,  456,  553,  457,  458,  554,  555,  457,  159,  457,  456,    1,
	  556,  548,  549,  451,  452,  145,  550,  551,  451,  552,  146,  145,
	  451,  556,  557,  557,  145,  557,  145,  145,    1,  448,  548,  549,
	   16,  451,  452,  558,  550,  551,  451,  552,  560,  559,  451,  448,
	  145,  559,  559,  559,    1,  448,  548,  549,  451,  452,  145,  550,
	  551,  451,  552,  561,  232,  451,  448,  145,  232,  232,  232,    1,
	  562,  563,  549,  564,  565,  232,  566,  567,  564,  568,  561,  232,
	  564,  562,  232,  232,  232,  232,    1,  569,  563,  549,  564,  565,
	  232,  566,  567,  564,  568,  561,  232,  564,  569,  570,  570,  232,
	  570,  232,  232,    1,  562,  563,  549,   16,  564,  565,  559,  566,
	  567,  564,  568,  560,  559,  564,  562,  232,  559,  559,  559,    1,
	  569,  563,  549,  564,  565,  232,  566,  567,  564,  568,  561,  232,
	  564,  569,  571,  571,  232,  571,  232,  232,    1,  569,  563,  549,
	  564,  565,  232,  566,  567,  564,  568,  561,  232,  564,  569,  572,
	  572,  232,  572,  232,  232,    1,  569,  563,  549,  564,  565,  232,
	  566,  567,  564,  568,  561,  232,  564,  569,  573,  573,  232,  573,
	  232,  232,    1,  569,  563,  549,  564,  565,  232,  566,  567,  564,
	  568,  561,  232,  564,  569,  574,  574,  232,  574,  232,  232,    1,
	  569,  563,  549,  564,  565,  232,  566,  567,  564,  568,  561,  232,
	  564,  569,  232,  232,  232,  232,    1,  556,  548,  549,  451,  452,
	  145,  550,  551,  451,  552,  146,  145,  451,  556,  575,  575,  145,
	  575,  145,  145,    1,  556,  548,  549,  451,  452,  145,  550,  551,
	  451,  552,  146,  145,  451,  556,  576,  576,  145,  576,  145,  145,
	    1,  556,  548,  549,  451,  452,  145,  550,  551,  451,  552,  146,
	  145,  451,  556,  577,  577,  145,  577,  145,  145,    1,  556,  548,
	  549,  451,  452,  145,  550,  551,  451,  552,  146,  145,  451,  556,
	  578,  578,  145,  578,  145,  145,    1,  556,  548,  549,  451,  452,
	  145,  550,  551,  451,  552,  146,  145,  451,  556,  145,  145,  145,
	  145,    1,  456,  553,  457,  458,  235,  554,  555,  457,  159,  236,
	  235,  457,  456,  235,  235,  235,  235,    1,  579,  553,  457,  458,
	  235,  554,  555,  457,  159,  236,  235,  457,  579,  580,  580,  235,
	  580,  235,  235,    1,  456,  553,   16,  457,  458,  581,  554,  555,
	  457,  159,  583,  582,  457,  456,  235,  582,  582,  582,    1,  456,
	  553,  457,  458,  235,  554,  555,  457,  159,  584,  238,  457,  456,
	  235,  238,  238,  238,    1,  585,  586,  587,  588,  238,  589,  590,
	  587,  591,  584,  238,  587,  585,  238,  238,  238,  238,    1,  592,
	  586,  587,  588,  238,  589,  590,  587,  591,  584,  238,  587,  592,
	  593,  593,  238,  593,  238,  238,    1,  585,  586,   16,  587,  588,
	  582,  589,  590,  587,  591,  583,  582,  587,  585,  238,  582,  582,
	  582,    1,  592,  586,  587,  588,  238,  589,  590,  587,  591,  584,
	  238,  587,  592,  594,  594,  238,  594,  238,  238,    1,  592,  586,
	  587,  588,  238,  589,  590,  587,  591,  584,  238,  587,  592,  595,
	  595,  238,  595,  238,  238,    1,  592,  586,  587,  588,  238,  589,
	  590,  587,  591,  584,  238,  587,  592,  596,  596,  238,  596,  238,
	  238,    1,  592,  586,  587,  588,  238,  589,  590,  587,  591,  584,
	  238,  587,  592,  597,  597,  238,  597,  238,  238,    1,  592,  586,
	  587,  588,  238,  589,  590,  587,  591,  584,  238,  587,  592,  238,
	  238,  238,  238,    1,  579,  553,  457,  458,  235,  554,  555,  457,
	  159,  236,  235,  457,  579,  598,  598,  235,  598,  235,  235,    1,
	  579,  553,  457,  458,  235,  554,  555,  457,  159,  236,  235,  457,
	  579,  599,  599,  235,  599,  235,  235,    1,  579,  553,  457,  458,
	  235,  554,  555,  457,  159,  236,  235,  457,  579,  600,  600,  235,
	  600,  235,  235,    1,  579,  553,  457,  458,  235,  554,  555,  457,
	  159,  236,  235,  457,  579,  601,  601,  235,  601,  235,  235,    1,
	  579,  553,  457,  458,  235,  554,  555,  457,  159,  236,  235,  457,
	  579,  235,  235,  235,  235,    1,  448,  548,  549,  451,  452,  145,
	  550,  551,  451,  552,  146,  145,  602,  451,  448,  145,  145,  145,
	  145,    1,  448,  548,  549,  451,  452,  145,  550,  551,  451,  552,
	  146,  145,  603,  451,  448,  145,  145,  145,  145,    1,  448,  548,
	  604,  451,  452,  145,  550,  551,  451,  552,  146,  145,  451,  448,
	  145,  145,  145,  145,    1,  605,  544,  443,  444,  138,  545,  546,
	  443,  547,  139,  138,  443,  605,  606,  606,  138,  606,  138,  138,
	    1,  441,  544,   16,  443,  444,  607,  545,  546,  443,  547,  609,
	  608,  443,  441,  138,  608,  608,  608,    1,  441,  544,  443,  444,
	  138,  545,  546,  443,  547,  610,  241,  443,  441,  138,  241,  241,
	  241,    1,  611,  612,  613,  614,  241,  615,  616,  613,  617,  610,
	  241,  613,  611,  241,  241,  241,  241,    1,  618,  612,  613,  614,
	  241,  615,  616,  613,  617,  610,  241,  613,  618,  619,  619,  241,
	  619,  241,  241,    1,  611,  612,   16,  613,  614,  608,  615,  616,
	  613,  617,  609,  608,  613,  611,  241,  608,  608,  608,    1,  618,
	  612,  613,  614,  241,  615,  616,  613,  617,  610,  241,  613,  618,
	  620,  620,  241,  620,  241,  241,    1,  618,  612,  613,  614,  241,
	  615,  616,  613,  617,  610,  241,  613,  618,  621,  621,  241,  621,
	  241,  241,    1,  618,  612,  613,  614,  241,  615,  616,  613,  617,
	  610,  241,  613,  618,  622,  622,  241,  622,  241,  241,    1,  618,
	  612,  613,  614,  241,  615,  616,  613,  617,  610,  241,  613,  618,
	  623,  623,  241,  623,  241,  241,    1,  618,  612,  613,  614,  241,
	  615,  616,  613,  617,  610,  241,  613,  618,  241,  241,  241,  241,
	    1,  605,  544,  443,  444,  138,  545,  546,  443,  547,  139,  138,
	  443,  605,  624,  624,  138,  624,  138,  138,    1,  605,  544,  443,
	  444,  138,  545,  546,  443,  547,  139,  138,  443,  605,  625,  625,
	  138,  625,  138,  138,    1,  605,  544,  443,  444,  138,  545,  546,
	  443,  547,  139,  138,  443,  605,  626,  626,  138,  626,  138,  138,
	    1,  605,  544,  443,  444,  138,  545,  546,  443,  547,  139,  138,
	  443,  605,  627,  627,  138,  627,  138,  138,    1,  605,  544,  443,
	  444,  138,  545,  546,  443,  547,  139,  138,  443,  605,  138,  138,
	  138,  138,    1,  628,  419,  420,  421,  243,  422,  423,  420,  424,
	  425,  243,  420,  628,  629,  629,  243,  629,  243,  243,    1,  418,
	  419,   16,  420,  421,  630,  422,  423,  420,  424,  632,  631,  420,
	  418,  243,  631,  631,  631,    1,  418,  419,  420,  421,  243,  422,
	  423,  420,  424,  633,  245,  420,  418,  243,  245,  245,  245,    1,
	  634,  635,  636,  637,  245,  638,  639,  636,  640,  633,  245,  636,
	  634,  245,  245,  245,  245,    1,  641,  635,  636,  637,  245,  638,
	  639,  636,  640,  633,  245,  636,  641,  642,  642,  245,  642,  245,
	  245,    1,  634,  635,   16,  636,  637,  631,  638,  639,  636,  640,
	  632,  631,  636,  634,  245,  631,  631,  631,    1,  641,  635,  636,
	  637,  245,  638,  639,  636,  640,  633,  245,  636,  641,  643,  643,
	  245,  643,  245,  245,    1,  641,  635,  636,  637,  245,  638,  639,
	  636,  640,  633,  245,  636,  641,  644,  644,  245,  644,  245,  245,
	    1,  641,  635,  636,  637,  245,  638,  639,  636,  640,  633,  245,
	  636,  641,  645,  645,  245,  645,  245,  245,    1,  641,  635,  636,
	  637,  245,  638,  639,  636,  640,  633,  245,  636,  641,  646,  646,
	  245,  646,  245,  245,    1,  641,  635,  636,  637,  245,  638,  639,
	  636,  640,  633,  245,  636,  641,  245,  245,  245,  245,    1,  628,
	  419,  420,  421,  243,  422,  423,  420,  424,  425,  243,  420,  628,
	  647,  647,  243,  647,  243,  243,    1,  628,  419,  420,  421,  243,
	  422,  423,  420,  424,  425,  243,  420,  628,  648,  648,  243,  648,
	  243,  243,    1,  628,  419,  420,  421,  243,  422,  423,  420,  424,
	  425,  243,  420,  628,  649,  649,  243,  649,  243,  243,    1,  628,
	  419,  420,  421,  243,  422,  423,  420,  424,  425,  243,  420,  628,
	  650,  650,  243,  650,  243,  243,    1,  628,  419,  420,  421,  243,
	  422,  423,  420,  424,  425,  243,  420,  628,  243,  243,  243,  243,
	    1,  434,  586,  436,  437,  589,  590,  436,  591,  436,  434,    1,
	  434,  586,  436,  437,  247,  589,  590,  436,  591,  248,  247,  436,
	  434,  247,  247,  247,  247,    1,  651,  586,  436,  437,  247,  589,
	  590,  436,  591,  248,  247,  436,  651,  652,  652,  247,  652,  247,
	  247,    1,  434,  586,   16,  436,  437,  653,  589,  590,  436,  591,
	  654,  653,  436,  434,  247,  653,  653,  653,    1,  651,  586,  436,
	  437,  247,  589,  590,  436,  591,  248,  247,  436,  651,  655,  655,
	  247,  655,  247,  247,    1,  651,  586,  436,  437,  247,  589,  590,
	  436,  591,  248,  247,  436,  651,  656,  656,  247,  656,  247,  247,
	    1,  651,  586,  436,  437,  247,  589,  590,  436,  591,  248,  247,
	  436,  651,  657,  657,  247,  657,  247,  247,    1,  651,  586,  436,
	  437,  247,  589,  590,  436,  591,  248,  247,  436,  651,  658,  658,
	  247,  658,  247,  247,    1,  651,  586,  436,  437,  247,  589,  590,
	  436,  591,  248,  247,  436,  651,  247,  247,  247,  247,    1,    1,
	    0
	};
}

private static final short _Scanner_indicies[] = init__Scanner_indicies_0();


private static short[] init__Scanner_trans_targs_0()
{
	return new short [] {
	    1,    0,    2,  398,  148,   77,   79,  399,   85,  149,  252,  146,
	  254,   75,    4,    3,  255,   74,    5,    7,  279,   13,   71,    6,
	  256,   72,  256,   72,    8,   68,  257,   66,  292,  257,   66,    9,
	   10,   11,   60,   56,   64,   11,   56,   12,  258,   12,  258,   14,
	   15,   49,   15,   49,   16,   17,   18,  258,   16,   17,   18,  258,
	   18,   19,   20,   31,   40,   41,   42,   19,   20,   31,   40,   41,
	   42,   20,   21,   23,   22,  258,   22,   24,   25,   26,   27,   28,
	   29,   30,   31,   32,   33,   34,   35,   36,   37,   38,   39,   41,
	   42,   43,   41,   44,   45,   46,   47,   48,   50,   15,   51,   52,
	   53,   54,   55,   57,   58,   59,   61,   62,   63,   65,  259,  262,
	  263,   69,  275,   70,  276,  279,  280,  295,  298,  299,   71,  254,
	  311,  314,  315,   78,  327,  144,  327,  144,   80,  140,  328,  138,
	  363,  328,  138,   81,   82,   83,  132,  128,  136,   83,  128,   84,
	  329,   84,  329,   85,   86,   87,  121,   87,  121,   88,   89,   90,
	  329,   88,   89,   90,  329,   90,   91,   92,  103,  112,  113,  114,
	   91,   92,  103,  112,  113,  114,   92,   93,   95,   94,  329,   94,
	   96,   97,   98,   99,  100,  101,  102,  103,  104,  105,  106,  107,
	  108,  109,  110,  111,  113,  114,  115,  113,  116,  117,  118,  119,
	  120,  122,   87,  123,  124,  125,  126,  127,  129,  130,  131,  133,
	  134,  135,  137,  330,  333,  334,  141,  346,  142,  347,  350,  351,
	  366,  369,  370,  252,  382,  385,  386,  399,  149,  400,  150,  151,
	  242,  243,  154,  157,  244,  165,  245,  152,  235,  153,  151,  407,
	  152,  154,  157,  165,  235,  153,  407,  155,  156,  228,  156,  228,
	  153,  151,  407,  154,  157,  165,  158,  159,  218,  225,  159,  218,
	  153,  151,  160,  407,  154,  157,  165,  160,  161,  162,  212,  208,
	  216,  162,  208,  163,  164,  163,  164,  153,  407,  166,  167,  201,
	  167,  201,  168,  169,  170,  164,  168,  169,  170,  164,  170,  171,
	  172,  183,  192,  193,  194,  171,  172,  183,  192,  193,  194,  172,
	  173,  175,  174,  164,  174,  176,  177,  178,  179,  180,  181,  182,
	  183,  184,  185,  186,  187,  188,  189,  190,  191,  193,  194,  195,
	  193,  196,  197,  198,  199,  200,  202,  167,  203,  204,  205,  206,
	  207,  209,  210,  211,  213,  214,  215,  217,  219,  159,  220,  221,
	  222,  223,  224,  226,  227,  229,  156,  230,  231,  232,  233,  234,
	  236,  152,  237,  238,  239,  240,  241,  153,  151,  407,  154,  157,
	  165,  244,  245,  246,  244,  247,  248,  249,  250,  251,  253,    2,
	    4,    1,   77,   79,   85,  146,  253,    4,    1,    3,    5,    7,
	   13,   75,  253,    3,    4,    1,    5,    7,   13,  253,    3,    4,
	    1,    5,    7,   13,  253,    3,    9,    4,    1,    5,    7,   13,
	  253,    4,    1,  260,  270,  261,  262,   67,   67,  253,    3,    4,
	    1,    5,    7,   13,  264,  265,  266,  267,  268,  269,  271,  272,
	  273,  274,  277,  287,  278,  281,  282,  283,  284,  285,  286,  288,
	  289,  290,  291,  293,  294,  258,  296,  306,  297,  298,   73,   73,
	  253,    3,    4,    1,    5,    7,   13,  300,  301,  302,  303,  304,
	  305,  307,  308,  309,  310,  312,  322,  313,  314,   76,   76,  253,
	    3,    4,    1,    5,    7,   13,  316,  317,  318,  319,  320,  321,
	  323,  324,  325,  326,    2,   77,   79,   85,    2,   81,   77,   79,
	   85,    2,   77,   79,  331,  341,  332,  333,  139,  139,  253,    2,
	    4,    1,   77,   79,   85,  335,  336,  337,  338,  339,  340,  342,
	  343,  344,  345,  348,  358,  349,  350,  143,  143,  253,    2,    4,
	    1,   77,   79,   85,  352,  353,  354,  355,  356,  357,  359,  360,
	  361,  362,  364,  365,  329,  367,  377,  368,  369,  145,  145,  253,
	    2,    4,    1,   77,   79,   85,  371,  372,  373,  374,  375,  376,
	  378,  379,  380,  381,  383,  393,  384,  385,  147,  147,  253,    2,
	    4,    1,   77,   79,   85,  387,  388,  389,  390,  391,  392,  394,
	  395,  396,  397,  401,  402,  399,  149,  403,  404,  405,  406
	};
}

private static final short _Scanner_trans_targs[] = init__Scanner_trans_targs_0();


private static short[] init__Scanner_trans_actions_0()
{
	return new short [] {
	    0,    0,   13,   49,   49,   13,   13,   49,   13,   49,   19,   19,
	   19,   19,    0,    0,   19,   19,    0,    0,   19,    0,   19,   19,
	   19,   19,    0,    0,   19,    0,   19,   19,   19,    0,    0,    0,
	   19,   19,   19,   19,   19,    0,    0,   23,   23,    0,    0,   19,
	   19,   19,    0,    0,    3,   34,   34,   31,    0,   19,   19,    1,
	    0,    5,   37,   37,   37,   37,   37,    0,   19,   19,   19,   19,
	   19,    0,    0,    0,    7,   40,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    7,    0,    0,    0,    0,    0,    0,    3,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,   19,   19,   19,    0,    0,   19,    0,   19,   19,
	   19,    0,    0,    0,   19,   19,   19,   19,   19,    0,    0,   23,
	   23,    0,    0,    0,   19,   19,   19,    0,    0,    3,   34,   34,
	   31,    0,   19,   19,    1,    0,    5,   37,   37,   37,   37,   37,
	    0,   19,   19,   19,   19,   19,    0,    0,    0,    7,   40,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    7,    0,    0,    0,    0,
	    0,    0,    3,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	   19,   19,    0,    0,   19,    0,   19,   19,   19,   52,   17,  174,
	    0,   17,   17,   17,    0,    0,   61,   19,   19,   19,    0,    0,
	   43,    9,  159,    9,    9,    9,   19,   19,   19,   19,    0,    0,
	   64,   21,   25,  189,   21,   21,   21,    0,   19,   19,   19,   19,
	   19,    0,    0,   23,   23,    0,    0,   27,  127,   19,   19,   19,
	    0,    0,    3,   34,   34,   31,    0,   19,   19,    1,    0,    5,
	   37,   37,   37,   37,   37,    0,   19,   19,   19,   19,   19,    0,
	    0,    0,    7,   40,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    7,    0,    0,    0,    0,    0,    0,    3,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,   64,    0,    0,
	    0,    0,    0,    0,    0,    0,   43,    0,    0,    0,    0,    0,
	    0,   52,    0,    0,    0,    0,    0,   88,   29,  234,   29,   29,
	   29,    0,    0,    0,   88,    0,    0,    0,    0,    0,   52,   17,
	  103,  107,   17,   17,   17,    0,    0,   11,   15,   17,   17,   17,
	   17,    0,   88,   29,  151,  155,   29,   29,   29,   43,    9,   91,
	   95,    9,    9,    9,   64,   21,   25,  115,  119,   21,   21,   21,
	   27,   70,   73,   64,    0,   19,   19,   19,    0,  147,   85,  224,
	  229,   85,   85,   85,  147,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,   27,    0,   19,   88,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,   58,   43,    0,   19,   19,   19,    0,
	  139,   79,  204,  209,   79,   79,   79,  139,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,   52,    0,   19,   19,   19,    0,  143,
	   82,  214,  219,   82,   82,   82,  143,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    9,    9,    9,    9,   21,   25,   21,   21,
	   21,    0,    0,    0,   64,    0,   19,   19,   19,    0,  123,   67,
	  194,  199,   67,   67,   67,  123,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,   27,    0,   19,   19,   19,    0,   76,   29,  131,
	  135,   29,   29,   29,   76,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,   58,   43,    0,   19,   19,   19,    0,   99,
	   46,  164,  169,   46,   46,   46,   99,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,   52,    0,   19,   19,   19,    0,  111,   55,
	  179,  184,   55,   55,   55,  111,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,   88,    0,   19,   19,    0,    0,    0,    0
	};
}

private static final short _Scanner_trans_actions[] = init__Scanner_trans_actions_0();


private static short[] init__Scanner_eof_actions_0()
{
	return new short [] {
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	  107,   15,  107,  155,   95,  119,   73,  119,  119,  119,  229,  229,
	  229,  229,  229,  229,  229,  229,  119,  119,  119,  119,  119,   73,
	   73,   73,   73,  155,  155,  155,  155,  155,  155,  155,  155,   73,
	   73,   73,   73,   73,  119,  119,  119,   95,   95,   95,  209,  209,
	  209,  209,  209,  209,  209,  209,   95,   95,   95,   95,   95,  107,
	  107,  107,  219,  219,  219,  219,  219,  219,  219,  219,  107,  107,
	  107,  107,  107,   95,  119,   73,  119,  119,  119,  199,  199,  199,
	  199,  199,  199,  199,  199,  119,  119,  119,  119,  119,   73,   73,
	   73,   73,  135,  135,  135,  135,  135,  135,  135,  135,   73,   73,
	   73,   73,   73,  119,  119,  119,   95,   95,   95,  169,  169,  169,
	  169,  169,  169,  169,  169,   95,   95,   95,   95,   95,  107,  107,
	  107,  184,  184,  184,  184,  184,  184,  184,  184,  107,  107,  107,
	  107,  107,  155,  155,  155,  155,  155,  155,  155,  155,  155,    0
	};
}

private static final short _Scanner_eof_actions[] = init__Scanner_eof_actions_0();


static final int Scanner_start = 1;
static final int Scanner_first_final = 252;
static final int Scanner_error = 0;

static final int Scanner_en_neg = 150;
static final int Scanner_en_main = 1;


// line 183 "Scanner.java.rl"


	/**
	 * Scan the {@link #input}.
	 *
	 * @return A list of selector groups that contain a list of {@link Selector}s scanned.
	 * @throws ScannerException If the input is invalid.
	 */
	public List<List<Selector>> scan() throws ScannerException {
		char[] data = input.toCharArray();
		int cs;
		int top;
		int[] stack = new int[32];
		int eof = data.length;
		int p = 0;
		int pe = eof;

	    int mark = 0;

	    LinkedList<List<Selector>> selectors = new LinkedList<List<Selector>>();
	    // List<Selector> parts = new LinkedList<Selector>();
            List<Selector> parts = null;

	    String tagName = Selector.UNIVERSAL_TAG;
	    String negationTagName = Selector.UNIVERSAL_TAG;
	    Selector.Combinator combinator = null;
	    List<Specifier> specifiers = new LinkedList<Specifier>();

		String attributeName = null;
		String attributeValue = null;
		AttributeSpecifier.Match attributeMatch = null;

		String pseudoNthClass = null;

		boolean isNegation = false;
		Selector negationSelector = null;


// line 1538 "../java/se/fishtank/css/selectors/scanner/Scanner.java"
	{
	cs = Scanner_start;
	top = 0;
	}

// line 221 "Scanner.java.rl"

// line 1546 "../java/se/fishtank/css/selectors/scanner/Scanner.java"
	{
	int _klen;
	int _trans = 0;
	int _acts;
	int _nacts;
	int _keys;
	int _goto_targ = 0;

	_goto: while (true) {
	switch ( _goto_targ ) {
	case 0:
	if ( p == pe ) {
		_goto_targ = 4;
		continue _goto;
	}
	if ( cs == 0 ) {
		_goto_targ = 5;
		continue _goto;
	}
case 1:
	_match: do {
	_keys = _Scanner_key_offsets[cs];
	_trans = _Scanner_index_offsets[cs];
	_klen = _Scanner_single_lengths[cs];
	if ( _klen > 0 ) {
		int _lower = _keys;
		int _mid;
		int _upper = _keys + _klen - 1;
		while (true) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( data[p] < _Scanner_trans_keys[_mid] )
				_upper = _mid - 1;
			else if ( data[p] > _Scanner_trans_keys[_mid] )
				_lower = _mid + 1;
			else {
				_trans += (_mid - _keys);
				break _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _Scanner_range_lengths[cs];
	if ( _klen > 0 ) {
		int _lower = _keys;
		int _mid;
		int _upper = _keys + (_klen<<1) - 2;
		while (true) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( data[p] < _Scanner_trans_keys[_mid] )
				_upper = _mid - 2;
			else if ( data[p] > _Scanner_trans_keys[_mid+1] )
				_lower = _mid + 2;
			else {
				_trans += ((_mid - _keys)>>1);
				break _match;
			}
		}
		_trans += _klen;
	}
	} while (false);

	_trans = _Scanner_indicies[_trans];
	cs = _Scanner_trans_targs[_trans];

	if ( _Scanner_trans_actions[_trans] != 0 ) {
		_acts = _Scanner_trans_actions[_trans];
		_nacts = _Scanner_actions[_acts++];
		while ( _nacts-- > 0 )
	{
			switch ( _Scanner_actions[_acts++] )
			{
	case 0:
// line 44 "Scanner.java.rl"
	{
	    AttributeSpecifier specifier;
	    if (attributeValue != null) {
	        specifier = new AttributeSpecifier(attributeName, attributeValue, attributeMatch);
	    } else {
	        specifier = new AttributeSpecifier(attributeName);
	    }

	    specifiers.add(specifier);
	}
	break;
	case 1:
// line 55 "Scanner.java.rl"
	{
	    attributeName = getSlice(mark, p);
	}
	break;
	case 2:
// line 59 "Scanner.java.rl"
	{
	    String m = getSlice(mark, p);
	    if ("=".equals(m)) {
	        attributeMatch = AttributeSpecifier.Match.EXACT;
	    } else if ("~=".equals(m)) {
	        attributeMatch = AttributeSpecifier.Match.LIST;
	    } else if ("|=".equals(m)) {
	        attributeMatch = AttributeSpecifier.Match.HYPHEN;
	    } else if ("^=".equals(m)) {
	        attributeMatch = AttributeSpecifier.Match.PREFIX;
	    } else if ("$=".equals(m)) {
	        attributeMatch = AttributeSpecifier.Match.SUFFIX;
	    } else if ("*=".equals(m)) {
	        attributeMatch = AttributeSpecifier.Match.CONTAINS;
	    }
	}
	break;
	case 3:
// line 76 "Scanner.java.rl"
	{
	    String value = getSlice(mark, p);
	    if (value.charAt(0) == '"' || value.charAt(0) == '\'') {
	        value = value.substring(1, value.length() - 1);
	    }

	    attributeValue = value;
	}
	break;
	case 4:
// line 85 "Scanner.java.rl"
	{
	    specifiers.add(new AttributeSpecifier("class",
	        getSlice(mark, p), AttributeSpecifier.Match.LIST));
	}
	break;
	case 5:
// line 90 "Scanner.java.rl"
	{
	    switch (data[p]) {
	    case ' ':
	        combinator = Selector.Combinator.DESCENDANT;
	        break;
	    case '>':
	        combinator = Selector.Combinator.CHILD;
	        break;
	    case '+':
	        combinator = Selector.Combinator.ADJACENT_SIBLING;
	        break;
	    case '~':
	        combinator = Selector.Combinator.GENERAL_SIBLING;
	        break;
	    }
	}
	break;
	case 6:
// line 107 "Scanner.java.rl"
	{
	    parts = new LinkedList<Selector>();
	}
	break;
	case 7:
// line 111 "Scanner.java.rl"
	{
	    selectors.add(parts);
	}
	break;
	case 8:
// line 115 "Scanner.java.rl"
	{
	    specifiers.add(new AttributeSpecifier("id",
	        getSlice(mark, p), AttributeSpecifier.Match.EXACT));
	}
	break;
	case 9:
// line 120 "Scanner.java.rl"
	{
	    mark = p;
	}
	break;
	case 10:
// line 124 "Scanner.java.rl"
	{
	    isNegation = true;
	}
	break;
	case 11:
// line 128 "Scanner.java.rl"
	{
	    specifiers.add(new NegationSpecifier(negationSelector));
	    isNegation = false;
	}
	break;
	case 12:
// line 133 "Scanner.java.rl"
	{
            specifiers.add(new PseudoClassSpecifier(getSlice(mark, p)));
	}
	break;
	case 13:
// line 137 "Scanner.java.rl"
	{
	    specifiers.add(new PseudoNthSpecifier(pseudoNthClass, getSlice(mark, p)));
	}
	break;
	case 14:
// line 141 "Scanner.java.rl"
	{
	    pseudoNthClass = getSlice(mark, p);
	}
	break;
	case 15:
// line 145 "Scanner.java.rl"
	{
	    Selector selector;
	    List<Specifier> list = specifiers.isEmpty() ? null : specifiers;
	    if (isNegation) {
	        negationSelector = new Selector(negationTagName, list);
	    } else {
	        if (combinator == null) {
	            selector = new Selector(tagName, list);
	        } else {
	            selector = new Selector(tagName, combinator, list);
	        }

	        parts.add(selector);
	        tagName = Selector.UNIVERSAL_TAG;
	        combinator = null;
	    }

	    negationTagName = Selector.UNIVERSAL_TAG;
	    attributeName = null;
	    attributeValue = null;
	    attributeMatch = null;
	    pseudoNthClass = null;
	    specifiers = new LinkedList<Specifier>();
	}
	break;
	case 16:
// line 170 "Scanner.java.rl"
	{
	    if (isNegation) {
	        negationTagName = getSlice(mark, p);
	    } else {
	        tagName = getSlice(mark, p);
	    }
	}
	break;
	case 17:
// line 28 "ScannerCommon.rl"
	{ {stack[top++] = cs; cs = 150; _goto_targ = 2; if (true) continue _goto;} }
	case 18:
// line 42 "ScannerCommon.rl"
	{ {cs = stack[--top];_goto_targ = 2; if (true) continue _goto;} }
// line 1802 "../java/se/fishtank/css/selectors/scanner/Scanner.java"
			}
		}
	}

case 2:
	if ( cs == 0 ) {
		_goto_targ = 5;
		continue _goto;
	}
	if ( ++p != pe ) {
		_goto_targ = 1;
		continue _goto;
	}
case 4:
	if ( p == eof )
	{
	int __acts = _Scanner_eof_actions[cs];
	int __nacts = _Scanner_actions[__acts++];
	while ( __nacts-- > 0 ) {
		switch ( _Scanner_actions[__acts++] ) {
	case 4:
// line 85 "Scanner.java.rl"
	{
	    specifiers.add(new AttributeSpecifier("class",
	        getSlice(mark, p), AttributeSpecifier.Match.LIST));
	}
	break;
	case 7:
// line 111 "Scanner.java.rl"
	{
	    selectors.add(parts);
	}
	break;
	case 8:
// line 115 "Scanner.java.rl"
	{
	    specifiers.add(new AttributeSpecifier("id",
	        getSlice(mark, p), AttributeSpecifier.Match.EXACT));
	}
	break;
	case 12:
// line 133 "Scanner.java.rl"
	{
            specifiers.add(new PseudoClassSpecifier(getSlice(mark, p)));
	}
	break;
	case 15:
// line 145 "Scanner.java.rl"
	{
	    Selector selector;
	    List<Specifier> list = specifiers.isEmpty() ? null : specifiers;
	    if (isNegation) {
	        negationSelector = new Selector(negationTagName, list);
	    } else {
	        if (combinator == null) {
	            selector = new Selector(tagName, list);
	        } else {
	            selector = new Selector(tagName, combinator, list);
	        }

	        parts.add(selector);
	        tagName = Selector.UNIVERSAL_TAG;
	        combinator = null;
	    }

	    negationTagName = Selector.UNIVERSAL_TAG;
	    attributeName = null;
	    attributeValue = null;
	    attributeMatch = null;
	    pseudoNthClass = null;
	    specifiers = new LinkedList<Specifier>();
	}
	break;
	case 16:
// line 170 "Scanner.java.rl"
	{
	    if (isNegation) {
	        negationTagName = getSlice(mark, p);
	    } else {
	        tagName = getSlice(mark, p);
	    }
	}
	break;
// line 1886 "../java/se/fishtank/css/selectors/scanner/Scanner.java"
		}
	}
	}

case 5:
	}
	break; }
	}

// line 222 "Scanner.java.rl"

		if (cs < Scanner_first_final && p != pe) {
		    // TODO: Better error reporting ;)
			throw new ScannerException("Bad input!");
		}

		return selectors;
	}

	/**
	 * Get a slice from the {@linkplain #input scanner input}.
	 *
	 * @param start The start offset.
	 * @param end The end offset.
	 * @return A substring starting at {@code start} and ending in {@code end}.
	 */
	private String getSlice(int start, int end) {
		return input.substring(start, end);
	}

}
