/*
 * Decompiled with CFR 0.152.
 */
package org.joox;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.joox.Context;
import org.joox.DefaultContext;
import org.joox.JOOX;
import org.joox.Match;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class Util {
    Util() {
    }

    static final DocumentFragment createContent(Document doc, String text) {
        if (text.contains("<")) {
            DocumentBuilder builder = JOOX.builder();
            try {
                String wrapped = "<dummy>" + text + "</dummy>";
                Document parsed = builder.parse(new InputSource(new StringReader(wrapped)));
                DocumentFragment fragment = parsed.createDocumentFragment();
                NodeList children = parsed.getDocumentElement().getChildNodes();
                while (children.getLength() > 0) {
                    fragment.appendChild(children.item(0));
                }
                return (DocumentFragment)doc.importNode(fragment, true);
            }
            catch (IOException ignore) {
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
        return null;
    }

    static final String attr(Element element, String name) {
        if (element.hasAttribute(name)) {
            return element.getAttribute(name);
        }
        return null;
    }

    static final List<Element> importOrDetach(Document document, Element ... elements) {
        ArrayList<Element> detached = new ArrayList<Element>();
        for (Element e : elements) {
            if (document != e.getOwnerDocument()) {
                detached.add((Element)document.importNode(e, true));
                continue;
            }
            detached.add((Element)e.getParentNode().removeChild(e));
        }
        return detached;
    }

    static final Element[] elements(Match ... content) {
        LinkedHashSet<Element> result = new LinkedHashSet<Element>();
        for (Match x : content) {
            result.addAll(x.get());
        }
        return result.toArray(new Element[result.size()]);
    }

    static final String toString(Element element) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource source = new DOMSource(element);
            StreamResult target = new StreamResult(out);
            transformer.transform(source, target);
            return out.toString();
        }
        catch (Exception e) {
            return "[ ERROR IN toString() : " + e.getMessage() + " ]";
        }
    }

    static final boolean hasElementNodes(NodeList list) {
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            if (list.item(i).getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    static final String xpath(Element element) {
        StringBuilder sb = new StringBuilder();
        Node iterator = element;
        while (iterator.getNodeType() == 1) {
            sb.insert(0, "]");
            sb.insert(0, Util.siblingIndex(iterator) + 1);
            sb.insert(0, "[");
            sb.insert(0, iterator.getTagName());
            sb.insert(0, "/");
            iterator = iterator.getParentNode();
        }
        return sb.toString();
    }

    private static final int siblingIndex(Element element) {
        return JOOX.list(element.getParentNode().getChildNodes()).indexOf(element);
    }

    static final Context context(Element match, int matchIndex, int matchSize) {
        return new DefaultContext(match, matchIndex, matchSize);
    }

    static final Context context(Element match, int matchIndex, int matchSize, Element element, int elementIndex, int elementSize) {
        return new DefaultContext(match, matchIndex, matchSize, element, elementIndex, elementSize);
    }
}

