/*
 * Decompiled with CFR 0.152.
 */
package org.joox;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.joox.Content;
import org.joox.Elements;
import org.joox.Filter;
import org.joox.Impl;
import org.joox.Mapper;
import org.joox.X;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class JOOX {
    public static X joox() {
        return new Impl();
    }

    public static X joox(Document document) {
        return JOOX.joox(document.getDocumentElement());
    }

    public static X joox(Element element) {
        return new Impl().addElements(element);
    }

    public static DocumentBuilder builder() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Filter none() {
        return new Filter(){

            @Override
            public boolean filter(int index, Element element) {
                return false;
            }
        };
    }

    public static Filter all() {
        return new Filter(){

            @Override
            public boolean filter(int index, Element element) {
                return true;
            }
        };
    }

    public static Filter even() {
        return new Filter(){

            @Override
            public boolean filter(int index, Element element) {
                return index % 2 == 0;
            }
        };
    }

    public static Filter odd() {
        return new Filter(){

            @Override
            public boolean filter(int index, Element element) {
                return index % 2 == 1;
            }
        };
    }

    public static Filter selector(String selector) {
        return JOOX.tag(selector);
    }

    public static Filter tag(final String tagName) {
        if (tagName == null || tagName.equals("")) {
            return JOOX.none();
        }
        return new Filter(){

            @Override
            public boolean filter(int index, Element element) {
                return tagName.equals(element.getTagName());
            }
        };
    }

    public static Filter and(final Filter ... filters) {
        return new Filter(){

            @Override
            public boolean filter(int index, Element element) {
                for (Filter filter : filters) {
                    if (filter.filter(index, element)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Filter or(final Filter ... filters) {
        return new Filter(){

            @Override
            public boolean filter(int index, Element element) {
                for (Filter filter : filters) {
                    if (!filter.filter(index, element)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Filter not(final Filter filter) {
        return new Filter(){

            @Override
            public boolean filter(int index, Element element) {
                return !filter.filter(index, element);
            }
        };
    }

    public static Filter ids(String ... ids) {
        final HashSet<String> set = new HashSet<String>(Arrays.asList(ids));
        return new Filter(){

            @Override
            public boolean filter(int index, Element element) {
                return set.contains(element.getAttribute("id"));
            }
        };
    }

    public static Content content(final String value) {
        return new Content(){

            @Override
            public String content(int index, Element element) {
                return value;
            }
        };
    }

    public static Mapper<String> ids() {
        return JOOX.attributes("id");
    }

    public static Mapper<String> attributes(final String attributeName) {
        return new Mapper<String>(){

            @Override
            public String map(int index, Element element) {
                return element.getAttribute(attributeName);
            }
        };
    }

    public static Iterable<Element> iterable(NodeList elements) {
        return new Elements(elements);
    }

    public static Iterator<Element> iterator(NodeList elements) {
        return new Elements(elements).iterator();
    }

    public static List<Element> list(NodeList elements) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (Element element : JOOX.iterable(elements)) {
            list.add(element);
        }
        return list;
    }
}

