/*
 * Decompiled with CFR 0.152.
 */
package org.joox;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.joox.Content;
import org.joox.Each;
import org.joox.Filter;
import org.joox.JOOX;
import org.joox.Mapper;
import org.joox.X;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class Impl
implements X {
    private final List<Element> elements = new ArrayList<Element>();

    Impl() {
    }

    final Impl addNodeLists(List<NodeList> lists) {
        for (NodeList list : lists) {
            this.addNodeList(list);
        }
        return this;
    }

    final Impl addNodeList(NodeList list) {
        for (int i = 0; i < list.getLength(); ++i) {
            this.elements.add((Element)list.item(i));
        }
        return this;
    }

    final Impl addUniqueElements(Element ... e) {
        if (e.length == 1) {
            Element element = e[0];
            this.elements.remove(element);
            this.elements.add(element);
        } else if (e.length > 1) {
            LinkedHashSet<Element> set = new LinkedHashSet<Element>(Arrays.asList(e));
            this.elements.removeAll(set);
            this.elements.addAll(set);
        }
        return this;
    }

    final Impl addUniqueElements(List<Element> e) {
        int size = e.size();
        if (size == 1) {
            Element element = e.get(0);
            this.elements.remove(element);
            this.elements.add(element);
        } else if (size > 1) {
            LinkedHashSet<Element> set = new LinkedHashSet<Element>(e);
            this.elements.removeAll(set);
            this.elements.addAll(set);
        }
        return this;
    }

    final Impl addElements(Element ... e) {
        this.elements.addAll(Arrays.asList(e));
        return this;
    }

    final Impl addElements(List<Element> e) {
        this.elements.addAll(e);
        return this;
    }

    @Override
    public final Iterator<Element> iterator() {
        return this.elements.iterator();
    }

    @Override
    public final Element get(int index) {
        try {
            return this.elements.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public final List<Element> get() {
        return Collections.unmodifiableList(this.elements);
    }

    @Override
    public final int size() {
        return this.elements.size();
    }

    @Override
    public final Impl add(Element ... e) {
        Impl x = this.copy();
        x.addUniqueElements(e);
        return x;
    }

    @Override
    public final Impl add(X ... e) {
        Impl x = this.copy();
        for (X element : e) {
            x.addUniqueElements(element.get());
        }
        return x;
    }

    @Override
    public final Impl children() {
        return this.children(JOOX.all());
    }

    @Override
    public final Impl children(String selector) {
        return this.children(JOOX.selector(selector));
    }

    @Override
    public final Impl children(Filter filter) {
        ArrayList<Element> result = new ArrayList<Element>();
        int index = 0;
        for (Element element : this.elements) {
            for (Element child : JOOX.iterable(element.getChildNodes())) {
                if (!filter.filter(index++, child)) continue;
                result.add(child);
            }
        }
        return new Impl().addUniqueElements(result);
    }

    @Override
    public final Impl each(Each each) {
        for (int i = 0; i < this.size(); ++i) {
            each.each(i, this.get(i));
        }
        return this;
    }

    @Override
    public final Impl filter(String selector) {
        return this.filter(JOOX.selector(selector));
    }

    @Override
    public final Impl filter(Filter filter) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < this.size(); ++i) {
            if (!filter.filter(i, this.get(i))) continue;
            result.add(this.get(i));
        }
        return new Impl().addElements(result);
    }

    @Override
    public final Impl eq(int index) {
        Element element = this.get(index);
        if (element != null) {
            return new Impl().addElements(element);
        }
        return new Impl();
    }

    @Override
    public final Impl find() {
        return this.find(JOOX.all());
    }

    @Override
    public final Impl find(String selector) {
        ArrayList<NodeList> result = new ArrayList<NodeList>();
        for (Element element : this.elements) {
            result.add(element.getElementsByTagName(selector));
        }
        return new Impl().addNodeLists(result);
    }

    @Override
    public final Impl find(Filter filter) {
        ArrayList<Element> result = new ArrayList<Element>();
        int index = 0;
        for (int i = 0; i < this.size(); ++i) {
            for (Element descendant : JOOX.iterable(this.get(i).getElementsByTagName("*"))) {
                if (!filter.filter(index++, descendant)) continue;
                result.add(descendant);
            }
        }
        return new Impl().addUniqueElements(result);
    }

    @Override
    public final Impl first() {
        if (this.size() > 0) {
            return new Impl().addElements(this.get(0));
        }
        return new Impl();
    }

    @Override
    public final Impl has(String selector) {
        return this.has(JOOX.selector(selector));
    }

    @Override
    public final Impl has(Filter filter) {
        ArrayList<Element> result = new ArrayList<Element>();
        block0: for (int i = 0; i < this.size(); ++i) {
            Element element = this.elements.get(i);
            for (Element child : JOOX.iterable(element.getElementsByTagName("*"))) {
                if (!filter.filter(i, child)) continue;
                result.add(element);
                continue block0;
            }
        }
        return new Impl().addElements(result);
    }

    @Override
    public final boolean is(String selector) {
        return this.is(JOOX.selector(selector));
    }

    @Override
    public final boolean is(Filter filter) {
        for (int i = 0; i < this.size(); ++i) {
            if (!filter.filter(i, this.elements.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Impl last() {
        if (this.size() > 0) {
            return new Impl().addElements(this.get(this.size() - 1));
        }
        return new Impl();
    }

    @Override
    public final <E> List<E> map(Mapper<E> map) {
        ArrayList<E> result = new ArrayList<E>();
        for (int i = 0; i < this.size(); ++i) {
            result.add(map.map(i, this.elements.get(i)));
        }
        return result;
    }

    @Override
    public final Impl next() {
        return this.next(JOOX.all());
    }

    @Override
    public final Impl next(String selector) {
        return this.next(JOOX.selector(selector));
    }

    @Override
    public final Impl next(Filter filter) {
        return this.next(false, JOOX.none(), filter);
    }

    @Override
    public final Impl nextAll() {
        return this.nextAll(JOOX.all());
    }

    @Override
    public final Impl nextAll(String selector) {
        return this.nextAll(JOOX.selector(selector));
    }

    @Override
    public final Impl nextAll(Filter filter) {
        return this.next(true, JOOX.none(), filter);
    }

    @Override
    public final Impl nextUntil(String until) {
        return this.nextUntil(JOOX.selector(until));
    }

    @Override
    public final Impl nextUntil(Filter until) {
        return this.nextUntil(until, JOOX.all());
    }

    @Override
    public final Impl nextUntil(String until, String selector) {
        return this.nextUntil(JOOX.selector(until), JOOX.selector(selector));
    }

    @Override
    public final Impl nextUntil(String until, Filter filter) {
        return this.nextUntil(JOOX.selector(until), filter);
    }

    @Override
    public final Impl nextUntil(Filter until, String selector) {
        return this.nextUntil(until, JOOX.selector(selector));
    }

    @Override
    public final Impl nextUntil(Filter until, Filter filter) {
        return this.next(true, until, filter);
    }

    private final Impl next(boolean all, Filter until, Filter filter) {
        ArrayList<Element> result = new ArrayList<Element>();
        block0: for (Element element : this.elements) {
            Node node = element;
            int i = 0;
            while ((node = node.getNextSibling()) != null) {
                if (node.getNodeType() != 1) continue;
                Element next = (Element)node;
                if (until.filter(i, next)) continue block0;
                if (filter.filter(i++, next)) {
                    result.add(next);
                }
                if (all) continue;
                continue block0;
            }
        }
        return new Impl().addUniqueElements(result);
    }

    @Override
    public final Impl not(String selector) {
        return this.not(JOOX.selector(selector));
    }

    @Override
    public final Impl not(Filter filter) {
        return this.filter(JOOX.not(filter));
    }

    @Override
    public final Impl parent() {
        return this.parent(JOOX.all());
    }

    @Override
    public final Impl parent(String selector) {
        return this.parent(JOOX.selector(selector));
    }

    @Override
    public final Impl parent(Filter filter) {
        return this.parents(false, JOOX.none(), filter);
    }

    @Override
    public final Impl parents() {
        return this.parents(JOOX.all());
    }

    @Override
    public final Impl parents(String selector) {
        return this.parents(JOOX.selector(selector));
    }

    @Override
    public final Impl parents(Filter filter) {
        return this.parents(true, JOOX.none(), filter);
    }

    @Override
    public final Impl parentsUntil(String until) {
        return this.parentsUntil(JOOX.selector(until), JOOX.all());
    }

    @Override
    public final Impl parentsUntil(Filter until) {
        return this.parentsUntil(until, JOOX.all());
    }

    @Override
    public final Impl parentsUntil(String until, String selector) {
        return this.parentsUntil(JOOX.selector(until), JOOX.selector(selector));
    }

    @Override
    public final Impl parentsUntil(String until, Filter filter) {
        return this.parentsUntil(JOOX.selector(until), filter);
    }

    @Override
    public final Impl parentsUntil(Filter until, String selector) {
        return this.parentsUntil(until, JOOX.selector(selector));
    }

    @Override
    public final Impl parentsUntil(Filter until, Filter filter) {
        return this.parents(true, until, filter);
    }

    private final Impl parents(boolean all, Filter until, Filter filter) {
        ArrayList<Element> result = new ArrayList<Element>();
        block0: for (Element element : this.elements) {
            Node node = element;
            int i = 0;
            while ((node = node.getParentNode()) != null) {
                if (node.getNodeType() != 1) continue;
                Element next = (Element)node;
                if (until.filter(i, next)) continue block0;
                if (filter.filter(i++, next)) {
                    result.add(next);
                }
                if (all) continue;
                continue block0;
            }
        }
        return new Impl().addUniqueElements(result);
    }

    @Override
    public final Impl prev() {
        return this.prev(JOOX.all());
    }

    @Override
    public final Impl prev(String selector) {
        return this.prev(JOOX.selector(selector));
    }

    @Override
    public final Impl prev(Filter filter) {
        return this.prev(false, JOOX.none(), filter);
    }

    @Override
    public final Impl prevAll() {
        return this.prevAll(JOOX.all());
    }

    @Override
    public final Impl prevAll(String selector) {
        return this.prevAll(JOOX.selector(selector));
    }

    @Override
    public final Impl prevAll(Filter filter) {
        return this.prev(true, JOOX.none(), filter);
    }

    @Override
    public final Impl prevUntil(String until) {
        return this.prevUntil(JOOX.selector(until));
    }

    @Override
    public final Impl prevUntil(Filter until) {
        return this.prevUntil(until, JOOX.all());
    }

    @Override
    public final Impl prevUntil(String until, String selector) {
        return this.prevUntil(JOOX.selector(until), JOOX.selector(selector));
    }

    @Override
    public final Impl prevUntil(String until, Filter filter) {
        return this.prevUntil(JOOX.selector(until), filter);
    }

    @Override
    public final Impl prevUntil(Filter until, String selector) {
        return this.prevUntil(until, JOOX.selector(selector));
    }

    @Override
    public final Impl prevUntil(Filter until, Filter filter) {
        return this.prev(true, until, filter);
    }

    private final Impl prev(boolean all, Filter until, Filter filter) {
        ArrayList<Element> result = new ArrayList<Element>();
        block0: for (Element element : this.elements) {
            Node node = element;
            int i = 0;
            while ((node = node.getPreviousSibling()) != null) {
                if (node.getNodeType() != 1) continue;
                Element prev = (Element)node;
                if (until.filter(i, prev)) continue block0;
                if (filter.filter(i++, prev)) {
                    result.add(prev);
                }
                if (all) continue;
                continue block0;
            }
        }
        Collections.reverse(result);
        return new Impl().addUniqueElements(result);
    }

    @Override
    public final Impl siblings() {
        return this.siblings(JOOX.all());
    }

    @Override
    public final Impl siblings(String selector) {
        return this.siblings(JOOX.selector(selector));
    }

    @Override
    public final Impl siblings(Filter filter) {
        return this.prevAll(filter).add(this.nextAll(filter));
    }

    @Override
    public final Impl slice(int start) {
        return this.slice(start, Integer.MAX_VALUE);
    }

    @Override
    public final Impl slice(int start, int end) {
        if (start < 0) {
            start = this.size() + start;
        }
        if (end < 0) {
            end = this.size() + end;
        }
        if ((start = Math.max(0, start)) > (end = Math.min(this.size(), end))) {
            return new Impl();
        }
        if (start == 0 && end == this.size()) {
            return this;
        }
        return new Impl().addElements(this.elements.subList(start, end));
    }

    @Override
    public final Impl after(String content) {
        return this.after(JOOX.content(content));
    }

    @Override
    public final Impl after(Content content) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < this.size(); ++i) {
            Element element = this.get(i);
            result.add(element);
            Document document = element.getOwnerDocument();
            String text = content.content(i, element);
            DocumentFragment imported = this.createContent(document, text);
            Node parent = element.getParentNode();
            Node next = element.getNextSibling();
            if (imported != null) {
                result.addAll(JOOX.list(imported.getChildNodes()));
                parent.insertBefore(imported, next);
                continue;
            }
            parent.insertBefore(document.createTextNode(text), next);
        }
        this.elements.clear();
        this.elements.addAll(result);
        return this;
    }

    @Override
    public final Impl before(String content) {
        return this.before(JOOX.content(content));
    }

    @Override
    public final Impl before(Content content) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < this.size(); ++i) {
            Element element = this.get(i);
            Document document = element.getOwnerDocument();
            String text = content.content(i, element);
            DocumentFragment imported = this.createContent(document, text);
            Node parent = element.getParentNode();
            if (imported != null) {
                result.addAll(JOOX.list(imported.getChildNodes()));
                parent.insertBefore(imported, element);
            } else {
                parent.insertBefore(document.createTextNode(text), element);
            }
            result.add(element);
        }
        this.elements.clear();
        this.elements.addAll(result);
        return this;
    }

    @Override
    public final Impl append(String content) {
        return this.append(JOOX.content(content));
    }

    @Override
    public final Impl append(Content content) {
        for (int i = 0; i < this.size(); ++i) {
            String text;
            Element element = this.get(i);
            Document document = element.getOwnerDocument();
            DocumentFragment imported = this.createContent(document, text = content.content(i, element));
            if (imported != null) {
                element.appendChild(imported);
                continue;
            }
            element.appendChild(document.createTextNode(text));
        }
        return this;
    }

    @Override
    public final Impl prepend(String content) {
        return this.prepend(JOOX.content(content));
    }

    @Override
    public final Impl prepend(Content content) {
        for (int i = 0; i < this.size(); ++i) {
            Element element = this.get(i);
            Document document = element.getOwnerDocument();
            String text = content.content(i, element);
            DocumentFragment imported = this.createContent(document, text);
            Node first = element.getFirstChild();
            if (imported != null) {
                element.insertBefore(imported, first);
                continue;
            }
            element.insertBefore(document.createTextNode(text), first);
        }
        return this;
    }

    @Override
    public final String attr(String name) {
        if (this.size() > 0) {
            return this.attr(this.get(0), name);
        }
        return null;
    }

    @Override
    public final List<String> attrs(String name) {
        ArrayList<String> result = new ArrayList<String>();
        for (Element element : this.elements) {
            result.add(this.attr(element, name));
        }
        return result;
    }

    private final String attr(Element element, String name) {
        if (element.hasAttribute(name)) {
            return element.getAttribute(name);
        }
        return null;
    }

    @Override
    public final Impl attr(String name, String value) {
        return this.attr(name, JOOX.content(value));
    }

    @Override
    public final Impl attr(String name, Content content) {
        for (int i = 0; i < this.size(); ++i) {
            Element element = this.get(i);
            String value = content.content(i, element);
            if (value == null) {
                element.removeAttribute(name);
                continue;
            }
            element.setAttribute(name, value);
        }
        return this;
    }

    @Override
    public final Impl removeAttr(String name) {
        return this.attr(name, (String)null);
    }

    @Override
    public final String content() {
        if (this.size() > 0) {
            return this.content(this.get(0));
        }
        return null;
    }

    @Override
    public final List<String> contents() {
        ArrayList<String> result = new ArrayList<String>();
        for (Element element : this.elements) {
            result.add(this.content(element));
        }
        return result;
    }

    private final String content(Element element) {
        NodeList children = element.getChildNodes();
        if (children.getLength() == 0) {
            return "";
        }
        if (!this.hasElementNodes(children)) {
            return element.getTextContent();
        }
        String name = element.getTagName();
        return this.toString(element).replaceAll("^<" + name + "(?:[^>]*)>(.*)</" + name + ">$", "$1");
    }

    private final boolean hasElementNodes(NodeList list) {
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Impl content(String content) {
        return this.content(JOOX.content(content));
    }

    @Override
    public final Impl content(Content content) {
        for (int i = 0; i < this.size(); ++i) {
            Element element = this.get(i);
            String text = content.content(i, element);
            DocumentFragment imported = this.createContent(element.getOwnerDocument(), text);
            if (imported != null) {
                element.setTextContent("");
                element.appendChild(imported);
                continue;
            }
            element.setTextContent(text);
        }
        return this;
    }

    private final DocumentFragment createContent(Document document, String text) {
        if (text.contains("<")) {
            DocumentBuilder builder = JOOX.builder();
            try {
                String wrapped = "<dummy>" + text + "</dummy>";
                Document parsed = builder.parse(new InputSource(new StringReader(wrapped)));
                DocumentFragment fragment = parsed.createDocumentFragment();
                NodeList children = parsed.getDocumentElement().getChildNodes();
                while (children.getLength() > 0) {
                    fragment.appendChild(children.item(0));
                }
                return (DocumentFragment)document.importNode(fragment, true);
            }
            catch (IOException ignore) {
            }
            catch (SAXException ignore) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public final String text() {
        if (this.size() > 0) {
            return this.get(0).getTextContent();
        }
        return null;
    }

    @Override
    public final List<String> texts() {
        ArrayList<String> result = new ArrayList<String>();
        for (Element element : this.elements) {
            result.add(element.getTextContent());
        }
        return result;
    }

    @Override
    public final Impl text(String content) {
        return this.text(JOOX.content(content));
    }

    @Override
    public final Impl text(Content content) {
        for (int i = 0; i < this.size(); ++i) {
            Element element = this.get(i);
            String text = content.content(i, element);
            element.setTextContent(text);
        }
        return this;
    }

    @Override
    public final X empty() {
        for (Element element : this.elements) {
            this.empty(element);
        }
        return this;
    }

    @Override
    public final Impl remove() {
        return this.remove(JOOX.all());
    }

    @Override
    public final Impl remove(String selector) {
        return this.remove(JOOX.selector(selector));
    }

    @Override
    public final Impl remove(Filter filter) {
        ArrayList<Element> remove = new ArrayList<Element>();
        for (int i = 0; i < this.size(); ++i) {
            Element element = this.get(i);
            if (!filter.filter(i, element)) continue;
            remove.add(element);
        }
        for (Element element : remove) {
            this.remove(element);
        }
        return this;
    }

    private final void remove(Element element) {
        element.getParentNode().removeChild(element);
        this.elements.remove(element);
    }

    private final void empty(Element element) {
        Node child;
        while ((child = element.getFirstChild()) != null) {
            element.removeChild(child);
        }
    }

    @Override
    public final Impl replaceWith(String content) {
        return this.replaceWith(JOOX.content(content));
    }

    @Override
    public final Impl replaceWith(Content content) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < this.size(); ++i) {
            Element element = this.get(i);
            Document document = element.getOwnerDocument();
            String text = content.content(i, element);
            DocumentFragment imported = this.createContent(document, text);
            Node parent = element.getParentNode();
            if (imported != null) {
                result.addAll(JOOX.list(imported.getChildNodes()));
                parent.replaceChild(imported, element);
                continue;
            }
            parent.replaceChild(document.createTextNode(text), element);
        }
        this.elements.clear();
        this.elements.addAll(result);
        return this;
    }

    @Override
    public final Impl copy() {
        Impl copy = new Impl();
        copy.elements.addAll(this.elements);
        return copy;
    }

    @Override
    public final String tag() {
        return this.tag(0);
    }

    @Override
    public final String tag(int index) {
        Element element = this.get(index);
        if (element != null) {
            return element.getTagName();
        }
        return null;
    }

    @Override
    public final List<String> tags() {
        ArrayList<String> result = new ArrayList<String>();
        for (Element element : this.elements) {
            result.add(element.getTagName());
        }
        return result;
    }

    @Override
    public final String id() {
        return this.id(0);
    }

    @Override
    public final String id(int index) {
        return this.eq(index).attr("id");
    }

    @Override
    public final List<String> ids() {
        return this.attrs("id");
    }

    public final String toString() {
        if (this.elements.size() == 0) {
            return "[]";
        }
        if (this.elements.size() == 1) {
            return this.toString(this.get(0));
        }
        StringBuilder sb = new StringBuilder();
        String separator = "";
        sb.append("[");
        for (Element element : this.elements) {
            sb.append(separator);
            sb.append(this.toString(element));
            separator = ",\n";
        }
        sb.append("]");
        return sb.toString();
    }

    private final String toString(Element element) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource source = new DOMSource(element);
            StreamResult target = new StreamResult(out);
            transformer.transform(source, target);
            return out.toString();
        }
        catch (Exception e) {
            return "[ ERROR IN toString() : " + e.getMessage() + " ]";
        }
    }
}

