/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.bind.JAXB;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.impl.DSL;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.xml.XMLTableDefinition;
import org.jooq.util.xml.jaxb.InformationSchema;
import org.jooq.util.xml.jaxb.KeyColumnUsage;
import org.jooq.util.xml.jaxb.ReferentialConstraint;
import org.jooq.util.xml.jaxb.Schema;
import org.jooq.util.xml.jaxb.Sequence;
import org.jooq.util.xml.jaxb.Table;
import org.jooq.util.xml.jaxb.TableConstraint;
import org.jooq.util.xml.jaxb.TableConstraintType;

public class XMLDatabase
extends AbstractDatabase {
    private static final JooqLogger log = JooqLogger.getLogger(XMLDatabase.class);
    public static final String P_XML_FILE = "xml-file";
    public static final String P_XSL_FILE = "xsl-file";
    public static final String P_DIALECT = "dialect";
    InformationSchema info;

    private InformationSchema info() {
        block21: {
            if (this.info == null) {
                String xml = this.getProperties().getProperty(P_XML_FILE);
                String xsl = this.getProperties().getProperty(P_XSL_FILE);
                InputStream xmlIs = null;
                InputStream xslIs = null;
                log.info((Object)"Using XML file", (Object)xml);
                try {
                    xmlIs = XMLDatabase.class.getResourceAsStream(xml);
                    if (xmlIs == null) {
                        xmlIs = new FileInputStream(xml);
                    }
                    if (StringUtils.isBlank((String)xsl)) {
                        this.info = (InformationSchema)JAXB.unmarshal((File)new File(xml), InformationSchema.class);
                        break block21;
                    }
                    log.info((Object)"Using XSL file", (Object)xsl);
                    xslIs = XMLDatabase.class.getResourceAsStream(xsl);
                    if (xslIs == null) {
                        xslIs = new FileInputStream(xsl);
                    }
                    try {
                        StringWriter writer = new StringWriter();
                        TransformerFactory factory = TransformerFactory.newInstance();
                        Transformer transformer = factory.newTransformer(new StreamSource(xslIs));
                        transformer.transform(new StreamSource(xmlIs), new StreamResult(writer));
                        this.info = (InformationSchema)JAXB.unmarshal((Reader)new StringReader(writer.getBuffer().toString()), InformationSchema.class);
                    }
                    catch (TransformerException e) {
                        throw new RuntimeException("Error while transforming XML file " + xml + " with XSL file " + xsl, e);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while opening files " + xml + " or " + xsl, e);
                }
                finally {
                    if (xmlIs != null) {
                        try {
                            xmlIs.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (xslIs != null) {
                        try {
                            xslIs.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        return this.info;
    }

    @Override
    protected DSLContext create0() {
        SQLDialect dialect = SQLDialect.DEFAULT;
        try {
            dialect = SQLDialect.valueOf((String)this.getProperties().getProperty(P_DIALECT));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DSL.using((SQLDialect)dialect);
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) {
        for (KeyColumnUsage usage : this.keyColumnUsage(TableConstraintType.PRIMARY_KEY)) {
            SchemaDefinition schema = this.getSchema(usage.getConstraintSchema());
            String key = usage.getConstraintName();
            String tableName = usage.getTableName();
            String columnName = usage.getColumnName();
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) {
        for (KeyColumnUsage usage : this.keyColumnUsage(TableConstraintType.UNIQUE)) {
            SchemaDefinition schema = this.getSchema(usage.getConstraintSchema());
            String key = usage.getConstraintName();
            String tableName = usage.getTableName();
            String columnName = usage.getColumnName();
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    private List<KeyColumnUsage> keyColumnUsage(TableConstraintType constraintType) {
        ArrayList<KeyColumnUsage> result = new ArrayList<KeyColumnUsage>();
        for (TableConstraint constraint : this.info().getTableConstraints()) {
            if (constraintType != constraint.getConstraintType() || !this.getInputSchemata().contains(constraint.getConstraintSchema())) continue;
            for (KeyColumnUsage usage : this.info().getKeyColumnUsages()) {
                if (!StringUtils.equals((Object)constraint.getConstraintCatalog(), (Object)usage.getConstraintCatalog()) || !StringUtils.equals((Object)constraint.getConstraintSchema(), (Object)usage.getConstraintSchema()) || !StringUtils.equals((Object)constraint.getConstraintName(), (Object)usage.getConstraintName())) continue;
                result.add(usage);
            }
        }
        Collections.sort(result, new Comparator<KeyColumnUsage>(){

            @Override
            public int compare(KeyColumnUsage o1, KeyColumnUsage o2) {
                int r = 0;
                r = ((String)StringUtils.defaultIfNull((Object)o1.getConstraintCatalog(), (Object)"")).compareTo((String)StringUtils.defaultIfNull((Object)o2.getConstraintCatalog(), (Object)""));
                if (r != 0) {
                    return r;
                }
                r = ((String)StringUtils.defaultIfNull((Object)o1.getConstraintSchema(), (Object)"")).compareTo((String)StringUtils.defaultIfNull((Object)o2.getConstraintSchema(), (Object)""));
                if (r != 0) {
                    return r;
                }
                r = ((String)StringUtils.defaultIfNull((Object)o1.getConstraintName(), (Object)"")).compareTo((String)StringUtils.defaultIfNull((Object)o2.getConstraintName(), (Object)""));
                if (r != 0) {
                    return r;
                }
                return Integer.valueOf(o1.getOrdinalPosition()).compareTo(o2.getOrdinalPosition());
            }
        });
        return result;
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) {
        for (ReferentialConstraint constraint : this.info().getReferentialConstraints()) {
            if (!this.getInputSchemata().contains(constraint.getConstraintSchema())) continue;
            for (KeyColumnUsage usage : this.info().getKeyColumnUsages()) {
                if (!StringUtils.equals((Object)constraint.getConstraintCatalog(), (Object)usage.getConstraintCatalog()) || !StringUtils.equals((Object)constraint.getConstraintSchema(), (Object)usage.getConstraintSchema()) || !StringUtils.equals((Object)constraint.getConstraintName(), (Object)usage.getConstraintName())) continue;
                SchemaDefinition foreignKeySchema = this.getSchema(constraint.getConstraintSchema());
                SchemaDefinition uniqueKeySchema = this.getSchema(constraint.getUniqueConstraintSchema());
                String foreignKey = usage.getConstraintName();
                String foreignKeyTable = usage.getTableName();
                String foreignKeyColumn = usage.getColumnName();
                String uniqueKey = constraint.getUniqueConstraintName();
                TableDefinition referencingTable = this.getTable(foreignKeySchema, foreignKeyTable);
                if (referencingTable == null) continue;
                ColumnDefinition referencingColumn = referencingTable.getColumn(foreignKeyColumn);
                relations2.addForeignKey(foreignKey, uniqueKey, referencingColumn, uniqueKeySchema);
            }
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations r) {
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (Schema schema : this.info().getSchemata()) {
            result.add(new SchemaDefinition((Database)this, schema.getSchemaName(), null));
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Sequence sequence : this.info().getSequences()) {
            if (!this.getInputSchemata().contains(sequence.getSequenceSchema())) continue;
            SchemaDefinition schema = this.getSchema(sequence.getSequenceSchema());
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, sequence.getDataType(), sequence.getCharacterMaximumLength(), sequence.getNumericPrecision(), sequence.getNumericScale(), false, false);
            result.add(new DefaultSequenceDefinition(schema, sequence.getSequenceName(), type));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Table table : this.info().getTables()) {
            if (!this.getInputSchemata().contains(table.getTableSchema())) continue;
            SchemaDefinition schema = this.getSchema(table.getTableSchema());
            result.add(new XMLTableDefinition(schema, this.info(), table));
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    static int unbox(Integer i) {
        return i == null ? 0 : i;
    }

    static long unbox(Long l) {
        return l == null ? 0L : l;
    }
}

