/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.AbstractDefinition;
import org.jooq.util.Database;
import org.jooq.util.Definition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.TypedElementDefinition;

public abstract class AbstractElementContainerDefinition<E extends TypedElementDefinition<?>>
extends AbstractDefinition {
    protected static final Pattern PRECISION_SCALE = Pattern.compile("\\((\\d+)\\s*(?:,\\s*(\\d+))?\\)");
    private static final JooqLogger log = JooqLogger.getLogger(AbstractElementContainerDefinition.class);
    private List<E> elements;

    public AbstractElementContainerDefinition(SchemaDefinition schema, String name, String comment) {
        super(schema.getDatabase(), schema, name, comment);
    }

    @Override
    public final List<Definition> getDefinitionPath() {
        return Arrays.asList(this.getSchema(), this);
    }

    protected final List<E> getElements() {
        if (this.elements == null) {
            this.elements = new ArrayList();
            try {
                Database db = this.getDatabase();
                List<E> e = this.getElements0();
                if (this instanceof TableDefinition && db.getIncludeExcludeColumns()) {
                    this.elements = db.filterExcludeInclude(e);
                    log.info((Object)"Columns fetched", (Object)AbstractDatabase.fetchedSize(e, this.elements));
                } else {
                    this.elements = e;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error while initialising type", (Throwable)e);
            }
        }
        return this.elements;
    }

    protected final E getElement(String name) {
        return this.getElement(name, false);
    }

    protected final E getElement(String name, boolean ignoreCase) {
        return (E)((TypedElementDefinition)AbstractDatabase.getDefinition(this.getElements(), name, ignoreCase));
    }

    protected final E getElement(int index) {
        return (E)((TypedElementDefinition)this.getElements().get(index));
    }

    protected abstract List<E> getElements0() throws SQLException;

    protected Number parsePrecision(String typeName) {
        Matcher m;
        if (typeName.contains("(") && (m = PRECISION_SCALE.matcher(typeName)).find() && !StringUtils.isBlank((String)m.group(1))) {
            return Integer.valueOf(m.group(1));
        }
        return 0;
    }

    protected Number parseScale(String typeName) {
        Matcher m;
        if (typeName.contains("(") && (m = PRECISION_SCALE.matcher(typeName)).find() && !StringUtils.isBlank((String)m.group(2))) {
            return Integer.valueOf(m.group(2));
        }
        return 0;
    }

    protected String parseTypeName(String typeName) {
        return typeName.replace(" NOT NULL", "");
    }

    protected boolean parseNotNull(String typeName) {
        return typeName.toUpperCase().contains("NOT NULL");
    }
}

