/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.postgres;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.WindowSpecification;
import org.jooq.impl.DSL;
import org.jooq.util.AbstractTableDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DefaultColumnDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.ParameterDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.postgres.PostgresDSL;
import org.jooq.util.postgres.PostgresRoutineDefinition;
import org.jooq.util.postgres.information_schema.Tables;
import org.jooq.util.postgres.information_schema.tables.Parameters;
import org.jooq.util.postgres.information_schema.tables.Routines;
import org.jooq.util.postgres.pg_catalog.tables.PgNamespace;
import org.jooq.util.postgres.pg_catalog.tables.PgProc;

public class PostgresTableValuedFunction
extends AbstractTableDefinition {
    private final PostgresRoutineDefinition routine;
    private final String specificName;

    public PostgresTableValuedFunction(SchemaDefinition schema, String name, String specificName, String comment) {
        super(schema, name, comment);
        this.routine = new PostgresRoutineDefinition(schema.getDatabase(), schema.getInputName(), name, specificName);
        this.specificName = specificName;
    }

    @Override
    public List<ColumnDefinition> getElements0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        Routines r = Tables.ROUTINES;
        Parameters p = Tables.PARAMETERS;
        PgNamespace pg_n = org.jooq.util.postgres.pg_catalog.Tables.PG_NAMESPACE;
        PgProc pg_p = org.jooq.util.postgres.pg_catalog.Tables.PG_PROC;
        for (Record record : this.create().select(r.ROUTINE_NAME, p.PARAMETER_NAME, DSL.rowNumber().over((WindowSpecification)DSL.partitionBy((Field[])new Field[]{p.SPECIFIC_NAME}).orderBy(new Field[]{p.ORDINAL_POSITION})).as(p.ORDINAL_POSITION.getName()), p.DATA_TYPE, p.CHARACTER_MAXIMUM_LENGTH, p.NUMERIC_PRECISION, p.NUMERIC_SCALE, p.UDT_NAME).from((TableLike)r).join((TableLike)p).on(new Condition[]{DSL.row(r.SPECIFIC_CATALOG, r.SPECIFIC_SCHEMA, r.SPECIFIC_NAME).eq(p.SPECIFIC_CATALOG, p.SPECIFIC_SCHEMA, p.SPECIFIC_NAME)}).join((TableLike)pg_n).on(new Condition[]{r.SPECIFIC_SCHEMA.eq(pg_n.NSPNAME)}).join((TableLike)pg_p).on(new Condition[]{pg_p.PRONAMESPACE.eq(PostgresDSL.oid((Table)pg_n))}).and(pg_p.PRONAME.eq(r.ROUTINE_NAME)).where(new Condition[]{r.SPECIFIC_NAME.eq((Object)this.specificName)}).and(p.PARAMETER_MODE.ne((Object)"IN")).and(pg_p.PRORETSET).fetch()) {
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), (String)record.getValue(p.DATA_TYPE), (Number)record.getValue(p.CHARACTER_MAXIMUM_LENGTH), (Number)record.getValue(p.NUMERIC_PRECISION), (Number)record.getValue(p.NUMERIC_SCALE), true, false, (String)record.getValue(p.UDT_NAME));
            DefaultColumnDefinition column = new DefaultColumnDefinition(this.getDatabase().getTable(this.getSchema(), this.getName()), (String)record.getValue(p.PARAMETER_NAME), (Integer)record.getValue(p.ORDINAL_POSITION), type, false, null);
            result.add(column);
        }
        return result;
    }

    @Override
    protected List<ParameterDefinition> getParameters0() {
        return this.routine.getInParameters();
    }

    @Override
    public boolean isTableValuedFunction() {
        return true;
    }
}

