/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jooq.tools.JooqLogger;
import org.jooq.util.AbstractDefinition;
import org.jooq.util.DataTypeDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.Definition;
import org.jooq.util.InOutDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.ParameterDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;

public abstract class AbstractRoutineDefinition
extends AbstractDefinition
implements RoutineDefinition {
    private static final JooqLogger log = JooqLogger.getLogger(AbstractRoutineDefinition.class);
    private static final String INOUT = "(?i:(IN|OUT|INOUT)\\s+?)?";
    private static final String PARAM_NAME = "(?:(\\S+?)\\s+?)";
    private static final String PARAM_TYPE = "([^\\s\\(]+)(?:\\s*\\((\\d+)(?:\\s*,\\s*(\\d+))?\\))?";
    private static final String PARAMETER = "((?i:(IN|OUT|INOUT)\\s+?)?(?:(\\S+?)\\s+?)([^\\s\\(]+)(?:\\s*\\((\\d+)(?:\\s*,\\s*(\\d+))?\\))?)";
    protected static final Pattern PARAMETER_PATTERN = Pattern.compile("((?i:(IN|OUT|INOUT)\\s+?)?(?:(\\S+?)\\s+?)([^\\s\\(]+)(?:\\s*\\((\\d+)(?:\\s*,\\s*(\\d+))?\\))?)");
    protected static final Pattern TYPE_PATTERN = Pattern.compile("([^\\s\\(]+)(?:\\s*\\((\\d+)(?:\\s*,\\s*(\\d+))?\\))?");
    protected List<ParameterDefinition> inParameters;
    protected List<ParameterDefinition> outParameters;
    protected ParameterDefinition returnValue;
    protected List<ParameterDefinition> allParameters;
    private final PackageDefinition pkg;
    private final boolean aggregate;

    public AbstractRoutineDefinition(SchemaDefinition schema, PackageDefinition pkg, String name, String comment, String overload) {
        this(schema, pkg, name, comment, overload, false);
    }

    public AbstractRoutineDefinition(SchemaDefinition schema, PackageDefinition pkg, String name, String comment, String overload, boolean aggregate) {
        super(schema.getDatabase(), schema, name, comment, overload);
        this.pkg = pkg;
        this.aggregate = aggregate;
    }

    @Override
    public List<Definition> getDefinitionPath() {
        if (this.pkg != null) {
            return Arrays.asList(this.getSchema(), this.pkg, this);
        }
        return Arrays.asList(this.getSchema(), this);
    }

    private void init() {
        this.inParameters = new ArrayList<ParameterDefinition>();
        this.outParameters = new ArrayList<ParameterDefinition>();
        this.allParameters = new ArrayList<ParameterDefinition>();
        try {
            if (this.returnValue != null) {
                this.addParameter(InOutDefinition.RETURN, this.returnValue);
            }
            this.init0();
        }
        catch (SQLException e) {
            log.error((Object)"Error while initialising routine", (Throwable)e);
        }
    }

    protected abstract void init0() throws SQLException;

    @Override
    public final PackageDefinition getPackage() {
        return this.pkg;
    }

    @Override
    public final List<ParameterDefinition> getInParameters() {
        if (this.inParameters == null) {
            this.init();
        }
        return this.inParameters;
    }

    @Override
    public final List<ParameterDefinition> getOutParameters() {
        if (this.outParameters == null) {
            this.init();
        }
        return this.outParameters;
    }

    @Override
    public final List<ParameterDefinition> getAllParameters() {
        if (this.allParameters == null) {
            this.init();
        }
        return this.allParameters;
    }

    @Override
    public final ParameterDefinition getReturnValue() {
        if (this.allParameters == null) {
            this.init();
        }
        return this.returnValue;
    }

    @Override
    public final DataTypeDefinition getReturnType() {
        if (this.getReturnValue() != null) {
            return this.getReturnValue().getType();
        }
        return new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), "unknown");
    }

    @Override
    public final boolean isSQLUsable() {
        return this.getReturnValue() != null && this.getOutParameters().isEmpty();
    }

    @Override
    public final boolean isAggregate() {
        return this.aggregate;
    }

    protected final void addParameter(InOutDefinition inOut, ParameterDefinition parameter) {
        this.allParameters.add(parameter);
        switch (inOut) {
            case IN: {
                this.inParameters.add(parameter);
                break;
            }
            case OUT: {
                this.outParameters.add(parameter);
                break;
            }
            case INOUT: {
                this.inParameters.add(parameter);
                this.outParameters.add(parameter);
                break;
            }
            case RETURN: {
                this.returnValue = parameter;
            }
        }
    }
}

