/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractDefinition;
import org.jooq.meta.AttributeDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.tools.JooqLogger;

public abstract class AbstractPackageDefinition
extends AbstractDefinition
implements PackageDefinition {
    private static final JooqLogger log = JooqLogger.getLogger(AbstractPackageDefinition.class);
    private List<RoutineDefinition> routines;
    private List<AttributeDefinition> constants;

    public AbstractPackageDefinition(SchemaDefinition schema, String name, String comment) {
        super(schema.getDatabase(), schema, name, comment);
    }

    @Override
    public List<Definition> getDefinitionPath() {
        ArrayList<Definition> result = new ArrayList<Definition>();
        result.addAll(this.getSchema().getDefinitionPath());
        result.add(this);
        return result;
    }

    @Override
    public final List<RoutineDefinition> getRoutines() {
        if (this.routines == null) {
            this.routines = new ArrayList<RoutineDefinition>();
            if (this.getDatabase().getIncludePackageRoutines()) {
                try {
                    List<RoutineDefinition> r = this.getRoutines0();
                    if (this.getDatabase().getIncludeExcludePackageRoutines()) {
                        this.routines = this.getDatabase().filterExcludeInclude(r);
                        log.info((Object)"Columns fetched", (Object)AbstractDatabase.fetchedSize(r, this.routines));
                    } else {
                        this.routines = r;
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error while initialising package", (Throwable)e);
                }
            }
        }
        return this.routines;
    }

    @Override
    public final List<UDTDefinition> getUDTs() {
        return this.getDatabase().getUDTs(this);
    }

    protected abstract List<RoutineDefinition> getRoutines0() throws SQLException;

    @Override
    public final List<AttributeDefinition> getConstants() {
        if (this.constants == null) {
            this.constants = new ArrayList<AttributeDefinition>();
            if (this.getDatabase().getIncludePackageConstants()) {
                try {
                    this.constants = this.getConstants0();
                }
                catch (Exception e) {
                    log.error((Object)"Error while initialising package", (Throwable)e);
                }
            }
        }
        return this.constants;
    }

    protected abstract List<AttributeDefinition> getConstants0() throws SQLException;
}

