/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.DataType;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.DateAsTimestampBinding;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.EnumConverter;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.AbstractDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.JavaTypeResolver;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.TypedElementDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.jaxb.CustomType;
import org.jooq.meta.jaxb.ForcedType;
import org.jooq.tools.Convert;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

public abstract class AbstractTypedElementDefinition<T extends Definition>
extends AbstractDefinition
implements TypedElementDefinition<T> {
    private static final JooqLogger log = JooqLogger.getLogger(AbstractTypedElementDefinition.class);
    private static final Pattern LENGTH_PRECISION_SCALE_PATTERN = Pattern.compile("[\\w\\s]+(?:\\(\\s*?(\\d+)\\s*?\\)|\\(\\s*?(\\d+)\\s*?,\\s*?(\\d+)\\s*?\\))");
    private final T container;
    private final DataTypeDefinition definedType;
    private transient DataTypeDefinition type;
    private transient DataTypeDefinition resolvedType;

    public AbstractTypedElementDefinition(T container, String name, int position, DataTypeDefinition definedType, String comment) {
        super(container.getDatabase(), container.getSchema(), AbstractTypedElementDefinition.protectName(container, name, position), comment);
        this.container = container;
        this.definedType = definedType;
    }

    private static final String protectName(Definition container, String name, int position) {
        if (name == null) {
            if (container instanceof TableDefinition) {
                log.info((Object)"Missing name", (Object)("Table " + container + " holds a column without a name at position " + position));
            } else if (container instanceof UDTDefinition) {
                log.info((Object)"Missing name", (Object)("UDT " + container + " holds an attribute without a name at position " + position));
            } else if (container instanceof IndexDefinition) {
                log.info((Object)"Missing name", (Object)("Index " + container + " holds a column without a name at position " + position));
            } else if (container instanceof RoutineDefinition) {
                log.info((Object)"Missing name", (Object)("Routine " + container + " holds a parameter without a name at position " + position));
            } else {
                log.info((Object)"Missing name", (Object)("Object " + container + " holds an element without a name at position " + position));
            }
            return "_" + position;
        }
        return name;
    }

    @Override
    public final T getContainer() {
        return this.container;
    }

    @Override
    public List<Definition> getDefinitionPath() {
        ArrayList<Definition> result = new ArrayList<Definition>();
        result.addAll(this.getContainer().getDefinitionPath());
        result.add(this);
        return result;
    }

    @Override
    public DataTypeDefinition getType() {
        if (this.type == null) {
            this.type = AbstractTypedElementDefinition.mapDefinedType(this.container, this, this.definedType, null);
        }
        return this.type;
    }

    @Override
    public DataTypeDefinition getType(JavaTypeResolver resolver) {
        if (this.resolvedType == null) {
            this.resolvedType = AbstractTypedElementDefinition.mapDefinedType(this.container, this, this.definedType, resolver);
        }
        return this.resolvedType;
    }

    @Override
    public DataTypeDefinition getDefinedType() {
        return this.definedType;
    }

    public static final DataType<?> getDataType(Database db, String t, int p, int s) {
        if ("OFFSETDATETIME".equalsIgnoreCase(t)) {
            return SQLDataType.OFFSETDATETIME.precision(p);
        }
        if ("OFFSETTIME".equalsIgnoreCase(t)) {
            return SQLDataType.OFFSETTIME.precision(p);
        }
        if ("LOCALDATE".equalsIgnoreCase(t)) {
            return SQLDataType.LOCALDATE;
        }
        if ("LOCALDATETIME".equalsIgnoreCase(t)) {
            return SQLDataType.LOCALDATETIME.precision(p);
        }
        if ("LOCALTIME".equalsIgnoreCase(t)) {
            return SQLDataType.LOCALTIME.precision(p);
        }
        if (db.getForceIntegerTypesOnZeroScaleDecimals()) {
            return DefaultDataType.getDataType((SQLDialect)db.getDialect(), (String)t, (int)p, (int)s);
        }
        DataType result = DefaultDataType.getDataType((SQLDialect)db.getDialect(), (String)t);
        if (result.getType() == BigDecimal.class && s == 0) {
            DefaultDataType.getDataType((SQLDialect)db.getDialect(), BigInteger.class);
        }
        return result;
    }

    public static final DataTypeDefinition mapDefinedType(Definition container, Definition child, DataTypeDefinition definedType, JavaTypeResolver resolver) {
        ForcedType forcedType;
        DataTypeDefinition result = definedType;
        Database db = container.getDatabase();
        log.debug((Object)"Type mapping", (Object)(child + " with type " + definedType.getType()));
        if (db.dateAsTimestamp()) {
            DataType<?> dataType = null;
            try {
                dataType = AbstractTypedElementDefinition.getDataType(db, result.getType(), 0, 0);
            }
            catch (SQLDialectNotSupportedException sQLDialectNotSupportedException) {
                // empty catch block
            }
            if (dataType != null && SQLDataType.DATE.equals(dataType.getSQLDataType())) {
                DataType<?> forcedDataType = AbstractTypedElementDefinition.getDataType(db, SQLDataType.TIMESTAMP.getTypeName(), 0, 0);
                result = new DefaultDataTypeDefinition(db, child.getSchema(), forcedDataType.getTypeName(), (Number)0, (Number)0, (Number)0, (Boolean)result.isNullable(), result.getDefaultValue(), (Name)null, null, DateAsTimestampBinding.class.getName());
            }
        }
        if ((forcedType = db.getConfiguredForcedType(child, definedType)) != null) {
            String uType = forcedType.getName();
            String converter = null;
            String binding = result.getBinding();
            CustomType customType = AbstractTypedElementDefinition.customType(db, forcedType);
            if (customType != null) {
                String string = uType = !StringUtils.isBlank((String)customType.getType()) ? customType.getType() : customType.getName();
                if (Boolean.TRUE.equals(customType.isEnumConverter()) || EnumConverter.class.getName().equals(customType.getConverter())) {
                    String tType = Object.class.getName();
                    if (resolver != null) {
                        tType = resolver.resolve(definedType);
                    } else {
                        try {
                            tType = AbstractTypedElementDefinition.getDataType(db, definedType.getType(), definedType.getPrecision(), definedType.getScale()).getType().getName();
                        }
                        catch (SQLDialectNotSupportedException sQLDialectNotSupportedException) {
                            // empty catch block
                        }
                    }
                    converter = "new " + EnumConverter.class.getName() + "<" + tType + ", " + uType + ">(" + tType + ".class, " + uType + ".class)";
                } else if (!StringUtils.isBlank((String)customType.getConverter())) {
                    converter = customType.getConverter();
                }
                if (!StringUtils.isBlank((String)customType.getBinding())) {
                    binding = customType.getBinding();
                }
            }
            if (uType != null) {
                log.info((Object)"Forcing type", (Object)(child + " to " + forcedType));
                DataType<?> forcedDataType = null;
                boolean n = result.isNullable();
                String d = result.getDefaultValue();
                int l = 0;
                int p = 0;
                int s = 0;
                Matcher matcher = LENGTH_PRECISION_SCALE_PATTERN.matcher(uType);
                if (matcher.find()) {
                    if (!StringUtils.isEmpty((String)matcher.group(1))) {
                        l = p = ((Integer)Convert.convert((Object)matcher.group(1), Integer.TYPE)).intValue();
                    } else {
                        p = (Integer)Convert.convert((Object)matcher.group(2), Integer.TYPE);
                        s = (Integer)Convert.convert((Object)matcher.group(3), Integer.TYPE);
                    }
                }
                try {
                    forcedDataType = AbstractTypedElementDefinition.getDataType(db, uType, p, s);
                }
                catch (SQLDialectNotSupportedException sQLDialectNotSupportedException) {
                    // empty catch block
                }
                if (forcedDataType != null) {
                    if (customType != null) {
                        log.warn((Object)"Custom type conflict", (Object)(child + " has custom type " + customType + " forced by " + forcedType + " but a data type rewrite applies"));
                    }
                    result = new DefaultDataTypeDefinition(db, child.getSchema(), uType, (Number)l, (Number)p, (Number)s, (Boolean)n, d, (Name)null, converter, binding);
                } else if (customType != null) {
                    l = result.getLength();
                    p = result.getPrecision();
                    s = result.getScale();
                    String t = result.getType();
                    Name u = result.getQualifiedUserType();
                    result = new DefaultDataTypeDefinition(db, definedType.getSchema(), t, (Number)l, (Number)p, (Number)s, (Boolean)n, d, u, converter, binding, uType);
                } else {
                    log.warn((Object)("Bad configuration for <forcedType/> " + forcedType.getName() + ". No matching <customType/> found, and no matching SQLDataType found: " + forcedType));
                }
            }
        }
        return result;
    }

    public static final CustomType customType(Database db, ForcedType forcedType) {
        String name = forcedType.getName();
        if (StringUtils.isBlank((String)forcedType.getUserType())) {
            if (name != null) {
                for (CustomType type : db.getConfiguredCustomTypes()) {
                    if (!name.equals(type.getName())) continue;
                    return type;
                }
            }
        } else {
            return new CustomType().withBinding(forcedType.getBinding()).withEnumConverter(forcedType.isEnumConverter()).withConverter(forcedType.getConverter()).withName(name).withType(forcedType.getUserType());
        }
        return null;
    }
}

