/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.extensions;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.h2.Driver;
import org.jetbrains.annotations.ApiStatus;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.conf.ParseUnknownFunctions;
import org.jooq.conf.Settings;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.h2.H2Database;
import org.jooq.tools.jdbc.JDBCUtils;

@ApiStatus.Internal
public abstract class AbstractInterpretingDatabase
extends H2Database {
    private Connection connection;
    private boolean publicIsDefault;

    protected DSLContext create0() {
        return DSL.using((Connection)this.connection());
    }

    protected abstract void export() throws Exception;

    protected Connection connection() {
        if (this.connection == null) {
            try {
                String unqualifiedSchema = this.getProperties().getProperty("unqualifiedSchema", "none").toLowerCase();
                this.publicIsDefault = "none".equals(unqualifiedSchema);
                Properties info = new Properties();
                info.put("user", "sa");
                info.put("password", "");
                this.connection = new Driver().connect("jdbc:h2:mem:jooq-meta-extensions-" + String.valueOf(UUID.randomUUID()), info);
                if (Boolean.parseBoolean(this.getProperties().getProperty("useParsingConnection"))) {
                    this.connection = DSL.using((Connection)this.connection, (SQLDialect)SQLDialect.H2, (Settings)new Settings().withParseUnknownFunctions(ParseUnknownFunctions.IGNORE)).parsingConnection();
                }
                this.export();
            }
            catch (Exception e) {
                throw new DataAccessException("Error while exporting schema", (Throwable)e);
            }
        }
        return this.connection;
    }

    public void close() {
        JDBCUtils.safeClose((Connection)this.connection);
        this.connection = null;
        super.close();
    }

    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>(super.getSchemata0());
        result.removeIf(s -> "INFORMATION_SCHEMA".equals(s.getName()));
        return result;
    }

    @Deprecated
    public String getOutputSchema(String inputSchema) {
        String outputSchema = super.getOutputSchema(inputSchema);
        if (this.publicIsDefault && "PUBLIC".equals(outputSchema)) {
            return "";
        }
        return outputSchema;
    }

    public String getOutputSchema(String inputCatalog, String inputSchema) {
        String outputSchema = super.getOutputSchema(inputCatalog, inputSchema);
        if (this.publicIsDefault && "PUBLIC".equals(outputSchema)) {
            return "";
        }
        return outputSchema;
    }
}

