/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXB;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.util.DefaultGenerator;
import org.jooq.util.DefaultGeneratorStrategy;
import org.jooq.util.Generator;
import org.jooq.util.GeneratorStrategy;
import org.jooq.util.jaxb.Configuration;
import org.jooq.util.jaxb.Database;
import org.jooq.util.jaxb.EnumType;
import org.jooq.util.jaxb.ForcedType;
import org.jooq.util.jaxb.Generate;
import org.jooq.util.jaxb.Jdbc;
import org.jooq.util.jaxb.MasterDataTable;
import org.jooq.util.jaxb.Property;
import org.jooq.util.jaxb.Schema;
import org.jooq.util.jaxb.Strategy;
import org.jooq.util.jaxb.Target;

public class GenerationTool {
    private static final JooqLogger log = JooqLogger.getLogger(GenerationTool.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        InputStream in;
        if (args.length < 1) {
            GenerationTool.error();
        }
        if ((in = GenerationTool.class.getResourceAsStream(args[0])) == null) {
            log.error((Object)("Cannot find " + args[0]));
            log.error((Object)"-----------");
            log.error((Object)"Please be sure it is located on the classpath and qualified as a classpath location.");
            log.error((Object)"If it is located at the current working directory, try adding a '/' to the path");
            GenerationTool.error();
        }
        log.info((Object)"Initialising properties", (Object)args[0]);
        try {
            if (args[0].endsWith(".xml")) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                GenerationTool.copyLarge(in, out);
                String xml = out.toString();
                xml = xml.replaceAll("<configuration xmlns=\"http://www.jooq.org/xsd/jooq-codegen-\\d+\\.\\d+\\.\\d+.xsd\">", "<configuration xmlns=\"http://www.jooq.org/xsd/jooq-codegen-2.1.0.xsd\">");
                xml = xml.replace("<configuration>", "<configuration xmlns=\"http://www.jooq.org/xsd/jooq-codegen-2.1.0.xsd\">");
                GenerationTool.main((Configuration)JAXB.unmarshal((Reader)new StringReader(xml), Configuration.class));
            } else {
                Properties properties = new Properties();
                properties.load(in);
                GenerationTool.main(properties, args);
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot read " + args[0] + ". Error : " + e.getMessage()));
            e.printStackTrace();
            GenerationTool.error();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static void main(Properties properties, String ... args) throws Exception {
        Jdbc jdbc = new Jdbc();
        jdbc.setDriver(properties.getProperty("jdbc.Driver"));
        jdbc.setUrl(properties.getProperty("jdbc.URL"));
        jdbc.setUser(properties.getProperty("jdbc.User"));
        jdbc.setPassword(properties.getProperty("jdbc.Password"));
        jdbc.setSchema(properties.getProperty("jdbc.Schema"));
        Strategy strategy = new Strategy();
        strategy.setName(properties.containsKey("generator.strategy") ? properties.getProperty("generator.strategy") : null);
        ArrayList<MasterDataTable> masterDataTables = new ArrayList<MasterDataTable>();
        for (String name : StringUtils.defaultString((String)properties.getProperty("generator.generate.master-data-tables")).split(",")) {
            if (StringUtils.isBlank((String)name)) continue;
            MasterDataTable table = new MasterDataTable();
            table.setName(name);
            table.setLiteral(properties.getProperty("generator.generate.master-data-table-literal." + name));
            table.setDescription(properties.getProperty("generator.generate.master-data-table-description." + name));
            masterDataTables.add(table);
        }
        ArrayList<EnumType> enumTypes = new ArrayList<EnumType>();
        for (String property : properties.stringPropertyNames()) {
            String name;
            if (!property.startsWith("generator.database.enum-type.")) continue;
            name = property.replace("generator.database.enum-type.", "");
            EnumType type = new EnumType();
            type.setName(name);
            type.setLiterals(properties.getProperty(property));
            enumTypes.add(type);
        }
        ArrayList<ForcedType> forcedTypes = new ArrayList<ForcedType>();
        for (String property : properties.stringPropertyNames()) {
            if (!property.startsWith("generator.database.forced-type.")) continue;
            String name = property.replace("generator.database.forced-type.", "");
            ForcedType type = new ForcedType();
            type.setName(name);
            type.setExpressions(properties.getProperty(property));
            forcedTypes.add(type);
        }
        Database database = new Database();
        database.setName(properties.getProperty("generator.database"));
        database.setIncludes(properties.containsKey("generator.database.includes") ? properties.getProperty("generator.database.includes") : null);
        database.setExcludes(properties.containsKey("generator.database.excludes") ? properties.getProperty("generator.database.excludes") : null);
        database.setDateAsTimestamp(Boolean.valueOf("true".equalsIgnoreCase(properties.getProperty("generator.database.date-as-timestamp"))));
        database.setUnsignedTypes(Boolean.valueOf(!"false".equalsIgnoreCase(properties.getProperty("generator.generate.unsigned-types"))));
        database.setInputSchema(properties.containsKey("generator.database.input-schema") ? properties.getProperty("generator.database.input-schema") : null);
        database.setOutputSchema(properties.containsKey("generator.database.output-schema") ? properties.getProperty("generator.database.output-schema") : null);
        if (!masterDataTables.isEmpty()) {
            database.getMasterDataTables().addAll(masterDataTables);
        }
        if (!enumTypes.isEmpty()) {
            database.getEnumTypes().addAll(enumTypes);
        }
        if (!forcedTypes.isEmpty()) {
            database.getForcedTypes().addAll(forcedTypes);
        }
        Target target = new Target();
        target.setPackageName(properties.getProperty("generator.target.package"));
        target.setDirectory(properties.getProperty("generator.target.directory"));
        Generate generate = new Generate();
        generate.setRelations(Boolean.valueOf("true".equalsIgnoreCase(properties.getProperty("generator.generate.relations"))));
        generate.setDeprecated(Boolean.valueOf(!"false".equalsIgnoreCase(properties.getProperty("generator.generate.deprecated"))));
        generate.setInstanceFields(Boolean.valueOf(!"false".equalsIgnoreCase(properties.getProperty("generator.generate.instance-fields"))));
        generate.setGeneratedAnnotation(Boolean.valueOf(!"false".equalsIgnoreCase(properties.getProperty("generator.generate.generated-annotation"))));
        generate.setPojos(Boolean.valueOf("true".equalsIgnoreCase(properties.getProperty("generator.generate.pojos"))));
        generate.setRecords(Boolean.valueOf(!"false".equalsIgnoreCase(properties.getProperty("generator.generate.records"))));
        generate.setJpaAnnotations(Boolean.valueOf("true".equalsIgnoreCase(properties.getProperty("generator.generate.jpa-annotations"))));
        org.jooq.util.jaxb.Generator generator = new org.jooq.util.jaxb.Generator();
        if (!StringUtils.isBlank((String)strategy.getName())) {
            generator.setStrategy(strategy);
        }
        generator.setDatabase(database);
        generator.setTarget(target);
        generator.setGenerate(generate);
        generator.setName(properties.containsKey("generator") ? properties.getProperty("generator") : null);
        Configuration configuration = new Configuration();
        configuration.setJdbc(jdbc);
        configuration.setGenerator(generator);
        if (args.length < 2) {
            log.warn((Object)"WARNING: jooq-codegen source code generation using .properties files is deprecated as of jOOQ 2.0.4");
            log.info((Object)"         Consider using XML configuration instead");
            log.info((Object)"         See http://www.jooq.org/manual/META/Configuration/ for more details");
            log.info((Object)"");
            log.info((Object)"Use GenerationTool to migrate your .properties file to XML (printed on System.out) :");
            log.info((Object)"Usage  : GenerationTool <configuration-file> migrate");
            log.info((Object)"");
            log.info((Object)"XML output:");
            log.info((Object)"");
            JAXB.marshal((Object)configuration, (OutputStream)System.out);
            log.info((Object)"");
            log.info((Object)"");
            GenerationTool.main(configuration);
        } else if ("migrate".equals(args[1])) {
            log.info((Object)"Migrating properties to XML");
            JAXB.marshal((Object)configuration, (OutputStream)System.out);
        }
    }

    public static void main(Configuration configuration) throws Exception {
        Jdbc j = configuration.getJdbc();
        org.jooq.util.jaxb.Generator g = configuration.getGenerator();
        if (g.getStrategy() == null) {
            g.setStrategy(new Strategy());
        }
        if (g.getTarget() == null) {
            g.setTarget(new Target());
        }
        Class.forName(j.getDriver());
        Connection connection = null;
        try {
            Properties properties = new Properties();
            for (Property p : j.getProperties()) {
                properties.put(p.getKey(), p.getValue());
            }
            if (!properties.containsKey("user")) {
                properties.put("user", StringUtils.defaultString((String)j.getUser()));
            }
            if (!properties.containsKey("password")) {
                properties.put("password", StringUtils.defaultString((String)j.getPassword()));
            }
            connection = DriverManager.getConnection(StringUtils.defaultString((String)j.getUrl()), properties);
            Class<DefaultGenerator> generatorClass = !StringUtils.isBlank((String)g.getName()) ? Class.forName(GenerationTool.trim(g.getName())) : DefaultGenerator.class;
            Generator generator = (Generator)generatorClass.newInstance();
            Class<DefaultGeneratorStrategy> strategyClass = !StringUtils.isBlank((String)g.getStrategy().getName()) ? Class.forName(GenerationTool.trim(g.getStrategy().getName())) : DefaultGeneratorStrategy.class;
            GeneratorStrategy strategy = (GeneratorStrategy)strategyClass.newInstance();
            generator.setStrategy(strategy);
            Class<?> databaseClass = Class.forName(GenerationTool.trim(g.getDatabase().getName()));
            org.jooq.util.Database database = (org.jooq.util.Database)databaseClass.newInstance();
            List schemata = g.getDatabase().getSchemata();
            if (schemata.isEmpty()) {
                Schema schema = new Schema();
                schema.setInputSchema(GenerationTool.trim(g.getDatabase().getInputSchema()));
                schema.setOutputSchema(GenerationTool.trim(g.getDatabase().getOutputSchema()));
                schemata.add(schema);
            } else {
                if (!StringUtils.isBlank((String)g.getDatabase().getInputSchema())) {
                    log.warn((Object)"WARNING: Cannot combine configuration properties /configuration/generator/database/inputSchema and /configuration/generator/database/schemata");
                }
                if (!StringUtils.isBlank((String)g.getDatabase().getOutputSchema())) {
                    log.warn((Object)"WARNING: Cannot combine configuration properties /configuration/generator/database/outputSchema and /configuration/generator/database/schemata");
                }
            }
            for (Schema schema : schemata) {
                if (StringUtils.isBlank((String)schema.getInputSchema())) {
                    log.warn((Object)"WARNING: The configuration property jdbc.Schema is deprecated and will be removed in the future. Use /configuration/generator/database/inputSchema instead");
                    schema.setInputSchema(GenerationTool.trim(j.getSchema()));
                }
                if (!StringUtils.isBlank((String)schema.getOutputSchema())) continue;
                schema.setOutputSchema(GenerationTool.trim(schema.getInputSchema()));
            }
            database.setConnection(connection);
            database.setConfiguredSchemata(schemata);
            database.setIncludes(StringUtils.defaultString((String)g.getDatabase().getIncludes()).split(","));
            database.setExcludes(StringUtils.defaultString((String)g.getDatabase().getExcludes()).split(","));
            database.setConfiguredMasterDataTables(g.getDatabase().getMasterDataTables());
            database.setConfiguredCustomTypes(g.getDatabase().getCustomTypes());
            database.setConfiguredEnumTypes(g.getDatabase().getEnumTypes());
            database.setConfiguredForcedTypes(g.getDatabase().getForcedTypes());
            if (g.getDatabase().getEnumTypes().size() > 0) {
                log.warn((Object)"WARNING: The configuration property /configuration/generator/database/enumTypes is experimental and deprecated and will be removed in the future.");
            }
            if (g.getDatabase().isDateAsTimestamp() != null) {
                database.setDateAsTimestamp(g.getDatabase().isDateAsTimestamp().booleanValue());
            }
            if (g.getDatabase().isUnsignedTypes() != null) {
                database.setSupportsUnsignedTypes(g.getDatabase().isUnsignedTypes().booleanValue());
            }
            if (StringUtils.isBlank((String)g.getTarget().getPackageName())) {
                g.getTarget().setPackageName("org.jooq.generated");
            }
            if (StringUtils.isBlank((String)g.getTarget().getDirectory())) {
                g.getTarget().setPackageName("target/generated-sources/jooq");
            }
            generator.setTargetPackage(g.getTarget().getPackageName());
            generator.setTargetDirectory(g.getTarget().getDirectory());
            if (g.getGenerate().isRelations() != null) {
                generator.setGenerateRelations(g.getGenerate().isRelations());
            }
            if (g.getGenerate().isNavigationMethods() != null) {
                generator.setGenerateNavigationMethods(g.getGenerate().isNavigationMethods());
            }
            if (g.getGenerate().isDeprecated() != null) {
                generator.setGenerateDeprecated(g.getGenerate().isDeprecated());
            }
            if (g.getGenerate().isInstanceFields() != null) {
                generator.setGenerateInstanceFields(g.getGenerate().isInstanceFields());
            }
            if (g.getGenerate().isGeneratedAnnotation() != null) {
                generator.setGenerateGeneratedAnnotation(g.getGenerate().isGeneratedAnnotation());
            }
            if (g.getGenerate().isPojos() != null) {
                generator.setGeneratePojos(g.getGenerate().isPojos());
            }
            if (g.getGenerate().isRecords() != null) {
                generator.setGenerateRecords(g.getGenerate().isRecords());
            }
            if (g.getGenerate().isJpaAnnotations() != null) {
                generator.setGenerateJPAAnnotations(g.getGenerate().isJpaAnnotations());
            }
            strategy.setInstanceFields(generator.generateInstanceFields());
            generator.generate(database);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private static String trim(String string) {
        return string == null ? null : string.trim();
    }

    private static void error() {
        log.error((Object)"Usage : GenerationTool <configuration-file>");
        System.exit(-1);
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

