/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.TypeVariable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import org.jooq.Configuration;
import org.jooq.DataType;
import org.jooq.EnumType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.MasterDataType;
import org.jooq.Package;
import org.jooq.Parameter;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SchemaMapping;
import org.jooq.Select;
import org.jooq.Sequence;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UDT;
import org.jooq.UDTField;
import org.jooq.UniqueKey;
import org.jooq.exception.DataAccessException;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractKeys;
import org.jooq.impl.AbstractRoutine;
import org.jooq.impl.ArrayRecordImpl;
import org.jooq.impl.FieldTypeHelper;
import org.jooq.impl.PackageImpl;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.SequenceImpl;
import org.jooq.impl.TableImpl;
import org.jooq.impl.TableRecordImpl;
import org.jooq.impl.UDTImpl;
import org.jooq.impl.UDTRecordImpl;
import org.jooq.impl.UpdatableRecordImpl;
import org.jooq.impl.UpdatableTableImpl;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StopWatch;
import org.jooq.tools.StringUtils;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.AttributeDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DataTypeDefinition;
import org.jooq.util.Database;
import org.jooq.util.Definition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.ForeignKeyDefinition;
import org.jooq.util.GenerationUtil;
import org.jooq.util.GenerationWriter;
import org.jooq.util.Generator;
import org.jooq.util.GeneratorStrategy;
import org.jooq.util.MasterDataTableDefinition;
import org.jooq.util.MasterDataTypeDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.ParameterDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.TypedElementDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.UniqueKeyDefinition;

public class DefaultGenerator
implements Generator {
    private static final JooqLogger log = JooqLogger.getLogger(DefaultGenerator.class);
    private static String version;
    private boolean generateDeprecated = true;
    private boolean generateRelations = false;
    private boolean generateInstanceFields = true;
    private boolean generateUnsignedTypes = true;
    private GeneratorStrategy strategy;

    @Override
    public void setStrategy(GeneratorStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public GeneratorStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public boolean generateDeprecated() {
        return this.generateDeprecated;
    }

    @Override
    public void setGenerateDeprecated(boolean generateDeprecated) {
        this.generateDeprecated = generateDeprecated;
    }

    @Override
    public boolean generateRelations() {
        return this.generateRelations;
    }

    @Override
    public void setGenerateRelations(boolean generateRelations) {
        this.generateRelations = generateRelations;
    }

    @Override
    public boolean generateInstanceFields() {
        return this.generateInstanceFields;
    }

    @Override
    public void setGenerateInstanceFields(boolean generateInstanceFields) {
        this.generateInstanceFields = generateInstanceFields;
    }

    @Override
    public boolean generateUnsignedTypes() {
        return this.generateUnsignedTypes;
    }

    @Override
    public void setGenerateUnsignedTypes(boolean generateUnsignedTypes) {
        this.generateUnsignedTypes = generateUnsignedTypes;
    }

    @Override
    public void setTargetDirectory(String directory) {
        this.strategy.setTargetDirectory(directory);
    }

    @Override
    public String getTargetDirectory() {
        return this.strategy.getTargetDirectory();
    }

    @Override
    public void setTargetPackage(String packageName) {
        this.strategy.setTargetPackage(packageName);
    }

    @Override
    public String getTargetPackage() {
        return this.strategy.getTargetPackage();
    }

    @Override
    public void generate(Database database) throws SQLException, IOException {
        GenerationWriter out;
        GenerationWriter out2;
        String separator;
        StopWatch watch = new StopWatch();
        log.info((Object)"Database parameters");
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"  dialect", (Object)database.getDialect());
        log.info((Object)"  schema", (Object)database.getInputSchema());
        log.info((Object)"  target dir", (Object)this.getTargetDirectory());
        log.info((Object)"  target package", (Object)this.getTargetPackage());
        log.info((Object)"----------------------------------------------------------");
        String targetPackage = this.getTargetPackage();
        File targetPackageDir = new File(this.getTargetDirectory() + File.separator + targetPackage.replace('.', File.separatorChar));
        log.info((Object)"Emptying", (Object)targetPackageDir.getCanonicalPath());
        this.empty(targetPackageDir);
        log.info((Object)"Generating classes in", (Object)targetPackageDir.getCanonicalPath());
        SchemaDefinition schema = database.getSchema();
        GenerationWriter outS = null;
        GenerationWriter outF = null;
        if (!schema.isDefaultSchema()) {
            targetPackageDir.mkdirs();
            log.info((Object)"Generating schema", (Object)this.strategy.getFileName((Definition)schema));
            outS = new GenerationWriter(new PrintWriter(new File(targetPackageDir, this.strategy.getFileName((Definition)schema))));
            this.printHeader(outS, targetPackage);
            this.printClassJavadoc(outS, (Definition)schema);
            outS.print("public class ");
            outS.print(this.strategy.getJavaClassName((Definition)schema));
            outS.print(" extends ");
            outS.print(SchemaImpl.class);
            outS.println(" {");
            outS.printSerial();
            outS.println();
            outS.println("\t/**");
            outS.println("\t * The singleton instance of " + schema.getName());
            outS.println("\t */");
            outS.println("\tpublic static final " + this.strategy.getJavaClassName((Definition)schema) + " " + this.strategy.getJavaIdentifierUC((Definition)schema) + " = new " + this.strategy.getJavaClassName((Definition)schema) + "();");
            outS.println();
            this.printNoFurtherInstancesAllowedJavadoc(outS);
            outS.println("\tprivate " + this.strategy.getJavaClassName((Definition)schema) + "() {");
            outS.println("\t\tsuper(\"" + schema.getName() + "\");");
            outS.println("\t}");
            outS.printInitialisationStatementsPlaceholder();
            log.info((Object)"Generating factory", (Object)this.strategy.getFileName((Definition)schema, "Factory"));
            outF = new GenerationWriter(new PrintWriter(new File(targetPackageDir, this.strategy.getFileName((Definition)schema, "Factory"))));
            this.printHeader(outF, targetPackage);
            this.printClassJavadoc(outF, (Definition)schema);
            outF.print("public class ");
            outF.print(this.strategy.getJavaClassName((Definition)schema, "Factory"));
            outF.print(" extends ");
            outF.print(database.getDialect().getFactory());
            outF.println(" {");
            outF.printSerial();
            outF.println();
            outF.println("\t/**");
            outF.println("\t * Create a factory with a connection");
            outF.println("\t *");
            outF.println("\t * @param connection The connection to use with objects created from this factory");
            outF.println("\t */");
            outF.print("\tpublic ");
            outF.print(this.strategy.getJavaClassName((Definition)schema, "Factory"));
            outF.print("(");
            outF.print(Connection.class);
            outF.println(" connection) {");
            outF.println("\t\tsuper(connection);");
            outF.println("\t}");
            outF.println();
            outF.println("\t/**");
            outF.println("\t * Create a factory with a connection and a schema mapping");
            outF.println("\t *");
            outF.println("\t * @param connection The connection to use with objects created from this factory");
            outF.println("\t * @param mapping The schema mapping to use with objects created from this factory");
            outF.println("\t */");
            outF.print("\tpublic ");
            outF.print(this.strategy.getJavaClassName((Definition)schema, "Factory"));
            outF.print("(");
            outF.print(Connection.class);
            outF.print(" connection, ");
            outF.print(SchemaMapping.class);
            outF.println(" mapping) {");
            outF.println("\t\tsuper(connection, mapping);");
            outF.println("\t}");
            watch.splitInfo("Schema generated");
        }
        if (database.getSequences().size() > 0) {
            log.info((Object)"Generating sequences", (Object)targetPackageDir.getCanonicalPath());
            targetPackageDir.mkdirs();
            GenerationWriter out3 = new GenerationWriter(new PrintWriter(new File(targetPackageDir, "Sequences.java")));
            this.printHeader(out3, targetPackage);
            this.printClassJavadoc(out3, "Convenience access to all sequences in " + schema.getName());
            out3.println("public final class Sequences {");
            for (SequenceDefinition sequence : database.getSequences()) {
                out3.println();
                out3.println("\t/**");
                out3.println("\t * The sequence " + sequence.getQualifiedName());
                out3.println("\t */");
                out3.print("\tpublic static final ");
                out3.print(Sequence.class);
                out3.print("<");
                out3.print(this.getJavaType(sequence.getType()));
                out3.print(">");
                out3.print(" ");
                out3.print(this.strategy.getJavaIdentifierUC((Definition)sequence));
                out3.print(" = new ");
                out3.print(SequenceImpl.class);
                out3.print("<");
                out3.print(this.getJavaType(sequence.getType()));
                out3.print(">");
                out3.print("(\"");
                out3.print(sequence.getName());
                out3.print("\"");
                if (!schema.isDefaultSchema()) {
                    out3.print(", ");
                    out3.print(this.strategy.getFullJavaIdentifierUC((Definition)schema));
                } else {
                    out3.print(", null");
                }
                out3.print(", ");
                out3.print(this.getJavaTypeReference(sequence.getDatabase(), sequence.getType()));
                out3.println(");");
            }
            this.printPrivateConstructor(out3, "Sequences");
            out3.println("}");
            out3.close();
            this.registerInSchema(outS, database.getSequences(), Sequence.class, true);
            watch.splitInfo("Sequences generated");
        }
        File targetMasterDataTablePackageDir = new File(targetPackageDir, "enums");
        if (database.getMasterDataTables().size() > 0) {
            log.info((Object)"Generating master data", (Object)targetMasterDataTablePackageDir.getCanonicalPath());
            for (MasterDataTableDefinition table : database.getMasterDataTables()) {
                try {
                    targetMasterDataTablePackageDir.mkdirs();
                    log.info((Object)"Generating table", (Object)this.strategy.getFileName((Definition)table));
                    GenerationWriter out4 = new GenerationWriter(new PrintWriter(new File(targetMasterDataTablePackageDir, this.strategy.getFileName((Definition)table))));
                    this.printHeader(out4, targetPackage + ".enums");
                    this.printClassJavadoc(out4, (Definition)table);
                    ColumnDefinition pk = table.getPrimaryKeyColumn();
                    ColumnDefinition l = table.getLiteralColumn();
                    ColumnDefinition d = table.getDescriptionColumn();
                    Result data = table.getData();
                    out4.print("public enum ");
                    out4.print(this.strategy.getJavaClassName((Definition)table));
                    out4.print(" implements ");
                    out4.print(MasterDataType.class);
                    out4.print("<");
                    out4.print(data.getField(pk.getName()).getType());
                    out4.println("> {");
                    LinkedHashSet<ColumnDefinition> columns = new LinkedHashSet<ColumnDefinition>(Arrays.asList(pk, l, d));
                    for (Record record : data) {
                        String literal = record.getValueAsString(l.getName());
                        String description = record.getValueAsString(d.getName());
                        if (!StringUtils.isEmpty((String)description)) {
                            out4.println();
                            out4.println("\t/**");
                            out4.println("\t * " + description);
                            out4.println("\t */");
                        }
                        out4.print("\t");
                        out4.print(GenerationUtil.convertToJavaIdentifierEnum(literal));
                        out4.print("(");
                        String separator2 = "";
                        for (ColumnDefinition column : columns) {
                            out4.print(separator2);
                            out4.printNewJavaObject(record.getValue(column.getName()));
                            separator2 = ", ";
                        }
                        out4.println("),");
                    }
                    out4.println("\t;");
                    out4.println();
                    for (ColumnDefinition column : columns) {
                        out4.print("\tprivate final ");
                        out4.print(data.getField(column.getName()).getType());
                        out4.print(" ");
                        out4.println(this.strategy.getJavaClassNameLC((Definition)column) + ";");
                    }
                    out4.println();
                    out4.print("\tprivate " + this.strategy.getJavaClassName((Definition)table) + "(");
                    separator = "";
                    for (ColumnDefinition column : columns) {
                        out4.print(separator);
                        out4.print(data.getField(column.getName()).getType());
                        out4.print(" ");
                        out4.print(this.strategy.getJavaClassNameLC((Definition)column));
                        separator = ", ";
                    }
                    out4.println(") {");
                    for (ColumnDefinition column : columns) {
                        out4.print("\t\tthis.");
                        out4.print(this.strategy.getJavaClassNameLC((Definition)column));
                        out4.print(" = ");
                        out4.print(this.strategy.getJavaClassNameLC((Definition)column));
                        out4.println(";");
                    }
                    out4.println("\t}");
                    out4.println();
                    this.printOverride(out4);
                    out4.print("\tpublic ");
                    out4.print(data.getField(pk.getName()).getType());
                    out4.println(" getPrimaryKey() {");
                    out4.println("\t\treturn " + this.strategy.getJavaClassNameLC((Definition)pk) + ";");
                    out4.println("\t}");
                    for (ColumnDefinition column : columns) {
                        this.printFieldJavaDoc(out4, (TypedElementDefinition<?>)column);
                        out4.print("\tpublic final ");
                        out4.print(data.getField(column.getName()).getType());
                        out4.print(" get");
                        out4.print(this.strategy.getJavaClassName((Definition)column));
                        out4.println("() {");
                        out4.print("\t\treturn ");
                        out4.print(this.strategy.getJavaClassNameLC((Definition)column));
                        out4.println(";");
                        out4.println("\t}");
                    }
                    out4.println("}");
                    out4.close();
                }
                catch (Exception e) {
                    log.error((Object)("Exception while generating master data table " + table), (Throwable)e);
                }
            }
            watch.splitInfo("Master data generated");
        }
        File targetTablePackageDir = new File(targetPackageDir, "tables");
        if (database.getTables().size() > 0) {
            log.info((Object)"Generating tables", (Object)targetTablePackageDir.getCanonicalPath());
            for (TableDefinition table : database.getTables()) {
                try {
                    targetTablePackageDir.mkdirs();
                    log.info((Object)"Generating table", (Object)this.strategy.getFileName((Definition)table));
                    GenerationWriter out5 = new GenerationWriter(new PrintWriter(new File(targetTablePackageDir, this.strategy.getFileName((Definition)table))));
                    this.printHeader(out5, targetPackage + ".tables");
                    this.printClassJavadoc(out5, (Definition)table);
                    Class baseClass = this.generateRelations() && table.getMainUniqueKey() != null ? UpdatableTableImpl.class : TableImpl.class;
                    out5.print("public class ");
                    out5.print(this.strategy.getJavaClassName((Definition)table));
                    out5.print(" extends ");
                    out5.print(baseClass);
                    out5.print("<");
                    out5.print(this.strategy.getFullJavaClassName((Definition)table, "Record"));
                    out5.println("> {");
                    out5.printSerial();
                    this.printSingletonInstance((Definition)table, out5);
                    this.printRecordTypeMethod((Definition)table, out5);
                    for (ColumnDefinition column : table.getColumns()) {
                        this.printTableColumn(out5, column, (Definition)table);
                    }
                    out5.println();
                    this.printNoFurtherInstancesAllowedJavadoc(out5);
                    out5.println("\tprivate " + this.strategy.getJavaClassName((Definition)table) + "() {");
                    if (!schema.isDefaultSchema()) {
                        out5.println("\t\tsuper(\"" + table.getName() + "\", " + this.strategy.getFullJavaIdentifierUC((Definition)schema) + ");");
                    } else {
                        out5.println("\t\tsuper(\"" + table.getName() + "\");");
                    }
                    out5.println("\t}");
                    if (this.generateInstanceFields()) {
                        out5.println();
                        this.printNoFurtherInstancesAllowedJavadoc(out5);
                        out5.print("\tprivate ");
                        out5.print(this.strategy.getJavaClassName((Definition)table));
                        out5.print("(");
                        out5.print(String.class);
                        out5.println(" alias) {");
                        out5.print("\t\tsuper(alias, ");
                        out5.print(this.strategy.getFullJavaIdentifierUC((Definition)schema));
                        out5.print(", ");
                        out5.print(this.strategy.getFullJavaClassName((Definition)table));
                        out5.print(".");
                        out5.print(this.strategy.getJavaIdentifierUC((Definition)table));
                        out5.println(");");
                        out5.println("\t}");
                    }
                    if (this.generateRelations()) {
                        List foreignKeys;
                        List uniqueKeys;
                        UniqueKeyDefinition mainKey;
                        ColumnDefinition identity = table.getIdentity();
                        if (identity != null) {
                            out5.println();
                            out5.println("\t@Override");
                            out5.print("\tpublic ");
                            out5.print(Identity.class);
                            out5.print("<");
                            out5.print(this.strategy.getFullJavaClassName((Definition)table, "Record"));
                            out5.print(", ");
                            out5.print(this.getJavaType(table.getIdentity().getType()));
                            out5.println("> getIdentity() {");
                            out5.print("\t\treturn ");
                            out5.print(this.strategy.getTargetPackage());
                            out5.print(".Keys.IDENTITY_");
                            out5.print(this.strategy.getJavaIdentifier(identity.getContainer()));
                            out5.println(";");
                            out5.println("\t}");
                        }
                        if ((mainKey = table.getMainUniqueKey()) != null) {
                            out5.println();
                            out5.println("\t@Override");
                            out5.print("\tpublic ");
                            out5.print(UniqueKey.class);
                            out5.print("<");
                            out5.print(this.strategy.getFullJavaClassName((Definition)table, "Record"));
                            out5.println("> getMainKey() {");
                            out5.print("\t\treturn ");
                            out5.print(this.strategy.getTargetPackage());
                            out5.print(".Keys.");
                            out5.print(this.strategy.getJavaIdentifier((Definition)mainKey));
                            out5.println(";");
                            out5.println("\t}");
                        }
                        if ((uniqueKeys = table.getUniqueKeys()).size() > 0) {
                            out5.println();
                            out5.println("\t@Override");
                            out5.println("\t@SuppressWarnings(\"unchecked\")");
                            out5.print("\tpublic ");
                            out5.print(List.class);
                            out5.print("<");
                            out5.print(UniqueKey.class);
                            out5.print("<");
                            out5.print(this.strategy.getFullJavaClassName((Definition)table, "Record"));
                            out5.println(">> getKeys() {");
                            out5.print("\t\treturn ");
                            out5.print(Arrays.class);
                            out5.print(".<");
                            out5.print(UniqueKey.class);
                            out5.print("<");
                            out5.print(this.strategy.getFullJavaClassName((Definition)table, "Record"));
                            out5.print(">>asList(");
                            separator = "";
                            for (UniqueKeyDefinition uniqueKey : uniqueKeys) {
                                out5.print(separator);
                                out5.print(this.strategy.getTargetPackage());
                                out5.print(".Keys.");
                                out5.print(this.strategy.getJavaIdentifier((Definition)uniqueKey));
                                separator = ", ";
                            }
                            out5.println(");");
                            out5.println("\t}");
                        }
                        if ((foreignKeys = table.getForeignKeys()).size() > 0) {
                            out5.println();
                            out5.println("\t@Override");
                            out5.println("\t@SuppressWarnings(\"unchecked\")");
                            out5.print("\tpublic ");
                            out5.print(List.class);
                            out5.print("<");
                            out5.print(ForeignKey.class);
                            out5.print("<");
                            out5.print(this.strategy.getFullJavaClassName((Definition)table, "Record"));
                            out5.println(", ?>> getReferences() {");
                            out5.print("\t\treturn ");
                            out5.print(Arrays.class);
                            out5.print(".<");
                            out5.print(ForeignKey.class);
                            out5.print("<");
                            out5.print(this.strategy.getFullJavaClassName((Definition)table, "Record"));
                            out5.print(", ?>>asList(");
                            String separator3 = "";
                            for (ForeignKeyDefinition foreignKey : foreignKeys) {
                                TableDefinition referencedTable = foreignKey.getReferencedTable();
                                if (referencedTable instanceof MasterDataTableDefinition) continue;
                                out5.print(separator3);
                                out5.print(this.strategy.getTargetPackage());
                                out5.print(".Keys.");
                                out5.print(this.strategy.getJavaIdentifier((Definition)foreignKey));
                                separator3 = ", ";
                            }
                            out5.println(");");
                            out5.println("\t}");
                        }
                    }
                    if (this.generateInstanceFields()) {
                        out5.println();
                        out5.println("\t@Override");
                        out5.print("\tpublic ");
                        out5.print(this.strategy.getFullJavaClassName((Definition)table));
                        out5.print(" as(");
                        out5.print(String.class);
                        out5.println(" alias) {");
                        out5.print("\t\treturn new ");
                        out5.print(this.strategy.getFullJavaClassName((Definition)table));
                        out5.println("(alias);");
                        out5.println("\t}");
                    }
                    out5.printStaticInitialisationStatementsPlaceholder();
                    out5.println("}");
                    out5.close();
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating table " + table), (Throwable)e);
                }
            }
            this.registerInSchema(outS, database.getTables(), Table.class, true);
            watch.splitInfo("Tables generated");
        }
        if (database.getTables().size() > 0) {
            log.info((Object)"Generating table references", (Object)targetTablePackageDir.getCanonicalPath());
            out2 = new GenerationWriter(new PrintWriter(new File(targetPackageDir, "Tables.java")));
            this.printHeader(out2, targetPackage);
            this.printClassJavadoc(out2, "Convenience access to all tables in " + schema.getName());
            out2.println("public final class Tables {");
            for (TableDefinition table : database.getTables()) {
                out2.println();
                out2.println("\t/**");
                out2.println("\t * The table " + table.getQualifiedName());
                out2.println("\t */");
                out2.print("\tpublic static ");
                out2.print(this.strategy.getFullJavaClassName((Definition)table));
                out2.print(" ");
                out2.print(this.strategy.getJavaIdentifierUC((Definition)table));
                out2.print(" = ");
                out2.print(this.strategy.getFullJavaClassName((Definition)table));
                out2.print(".");
                out2.print(this.strategy.getJavaIdentifierUC((Definition)table));
                out2.println(";");
            }
            this.printPrivateConstructor(out2, "Tables");
            out2.println("}");
            out2.close();
            watch.splitInfo("Table references generated");
        }
        if (this.generateRelations() && database.getTables().size() > 0) {
            String separator4;
            log.info((Object)"Generating Keys", (Object)targetTablePackageDir.getCanonicalPath());
            targetPackageDir.mkdirs();
            out2 = new GenerationWriter(new PrintWriter(new File(targetPackageDir, "Keys.java")));
            this.printHeader(out2, targetPackage);
            this.printClassJavadoc(out2, "A class modelling foreign key relationships between tables of the " + schema.getName() + " schema");
            out2.suppressWarnings("unchecked");
            out2.print("public class Keys extends ");
            out2.print(AbstractKeys.class);
            out2.println(" {");
            out2.println();
            out2.println("\t// IDENTITY definitions");
            for (TableDefinition table : database.getTables()) {
                try {
                    ColumnDefinition identity = table.getIdentity();
                    if (identity == null) continue;
                    out2.print("\tpublic static final ");
                    out2.print(Identity.class);
                    out2.print("<");
                    out2.print(this.strategy.getFullJavaClassName(identity.getContainer(), "Record"));
                    out2.print(", ");
                    out2.print(this.getJavaType(identity.getType()));
                    out2.print("> IDENTITY_");
                    out2.print(this.strategy.getJavaIdentifier(identity.getContainer()));
                    out2.print(" = createIdentity(");
                    out2.print(this.strategy.getFullJavaIdentifierUC(identity.getContainer()));
                    out2.print(", ");
                    out2.print(this.strategy.getFullJavaIdentifierUC((Definition)identity));
                    out2.println(");");
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating table " + table), (Throwable)e);
                }
            }
            out2.println();
            out2.println("\t// UNIQUE and PRIMARY KEY definitions");
            for (TableDefinition table : database.getTables()) {
                try {
                    List uniqueKeys = table.getUniqueKeys();
                    if (uniqueKeys.size() <= 0) continue;
                    for (UniqueKeyDefinition uniqueKey : uniqueKeys) {
                        out2.print("\tpublic static final ");
                        out2.print(UniqueKey.class);
                        out2.print("<");
                        out2.print(this.strategy.getFullJavaClassName((Definition)uniqueKey.getTable(), "Record"));
                        out2.print("> ");
                        out2.print(this.strategy.getJavaIdentifier((Definition)uniqueKey));
                        out2.print(" = createUniqueKey(");
                        out2.print(this.strategy.getFullJavaIdentifierUC((Definition)uniqueKey.getTable()));
                        out2.print(", ");
                        separator4 = "";
                        for (ColumnDefinition column : uniqueKey.getKeyColumns()) {
                            out2.print(separator4);
                            out2.print(this.strategy.getFullJavaIdentifierUC((Definition)column));
                            separator4 = ", ";
                        }
                        out2.println(");");
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating table " + table), (Throwable)e);
                }
            }
            out2.println();
            out2.println("\t// FOREIGN KEY definitions");
            for (TableDefinition table : database.getTables()) {
                try {
                    List foreignKeys = table.getForeignKeys();
                    if (foreignKeys.size() <= 0) continue;
                    for (ForeignKeyDefinition foreignKey : foreignKeys) {
                        if (foreignKey.getReferencedTable() instanceof MasterDataTableDefinition) continue;
                        out2.print("\tpublic static final ");
                        out2.print(ForeignKey.class);
                        out2.print("<");
                        out2.print(this.strategy.getFullJavaClassName((Definition)foreignKey.getKeyTable(), "Record"));
                        out2.print(", ");
                        out2.print(this.strategy.getFullJavaClassName((Definition)foreignKey.getReferencedTable(), "Record"));
                        out2.print("> ");
                        out2.print(this.strategy.getJavaIdentifier((Definition)foreignKey));
                        out2.print(" = createForeignKey(");
                        out2.print(this.strategy.getJavaIdentifier((Definition)foreignKey.getReferencedKey()));
                        out2.print(", ");
                        out2.print(this.strategy.getFullJavaIdentifierUC((Definition)foreignKey.getKeyTable()));
                        out2.print(", ");
                        separator4 = "";
                        for (ColumnDefinition column : foreignKey.getKeyColumns()) {
                            out2.print(separator4);
                            out2.print(this.strategy.getFullJavaIdentifierUC((Definition)column));
                            separator4 = ", ";
                        }
                        out2.println(");");
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating reference " + table), (Throwable)e);
                }
            }
            this.printPrivateConstructor(out2, "Keys");
            out2.println("}");
            out2.close();
            watch.splitInfo("Keys generated");
        }
        File targetTableRecordPackageDir = new File(new File(targetPackageDir, "tables"), "records");
        if (database.getTables().size() > 0) {
            log.info((Object)"Generating records", (Object)targetTableRecordPackageDir.getCanonicalPath());
            for (TableDefinition table : database.getTables()) {
                try {
                    targetTableRecordPackageDir.mkdirs();
                    log.info((Object)"Generating record", (Object)this.strategy.getFileName((Definition)table, "Record"));
                    out = new GenerationWriter(new PrintWriter(new File(targetTableRecordPackageDir, this.strategy.getFileName((Definition)table, "Record"))));
                    this.printHeader(out, targetPackage + ".tables.records");
                    this.printClassJavadoc(out, (Definition)table);
                    Class baseClass = this.generateRelations() && table.getMainUniqueKey() != null ? UpdatableRecordImpl.class : TableRecordImpl.class;
                    out.print("public class ");
                    out.print(this.strategy.getJavaClassName((Definition)table, "Record"));
                    out.print(" extends ");
                    out.print(baseClass);
                    out.print("<");
                    out.print(this.strategy.getFullJavaClassName((Definition)table, "Record"));
                    out.println("> {");
                    out.printSerial();
                    for (ColumnDefinition column : table.getColumns()) {
                        this.printGetterAndSetter(out, (TypedElementDefinition<?>)column);
                    }
                    out.println();
                    out.println("\t/**");
                    out.println("\t * Create a detached " + this.strategy.getJavaClassName((Definition)table, "Record"));
                    out.println("\t */");
                    out.println("\tpublic " + this.strategy.getJavaClassName((Definition)table, "Record") + "() {");
                    out.print("\t\tsuper(");
                    out.print(this.strategy.getFullJavaIdentifierUC((Definition)table));
                    out.println(");");
                    out.println("\t}");
                    out.println("}");
                    out.close();
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating table record " + table), (Throwable)e);
                }
            }
            watch.splitInfo("Table records generated");
        }
        File targetUDTPackageDir = new File(targetPackageDir, "udt");
        if (database.getUDTs().size() > 0) {
            log.info((Object)"Generating UDTs", (Object)targetUDTPackageDir.getCanonicalPath());
            for (UDTDefinition udt : database.getUDTs()) {
                try {
                    targetUDTPackageDir.mkdirs();
                    log.info((Object)"Generating UDT ", (Object)this.strategy.getFileName((Definition)udt));
                    GenerationWriter out6 = new GenerationWriter(new PrintWriter(new File(targetUDTPackageDir, this.strategy.getFileName((Definition)udt))));
                    this.printHeader(out6, targetPackage + ".udt");
                    this.printClassJavadoc(out6, (Definition)udt);
                    out6.print("public class ");
                    out6.print(this.strategy.getJavaClassName((Definition)udt));
                    out6.print(" extends ");
                    out6.print(UDTImpl.class);
                    out6.print("<");
                    out6.print(this.strategy.getFullJavaClassName((Definition)udt, "Record"));
                    out6.print(">");
                    if (udt.getRoutines().size() > 0) {
                        out6.print(" implements ");
                        out6.print(Package.class);
                    }
                    out6.println(" {");
                    out6.printSerial();
                    this.printSingletonInstance((Definition)udt, out6);
                    this.printRecordTypeMethod((Definition)udt, out6);
                    for (AttributeDefinition attribute : udt.getAttributes()) {
                        this.printUDTColumn(out6, attribute, (Definition)udt);
                    }
                    for (RoutineDefinition routine : udt.getRoutines()) {
                        try {
                            if (!routine.isSQLUsable()) {
                                this.printConvenienceMethodProcedure(out6, routine, false);
                                continue;
                            }
                            this.printConvenienceMethodFunction(out6, routine, false);
                            this.printConvenienceMethodFunctionAsField(out6, routine, false);
                            this.printConvenienceMethodFunctionAsField(out6, routine, true);
                        }
                        catch (Exception e) {
                            log.error((Object)("Error while generating routine " + routine), (Throwable)e);
                        }
                    }
                    out6.println();
                    this.printNoFurtherInstancesAllowedJavadoc(out6);
                    out6.println("\tprivate " + this.strategy.getJavaClassName((Definition)udt) + "() {");
                    if (!schema.isDefaultSchema()) {
                        out6.println("\t\tsuper(\"" + udt.getName() + "\", " + this.strategy.getFullJavaIdentifierUC((Definition)schema) + ");");
                    } else {
                        out6.println("\t\tsuper(\"" + udt.getName() + "\");");
                    }
                    out6.println("\t}");
                    out6.println("}");
                    out6.close();
                    if (outS == null) continue;
                    outS.printInitialisationStatement("addMapping(\"" + schema.getName() + "." + udt.getName() + "\", " + this.strategy.getFullJavaClassName((Definition)udt, "Record") + ".class);");
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating udt " + udt), (Throwable)e);
                }
            }
            this.registerInSchema(outS, database.getUDTs(), UDT.class, true);
            watch.splitInfo("UDTs generated");
        }
        File targetRecordUDTPackageDir = new File(targetUDTPackageDir, "records");
        if (database.getUDTs().size() > 0) {
            log.info((Object)"Generating UDT records", (Object)targetRecordUDTPackageDir.getCanonicalPath());
            for (UDTDefinition udt : database.getUDTs()) {
                try {
                    targetRecordUDTPackageDir.mkdirs();
                    log.info((Object)"Generating UDT record", (Object)this.strategy.getFileName((Definition)udt, "Record"));
                    GenerationWriter out7 = new GenerationWriter(new PrintWriter(new File(targetRecordUDTPackageDir, this.strategy.getFileName((Definition)udt, "Record"))));
                    this.printHeader(out7, targetPackage + ".udt.records");
                    this.printClassJavadoc(out7, (Definition)udt);
                    out7.print("public class ");
                    out7.print(this.strategy.getJavaClassName((Definition)udt, "Record"));
                    out7.print(" extends ");
                    out7.print(UDTRecordImpl.class);
                    out7.print("<");
                    out7.print(this.strategy.getFullJavaClassName((Definition)udt, "Record"));
                    out7.println("> {");
                    out7.printSerial();
                    out7.println();
                    for (AttributeDefinition attribute : udt.getAttributes()) {
                        this.printGetterAndSetter(out7, (TypedElementDefinition<?>)attribute);
                    }
                    for (RoutineDefinition routine : udt.getRoutines()) {
                        try {
                            if (!routine.isSQLUsable()) {
                                this.printConvenienceMethodProcedure(out7, routine, true);
                                continue;
                            }
                            this.printConvenienceMethodFunction(out7, routine, true);
                        }
                        catch (Exception e) {
                            log.error((Object)("Error while generating routine " + routine), (Throwable)e);
                        }
                    }
                    out7.println();
                    out7.println("\tpublic " + this.strategy.getJavaClassName((Definition)udt, "Record") + "() {");
                    out7.print("\t\tsuper(");
                    out7.print(this.strategy.getFullJavaIdentifierUC((Definition)udt));
                    out7.println(");");
                    out7.println("\t}");
                    out7.println("}");
                    out7.close();
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating UDT record " + udt), (Throwable)e);
                }
            }
            watch.splitInfo("UDT records generated");
        }
        if (database.getUDTs().size() > 0) {
            for (UDTDefinition udt : database.getUDTs()) {
                if (udt.getRoutines().size() <= 0) continue;
                try {
                    File dir = new File(targetUDTPackageDir, this.strategy.getJavaIdentifierUC((Definition)udt).toLowerCase());
                    log.info((Object)"Generating member routines", (Object)dir.getCanonicalPath());
                    for (RoutineDefinition routine : udt.getRoutines()) {
                        try {
                            this.printRoutine(database, schema, routine);
                        }
                        catch (Exception e) {
                            log.error((Object)("Error while generating member routines " + routine), (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating UDT " + udt), (Throwable)e);
                }
                watch.splitInfo("Member procedures routines");
            }
        }
        if (database.getUDTs().size() > 0) {
            log.info((Object)"Generating UDT references", (Object)targetTablePackageDir.getCanonicalPath());
            out = new GenerationWriter(new PrintWriter(new File(targetPackageDir, "UDTs.java")));
            this.printHeader(out, targetPackage);
            this.printClassJavadoc(out, "Convenience access to all UDTs in " + schema.getName());
            out.println("public final class UDTs {");
            for (UDTDefinition udt : database.getUDTs()) {
                out.println();
                out.println("\t/**");
                out.println("\t * The type " + udt.getQualifiedName());
                out.println("\t */");
                out.print("\tpublic static ");
                out.print(this.strategy.getFullJavaClassName((Definition)udt));
                out.print(" ");
                out.print(this.strategy.getJavaIdentifierUC((Definition)udt));
                out.print(" = ");
                out.print(this.strategy.getFullJavaClassName((Definition)udt));
                out.print(".");
                out.print(this.strategy.getJavaIdentifierUC((Definition)udt));
                out.println(";");
            }
            this.printPrivateConstructor(out, "UDTs");
            out.println("}");
            out.close();
            watch.splitInfo("UDT references generated");
        }
        File targetRecordARRAYPackageDir = new File(targetUDTPackageDir, "records");
        if (database.getArrays().size() > 0) {
            log.info((Object)"Generating ARRAYs", (Object)targetRecordARRAYPackageDir.getCanonicalPath());
            for (ArrayDefinition array : database.getArrays()) {
                try {
                    targetRecordARRAYPackageDir.mkdirs();
                    log.info((Object)"Generating ARRAY", (Object)this.strategy.getFileName((Definition)array, "Record"));
                    GenerationWriter out8 = new GenerationWriter(new PrintWriter(new File(targetRecordARRAYPackageDir, this.strategy.getFileName((Definition)array, "Record"))));
                    this.printHeader(out8, targetPackage + ".udt.records");
                    this.printClassJavadoc(out8, (Definition)array);
                    out8.print("public class ");
                    out8.print(this.strategy.getJavaClassName((Definition)array, "Record"));
                    out8.print(" extends ");
                    out8.print(ArrayRecordImpl.class);
                    out8.print("<");
                    out8.print(this.getJavaType(array.getElementType()));
                    out8.println("> {");
                    out8.printSerial();
                    out8.println();
                    out8.print("\tpublic ");
                    out8.print(this.strategy.getJavaClassName((Definition)array, "Record"));
                    out8.print("(");
                    out8.print(Configuration.class);
                    out8.println(" configuration) {");
                    out8.print("\t\tsuper(\"");
                    out8.print(array.getSchemaName());
                    out8.print(".");
                    out8.print(array.getName());
                    out8.print("\", ");
                    out8.print(this.getJavaTypeReference(database, array.getElementType()));
                    out8.println(", configuration);");
                    out8.println("\t}");
                    out8.println();
                    out8.print("\tpublic ");
                    out8.print(this.strategy.getJavaClassName((Definition)array, "Record"));
                    out8.print("(");
                    out8.print(Configuration.class);
                    out8.print(" configuration, ");
                    out8.print(this.getJavaType(array.getElementType()));
                    out8.print("... array");
                    out8.println(") {");
                    out8.println("\t\tthis(configuration);");
                    out8.println("\t\tset(array);");
                    out8.println("\t}");
                    out8.println();
                    out8.print("\tpublic ");
                    out8.print(this.strategy.getJavaClassName((Definition)array, "Record"));
                    out8.print("(");
                    out8.print(Configuration.class);
                    out8.print(" configuration, ");
                    out8.print(List.class);
                    out8.print("<? extends ");
                    out8.print(this.getJavaType(array.getElementType()));
                    out8.print("> list");
                    out8.println(") {");
                    out8.println("\t\tthis(configuration);");
                    out8.println("\t\tsetList(list);");
                    out8.println("\t}");
                    out8.println("}");
                    out8.close();
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating ARRAY record " + array), (Throwable)e);
                }
            }
            watch.splitInfo("ARRAYs generated");
        }
        File targetEnumPackageDir = new File(targetPackageDir, "enums");
        if (database.getEnums().size() > 0) {
            log.info((Object)"Generating ENUMs", (Object)targetEnumPackageDir.getCanonicalPath());
            for (EnumDefinition e : database.getEnums()) {
                try {
                    targetEnumPackageDir.mkdirs();
                    log.info((Object)"Generating ENUM", (Object)this.strategy.getFileName((Definition)e));
                    GenerationWriter out9 = new GenerationWriter(new PrintWriter(new File(targetEnumPackageDir, this.strategy.getFileName((Definition)e))));
                    this.printHeader(out9, targetPackage + ".enums");
                    this.printClassJavadoc(out9, (Definition)e);
                    out9.print("public enum ");
                    out9.print(this.strategy.getJavaClassName((Definition)e));
                    out9.print(" implements ");
                    out9.print(EnumType.class);
                    out9.print(" {");
                    out9.println();
                    for (String literal : e.getLiterals()) {
                        out9.println("\t" + GenerationUtil.convertToJavaIdentifierEnum(literal) + "(\"" + literal + "\"),");
                        out9.println();
                    }
                    out9.println("\t;");
                    out9.println();
                    out9.println("\tprivate final java.lang.String literal;");
                    out9.println();
                    out9.println("\tprivate " + this.strategy.getJavaClassName((Definition)e) + "(java.lang.String literal) {");
                    out9.println("\t\tthis.literal = literal;");
                    out9.println("\t}");
                    out9.println();
                    out9.println("\t@Override");
                    out9.println("\tpublic java.lang.String getName() {");
                    out9.println("\t\treturn \"" + e.getName() + "\";");
                    out9.println("\t}");
                    out9.println();
                    out9.println("\t@Override");
                    out9.println("\tpublic java.lang.String getLiteral() {");
                    out9.println("\t\treturn literal;");
                    out9.println("\t}");
                    out9.println("}");
                    out9.close();
                }
                catch (Exception ex) {
                    log.error((Object)("Error while generating enum " + e), (Throwable)ex);
                }
            }
            watch.splitInfo("Enums generated");
        }
        if (database.getRoutines().size() > 0) {
            File targetRoutinePackageDir = new File(targetPackageDir, "routines");
            log.info((Object)"Generating routines", (Object)targetRoutinePackageDir.getCanonicalPath());
            GenerationWriter outR = new GenerationWriter(new PrintWriter(new File(targetPackageDir, "Routines.java")));
            this.printHeader(outR, targetPackage);
            this.printClassJavadoc(outR, "Convenience access to all stored procedures and functions in " + schema.getName());
            outR.println("public final class Routines {");
            for (RoutineDefinition routine : database.getRoutines()) {
                try {
                    this.printRoutine(database, schema, routine);
                    if (!routine.isSQLUsable()) {
                        this.printConvenienceMethodProcedure(outR, routine, false);
                        continue;
                    }
                    this.printConvenienceMethodFunction(outR, routine, false);
                    this.printConvenienceMethodFunctionAsField(outR, routine, false);
                    this.printConvenienceMethodFunctionAsField(outR, routine, true);
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating routine " + routine), (Throwable)e);
                }
            }
            this.printPrivateConstructor(outR, "Routines");
            outR.println("}");
            outR.close();
            watch.splitInfo("Routines generated");
        }
        File targetPackagesPackageDir = new File(targetPackageDir, "packages");
        if (database.getPackages().size() > 0) {
            log.info((Object)"Generating packages", (Object)targetPackagesPackageDir.getCanonicalPath());
            for (PackageDefinition pkg : database.getPackages()) {
                try {
                    File targetPackagePackageDir = new File(targetPackagesPackageDir, this.strategy.getJavaIdentifierUC((Definition)pkg).toLowerCase());
                    log.info((Object)"Generating package", (Object)targetPackagePackageDir.getCanonicalPath());
                    for (RoutineDefinition routine : pkg.getRoutines()) {
                        try {
                            this.printRoutine(database, schema, routine);
                        }
                        catch (Exception e) {
                            log.error((Object)("Error while generating routine " + routine), (Throwable)e);
                        }
                    }
                    GenerationWriter outPkg = new GenerationWriter(new PrintWriter(new File(targetPackagesPackageDir, this.strategy.getFileName((Definition)pkg))));
                    this.printHeader(outPkg, targetPackage + ".packages");
                    this.printClassJavadoc(outPkg, "Convenience access to all stored procedures and functions in " + pkg.getName());
                    outPkg.print("public final class ");
                    outPkg.print(this.strategy.getJavaClassName((Definition)pkg));
                    outPkg.print(" extends ");
                    outPkg.print(PackageImpl.class);
                    outPkg.println(" {");
                    outPkg.printSerial();
                    outPkg.println();
                    outPkg.println("\t/**");
                    outPkg.println("\t * The singleton instance of " + this.strategy.getJavaIdentifierUC((Definition)pkg));
                    outPkg.println("\t */");
                    outPkg.print("\tpublic static ");
                    outPkg.print(this.strategy.getFullJavaClassName((Definition)pkg));
                    outPkg.print(" ");
                    outPkg.print(this.strategy.getJavaIdentifierUC((Definition)pkg));
                    outPkg.print(" = new ");
                    outPkg.print(this.strategy.getFullJavaClassName((Definition)pkg));
                    outPkg.println("();");
                    for (RoutineDefinition routine : pkg.getRoutines()) {
                        try {
                            if (!routine.isSQLUsable()) {
                                this.printConvenienceMethodProcedure(outPkg, routine, false);
                                continue;
                            }
                            this.printConvenienceMethodFunction(outPkg, routine, false);
                            this.printConvenienceMethodFunctionAsField(outPkg, routine, false);
                            this.printConvenienceMethodFunctionAsField(outPkg, routine, true);
                        }
                        catch (Exception e) {
                            log.error((Object)("Error while generating routine " + routine), (Throwable)e);
                        }
                    }
                    this.printNoFurtherInstancesAllowedJavadoc(outPkg);
                    outPkg.println("\tprivate " + this.strategy.getJavaClassName((Definition)pkg) + "() {");
                    outPkg.print("\t\tsuper(\"");
                    outPkg.print(this.strategy.getJavaIdentifierUC((Definition)pkg));
                    outPkg.print("\", ");
                    outPkg.print(this.strategy.getFullJavaIdentifierUC((Definition)schema));
                    outPkg.println(");");
                    outPkg.println("\t}");
                    outPkg.println("}");
                    outPkg.close();
                }
                catch (Exception e) {
                    log.error((Object)("Error while generating package " + pkg), (Throwable)e);
                }
            }
            watch.splitInfo("Packages generated");
        }
        if (outS != null) {
            outS.println("}");
            outS.close();
        }
        if (outF != null) {
            outF.println("}");
            outF.close();
        }
        watch.splitInfo("GENERATION FINISHED!");
    }

    private void registerInSchema(GenerationWriter outS, List<? extends Definition> definitions, Class<?> type, boolean isGeneric) {
        if (outS != null) {
            outS.println();
            this.printOverride(outS);
            outS.print("\tpublic final ");
            outS.print(List.class);
            outS.print("<");
            outS.print(type);
            if (isGeneric) {
                outS.print("<?>");
            }
            outS.print("> get");
            outS.print(type.getSimpleName());
            outS.println("s() {");
            outS.print("\t\treturn ");
            outS.print(Arrays.class);
            outS.print(".<");
            outS.print(type);
            if (isGeneric) {
                outS.print("<?>");
            }
            outS.print(">asList(");
            if (definitions.size() > 1) {
                outS.print("\n\t\t\t");
            }
            for (int i = 0; i < definitions.size(); ++i) {
                Definition def = definitions.get(i);
                if (i > 0) {
                    outS.print(",\n\t\t\t");
                }
                this.printSingletonReference(outS, def);
            }
            outS.println(");");
            outS.println("\t}");
        }
    }

    private void printRoutine(Database database, SchemaDefinition schema, RoutineDefinition routine) throws FileNotFoundException, SQLException {
        this.strategy.getFile((Definition)routine).getParentFile().mkdirs();
        log.info((Object)"Generating routine", (Object)this.strategy.getFileName((Definition)routine));
        GenerationWriter out = new GenerationWriter(new PrintWriter(this.strategy.getFile((Definition)routine)));
        this.printHeader(out, this.strategy.getJavaPackageName((Definition)routine));
        this.printClassJavadoc(out, (Definition)routine);
        out.print("public class ");
        out.print(this.strategy.getJavaClassName((Definition)routine));
        out.print(" extends ");
        out.print(AbstractRoutine.class);
        out.print("<");
        if (routine.getReturnValue() == null) {
            out.print(Void.class);
        } else {
            out.print(this.getJavaType(routine.getReturnType()));
        }
        out.print(">");
        out.println(" {");
        out.printSerial();
        out.println();
        for (ParameterDefinition parameter : routine.getAllParameters()) {
            this.printParameter(out, parameter, (Definition)routine);
        }
        out.println();
        this.printJavadoc(out, "Create a new routine call instance");
        out.println("\tpublic " + this.strategy.getJavaClassName((Definition)routine) + "() {");
        out.print("\t\tsuper(");
        out.print(SQLDialect.class);
        out.print(".");
        out.print(database.getDialect().name());
        out.print(", \"");
        out.print(routine.getName());
        out.print("\", ");
        out.print(this.strategy.getFullJavaIdentifierUC((Definition)schema));
        if (routine.getPackage() != null) {
            out.print(", ");
            out.print(this.strategy.getFullJavaClassName((Definition)routine.getPackage()));
            out.print(".");
            out.print(this.strategy.getJavaIdentifierUC((Definition)routine.getPackage()));
        }
        if (routine.getReturnValue() != null) {
            out.print(", ");
            out.print(this.getJavaTypeReference(database, routine.getReturnType()));
        }
        out.println(");");
        if (routine.getAllParameters().size() > 0) {
            out.println();
        }
        for (ParameterDefinition parameter : routine.getAllParameters()) {
            String parameterNameUC = parameter.getName().toUpperCase();
            out.print("\t\t");
            if (parameter.equals(routine.getReturnValue())) {
                out.println("setReturnParameter(" + parameterNameUC + ");");
                continue;
            }
            if (routine.getInParameters().contains(parameter)) {
                if (routine.getOutParameters().contains(parameter)) {
                    out.println("addInOutParameter(" + parameterNameUC + ");");
                    continue;
                }
                out.println("addInParameter(" + parameterNameUC + ");");
                continue;
            }
            out.println("addOutParameter(" + parameterNameUC + ");");
        }
        if (routine.getOverload() != null) {
            out.println("\t\tsetOverloaded(true);");
        }
        out.println("\t}");
        for (ParameterDefinition parameter : routine.getInParameters()) {
            out.println();
            out.println("\t/**");
            out.println("\t * Set the <code>" + parameter.getName() + "</code> parameter to the routine");
            out.println("\t */");
            out.print("\tpublic void set");
            out.print(this.strategy.getJavaClassName((Definition)parameter));
            out.print("(");
            this.printNumberType(out, parameter.getType());
            out.println(" value) {");
            out.print("\t\tset");
            if (parameter.getType().isGenericNumberType()) {
                out.print("Number");
            } else {
                out.print("Value");
            }
            out.print("(");
            out.print(this.strategy.getJavaIdentifierUC((Definition)parameter));
            out.println(", value);");
            out.println("\t}");
            if (!routine.isSQLUsable()) continue;
            out.println();
            out.println("\t/**");
            out.println("\t * Set the <code>" + parameter.getName() + "</code> parameter to the function");
            out.println("\t * <p>");
            out.print("\t * Use this method only, if the function is called as a {@link ");
            out.print(Field.class);
            out.print("} in a {@link ");
            out.print(Select.class);
            out.println("} statement!");
            out.println("\t */");
            out.print("\tpublic void set");
            out.print(this.strategy.getJavaClassName((Definition)parameter));
            out.print("(");
            out.print(Field.class);
            out.print("<");
            this.printExtendsNumberType(out, parameter.getType());
            out.println("> field) {");
            out.print("\t\tset");
            if (parameter.getType().isGenericNumberType()) {
                out.print("Number");
            } else {
                out.print("Field");
            }
            out.print("(");
            out.print(this.strategy.getJavaIdentifierUC((Definition)parameter));
            out.println(", field);");
            out.println("\t}");
        }
        for (ParameterDefinition parameter : routine.getAllParameters()) {
            boolean isReturnValue = parameter.equals(routine.getReturnValue());
            boolean isOutParameter = routine.getOutParameters().contains(parameter);
            if (!isOutParameter || isReturnValue) continue;
            out.println();
            out.println("\tpublic " + this.getJavaType(parameter.getType()) + " get" + this.strategy.getJavaClassName((Definition)parameter) + "() {");
            out.println("\t\treturn getValue(" + this.strategy.getJavaIdentifierUC((Definition)parameter) + ");");
            out.println("\t}");
        }
        out.println("}");
        out.close();
    }

    private void printConvenienceMethodFunctionAsField(GenerationWriter out, RoutineDefinition function, boolean parametersAsField) throws SQLException {
        if (function.getInParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        if (parametersAsField && function.getInParameters().isEmpty()) {
            return;
        }
        out.println();
        out.println("\t/**");
        out.println("\t * Get " + this.strategy.getJavaIdentifierUC((Definition)function) + " as a field");
        out.println("\t *");
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.println("\t * @param " + this.strategy.getJavaClassNameLC((Definition)parameter));
        }
        out.println("\t */");
        out.print("\tpublic static ");
        out.print(Field.class);
        out.print("<");
        out.print(this.getJavaType(function.getReturnType()));
        out.print("> ");
        out.print(this.strategy.getJavaClassNameLC((Definition)function));
        out.print("(");
        String separator = "";
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.print(separator);
            if (parametersAsField) {
                out.print(Field.class);
                out.print("<");
                this.printExtendsNumberType(out, parameter.getType());
                out.print(">");
            } else {
                this.printNumberType(out, parameter.getType());
            }
            out.print(" ");
            out.print(this.strategy.getJavaClassNameLC((Definition)parameter));
            separator = ", ";
        }
        out.println(") {");
        out.print("\t\t");
        out.print(this.strategy.getFullJavaClassName((Definition)function));
        out.print(" f = new ");
        out.print(this.strategy.getFullJavaClassName((Definition)function));
        out.println("();");
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.println("\t\tf.set" + this.strategy.getJavaClassName((Definition)parameter) + "(" + this.strategy.getJavaClassNameLC((Definition)parameter) + ");");
        }
        out.println();
        out.println("\t\treturn f.asField();");
        out.println("\t}");
    }

    private void printConvenienceMethodFunction(GenerationWriter out, RoutineDefinition function, boolean instance) throws SQLException {
        if (function.getInParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Function " + function + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        out.println();
        out.println("\t/**");
        out.println("\t * Invoke " + this.strategy.getJavaIdentifierUC((Definition)function));
        out.println("\t *");
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.println("\t * @param " + this.strategy.getJavaClassNameLC((Definition)parameter));
        }
        this.printThrowsDataAccessException(out);
        out.println("\t */");
        out.print("\tpublic ");
        if (!instance) {
            out.print("static ");
        }
        out.print(this.getJavaType(function.getReturnType()));
        out.print(" ");
        out.print(this.strategy.getJavaClassNameLC((Definition)function));
        out.print("(");
        String glue = "";
        if (!instance) {
            out.print(Configuration.class);
            out.print(" configuration");
            glue = ", ";
        }
        for (ParameterDefinition parameter : function.getInParameters()) {
            if (instance && parameter.equals(function.getInParameters().get(0))) continue;
            out.print(glue);
            this.printNumberType(out, parameter.getType());
            out.print(" ");
            out.print(this.strategy.getJavaClassNameLC((Definition)parameter));
            glue = ", ";
        }
        out.println(") {");
        out.print("\t\t");
        out.print(this.strategy.getFullJavaClassName((Definition)function));
        out.print(" f = new ");
        out.print(this.strategy.getFullJavaClassName((Definition)function));
        out.println("();");
        for (ParameterDefinition parameter : function.getInParameters()) {
            out.print("\t\tf.set");
            out.print(this.strategy.getJavaClassName((Definition)parameter));
            out.print("(");
            if (instance && parameter.equals(function.getInParameters().get(0))) {
                out.print("this");
            } else {
                out.print(this.strategy.getJavaClassNameLC((Definition)parameter));
            }
            out.println(");");
        }
        out.println();
        out.print("\t\tf.execute(");
        if (instance) {
            out.print("getConfiguration()");
        } else {
            out.print("configuration");
        }
        out.println(");");
        out.println("\t\treturn f.getReturnValue();");
        out.println("\t}");
    }

    private void printThrowsDataAccessException(GenerationWriter out) {
        out.print("\t * @throws ");
        out.print(DataAccessException.class);
        out.print(" if something went wrong executing the query");
        out.println();
    }

    private void printPrivateConstructor(GenerationWriter out, String javaClassName) {
        out.println();
        out.println("\t/**");
        out.println("\t * No instances");
        out.println("\t */");
        out.println("\tprivate " + javaClassName + "() {}");
    }

    private void printConvenienceMethodProcedure(GenerationWriter out, RoutineDefinition procedure, boolean instance) throws SQLException {
        if (procedure.getInParameters().size() > 254) {
            log.warn((Object)"Too many parameters", (Object)("Procedure " + procedure + " has more than 254 in parameters. Skipping generation of convenience method."));
            return;
        }
        out.println();
        out.println("\t/**");
        out.println("\t * Invoke " + this.strategy.getJavaIdentifierUC((Definition)procedure));
        out.println("\t *");
        for (ParameterDefinition parameter : procedure.getAllParameters()) {
            out.print("\t * @param " + this.strategy.getJavaClassNameLC((Definition)parameter) + " ");
            if (procedure.getInParameters().contains(parameter)) {
                if (procedure.getOutParameters().contains(parameter)) {
                    out.println("IN OUT parameter");
                    continue;
                }
                out.println("IN parameter");
                continue;
            }
            out.println("OUT parameter");
        }
        this.printThrowsDataAccessException(out);
        out.println("\t */");
        out.print("\tpublic ");
        if (!instance) {
            out.print("static ");
        }
        if (procedure.getOutParameters().size() == 0) {
            out.print("void ");
        } else if (procedure.getOutParameters().size() == 1) {
            out.print(this.getJavaType(((ParameterDefinition)procedure.getOutParameters().get(0)).getType()));
            out.print(" ");
        } else {
            out.print(this.strategy.getFullJavaClassName((Definition)procedure) + " ");
        }
        out.print(this.strategy.getJavaClassNameLC((Definition)procedure));
        out.print("(");
        String glue = "";
        if (!instance) {
            out.print(Configuration.class);
            out.print(" configuration");
            glue = ", ";
        }
        for (ParameterDefinition parameter : procedure.getInParameters()) {
            if (instance && parameter.equals(procedure.getInParameters().get(0))) continue;
            out.print(glue);
            this.printNumberType(out, parameter.getType());
            out.print(" ");
            out.print(this.strategy.getJavaClassNameLC((Definition)parameter));
            glue = ", ";
        }
        out.println(") {");
        out.print("\t\t");
        out.print(this.strategy.getFullJavaClassName((Definition)procedure));
        out.print(" p = new ");
        out.print(this.strategy.getFullJavaClassName((Definition)procedure));
        out.println("();");
        for (ParameterDefinition parameter : procedure.getInParameters()) {
            out.print("\t\tp.set");
            out.print(this.strategy.getJavaClassName((Definition)parameter));
            out.print("(");
            if (instance && parameter.equals(procedure.getInParameters().get(0))) {
                out.print("this");
            } else {
                out.print(this.strategy.getJavaClassNameLC((Definition)parameter));
            }
            out.println(");");
        }
        out.println();
        out.print("\t\tp.execute(");
        if (instance) {
            out.print("getConfiguration()");
        } else {
            out.print("configuration");
        }
        out.println(");");
        if (procedure.getOutParameters().size() > 0) {
            if (instance) {
                out.print("\t\tfrom(p.get");
                out.print(this.strategy.getJavaClassName((Definition)procedure.getOutParameters().get(0)));
                out.println("());");
            }
            if (procedure.getOutParameters().size() == 1) {
                out.print("\t\treturn p.get");
                out.print(this.strategy.getJavaClassName((Definition)procedure.getOutParameters().get(0)));
                out.println("();");
            } else if (procedure.getOutParameters().size() > 1) {
                out.println("\t\treturn p;");
            }
        }
        out.println("\t}");
    }

    private void printRecordTypeMethod(Definition definition, GenerationWriter out) {
        out.println();
        out.println("\t/**");
        out.println("\t * The class holding records for this type");
        out.println("\t */");
        out.print("\tprivate static final ");
        out.print(Class.class);
        out.print("<");
        out.print(this.strategy.getFullJavaClassName(definition, "Record"));
        out.print("> __RECORD_TYPE = ");
        out.print(this.strategy.getFullJavaClassName(definition, "Record"));
        out.println(".class;");
        out.println();
        out.println("\t/**");
        out.println("\t * The class holding records for this type");
        out.println("\t */");
        this.printOverride(out);
        out.print("\tpublic ");
        out.print(Class.class);
        out.print("<");
        out.print(this.strategy.getFullJavaClassName(definition, "Record"));
        out.println("> getRecordType() {");
        out.println("\t\treturn __RECORD_TYPE;");
        out.println("\t}");
    }

    private void printSingletonInstance(Definition definition, GenerationWriter out) {
        out.println();
        out.println("\t/**");
        out.println("\t * The singleton instance of " + definition.getName());
        out.println("\t */");
        out.print("\tpublic static final ");
        out.print(this.strategy.getFullJavaClassName(definition));
        out.print(" ");
        out.print(this.strategy.getJavaIdentifierUC(definition));
        out.print(" = new ");
        out.print(this.strategy.getFullJavaClassName(definition));
        out.println("();");
    }

    private void printSingletonReference(GenerationWriter out, Definition definition) {
        if (definition instanceof SequenceDefinition) {
            out.print(this.strategy.getTargetPackage());
            out.print(".");
            out.print("Sequences");
            out.print(".");
            out.print(this.strategy.getJavaIdentifierUC(definition));
        } else {
            out.print(this.strategy.getFullJavaIdentifierUC(definition));
        }
    }

    private void printOverride(GenerationWriter out) {
        out.println("\t@Override");
    }

    private void empty(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                File[] children = file.listFiles();
                if (children != null) {
                    for (File child : children) {
                        this.empty(child);
                    }
                }
            } else if (file.getName().endsWith(".java")) {
                file.delete();
            }
        }
    }

    private void printGetterAndSetter(GenerationWriter out, TypedElementDefinition<?> element) throws SQLException {
        this.printFieldJavaDoc(out, element);
        out.println("\tpublic void " + this.strategy.getJavaSetterName((Definition)element) + "(" + this.getJavaType(element.getType()) + " value) {");
        out.println("\t\tsetValue(" + this.strategy.getFullJavaIdentifierUC((Definition)element) + ", value);");
        out.println("\t}");
        this.printFieldJavaDoc(out, element);
        out.println("\tpublic " + this.getJavaType(element.getType()) + " " + this.strategy.getJavaGetterName((Definition)element) + "() {");
        out.println("\t\treturn getValue(" + this.strategy.getFullJavaIdentifierUC((Definition)element) + ");");
        out.println("\t}");
        if (this.generateRelations() && element instanceof ColumnDefinition) {
            ColumnDefinition column = (ColumnDefinition)element;
            List uniqueKeys = column.getUniqueKeys();
            for (UniqueKeyDefinition uniqueKey : uniqueKeys) {
                if (!out.printOnlyOnce(uniqueKey)) continue;
                for (ForeignKeyDefinition foreignKey : uniqueKey.getForeignKeys()) {
                    if (foreignKey.getReferencedColumns().size() != foreignKey.getKeyColumns().size()) {
                        log.warn((Object)"Foreign key mismatch", (Object)(foreignKey.getName() + " does not match its primary key! No code is generated for this key. See trac tickets #64 and #69"));
                        continue;
                    }
                    TableDefinition referencing = foreignKey.getKeyTable();
                    this.printFieldJavaDoc(out, (TypedElementDefinition<?>)column);
                    out.print("\tpublic ");
                    out.print(List.class);
                    out.print("<");
                    out.print(this.strategy.getFullJavaClassName((Definition)referencing, "Record"));
                    out.print("> fetch");
                    out.print(this.strategy.getJavaClassName((Definition)referencing));
                    out.print("List");
                    if (foreignKey.countSimilarReferences() > 1) {
                        out.print("By");
                        out.print(this.strategy.getJavaClassName((Definition)foreignKey.getKeyColumns().get(0)));
                    }
                    out.println("() {");
                    out.println("\t\treturn create()");
                    out.print("\t\t\t.selectFrom(");
                    out.print(this.strategy.getFullJavaIdentifierUC((Definition)referencing));
                    out.println(")");
                    String connector = "\t\t\t.where(";
                    for (int i = 0; i < foreignKey.getReferencedColumns().size(); ++i) {
                        out.print(connector);
                        out.print(this.strategy.getFullJavaIdentifierUC((Definition)foreignKey.getKeyColumns().get(i)));
                        out.print(".equal(getValue");
                        DataTypeDefinition foreignType = ((ColumnDefinition)foreignKey.getKeyColumns().get(i)).getType();
                        DataTypeDefinition primaryType = ((ColumnDefinition)uniqueKey.getKeyColumns().get(i)).getType();
                        if (!this.match(foreignType, primaryType)) {
                            out.print("As");
                            out.print(this.getSimpleJavaType(((ColumnDefinition)foreignKey.getKeyColumns().get(i)).getType()));
                        }
                        out.print("(");
                        out.print(this.strategy.getFullJavaIdentifierUC((Definition)uniqueKey.getKeyColumns().get(i)));
                        out.println(")))");
                        connector = "\t\t\t.and(";
                    }
                    out.println("\t\t\t.fetch();");
                    out.println("\t}");
                }
            }
            ForeignKeyDefinition foreignKey = column.getForeignKey();
            if (foreignKey != null && out.printOnlyOnce(foreignKey)) {
                TableDefinition referenced;
                boolean skipGeneration = false;
                if (foreignKey.getReferencedColumns().size() != foreignKey.getKeyColumns().size()) {
                    log.warn((Object)"Foreign key mismatch", (Object)(foreignKey.getName() + " does not match its primary key! No code is generated for this key. See trac tickets #64 and #69"));
                    skipGeneration = true;
                }
                if ((referenced = foreignKey.getReferencedTable()) instanceof MasterDataTableDefinition) {
                    skipGeneration = true;
                }
                if (!skipGeneration) {
                    this.printFieldJavaDoc(out, (TypedElementDefinition<?>)column);
                    out.print("\tpublic ");
                    out.print(this.strategy.getFullJavaClassName((Definition)referenced, "Record"));
                    out.print(" fetch");
                    out.print(this.strategy.getJavaClassName((Definition)referenced));
                    if (foreignKey.countSimilarReferences() > 1) {
                        out.print("By");
                        out.print(this.strategy.getJavaClassName((Definition)column));
                    }
                    out.println("() {");
                    out.println("\t\treturn create()");
                    out.print("\t\t\t.selectFrom(");
                    out.print(this.strategy.getFullJavaIdentifierUC((Definition)referenced));
                    out.println(")");
                    String connector = "\t\t\t.where(";
                    for (int i = 0; i < foreignKey.getReferencedColumns().size(); ++i) {
                        out.print(connector);
                        out.print(this.strategy.getFullJavaIdentifierUC((Definition)foreignKey.getReferencedColumns().get(i)));
                        out.print(".equal(getValue");
                        DataTypeDefinition foreignType = ((ColumnDefinition)foreignKey.getKeyColumns().get(i)).getType();
                        DataTypeDefinition primaryType = ((ColumnDefinition)foreignKey.getReferencedColumns().get(i)).getType();
                        if (!this.match(foreignType, primaryType)) {
                            out.print("As");
                            out.print(this.getSimpleJavaType(((ColumnDefinition)foreignKey.getReferencedColumns().get(i)).getType()));
                        }
                        out.print("(");
                        out.print(this.strategy.getFullJavaIdentifierUC((Definition)foreignKey.getKeyColumns().get(i)));
                        out.println(")))");
                        connector = "\t\t\t.and(";
                    }
                    out.println("\t\t\t.fetchOne();");
                    out.println("\t}");
                }
            }
        }
    }

    private void printUDTColumn(GenerationWriter out, AttributeDefinition attribute, Definition table) throws SQLException {
        Class<UDTField> declaredMemberClass = UDTField.class;
        this.printColumnDefinition(out, (TypedElementDefinition<?>)attribute, table, declaredMemberClass);
    }

    private void printTableColumn(GenerationWriter out, ColumnDefinition column, Definition table) throws SQLException {
        Class<TableField> declaredMemberClass = TableField.class;
        this.printColumnDefinition(out, (TypedElementDefinition<?>)column, table, declaredMemberClass);
    }

    private void printParameter(GenerationWriter out, ParameterDefinition parameter, Definition proc) throws SQLException {
        this.printColumnDefinition(out, (TypedElementDefinition<?>)parameter, proc, Parameter.class);
    }

    private void printColumnDefinition(GenerationWriter out, TypedElementDefinition<?> column, Definition type, Class<?> declaredMemberClass) throws SQLException {
        boolean hasType;
        this.printFieldJavaDoc(out, column);
        boolean bl = hasType = type instanceof TableDefinition || type instanceof UDTDefinition;
        if (type instanceof TableDefinition) {
            if (this.generateInstanceFields()) {
                out.print("\tpublic final ");
            } else {
                out.print("\tpublic static final ");
            }
        } else {
            out.print("\tpublic static final ");
        }
        out.print(declaredMemberClass);
        out.print("<");
        if (hasType) {
            out.print(this.strategy.getFullJavaClassName(type, "Record"));
            out.print(", ");
        }
        out.print(this.getJavaType(column.getType()));
        out.print("> ");
        out.print(this.strategy.getJavaIdentifierUC((Definition)column));
        if (declaredMemberClass == TableField.class) {
            out.print(" = createField");
        } else if (declaredMemberClass == UDTField.class) {
            out.print(" = createField");
        } else {
            out.print(" = createParameter");
        }
        out.print("(\"");
        out.print(column.getName());
        out.print("\", ");
        out.print(this.getJavaTypeReference(column.getDatabase(), column.getType()));
        if (hasType) {
            if (type instanceof TableDefinition) {
                if (this.generateInstanceFields()) {
                    out.print(", this");
                } else {
                    out.print(", " + this.strategy.getJavaIdentifierUC(type));
                }
            } else {
                out.print(", " + this.strategy.getJavaIdentifierUC(type));
            }
        }
        out.println(");");
    }

    private void printFieldJavaDoc(GenerationWriter out, TypedElementDefinition<?> element) throws SQLException {
        this.printFieldJavaDoc(out, element, null);
    }

    private void printFieldJavaDoc(GenerationWriter out, TypedElementDefinition<?> element, String deprecation) throws SQLException {
        out.println();
        out.println("\t/**");
        String comment = element.getComment();
        if (comment != null && comment.length() > 0) {
            out.println("\t * " + comment);
        } else {
            out.println("\t * An uncommented item");
        }
        if (this.getJavaType(element.getType()).startsWith("java.lang.Object")) {
            String u;
            String t = element.getType().getType();
            String combined = t.equalsIgnoreCase(u = element.getType().getUserType()) ? t : t + ", " + u;
            out.println("\t * ");
            out.print("\t * The SQL type of this item (");
            out.print(combined);
            out.println(") could not be mapped.<br/>");
            out.println("\t * Deserialising this field might not work!");
            log.warn((Object)"Unknown type", (Object)(element.getQualifiedName() + " (" + combined + ")"));
        }
        if (element instanceof ColumnDefinition) {
            ColumnDefinition column = (ColumnDefinition)element;
            UniqueKeyDefinition primaryKey = column.getPrimaryKey();
            ForeignKeyDefinition foreignKey = column.getForeignKey();
            if (primaryKey != null) {
                out.println("\t * ");
                out.print("\t * PRIMARY KEY");
                out.println();
            }
            if (foreignKey != null) {
                out.println("\t * <p>");
                out.println("\t * <code><pre>");
                out.print("\t * FOREIGN KEY ");
                out.println(foreignKey.getKeyColumns().toString());
                out.print("\t * REFERENCES ");
                out.print(foreignKey.getReferencedTable().getName());
                out.print(" ");
                out.println(foreignKey.getReferencedColumns().toString());
                out.println("\t * </pre></code>");
            }
        }
        this.printDeprecation(out, deprecation);
        out.println("\t */");
        if (deprecation != null) {
            out.println("\t@Deprecated");
        }
    }

    private void printDeprecation(GenerationWriter out, String deprecation) {
        if (deprecation != null) {
            out.println("\t *");
            String[] strings = deprecation.split("[\n\r]+");
            for (int i = 0; i < strings.length; ++i) {
                if (i == 0) {
                    out.println("\t * @deprecated " + strings[i]);
                    continue;
                }
                out.println("\t *             " + strings[i]);
            }
        }
    }

    private void printNoFurtherInstancesAllowedJavadoc(GenerationWriter out) {
        this.printJavadoc(out, "No further instances allowed");
    }

    private void printJavadoc(GenerationWriter out, String doc) {
        out.println("\t/**");
        out.println("\t * " + doc);
        out.println("\t */");
    }

    private void printClassJavadoc(GenerationWriter out, Definition definition) {
        this.printClassJavadoc(out, definition.getComment());
    }

    private void printClassJavadoc(GenerationWriter out, String comment) {
        this.printClassJavadoc(out, comment, null);
    }

    private void printClassJavadoc(GenerationWriter out, String comment, String deprecation) {
        out.println("/**");
        out.println(" * This class is generated by jOOQ.");
        if (comment != null && comment.length() > 0) {
            out.println(" *");
            out.println(" * " + comment);
        }
        if (deprecation != null && deprecation.length() > 0) {
            out.println(" *");
            out.println(" * @deprecated : " + deprecation);
        }
        out.println(" */");
        out.println("@javax.annotation.Generated(value    = {\"http://www.jooq.org\", \"" + DefaultGenerator.getVersion() + "\"},\n" + "                            comments = \"This class is generated by jOOQ\")");
        if (deprecation != null && deprecation.length() > 0) {
            out.println("@Deprecated");
        }
        out.printSuppressWarningsPlaceholder();
    }

    private static String getVersion() {
        if (version == null) {
            try {
                InputStream stream = DefaultGenerator.class.getResourceAsStream("/org/jooq/util/generator.properties");
                Properties properties = new Properties();
                properties.load(stream);
                version = properties.getProperty("version");
            }
            catch (Exception e) {
                version = "2.0.0";
            }
        }
        return version;
    }

    private void printHeader(GenerationWriter out, String packageName) {
        out.println("/**");
        out.println(" * This class is generated by jOOQ");
        out.println(" */");
        out.println("package " + packageName + ";");
        out.println();
    }

    private void printExtendsNumberType(GenerationWriter out, DataTypeDefinition type) throws SQLException {
        this.printNumberType(out, type, "? extends ");
    }

    private void printNumberType(GenerationWriter out, DataTypeDefinition type) throws SQLException {
        this.printNumberType(out, type, "");
    }

    private void printNumberType(GenerationWriter out, DataTypeDefinition type, String prefix) throws SQLException {
        if (type.isGenericNumberType()) {
            out.print(prefix);
            out.print(Number.class);
        } else {
            out.print(this.getJavaType(type));
        }
    }

    private String getSimpleJavaType(DataTypeDefinition type) throws SQLException {
        return GenerationUtil.getSimpleJavaType(this.getJavaType(type));
    }

    private String getJavaTypeReference(Database db, DataTypeDefinition type) throws SQLException {
        if (type instanceof MasterDataTypeDefinition) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getJavaTypeReference(db, ((MasterDataTypeDefinition)type).underlying));
            sb.append(".asMasterDataType(");
            sb.append(this.getJavaType(type));
            sb.append(".class)");
            return sb.toString();
        }
        if (db.isArrayType(type.getType())) {
            String baseType = GenerationUtil.getArrayBaseType(db.getDialect(), type.getType(), type.getUserType());
            return this.getTypeReference(db, baseType, 0, 0, baseType) + ".getArrayDataType()";
        }
        return this.getTypeReference(db, type.getType(), type.getPrecision(), type.getScale(), type.getUserType());
    }

    private String getJavaType(DataTypeDefinition type) throws SQLException {
        if (type instanceof MasterDataTypeDefinition) {
            return this.strategy.getFullJavaClassName((Definition)((MasterDataTypeDefinition)type).table);
        }
        return this.getType(type.getDatabase(), type.getType(), type.getPrecision(), type.getScale(), type.getUserType(), Object.class.getName());
    }

    private String getType(Database db, String t, int p, int s, String u, String defaultType) throws SQLException {
        String type;
        block12: {
            type = defaultType;
            if (db.isArrayType(t)) {
                String baseType = GenerationUtil.getArrayBaseType(db.getDialect(), t, u);
                type = this.getType(db, baseType, p, s, baseType, defaultType) + "[]";
            } else if (db.getArray(u) != null) {
                type = this.strategy.getFullJavaClassName((Definition)db.getArray(u), "Record");
            } else if (db.getEnum(u) != null) {
                type = this.strategy.getFullJavaClassName((Definition)db.getEnum(u));
            } else if (db.getUDT(u) != null) {
                type = this.strategy.getFullJavaClassName((Definition)db.getUDT(u), "Record");
            } else {
                try {
                    Class clazz = FieldTypeHelper.getDialectJavaType((SQLDialect)db.getDialect(), (String)t, (int)p, (int)s);
                    type = clazz.getCanonicalName();
                    if (clazz.getTypeParameters().length > 0) {
                        type = type + "<";
                        String separator = "";
                        for (TypeVariable var : clazz.getTypeParameters()) {
                            type = type + separator;
                            type = type + ((Class)var.getBounds()[0]).getCanonicalName();
                            separator = ", ";
                        }
                        type = type + ">";
                    }
                }
                catch (SQLDialectNotSupportedException e) {
                    if (defaultType != null) break block12;
                    throw e;
                }
            }
        }
        return type;
    }

    private String getTypeReference(Database db, String t, int p, int s, String u) throws SQLException {
        StringBuilder sb = new StringBuilder();
        if (db.getArray(u) != null) {
            ArrayDefinition array = db.getArray(u);
            sb.append(this.getJavaTypeReference(db, array.getElementType()));
            sb.append(".asArrayDataType(");
            sb.append(this.strategy.getFullJavaClassName((Definition)array, "Record"));
            sb.append(".class)");
        } else if (db.getUDT(u) != null) {
            UDTDefinition udt = db.getUDT(u);
            sb.append(this.strategy.getFullJavaIdentifierUC((Definition)udt));
            sb.append(".getDataType()");
        } else if (db.getEnum(u) != null) {
            sb.append("org.jooq.util.");
            sb.append(db.getDialect().getName().toLowerCase());
            sb.append(".");
            sb.append(db.getDialect().getName());
            sb.append("DataType.");
            sb.append(FieldTypeHelper.normalise((String)FieldTypeHelper.getDataType((SQLDialect)db.getDialect(), String.class).getTypeName()));
            sb.append(".asEnumDataType(");
            sb.append(this.strategy.getFullJavaClassName((Definition)db.getEnum(u)));
            sb.append(".class)");
        } else {
            DataType dataType = null;
            try {
                dataType = FieldTypeHelper.getDialectDataType((SQLDialect)db.getDialect(), (String)t, (int)p, (int)s);
            }
            catch (SQLDialectNotSupportedException ignore) {
                // empty catch block
            }
            if (dataType != null && dataType.getSQLDataType() != null) {
                SQLDataType sqlDataType = dataType.getSQLDataType();
                sb.append(SQLDataType.class.getCanonicalName());
                sb.append(".");
                sb.append(FieldTypeHelper.normalise((String)sqlDataType.getTypeName()));
            } else {
                sb.append("org.jooq.util.");
                sb.append(db.getDialect().getName().toLowerCase());
                sb.append(".");
                sb.append(db.getDialect().getName());
                sb.append("DataType.");
                try {
                    String type1 = this.getType(db, t, p, s, u, null);
                    String type2 = this.getType(db, t, 0, 0, u, null);
                    sb.append(FieldTypeHelper.normalise((String)t));
                    if (!type1.equals(type2)) {
                        Class clazz = FieldTypeHelper.getDialectJavaType((SQLDialect)db.getDialect(), (String)t, (int)p, (int)s);
                        sb.append(".asNumberDataType(");
                        sb.append(clazz.getCanonicalName());
                        sb.append(".class)");
                    }
                }
                catch (SQLDialectNotSupportedException e) {
                    sb.append("getDefaultDataType(\"");
                    sb.append(t);
                    sb.append("\")");
                }
            }
        }
        return sb.toString();
    }

    private boolean match(DataTypeDefinition type1, DataTypeDefinition type2) throws SQLException {
        return this.getJavaType(type1).equals(this.getJavaType(type2));
    }
}

