/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.sqlite;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.util.AbstractTableDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultColumnDefinition;
import org.jooq.util.DefaultDataTypeDefinition;

public class SQLiteTableDefinition
extends AbstractTableDefinition {
    public SQLiteTableDefinition(Database database, String name, String comment) {
        super(database, name, comment);
    }

    @Override
    public List<ColumnDefinition> getColumns0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        PreparedStatement stmt = this.getConnection().prepareStatement("pragma table_info('" + this.getName() + "')");
        ResultSet rs = stmt.executeQuery();
        int position = 0;
        while (rs.next()) {
            String name = rs.getString("name");
            String dataType = rs.getString("type").replaceAll("\\(\\d+\\)", "");
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), dataType);
            DefaultColumnDefinition column = new DefaultColumnDefinition(this.getDatabase(), this.getName(), name, ++position, type, null);
            result.add(column);
        }
        rs.close();
        stmt.close();
        return result;
    }
}

