/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.sqlite;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.TableLike;
import org.jooq.impl.Factory;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.EnumDefinition;
import org.jooq.util.FunctionDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.ProcedureDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.sqlite.SQLiteFactory;
import org.jooq.util.sqlite.SQLiteTableDefinition;
import org.jooq.util.sqlite.sqlite_master.SQLiteMaster;

public class SQLiteDatabase
extends AbstractDatabase {
    @Override
    public Factory create() {
        return new SQLiteFactory(this.getConnection());
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations) throws SQLException {
        for (String tableName : this.create().select(new Field[]{SQLiteMaster.NAME}).from(new TableLike[]{SQLiteMaster.SQLITE_MASTER}).where(new Condition[]{SQLiteMaster.TYPE.in((Object[])new String[]{"table"})}).orderBy(new Field[]{SQLiteMaster.NAME}).fetch(SQLiteMaster.NAME)) {
            PreparedStatement stmt = this.getConnection().prepareStatement("pragma table_info('" + tableName + "')");
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                if (!rs.getBoolean("pk")) continue;
                String columnName = rs.getString("name");
                String key = "pk_" + tableName + "_" + columnName;
                TableDefinition table = this.getTable(tableName);
                if (table == null) continue;
                ColumnDefinition column = table.getColumn(columnName);
                relations.addPrimaryKey(key, column);
            }
            rs.close();
            stmt.close();
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations r) throws SQLException {
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations) throws SQLException {
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (String name : this.create().select(new Field[]{SQLiteMaster.NAME}).from(new TableLike[]{SQLiteMaster.SQLITE_MASTER}).where(new Condition[]{SQLiteMaster.TYPE.in((Object[])new String[]{"table", "view"})}).orderBy(new Field[]{SQLiteMaster.NAME}).fetch(SQLiteMaster.NAME)) {
            SQLiteTableDefinition table = new SQLiteTableDefinition(this, name, "");
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<ProcedureDefinition> getProcedures0() throws SQLException {
        ArrayList<ProcedureDefinition> result = new ArrayList<ProcedureDefinition>();
        return result;
    }

    @Override
    protected List<FunctionDefinition> getFunctions0() throws SQLException {
        ArrayList<FunctionDefinition> result = new ArrayList<FunctionDefinition>();
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }
}

