/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.mysql;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.impl.Factory;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultEnumDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.EnumDefinition;
import org.jooq.util.FunctionDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.ProcedureDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.mysql.MySQLFactory;
import org.jooq.util.mysql.MySQLFunctionDefinition;
import org.jooq.util.mysql.MySQLProcedureDefinition;
import org.jooq.util.mysql.MySQLTableDefinition;
import org.jooq.util.mysql.information_schema.tables.Columns;
import org.jooq.util.mysql.information_schema.tables.KeyColumnUsage;
import org.jooq.util.mysql.information_schema.tables.ReferentialConstraints;
import org.jooq.util.mysql.information_schema.tables.TableConstraints;
import org.jooq.util.mysql.information_schema.tables.Tables;
import org.jooq.util.mysql.mysql.enums.ProcType;
import org.jooq.util.mysql.mysql.tables.Proc;

public class MySQLDatabase
extends AbstractDatabase {
    @Override
    protected void loadPrimaryKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("PRIMARY KEY")) {
            String constraintName = (String)record.getValue(KeyColumnUsage.CONSTRAINT_NAME);
            String tableName = (String)record.getValue(KeyColumnUsage.TABLE_NAME);
            String columnName = (String)record.getValue(KeyColumnUsage.COLUMN_NAME);
            String key = this.getKeyName(tableName, constraintName);
            TableDefinition table = this.getTable(tableName);
            if (table == null) continue;
            relations.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("UNIQUE")) {
            String constraintName = (String)record.getValue(KeyColumnUsage.CONSTRAINT_NAME);
            String tableName = (String)record.getValue(KeyColumnUsage.TABLE_NAME);
            String columnName = (String)record.getValue(KeyColumnUsage.COLUMN_NAME);
            String key = this.getKeyName(tableName, constraintName);
            TableDefinition table = this.getTable(tableName);
            if (table == null) continue;
            relations.addUniqueKey(key, table.getColumn(columnName));
        }
    }

    private String getKeyName(String tableName, String keyName) {
        return "KEY_" + tableName + "_" + keyName;
    }

    private List<Record> fetchKeys(String constraintType) throws SQLException {
        return this.create().select(new Field[]{KeyColumnUsage.CONSTRAINT_NAME, KeyColumnUsage.TABLE_NAME, KeyColumnUsage.COLUMN_NAME}).from(new TableLike[]{KeyColumnUsage.KEY_COLUMN_USAGE}).join((TableLike)TableConstraints.TABLE_CONSTRAINTS).on(new Condition[]{KeyColumnUsage.TABLE_SCHEMA.equal(TableConstraints.TABLE_SCHEMA)}).and(KeyColumnUsage.TABLE_NAME.equal(TableConstraints.TABLE_NAME)).and(KeyColumnUsage.CONSTRAINT_NAME.equal(TableConstraints.CONSTRAINT_NAME)).where(new Condition[]{TableConstraints.CONSTRAINT_TYPE.equal((Object)constraintType)}).and(KeyColumnUsage.TABLE_SCHEMA.equal((Object)this.getSchemaName())).orderBy(new SortField[]{KeyColumnUsage.TABLE_NAME.ascending(), KeyColumnUsage.ORDINAL_POSITION.ascending()}).fetch().getRecords();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.create().select(new Field[]{ReferentialConstraints.CONSTRAINT_NAME, ReferentialConstraints.TABLE_NAME, ReferentialConstraints.REFERENCED_TABLE_NAME, ReferentialConstraints.UNIQUE_CONSTRAINT_NAME, KeyColumnUsage.COLUMN_NAME}).from(new TableLike[]{ReferentialConstraints.REFERENTIAL_CONSTRAINTS}).join((TableLike)KeyColumnUsage.KEY_COLUMN_USAGE).on(new Condition[]{ReferentialConstraints.CONSTRAINT_SCHEMA.equal(KeyColumnUsage.CONSTRAINT_SCHEMA)}).and(ReferentialConstraints.CONSTRAINT_NAME.equal(KeyColumnUsage.CONSTRAINT_NAME)).where(new Condition[]{ReferentialConstraints.CONSTRAINT_SCHEMA.equal((Object)this.getSchemaName())}).orderBy(new SortField[]{KeyColumnUsage.CONSTRAINT_NAME.ascending(), KeyColumnUsage.ORDINAL_POSITION.ascending()}).fetch()) {
            String foreignKey = (String)record.getValue(ReferentialConstraints.CONSTRAINT_NAME);
            String foreignKeyColumn = (String)record.getValue(KeyColumnUsage.COLUMN_NAME);
            String foreignKeyTableName = (String)record.getValue(ReferentialConstraints.TABLE_NAME);
            String referencedKey = (String)record.getValue(ReferentialConstraints.UNIQUE_CONSTRAINT_NAME);
            String referencedTableName = (String)record.getValue(ReferentialConstraints.REFERENCED_TABLE_NAME);
            TableDefinition foreignKeyTable = this.getTable(foreignKeyTableName);
            if (foreignKeyTable == null) continue;
            ColumnDefinition column = foreignKeyTable.getColumn(foreignKeyColumn);
            String key = this.getKeyName(referencedTableName, referencedKey);
            relations.addForeignKey(foreignKey, key, column);
        }
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(new Field[]{Tables.TABLE_NAME, Tables.TABLE_COMMENT}).from(new TableLike[]{Tables.TABLES}).where(new Condition[]{Tables.TABLE_SCHEMA.equal((Object)this.getSchemaName())}).orderBy(new Field[]{Tables.TABLE_NAME}).fetch()) {
            String name = (String)record.getValue(Tables.TABLE_NAME);
            String comment = (String)record.getValue(Tables.TABLE_COMMENT);
            MySQLTableDefinition table = new MySQLTableDefinition(this, name, comment);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        Result records = this.create().select(new Field[]{Columns.COLUMN_COMMENT, Columns.TABLE_NAME, Columns.COLUMN_NAME, Columns.COLUMN_TYPE}).from(new TableLike[]{Columns.COLUMNS}).where(new Condition[]{Columns.COLUMN_TYPE.like((Object)"enum(%)").and(Columns.TABLE_SCHEMA.equal((Object)this.getSchemaName()))}).orderBy(new SortField[]{Columns.TABLE_NAME.ascending(), Columns.COLUMN_NAME.ascending()}).fetch();
        for (Record record : records) {
            String comment = (String)record.getValue(Columns.COLUMN_COMMENT);
            String table = (String)record.getValue(Columns.TABLE_NAME);
            String column = (String)record.getValue(Columns.COLUMN_NAME);
            String name = table + "_" + column;
            String columnType = (String)record.getValue(Columns.COLUMN_TYPE);
            DefaultEnumDefinition definition = new DefaultEnumDefinition(this, name, comment);
            for (String string : columnType.replaceAll("enum\\(|\\)", "").split(",")) {
                definition.addLiteral(string.trim().replaceAll("'", ""));
            }
            result.add(definition);
        }
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<ProcedureDefinition> getProcedures0() throws SQLException {
        ArrayList<ProcedureDefinition> result = new ArrayList<ProcedureDefinition>();
        for (Record record : this.executeProcedureQuery(ProcType.PROCEDURE)) {
            String name = (String)record.getValue(Proc.NAME);
            String comment = (String)record.getValue(Proc.COMMENT);
            String params = new String((byte[])record.getValue(Proc.PARAM_LIST));
            MySQLProcedureDefinition procedure = new MySQLProcedureDefinition(this, name, comment, params);
            result.add(procedure);
        }
        return result;
    }

    @Override
    protected List<FunctionDefinition> getFunctions0() throws SQLException {
        ArrayList<FunctionDefinition> result = new ArrayList<FunctionDefinition>();
        for (Record record : this.executeProcedureQuery(ProcType.FUNCTION)) {
            String name = (String)record.getValue(Proc.NAME);
            String comment = (String)record.getValue(Proc.COMMENT);
            String params = new String((byte[])record.getValue(Proc.PARAM_LIST));
            String returnValue = new String((byte[])record.getValue(Proc.RETURNS));
            MySQLFunctionDefinition function = new MySQLFunctionDefinition((Database)this, name, comment, params, returnValue);
            result.add(function);
        }
        return result;
    }

    private Result<Record> executeProcedureQuery(ProcType type) throws SQLException {
        return this.create().select(new Field[]{Proc.NAME, Proc.COMMENT, Proc.PARAM_LIST, Proc.RETURNS}).from(new TableLike[]{Proc.PROC}).where(new Condition[]{Proc.DB.equal((Object)this.getSchemaName())}).and(Proc.TYPE.equal((Object)type)).fetch();
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    public Factory create() {
        return new MySQLFactory(this.getConnection());
    }
}

