/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.h2;

import java.sql.SQLException;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.util.AbstractFunctionDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultColumnDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.h2.H2DataType;
import org.jooq.util.h2.information_schema.tables.FunctionColumns;

public class H2FunctionDefinition
extends AbstractFunctionDefinition {
    public H2FunctionDefinition(Database database, String name, String comment, String typeName) {
        super(database, null, name, comment, null);
        DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), typeName);
        this.returnValue = new DefaultColumnDefinition(this.getDatabase(), this.getName(), "RETURN_VALUE", -1, type, null);
    }

    @Override
    protected void init0() throws SQLException {
        Result result = this.create().select(new Field[]{FunctionColumns.COLUMN_NAME, FunctionColumns.TYPE_NAME, FunctionColumns.POS}).from(new TableLike[]{FunctionColumns.FUNCTION_COLUMNS}).where(new Condition[]{FunctionColumns.ALIAS_SCHEMA.equal((Object)this.getSchemaName())}).and(FunctionColumns.ALIAS_NAME.equal((Object)this.getName())).orderBy(new SortField[]{FunctionColumns.POS.ascending()}).fetch();
        for (Record record : result) {
            String paramName = (String)record.getValue(FunctionColumns.COLUMN_NAME);
            String typeName = (String)record.getValue(FunctionColumns.TYPE_NAME);
            int position = (Integer)record.getValue(FunctionColumns.POS);
            if (position == 0 && H2DataType.OTHER.getTypeName().equalsIgnoreCase(typeName)) continue;
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), typeName);
            DefaultColumnDefinition column = new DefaultColumnDefinition(this.getDatabase(), this.getName(), paramName, position, type, null);
            this.inParameters.add(column);
        }
    }
}

