/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.derby;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.TableLike;
import org.jooq.impl.Factory;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.FunctionDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.ProcedureDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.derby.DerbyTableDefinition;
import org.jooq.util.derby.sys.SysFactory;
import org.jooq.util.derby.sys.tables.Sysconglomerates;
import org.jooq.util.derby.sys.tables.Sysconstraints;
import org.jooq.util.derby.sys.tables.Syskeys;
import org.jooq.util.derby.sys.tables.Sysschemas;
import org.jooq.util.derby.sys.tables.Syssequences;
import org.jooq.util.derby.sys.tables.Systables;

public class DerbyDatabase
extends AbstractDatabase {
    @Override
    protected void loadPrimaryKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("P")) {
            String key = (String)record.getValue(Sysconstraints.CONSTRAINTNAME);
            String tableName = (String)record.getValue(Systables.TABLENAME);
            String descriptor = record.getValueAsString(Sysconglomerates.DESCRIPTOR);
            TableDefinition table = this.getTable(tableName);
            if (table == null) continue;
            for (int index : this.decode(descriptor)) {
                relations.addPrimaryKey(key, table.getColumn(index));
            }
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("U")) {
            String key = (String)record.getValue(Sysconstraints.CONSTRAINTNAME);
            String tableName = (String)record.getValue(Systables.TABLENAME);
            String descriptor = record.getValueAsString(Sysconglomerates.DESCRIPTOR);
            TableDefinition table = this.getTable(tableName);
            if (table == null) continue;
            for (int index : this.decode(descriptor)) {
                relations.addUniqueKey(key, table.getColumn(index));
            }
        }
    }

    private List<Record> fetchKeys(String constraintType) throws SQLException {
        return this.create().select(new Field[]{Systables.TABLENAME, Systables.TABLEID, Sysconstraints.CONSTRAINTNAME, Sysconglomerates.DESCRIPTOR}).from(new TableLike[]{Sysconglomerates.SYSCONGLOMERATES}).join((TableLike)Syskeys.SYSKEYS).on(new Condition[]{Syskeys.CONGLOMERATEID.equal(Sysconglomerates.CONGLOMERATEID)}).join((TableLike)Sysconstraints.SYSCONSTRAINTS).on(new Condition[]{Sysconstraints.CONSTRAINTID.equal(Syskeys.CONSTRAINTID)}).join((TableLike)Systables.SYSTABLES).on(new Condition[]{Systables.TABLEID.equal(Sysconglomerates.TABLEID)}).where(new Condition[]{Sysconstraints.TYPE.equal((Object)constraintType)}).fetch().getRecords();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations) throws SQLException {
        Field foreignKey = this.create().plainSQLField("fg.conglomeratename", String.class);
        Field foreignKeyTable = this.create().plainSQLField("ft.tablename", String.class);
        Field foreignKeyDescriptor = this.create().plainSQLField("fg.descriptor");
        Field uniqueKey = this.create().plainSQLField("pg.conglomeratename", String.class);
        for (Record record : this.create().select(new Field[]{foreignKey, foreignKeyTable, foreignKeyDescriptor, uniqueKey}).from("sys.sysconstraints fc").join("sys.sysforeignkeys f").on("f.constraintid = fc.constraintid").join("sys.sysconglomerates fg").on("fg.conglomerateid = f.conglomerateid").join("sys.systables ft").on("ft.tableid = fg.tableid").join("sys.syskeys pk").on("pk.constraintid = f.keyconstraintid").join("sys.sysconglomerates pg").on("pg.conglomerateid = pk.conglomerateid").join("sys.systables pt").on("pt.tableid = pg.tableid").where("fc.type = 'F'").fetch()) {
            String foreignKeyName = (String)record.getValue(foreignKey);
            String foreignKeyTableName = (String)record.getValue(foreignKeyTable);
            List<Integer> foreignKeyIndexes = this.decode(record.getValueAsString(foreignKeyDescriptor));
            String uniqueKeyName = (String)record.getValue(uniqueKey);
            TableDefinition referencingTable = this.getTable(foreignKeyTableName);
            if (referencingTable == null) continue;
            for (int i = 0; i < foreignKeyIndexes.size(); ++i) {
                ColumnDefinition column = referencingTable.getColumn(foreignKeyIndexes.get(i));
                relations.addForeignKey(foreignKeyName, uniqueKeyName, column);
            }
        }
    }

    private List<Integer> decode(String descriptor) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Pattern p = Pattern.compile(".*?\\((.*?)\\)");
        Matcher m = p.matcher(descriptor);
        while (m.find()) {
            String[] split = m.group(1).split(",");
            if (split == null) continue;
            for (String index : split) {
                result.add(Integer.valueOf(index.trim()) - 1);
            }
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (String name : this.create().select(new Field[]{Syssequences.SEQUENCENAME}).from(new TableLike[]{Syssequences.SYSSEQUENCES}).join((TableLike)Sysschemas.SYSSCHEMAS).on(new Condition[]{Sysschemas.SCHEMAID.equal(Syssequences.SCHEMAID)}).where(new Condition[]{Sysschemas.SCHEMANAME.equal((Object)this.getSchemaName())}).orderBy(new Field[]{Syssequences.SEQUENCENAME}).fetch(Syssequences.SEQUENCENAME)) {
            result.add(new DefaultSequenceDefinition(this, name));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(new Field[]{Systables.TABLENAME, Systables.TABLEID}).from(new TableLike[]{Systables.SYSTABLES}).join((TableLike)Sysschemas.SYSSCHEMAS).on(new Condition[]{Systables.SCHEMAID.equal(Sysschemas.SCHEMAID)}).where(new Condition[]{Sysschemas.SCHEMANAME.equal((Object)this.getSchemaName())}).fetch()) {
            String name = (String)record.getValue(Systables.TABLENAME);
            String id = (String)record.getValue(Systables.TABLEID);
            DerbyTableDefinition table = new DerbyTableDefinition(this, name, id);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<ProcedureDefinition> getProcedures0() throws SQLException {
        ArrayList<ProcedureDefinition> result = new ArrayList<ProcedureDefinition>();
        return result;
    }

    @Override
    protected List<FunctionDefinition> getFunctions0() throws SQLException {
        ArrayList<FunctionDefinition> result = new ArrayList<FunctionDefinition>();
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    public Factory create() {
        return new SysFactory(this.getConnection());
    }
}

