/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.db2;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectQuery;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.impl.Factory;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.FunctionDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.ProcedureDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.db2.DB2FunctionDefinition;
import org.jooq.util.db2.DB2ProcedureDefinition;
import org.jooq.util.db2.DB2TableDefinition;
import org.jooq.util.db2.DB2UDTDefinition;
import org.jooq.util.db2.syscat.SyscatFactory;
import org.jooq.util.db2.syscat.tables.Datatypes;
import org.jooq.util.db2.syscat.tables.Funcparms;
import org.jooq.util.db2.syscat.tables.Functions;
import org.jooq.util.db2.syscat.tables.Keycoluse;
import org.jooq.util.db2.syscat.tables.Procedures;
import org.jooq.util.db2.syscat.tables.References;
import org.jooq.util.db2.syscat.tables.Sequences;
import org.jooq.util.db2.syscat.tables.Tabconst;
import org.jooq.util.db2.syscat.tables.Tables;

public class DB2Database
extends AbstractDatabase {
    @Override
    public Factory create() {
        return new SyscatFactory(this.getConnection());
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("P")) {
            String key = (String)record.getValue(Keycoluse.CONSTNAME);
            String tableName = (String)record.getValue(Keycoluse.TABNAME);
            String columnName = (String)record.getValue(Keycoluse.COLNAME);
            TableDefinition table = this.getTable(tableName);
            if (table == null) continue;
            relations.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.fetchKeys("U")) {
            String key = (String)record.getValue(Keycoluse.CONSTNAME);
            String tableName = (String)record.getValue(Keycoluse.TABNAME);
            String columnName = (String)record.getValue(Keycoluse.COLNAME);
            TableDefinition table = this.getTable(tableName);
            if (table == null) continue;
            relations.addUniqueKey(key, table.getColumn(columnName));
        }
    }

    private List<Record> fetchKeys(String constraintType) throws SQLException {
        return this.create().select(new Field[]{Keycoluse.CONSTNAME, Keycoluse.TABNAME, Keycoluse.COLNAME}).from(new TableLike[]{Keycoluse.KEYCOLUSE}).join((TableLike)Tabconst.TABCONST).on(new Condition[]{Keycoluse.TABSCHEMA.equal(Tabconst.TABSCHEMA)}).and(Keycoluse.CONSTNAME.equal(Tabconst.CONSTNAME)).where(new Condition[]{Keycoluse.TABSCHEMA.equal((Object)this.getSchemaName())}).and(Tabconst.TYPE.equal((Object)constraintType)).orderBy(new SortField[]{Keycoluse.CONSTNAME.ascending(), Keycoluse.COLSEQ.ascending()}).fetch().getRecords();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations) throws SQLException {
        for (Record record : this.create().select(new Field[]{References.CONSTNAME, References.TABNAME, References.FK_COLNAMES, References.REFKEYNAME}).from(new TableLike[]{References.REFERENCES}).where(new Condition[]{References.TABSCHEMA.equal((Object)this.getSchemaName())}).fetch()) {
            String foreignKey = (String)record.getValue(References.CONSTNAME);
            String foreignKeyTableName = (String)record.getValue(References.TABNAME);
            String foreignKeyColumn = (String)record.getValue(References.FK_COLNAMES);
            String uniqueKey = (String)record.getValue(References.REFKEYNAME);
            TableDefinition foreignKeyTable = this.getTable(foreignKeyTableName);
            if (foreignKeyTable == null) continue;
            String[] referencingColumnNames = foreignKeyColumn.trim().split("[ ]+");
            for (int i = 0; i < referencingColumnNames.length; ++i) {
                ColumnDefinition column = foreignKeyTable.getColumn(referencingColumnNames[i]);
                relations.addForeignKey(foreignKey, uniqueKey, column);
            }
        }
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (String name : this.create().select(new Field[]{Sequences.SEQNAME}).from(new TableLike[]{Sequences.SEQUENCES}).where(new Condition[]{Sequences.SEQSCHEMA.equal((Object)this.getSchemaName())}).orderBy(new Field[]{Sequences.SEQNAME}).fetch(Sequences.SEQNAME)) {
            result.add(new DefaultSequenceDefinition(this, name));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        SelectQuery q = this.create().selectQuery();
        q.addFrom(new TableLike[]{Tables.TABLES});
        q.addSelect(new Field[]{Tables.TABNAME});
        q.addConditions(new Condition[]{Tables.TABSCHEMA.equal((Object)this.getSchemaName())});
        q.addConditions(new Condition[]{Tables.TYPE.in((Object[])new String[]{"T", "V"})});
        q.addOrderBy(new Field[]{Tables.TABNAME});
        q.execute();
        for (Record record : q.getResult()) {
            String name = (String)record.getValue(Tables.TABNAME);
            String comment = "";
            DB2TableDefinition table = new DB2TableDefinition(this, name, comment);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<ProcedureDefinition> getProcedures0() throws SQLException {
        ArrayList<ProcedureDefinition> result = new ArrayList<ProcedureDefinition>();
        for (Record record : this.create().select(new Field[]{Procedures.PROCNAME}).from(new TableLike[]{Procedures.PROCEDURES}).where(new Condition[]{Procedures.PROCSCHEMA.equal((Object)this.getSchemaName())}).orderBy(new Field[]{Procedures.PROCNAME}).fetch()) {
            String name = (String)record.getValue(Procedures.PROCNAME);
            result.add(new DB2ProcedureDefinition((Database)this, null, name));
        }
        return result;
    }

    @Override
    protected List<FunctionDefinition> getFunctions0() throws SQLException {
        HashMap<String, DB2FunctionDefinition> functionMap = new HashMap<String, DB2FunctionDefinition>();
        SelectQuery q = this.create().selectQuery();
        q.addFrom(new TableLike[]{Funcparms.FUNCPARMS});
        q.addJoin((TableLike)Functions.FUNCTIONS, new Condition[]{Funcparms.FUNCSCHEMA.equal(Functions.FUNCSCHEMA), Funcparms.FUNCNAME.equal(Functions.FUNCNAME)});
        q.addConditions(new Condition[]{Funcparms.FUNCSCHEMA.equal((Object)this.getSchemaName())});
        q.addConditions(new Condition[]{Functions.ORIGIN.equal((Object)"Q")});
        q.addOrderBy(new Field[]{Funcparms.FUNCNAME});
        q.addOrderBy(new Field[]{Funcparms.ORDINAL});
        q.execute();
        for (Record record : q.getResult()) {
            String name = (String)record.getValue(Funcparms.FUNCNAME);
            String rowType = (String)record.getValue(Funcparms.ROWTYPE);
            String dataType = (String)record.getValue(Funcparms.TYPENAME);
            short position = (Short)record.getValue(Funcparms.ORDINAL);
            String paramName = (String)record.getValue(Funcparms.PARMNAME);
            DB2FunctionDefinition function = (DB2FunctionDefinition)functionMap.get(name);
            if (function == null) {
                function = new DB2FunctionDefinition((Database)this, null, name, null);
                functionMap.put(name, function);
            }
            if ("C".equals(rowType)) {
                function.setReturnValue(dataType);
                continue;
            }
            if (!"P".equals(rowType)) continue;
            function.addParameter(paramName, position, dataType);
        }
        return new ArrayList<FunctionDefinition>(functionMap.values());
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        for (String name : this.create().selectDistinct(new Field[]{Datatypes.TYPENAME}).from(new TableLike[]{Datatypes.DATATYPES}).where(new Condition[]{Datatypes.TYPESCHEMA.equal((Object)this.getSchemaName())}).orderBy(new Field[]{Datatypes.TYPENAME}).fetch(Datatypes.TYPENAME)) {
            result.add(new DB2UDTDefinition(this, name, null));
        }
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }
}

