/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jooq.impl.JooqLogger;
import org.jooq.util.AbstractDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultForeignKeyDefinition;
import org.jooq.util.DefaultUniqueKeyDefinition;
import org.jooq.util.ForeignKeyDefinition;
import org.jooq.util.Relations;
import org.jooq.util.UniqueKeyDefinition;

public class DefaultRelations
extends AbstractDefinition
implements Relations {
    private static final JooqLogger log = JooqLogger.getLogger(DefaultRelations.class);
    private Map<String, ForeignKeyDefinition> foreignKeys = new LinkedHashMap<String, ForeignKeyDefinition>();
    private Map<String, UniqueKeyDefinition> primaryKeys = new LinkedHashMap<String, UniqueKeyDefinition>();
    private Map<String, UniqueKeyDefinition> uniqueKeys = new LinkedHashMap<String, UniqueKeyDefinition>();
    private Map<ColumnDefinition, ForeignKeyDefinition> foreignKeysByColumn = new LinkedHashMap<ColumnDefinition, ForeignKeyDefinition>();
    private Map<ColumnDefinition, UniqueKeyDefinition> primaryKeysByColumn = new LinkedHashMap<ColumnDefinition, UniqueKeyDefinition>();
    private Map<ColumnDefinition, List<UniqueKeyDefinition>> uniqueKeysByColumn = new LinkedHashMap<ColumnDefinition, List<UniqueKeyDefinition>>();

    public DefaultRelations(Database database) {
        super(database, "", "");
    }

    public void addPrimaryKey(String keyName, ColumnDefinition column) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding primary key", (Object)(keyName + " (" + column + ")"));
        }
        UniqueKeyDefinition key = this.getUniqueKey(keyName, column, true);
        key.getKeyColumns().add(column);
    }

    public void addUniqueKey(String keyName, ColumnDefinition column) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding unique key", (Object)(keyName + " (" + column + ")"));
        }
        UniqueKeyDefinition key = this.getUniqueKey(keyName, column, false);
        key.getKeyColumns().add(column);
    }

    private UniqueKeyDefinition getUniqueKey(String keyName, ColumnDefinition column, boolean isPK) {
        UniqueKeyDefinition key = this.uniqueKeys.get(keyName);
        if (key == null) {
            key = new DefaultUniqueKeyDefinition(this.getDatabase(), keyName, this.getDatabase().getTable(column.getTableName()));
            this.uniqueKeys.put(keyName, key);
            if (isPK) {
                this.primaryKeys.put(keyName, key);
            }
        }
        return key;
    }

    public void addForeignKey(String foreignKeyName, String uniqueKeyName, ColumnDefinition column) {
        UniqueKeyDefinition uniqueKey;
        ForeignKeyDefinition foreignKey;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding foreign key", (Object)(foreignKeyName + " (" + column + ") referencing " + uniqueKeyName));
        }
        if ((foreignKey = this.foreignKeys.get(foreignKeyName)) == null && (uniqueKey = this.uniqueKeys.get(uniqueKeyName)) != null) {
            foreignKey = new DefaultForeignKeyDefinition(this.getDatabase(), foreignKeyName, this.getDatabase().getTable(column.getTableName()), uniqueKey);
            this.foreignKeys.put(foreignKeyName, foreignKey);
            uniqueKey.getForeignKeys().add(foreignKey);
        }
        if (foreignKey != null) {
            foreignKey.getKeyColumns().add(column);
        }
    }

    @Override
    public UniqueKeyDefinition getPrimaryKey(ColumnDefinition column) {
        if (!this.primaryKeysByColumn.containsKey(column)) {
            UniqueKeyDefinition key = null;
            for (UniqueKeyDefinition primaryKey : this.primaryKeys.values()) {
                if (!primaryKey.getKeyColumns().contains(column)) continue;
                key = primaryKey;
                break;
            }
            this.primaryKeysByColumn.put(column, key);
        }
        return this.primaryKeysByColumn.get(column);
    }

    @Override
    public List<UniqueKeyDefinition> getUniqueKeys(ColumnDefinition column) {
        if (!this.uniqueKeysByColumn.containsKey(column)) {
            ArrayList<UniqueKeyDefinition> list = new ArrayList<UniqueKeyDefinition>();
            for (UniqueKeyDefinition uniqueKey : this.uniqueKeys.values()) {
                if (!uniqueKey.getKeyColumns().contains(column)) continue;
                list.add(uniqueKey);
            }
            this.uniqueKeysByColumn.put(column, list);
        }
        return this.uniqueKeysByColumn.get(column);
    }

    @Override
    public ForeignKeyDefinition getForeignKey(ColumnDefinition column) {
        if (!this.foreignKeysByColumn.containsKey(column)) {
            ForeignKeyDefinition key = null;
            for (ForeignKeyDefinition foreignKey : this.foreignKeys.values()) {
                if (!foreignKey.getKeyColumns().contains(column)) continue;
                key = foreignKey;
                break;
            }
            this.foreignKeysByColumn.put(column, key);
        }
        return this.foreignKeysByColumn.get(column);
    }
}

