/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.impl.JooqLogger;
import org.jooq.impl.StringUtils;
import org.jooq.util.AbstractDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.TypeDefinition;

public abstract class AbstractTypeDefinition
extends AbstractDefinition
implements TypeDefinition {
    private static final JooqLogger log = JooqLogger.getLogger(AbstractTypeDefinition.class);
    private List<ColumnDefinition> columns;

    public AbstractTypeDefinition(Database database, String name, String comment) {
        super(database, name, comment);
    }

    @Override
    public final String getQualifiedName() {
        if (StringUtils.isBlank((String)this.getSchemaName())) {
            return this.getName();
        }
        return this.getSchemaName() + "." + this.getName();
    }

    @Override
    public final List<ColumnDefinition> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<ColumnDefinition>();
            try {
                this.columns = this.getColumns0();
            }
            catch (SQLException e) {
                log.error((Object)"Error while initialising type", (Throwable)e);
            }
        }
        return this.columns;
    }

    @Override
    public final ColumnDefinition getColumn(String columnName) {
        for (ColumnDefinition column : this.getColumns()) {
            if (!column.getName().equals(columnName)) continue;
            return column;
        }
        return null;
    }

    @Override
    public final ColumnDefinition getColumn(int columnIndex) {
        return this.getColumns().get(columnIndex);
    }

    protected abstract List<ColumnDefinition> getColumns0() throws SQLException;
}

