/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen.gradle;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.jooq.codegen.gradle.MetaExtensions;
import org.jooq.meta.jaxb.Configuration;
import org.jooq.meta.jaxb.Generator;
import org.jooq.meta.jaxb.Target;
import org.jooq.tools.JooqLogger;
import org.jooq.util.jaxb.tools.MiniJAXB;
import org.jooq.util.jaxb.tools.XMLAppendable;

public class NamedConfiguration {
    static final JooqLogger log = JooqLogger.getLogger(NamedConfiguration.class);
    final ObjectFactory objects;
    final ProjectLayout projectLayout;
    final String name;
    final NamedConfiguration defaultConfiguration;
    Action<MetaExtensions.ConfigurationExtension> action;
    boolean unnamed;
    private Configuration configuration;
    private DirectoryProperty outputDirectory;
    private boolean outputDirectorySet;

    @Inject
    public NamedConfiguration(ObjectFactory objects, ProjectLayout projectLayout, String name, NamedConfiguration defaultConfiguration) {
        this.objects = objects;
        this.projectLayout = projectLayout;
        this.name = name;
        this.unnamed = false;
        this.configuration = NamedConfiguration.init(new Configuration());
        this.outputDirectory = objects.directoryProperty();
        this.defaultConfiguration = defaultConfiguration == null ? this : defaultConfiguration;
    }

    static final Configuration init(Configuration configuration) {
        return configuration.withGenerator(new Generator().withTarget(new Target()));
    }

    public String getName() {
        return this.name;
    }

    DirectoryProperty getOutputDirectory() {
        this.executeAction();
        return this.outputDirectorySet ? this.outputDirectory : null;
    }

    public Configuration getConfiguration() {
        this.executeAction();
        return this.configuration;
    }

    void configuration0(Configuration configuration) {
        if (!this.unnamed) {
            this.defaultConfiguration.executeAction();
            this.configuration = (Configuration)MiniJAXB.append((Object)NamedConfiguration.copy(this.defaultConfiguration.configuration), (Object)NamedConfiguration.copy(this.configuration));
        }
        this.configuration = (Configuration)MiniJAXB.append((Object)NamedConfiguration.copy(configuration), (Object)NamedConfiguration.copy(this.configuration));
    }

    static Configuration copy(Configuration configuration) {
        return (Configuration)MiniJAXB.unmarshal((String)MiniJAXB.marshal((XMLAppendable)configuration), Configuration.class);
    }

    public void configuration(Action<MetaExtensions.ConfigurationExtension> action) {
        this.action = action;
        this.executeAction();
    }

    public void delayedConfiguration(Action<MetaExtensions.ConfigurationExtension> action) {
        log.info((Object)"Delayed configuration is an experimental feature, which is subject to change in the future. Please illustrate your use-case here to help better understand why this is needed: https://github.com/jOOQ/jOOQ/issues/16821");
        this.action = action;
    }

    void executeAction() {
        if (this.action != null) {
            MetaExtensions.ConfigurationExtension c = (MetaExtensions.ConfigurationExtension)((Object)this.objects.newInstance(MetaExtensions.ConfigurationExtension.class, new Object[]{this.objects}));
            NamedConfiguration.init(c);
            this.action.execute((Object)c);
            this.action = null;
            this.configuration0(c);
            Target target = this.configuration.getGenerator().getTarget();
            if (this.defaultTarget()) {
                target.setDirectory("build/generated-sources/jooq");
            }
            String directory = target.getDirectory();
            if (this.configuration.getBasedir() == null) {
                this.configuration.setBasedir(this.projectLayout.getProjectDirectory().getAsFile().getAbsolutePath());
            } else if (!new File(directory).isAbsolute()) {
                directory = new File(this.configuration.getBasedir(), directory).getAbsolutePath();
            }
            this.outputDirectory.value(this.projectLayout.getProjectDirectory().dir(directory));
            this.outputDirectorySet = true;
        }
    }

    private boolean defaultTarget() {
        Target target = this.configuration.getGenerator().getTarget();
        return target.getDirectory() == null || "target/generated-sources/jooq".equals(target.getDirectory());
    }

    public String toString() {
        return "NamedConfiguration [" + this.name + ", " + String.valueOf(this.configuration) + "]";
    }
}

