/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen.gradle;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.work.InputChanges;
import org.jooq.codegen.GenerationTool;
import org.jooq.codegen.gradle.NamedConfiguration;
import org.jooq.meta.jaxb.Configuration;
import org.jooq.tools.StringUtils;

@CacheableTask
public class CodegenTask
extends DefaultTask {
    final NamedConfiguration configuration;
    final FileCollection codegenClasspath;
    final ProviderFactory providers;
    final List<NamedConfiguration> named;
    final Property<Boolean> caching;

    @Inject
    public CodegenTask(NamedConfiguration configuration, FileCollection codegenClasspath, ProviderFactory providers, ObjectFactory objects) {
        this.configuration = configuration;
        this.providers = providers;
        this.codegenClasspath = codegenClasspath;
        this.named = new ArrayList<NamedConfiguration>();
        this.caching = objects.property(Boolean.class).convention((Object)true);
        this.getOutputs().cacheIf("Caching is activated only in the presence of explicit inputs and when output isn't up to date", CodegenTask::upToDate);
        this.getOutputs().upToDateWhen(task -> CodegenTask.upToDate(task));
    }

    static boolean upToDate(Task task) {
        if (task.hasProperty("caching") && Boolean.FALSE.equals(((Property)task.property("caching")).get())) {
            return false;
        }
        TaskInputs inputs = task.getInputs();
        return !inputs.getFiles().filter(f -> !f.getName().endsWith(".jar")).isEmpty() || inputs.getHasSourceFiles() || inputs.getProperties().size() > 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void execute(InputChanges changes) throws Exception {
        if (this.named.isEmpty()) {
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            URLClassLoader pluginClassLoader = this.getClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(pluginClassLoader);
                GenerationTool.generate((Configuration)this.configuration.getConfiguration());
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
    }

    @Input
    public Provider<String> getConfiguration() {
        return this.providers.provider(() -> this.configuration.getConfiguration().toString());
    }

    @Input
    public Property<Boolean> getCaching() {
        return this.caching;
    }

    @Classpath
    public FileCollection getClasspath() {
        return this.codegenClasspath;
    }

    @OutputDirectories
    public List<DirectoryProperty> getOutputDirectory() {
        if (this.named.isEmpty() && this.configuration.getOutputDirectory() != null) {
            return Arrays.asList(this.configuration.getOutputDirectory());
        }
        return Arrays.asList(new DirectoryProperty[0]);
    }

    private URLClassLoader getClassLoader() {
        ArrayList classpath = new ArrayList(this.getClasspath().getFiles());
        try {
            URL[] urls = new URL[classpath.size()];
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = ((File)classpath.get(i)).toURI().toURL();
            }
            return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new GradleException("Couldn't create a classloader.", (Throwable)e);
        }
    }

    static String taskName(NamedConfiguration configuration) {
        return "jooqCodegen" + (configuration.unnamed ? "" : StringUtils.toUC((String)configuration.name));
    }
}

