/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.frontend;

import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.NodeInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.NpmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.typesafe.config.Config;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooby.frontend.Frontend;
import org.jooby.frontend.NodeTask;

public class Npm
extends Frontend {
    private String npmVersion;

    public Npm(String nodeVersion, String npmVersion) {
        super(nodeVersion);
        this.npmVersion = npmVersion;
    }

    public Npm(String nodeVersion) {
        this(nodeVersion, "provided");
    }

    @Override
    protected void installNpm(NodeInstaller node) {
        node.setNpmVersion(this.npmVersion);
    }

    @Override
    protected NodeTask newTask(FrontendPluginFactory factory, Config conf, ProxyConfig proxy, Map<String, String> env, String nodeVersion) throws InstallationException {
        Function<String, String> property = key -> conf.hasPath(key) ? conf.getString(key) : null;
        factory.getNPMInstaller(proxy).setNpmVersion(this.npmVersion).setNodeVersion(nodeVersion).setNpmDownloadRoot(conf.getString("npm.downloadRoot")).setUserName(property.apply("npm.username")).setPassword(property.apply("npm.password")).install();
        NpmRunner npm = factory.getNpmRunner(proxy, conf.getString("npm.registryURL"));
        return (cmd, args) -> {
            String cmdline = cmd + " " + Arrays.asList(args).stream().collect(Collectors.joining(" "));
            npm.execute(cmdline, env);
        };
    }
}

