/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.apitool;

import com.google.common.collect.ImmutableList;
import com.google.inject.util.Types;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jooby.internal.apitool.BytecodeRouteParser;
import org.jooby.internal.apitool.asm.Type;
import org.jooby.internal.apitool.asm.signature.SignatureReader;
import org.jooby.internal.apitool.asm.signature.SignatureVisitor;

class TypeDescriptorParser
extends SignatureVisitor {
    private List<List<java.lang.reflect.Type>> stack = new ArrayList<List<java.lang.reflect.Type>>();
    private boolean returns;
    private ClassLoader loader;
    private List<java.lang.reflect.Type> result;
    private int index;

    private TypeDescriptorParser(ClassLoader loader) {
        super(458752);
        this.loader = loader;
    }

    public static java.lang.reflect.Type parse(ClassLoader loader, String desc) {
        TypeDescriptorParser builder = new TypeDescriptorParser(loader);
        new SignatureReader(desc).accept(builder);
        return builder.getType();
    }

    private java.lang.reflect.Type getType() {
        java.lang.reflect.Type type = this.result.get(0);
        this.stack.forEach(List::clear);
        this.stack.clear();
        return type;
    }

    private java.lang.reflect.Type primitive(Type type) {
        switch (type.getSort()) {
            case 1: {
                return Boolean.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
        }
        return Double.TYPE;
    }

    @Override
    public void visitBaseType(char descriptor) {
        if (this.returns) {
            LinkedList<java.lang.reflect.Type> types = new LinkedList<java.lang.reflect.Type>();
            types.add(this.primitive(Type.getType(Character.toString(descriptor))));
            this.stack.add(types);
            ++this.index;
            this.visitEnd();
        }
    }

    @Override
    public void visitClassType(String name) {
        if (this.returns) {
            List<Object> types;
            if (this.index < this.stack.size()) {
                types = this.stack.get(this.index);
            } else {
                types = new LinkedList();
                this.stack.add(types);
            }
            Class type = BytecodeRouteParser.loadType(this.loader, name);
            types.add(type);
            ++this.index;
        }
    }

    @Override
    public void visitEnd() {
        if (this.returns) {
            List<java.lang.reflect.Type> types = this.stack.get(this.index - 1);
            if (this.result == null) {
                this.result = types;
            } else if (this.result != types) {
                this.result = ImmutableList.of((Object)Types.newParameterizedType((java.lang.reflect.Type)types.get(0), (java.lang.reflect.Type[])this.result.toArray(new java.lang.reflect.Type[0])));
            }
            --this.index;
        }
    }

    @Override
    public SignatureVisitor visitReturnType() {
        this.returns = true;
        return this;
    }
}

