/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.apitool;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jooby.internal.apitool.asm.Type;
import org.jooby.internal.apitool.asm.tree.MethodInsnNode;

class Signature {
    private final ClassLoader loader;
    private Set<String> owners;
    private String name;
    private Type[] args;

    public Signature(ClassLoader loader, String owner, String name, Object ... args) {
        this.owners = this.expand(loader, owner);
        this.loader = loader;
        this.name = name;
        this.args = this.args(args);
    }

    public Signature(Method method) {
        this.owners = this.expand(method.getDeclaringClass());
        this.loader = method.getDeclaringClass().getClassLoader();
        this.name = method.getName();
        this.args = this.args(method.getParameterTypes());
    }

    public Signature(ClassLoader loader, MethodInsnNode method) {
        this.owners = this.expand(loader, method.owner);
        this.loader = loader;
        this.name = method.name;
        this.args = Type.getArgumentTypes(method.desc);
    }

    public boolean matches(Method method) {
        return this.matches(new Signature(method));
    }

    public boolean matches(MethodInsnNode method) {
        return this.matches(new Signature(this.loader, method));
    }

    public boolean matches(Signature signature) {
        if (this.owners.stream().filter(signature.owners::contains).findFirst().isPresent() && (this.name == null || signature.name.equals(this.name)) && this.args.length == signature.args.length) {
            for (int i = 0; i < this.args.length; ++i) {
                if (this.args[i].getClassName().equals(signature.args[i].getClassName())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.owners + "." + this.name + "(" + Arrays.toString(this.args) + ")";
    }

    private Set<String> expand(ClassLoader classLoader, String owner) {
        try {
            return this.expand(classLoader.loadClass(owner.replace("/", ".")));
        }
        catch (ClassNotFoundException x) {
            return ImmutableSet.of((Object)owner);
        }
    }

    private Set<String> expand(Class<?> owner) {
        LinkedHashSet<String> owners = new LinkedHashSet<String>();
        this.expand(owner, owners);
        return owners;
    }

    private void expand(Class<?> owner, Set<String> owners) {
        if (owner != null && owner != Object.class) {
            owners.add(Type.getInternalName(owner));
            this.expand(owner.getSuperclass(), owners);
            for (Class<?> itf : owner.getInterfaces()) {
                this.expand(itf, owners);
            }
        }
    }

    private Type[] args(Object ... args) {
        Type[] result = new Type[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg instanceof Class) {
                arg = ((Class)arg).getName();
            }
            result[i] = Type.getObjectType(arg.toString().replace(".", "/"));
        }
        return result;
    }
}

