/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.apitool;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jooby.Route;
import org.jooby.internal.apitool.Filters;
import org.jooby.internal.apitool.Insn;
import org.jooby.internal.apitool.asm.Handle;
import org.jooby.internal.apitool.asm.Type;
import org.jooby.internal.apitool.asm.tree.AbstractInsnNode;
import org.jooby.internal.apitool.asm.tree.InvokeDynamicInsnNode;
import org.jooby.internal.apitool.asm.tree.LdcInsnNode;
import org.jooby.internal.apitool.asm.tree.MethodInsnNode;
import org.jooby.internal.apitool.asm.tree.MethodNode;
import org.jooby.internal.apitool.asm.tree.TypeInsnNode;

class Lambda {
    public final String name;
    public final String pattern;
    public final String desc;
    public final String implementationName;
    public final String owner;
    public final String declaringClass;
    public final Optional<MethodNode> method;
    public final String tag;

    private Lambda(String declaringClass, MethodInsnNode method, Handle h) {
        this(declaringClass, h.getOwner(), h.getDesc(), h.getName(), method.name, null, null);
    }

    private Lambda(String declaringClass, String owner, String desc, String implementationName, String name, String pattern, MethodNode method) {
        this(declaringClass, owner, desc, implementationName, name, pattern, method, null);
    }

    private Lambda(String declaringClass, String owner, String desc, String implementationName, String name, String pattern, MethodNode method, String tag) {
        this.declaringClass = declaringClass;
        this.owner = owner;
        this.desc = desc;
        this.implementationName = implementationName;
        this.name = name.equals("use") || name.equals("all") ? "*" : name;
        this.pattern = pattern;
        this.method = Optional.ofNullable(method);
        this.tag = tag;
    }

    public String toString() {
        return this.name + " " + this.pattern;
    }

    public Lambda prefix(String prefix) {
        return new Lambda(this.declaringClass, this.owner, this.desc, this.implementationName, this.name, Route.normalize((String)(prefix + "/" + this.pattern)), this.method.orElse(null), this.tag);
    }

    public Lambda tag(String tag) {
        if (this.tag != null || tag.startsWith("/:") || tag.startsWith("/{")) {
            return this;
        }
        return new Lambda(this.declaringClass, this.owner, this.desc, this.implementationName, this.name, this.pattern, this.method.orElse(null), tag);
    }

    public Lambda method(MethodNode method) {
        return new Lambda(this.declaringClass, this.owner, this.desc, this.implementationName, this.name, this.pattern, method, this.tag);
    }

    public static Stream<Lambda> create(String owner, Optional<String> prefix, MethodInsnNode method, MethodNode implementation) {
        List patterns = Insn.ldcFor(method).stream().map(it -> it.cst.toString()).collect(Collectors.toList());
        if (patterns.size() == 0) {
            AbstractInsnNode ldcpath;
            if (method.owner.equals("org/jooby/Kooby") && method.getPrevious() instanceof TypeInsnNode && (ldcpath = (AbstractInsnNode)new Insn<MethodInsnNode>(implementation, method).prev().filter(Filters.is(TypeInsnNode.class)).flatMap(n -> {
                if (n.getPrevious() instanceof LdcInsnNode) {
                    return Stream.of(n.getPrevious());
                }
                return Stream.empty();
            }).findFirst().orElse(null)) instanceof LdcInsnNode) {
                patterns.add(((LdcInsnNode)ldcpath).cst.toString());
            }
            if (patterns.size() == 0) {
                patterns.add("/");
            }
        }
        prefix.ifPresent(p -> IntStream.range(0, patterns.size()).forEach(i -> patterns.set(i, Route.normalize((String)(p + "/" + (String)patterns.get(i))))));
        return patterns.stream().map(pattern -> new Lambda(owner, owner, implementation.desc, implementation.name, method.name.replace("$default", ""), (String)pattern, implementation));
    }

    public static Stream<Lambda> create(ClassLoader loader, Predicate<MethodInsnNode> scriptRoute, String declaringClass, InvokeDynamicInsnNode node, MethodNode implementation) {
        return new Insn<InvokeDynamicInsnNode>(null, node).next().filter(Filters.is(MethodInsnNode.class)).findFirst().map(MethodInsnNode.class::cast).filter(scriptRoute).map(method -> Arrays.asList(node.bsmArgs).stream().filter(Handle.class::isInstance).map(Handle.class::cast).findFirst().map(handle -> {
            List ldc;
            Lambda lambda = new Lambda(declaringClass, (MethodInsnNode)method, (Handle)handle);
            List<Type> args = Arrays.asList(Type.getArgumentTypes(method.desc));
            AtomicInteger count = new AtomicInteger(IntStream.range(0, args.size()).filter(i -> !((Type)args.get(i)).getClassName().equals(String.class.getName())).findFirst().orElse(0));
            int from = 0;
            if ("use".equals(method.name) && count.get() == 2) {
                ++from;
            }
            MethodInsnNode start = method;
            if (!method.owner.equals(lambda.owner) && handle.getTag() != 6) {
                start = new Insn<AbstractInsnNode>(null, method.getPrevious()).prev().filter(Filters.is(MethodInsnNode.class)).findFirst().map(MethodInsnNode.class::cast).orElse((MethodInsnNode)method);
            }
            if ((ldc = Insn.ldcFor(start).stream().map(it -> Route.normalize((String)it.cst.toString())).collect(Collectors.toList())).size() == 0) {
                ldc.add("/");
                count.incrementAndGet();
            }
            return ldc.stream().skip(from).limit(Math.min(count.get(), ldc.size())).flatMap(pattern -> Stream.of(new Lambda(lambda.declaringClass, lambda.owner, lambda.desc, lambda.implementationName, lambda.name, (String)pattern, implementation)));
        }).orElse(Stream.of(new Lambda[0]))).orElse(Stream.of(new Lambda[0]));
    }
}

