/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.apitool;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jooby.internal.apitool.Filters;
import org.jooby.internal.apitool.Insn;
import org.jooby.internal.apitool.asm.tree.AbstractInsnNode;
import org.jooby.internal.apitool.asm.tree.InsnList;
import org.jooby.internal.apitool.asm.tree.MethodNode;

class Insns {
    private InsnList instructions;
    private Map<Predicate, Consumer> consumers = new LinkedHashMap<Predicate, Consumer>();
    private MethodNode method;

    public Insns(MethodNode method) {
        this(method, method.instructions);
    }

    public Insns(MethodNode method, AbstractInsnNode n) {
        this(method, Insns.instructions(method, n));
    }

    public Insns(MethodNode method, InsnList instructions) {
        this.method = method;
        this.instructions = instructions;
    }

    public Insn<AbstractInsnNode> last() {
        return new Insn<AbstractInsnNode>(this.method, this.instructions.getLast());
    }

    public <T extends AbstractInsnNode> Insns on(Class<T> filter, Consumer<Insn<T>> consumer) {
        return this.on(Filters.is(filter), consumer);
    }

    public <T extends AbstractInsnNode> Insns on(Predicate<T> filter, Consumer<Insn<T>> consumer) {
        this.consumers.put(filter, consumer);
        return this;
    }

    public void forEach() {
        for (int i = 0; i < this.instructions.size(); ++i) {
            AbstractInsnNode it = this.instructions.get(i);
            for (Map.Entry<Predicate, Consumer> consumer : this.consumers.entrySet()) {
                if (!consumer.getKey().test(it)) continue;
                consumer.getValue().accept(new Insn<AbstractInsnNode>(this.method, it));
            }
        }
    }

    private static InsnList instructions(MethodNode method, AbstractInsnNode n) {
        InsnList instructions = new InsnList();
        instructions.add(n);
        new Insn<AbstractInsnNode>(method, n).next().forEach(instructions::add);
        return instructions;
    }
}

