/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.apitool;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jooby.internal.apitool.Filters;
import org.jooby.internal.apitool.asm.tree.AbstractInsnNode;
import org.jooby.internal.apitool.asm.tree.LdcInsnNode;
import org.jooby.internal.apitool.asm.tree.MethodInsnNode;
import org.jooby.internal.apitool.asm.tree.MethodNode;
import org.jooby.internal.apitool.asm.util.ASMifier;
import org.jooby.internal.apitool.asm.util.TraceMethodVisitor;

class Insn<T extends AbstractInsnNode> {
    public final MethodNode method;
    public final T node;

    public Insn(MethodNode method, T node) {
        this.method = method;
        this.node = node;
    }

    public Stream<AbstractInsnNode> prev() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new NodeIterator((AbstractInsnNode)this.node, AbstractInsnNode::getPrevious), 16), false);
    }

    public Stream<AbstractInsnNode> next() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new NodeIterator((AbstractInsnNode)this.node, AbstractInsnNode::getNext), 16), false);
    }

    public String toString() {
        ASMifier printer = new ASMifier();
        TraceMethodVisitor visitor = new TraceMethodVisitor(printer);
        ((AbstractInsnNode)this.node).accept(visitor);
        return printer.getText().toString();
    }

    public static AbstractInsnNode first(AbstractInsnNode node) {
        AbstractInsnNode result = node;
        for (AbstractInsnNode it = node; it != null; it = it.getPrevious()) {
            result = it;
        }
        return result;
    }

    public static List<LdcInsnNode> ldcFor(MethodInsnNode node) {
        ArrayList<LdcInsnNode> ldc = new ArrayList<LdcInsnNode>();
        for (AbstractInsnNode it = new Insn<AbstractInsnNode>(null, node.getPrevious()).prev().filter(Filters.is(MethodInsnNode.class)).findFirst().orElseGet(() -> Insn.first(node)); it != node; it = it.getNext()) {
            if (!(it instanceof LdcInsnNode)) continue;
            ldc.add((LdcInsnNode)it);
        }
        return ldc;
    }

    private static class NodeIterator
    implements Iterator<AbstractInsnNode> {
        private AbstractInsnNode node;
        private Function<AbstractInsnNode, AbstractInsnNode> next;

        public NodeIterator(AbstractInsnNode node, Function<AbstractInsnNode, AbstractInsnNode> next) {
            this.node = node;
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            return this.node != null;
        }

        @Override
        public AbstractInsnNode next() {
            AbstractInsnNode it = this.node;
            this.node = this.next.apply(this.node);
            return it;
        }
    }
}

