/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.apitool;

import com.google.common.base.Strings;
import java.util.Map;

class DocItem {
    public final String summary;
    public final String text;
    public final Map<String, String> parameters;
    public final String returns;
    public final Map<Integer, String> statusCodes;
    public final String method;
    public final String pattern;

    public DocItem(String method, String pattern, String summary, String text, Map<String, String> parameters, String returns, Map<Integer, String> statusCodes) {
        this.method = method.toUpperCase();
        this.pattern = pattern;
        this.summary = Strings.emptyToNull((String)summary.trim());
        this.text = Strings.emptyToNull((String)text.trim());
        this.parameters = parameters;
        this.returns = Strings.emptyToNull((String)returns.trim());
        this.statusCodes = statusCodes;
    }

    public boolean matches(String method, String pattern) {
        return this.method.equalsIgnoreCase(method) && this.pattern.equals(pattern);
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("Summary: ").append(this.summary).append("\n");
        buff.append("   Description: ").append(this.text).append("\n");
        buff.append("   Parameters: ").append(this.parameters).append("\n");
        buff.append("   Return: ").append(this.returns).append("\n");
        buff.append("   StatusCodes: ").append(this.statusCodes).append("\n");
        return buff.toString();
    }
}

