/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.apitool;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Primitives;
import com.google.inject.internal.MoreTypes;
import com.google.inject.util.Types;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValueFactory;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.inject.Named;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Result;
import org.jooby.Route;
import org.jooby.Session;
import org.jooby.Status;
import org.jooby.Upload;
import org.jooby.apitool.RouteMethod;
import org.jooby.apitool.RouteParameter;
import org.jooby.apitool.RouteResponse;
import org.jooby.funzy.Try;
import org.jooby.funzy.When;
import org.jooby.internal.RouteMetadata;
import org.jooby.internal.apitool.DocItem;
import org.jooby.internal.apitool.DocParser;
import org.jooby.internal.apitool.Filters;
import org.jooby.internal.apitool.Insn;
import org.jooby.internal.apitool.Insns;
import org.jooby.internal.apitool.Lambda;
import org.jooby.internal.apitool.TypeDescriptorParser;
import org.jooby.internal.apitool.TypeJsonDeserializer;
import org.jooby.internal.apitool.TypeJsonSerializer;
import org.jooby.internal.apitool.asm.ClassReader;
import org.jooby.internal.apitool.asm.Handle;
import org.jooby.internal.apitool.asm.Type;
import org.jooby.internal.apitool.asm.tree.AbstractInsnNode;
import org.jooby.internal.apitool.asm.tree.ClassNode;
import org.jooby.internal.apitool.asm.tree.FieldInsnNode;
import org.jooby.internal.apitool.asm.tree.InnerClassNode;
import org.jooby.internal.apitool.asm.tree.InsnNode;
import org.jooby.internal.apitool.asm.tree.IntInsnNode;
import org.jooby.internal.apitool.asm.tree.InvokeDynamicInsnNode;
import org.jooby.internal.apitool.asm.tree.LdcInsnNode;
import org.jooby.internal.apitool.asm.tree.LocalVariableNode;
import org.jooby.internal.apitool.asm.tree.MethodInsnNode;
import org.jooby.internal.apitool.asm.tree.MethodNode;
import org.jooby.internal.apitool.asm.tree.TypeInsnNode;
import org.jooby.internal.apitool.asm.tree.VarInsnNode;
import org.jooby.internal.apitool.asm.util.ASMifier;
import org.jooby.internal.apitool.asm.util.TraceClassVisitor;
import org.jooby.internal.mvc.MvcRoutes;
import org.jooby.mvc.Body;
import org.jooby.mvc.Flash;
import org.jooby.mvc.Header;
import org.jooby.mvc.Local;
import org.jooby.mvc.POST;
import org.jooby.mvc.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytecodeRouteParser {
    static final Set<Class<?>> SKIP_TYPES = ImmutableSet.of(Route.Chain.class, Response.class, Request.class, Session.class, Route.class, Flash.class, (Object[])new Class[]{Local.class});
    static final Predicate<Parameter> TYPE_TO_SKIP = p -> !SKIP_TYPES.contains(p.getType());
    static final Predicate<Parameter> ANNOTATION_TO_SKIP = p -> !Arrays.asList(p.getAnnotations()).stream().filter(a -> SKIP_TYPES.contains(a.annotationType())).findFirst().isPresent();
    static final Predicate<Parameter> SKIP = TYPE_TO_SKIP.and(ANNOTATION_TO_SKIP);
    static final ObjectMapper mapper = new ObjectMapper();
    private static final String OBJECT = Type.getInternalName(Object.class);
    private static final String RETURN_OBJ = "L" + OBJECT + ";";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, ClassNode> cache = new HashMap<String, ClassNode>();
    private final DocParser javadoc;
    private final Predicate<MethodInsnNode> scriptRoute;
    private final ClassLoader loader;

    public BytecodeRouteParser(ClassLoader loader, java.nio.file.Path dir) {
        this.javadoc = new DocParser(dir);
        this.loader = loader;
        this.scriptRoute = Filters.scriptRoute(loader);
    }

    public List<RouteMethod> read(String classname) {
        String filename = "/" + classname.replace(".", "/") + ".json";
        URL resource = this.getClass().getResource(filename);
        if (resource != null) {
            try {
                return (List)mapper.readValue(resource, (JavaType)mapper.getTypeFactory().constructCollectionType(ArrayList.class, RouteMethod.class));
            }
            catch (IOException e) {
                this.log.error("read of {} resulted in exception", (Object)filename, (Object)e);
            }
        }
        return null;
    }

    private java.nio.file.Path write(java.nio.file.Path output, List<RouteMethod> routes) throws IOException {
        Files.createDirectories(output.getParent(), new FileAttribute[0]);
        this.log.debug("writing {} with {}", (Object)output, routes);
        mapper.writer().withDefaultPrettyPrinter().writeValue(output.toFile(), routes);
        return output;
    }

    private java.nio.file.Path toFile(java.nio.file.Path dir, String classname) {
        java.nio.file.Path path = Arrays.asList(classname.split("\\.")).stream().reduce(dir, java.nio.file.Path::resolve, java.nio.file.Path::resolve);
        ClassNode classNode = this.loadClass(classname);
        return path.getParent().resolve(classNode.sourceFile.replaceAll("\\.java|\\.kt", "") + ".json");
    }

    public java.nio.file.Path export(java.nio.file.Path dir, String classname) throws Exception {
        java.nio.file.Path output = this.toFile(dir, classname);
        Files.deleteIfExists(output);
        List<RouteMethod> routes = this.parse(classname);
        return this.write(output, routes);
    }

    public List<RouteMethod> parse(String classname) throws Exception {
        ClassNode owner = this.loadClass(classname);
        List<Object> lambdas = this.bindMethods(owner, this.lambdas(this.loader, owner));
        ArrayList<RouteMethod> methods = new ArrayList<RouteMethod>();
        for (Object it : lambdas) {
            this.log.debug("found: {}", it);
            if (it instanceof RouteMethod) {
                methods.add((RouteMethod)it);
                continue;
            }
            Lambda lambda = (Lambda)it;
            if (lambda.method.isPresent()) {
                Integer status;
                MethodNode method = lambda.method.get();
                java.lang.reflect.Type returnType = method.desc.endsWith("V") ? this.sendReturnType(this.loader, method) : (method.desc.endsWith(RETURN_OBJ) ? this.returnType(this.loader, method) : TypeDescriptorParser.parse(this.loader, Optional.ofNullable(method.signature).orElse(method.desc)));
                if (returnType instanceof TypeWithStatus) {
                    status = ((TypeWithStatus)returnType).status;
                    returnType = ((TypeWithStatus)returnType).type();
                } else {
                    status = null;
                }
                List<RouteParameter> parameters = this.params(this.loader, owner, lambda.pattern, method);
                RouteResponse routeResponse = new RouteResponse(BytecodeRouteParser.simplifyType(returnType));
                if (status != null) {
                    routeResponse.status((Map<Integer, String>)ImmutableMap.of((Object)status, (Object)Try.apply(() -> Status.valueOf((int)status).reason()).orElse((Object)status.toString())));
                }
                RouteMethod route = new RouteMethod(lambda.name, lambda.pattern, routeResponse).parameters(parameters);
                if (lambda.tag != null) {
                    route.attribute("route.tag", this.scriptRouteTag(lambda.tag));
                }
                this.javadoc(route, this.javadoc.pop(lambda.declaringClass, lambda.name, lambda.pattern));
                methods.add(route);
                continue;
            }
            this.log.debug("can't bind implementation for {} at {}", (Object)lambda, (Object)lambda.owner);
        }
        return this.typeAnalizer(methods);
    }

    private String scriptRouteTag(String tag) {
        String value = Stream.of(tag.split("/")).filter(it -> it.length() > 0).map(it -> Character.toUpperCase(it.charAt(0)) + it.substring(1)).collect(Collectors.joining());
        return value;
    }

    private List<RouteMethod> typeAnalizer(List<RouteMethod> methods) {
        methods.forEach(this::typeAnalizer);
        return methods;
    }

    private void typeAnalizer(RouteMethod route) {
        route.parameters().forEach(p -> p.type());
    }

    private RouteMethod javadoc(RouteMethod method, Optional<DocItem> doc) {
        doc.ifPresent(it -> {
            method.description(it.text);
            method.summary(it.summary);
            method.response().description(it.returns);
            method.response().status(it.statusCodes);
            method.parameters().forEach(p -> p.description(it.parameters.get(p.name())));
        });
        return method;
    }

    private List<Object> bindMethods(ClassNode owner, List<Object> lambdas) {
        List<MethodNode> methods = owner.methods;
        return lambdas.stream().flatMap(e -> {
            if (e instanceof RouteMethod) {
                return Stream.of(e);
            }
            Lambda it = (Lambda)e;
            if (it.method.isPresent()) {
                return Stream.of(it);
            }
            return methods.stream().filter(m -> owner.name.equals(it.owner) && it.implementationName.equals(m.name) && it.desc.equals(m.desc)).findFirst().map(m -> Stream.of(it.method((MethodNode)m))).orElseGet(() -> {
                ClassNode jump = this.loadClass(it.owner);
                List<Object> ext = this.bindMethods(jump, Arrays.asList(it));
                return ext.stream();
            });
        }).collect(Collectors.toList());
    }

    private List<Object> lambdas(ClassLoader loader, ClassNode owner, MethodNode method) {
        ArrayList<Object> result = new ArrayList<Object>();
        new Insns(method).on(InvokeDynamicInsnNode.class, it -> {
            this.log.debug("found candidate: {}", it);
            it.next().filter(Filters.is(MethodInsnNode.class)).map(MethodInsnNode.class::cast).filter(this.scriptRoute).findFirst().ifPresent(m -> {
                this.log.debug("found script route: {}.{}{}", new Object[]{m.owner, m.name, m.desc});
                Lambda.create(loader, this.scriptRoute, owner.name.replace("/", "."), (InvokeDynamicInsnNode)it.node, null).forEach(result::add);
            });
        }).on(Filters.path(loader, owner.name), it -> {
            this.log.debug("found path: " + it);
            result.addAll(this.pathOperator(owner, owner.methods, (Insn<MethodInsnNode>)it));
        }).on(Filters.use(loader, owner.name), it -> this.mvc((Insn<MethodInsnNode>)it, result::add)).on(Filters.mount(loader, owner.name), it -> {
            this.log.debug("found mount: " + it);
            it.prev().filter(Filters.and(Filters.is(MethodInsnNode.class), Filters.opcode(183))).findFirst().map(MethodInsnNode.class::cast).ifPresent(node -> {
                List<Object> rlist = this.lambdas(loader, this.loadClass(node.owner));
                Insn.ldcFor(node).stream().map(e -> e.cst.toString()).findFirst().ifPresent(prefix -> IntStream.range(0, rlist.size()).forEach(i -> {
                    Object o = rlist.get(i);
                    if (o instanceof Lambda) {
                        rlist.set(i, ((Lambda)o).prefix((String)prefix));
                    } else {
                        RouteMethod r = (RouteMethod)o;
                        r.pattern(prefix + r.pattern());
                    }
                }));
                result.addAll(rlist);
            });
        }).forEach();
        this.log.debug("results: {}", result);
        return result;
    }

    private List<Lambda> pathOperator(ClassNode owner, List<MethodNode> methods, Insn<MethodInsnNode> it) {
        ArrayList<Lambda> result = new ArrayList<Lambda>();
        Insn.ldcFor((MethodInsnNode)it.node).stream().map(e -> e.cst.toString()).findFirst().ifPresent(path -> it.prev().filter(Filters.is(InvokeDynamicInsnNode.class)).findFirst().map(InvokeDynamicInsnNode.class::cast).ifPresent(n -> Arrays.asList(n.bsmArgs).stream().filter(Handle.class::isInstance).findFirst().map(Handle.class::cast).ifPresent(handle -> methods.stream().filter(m -> m.name.equals(handle.getName())).findFirst().ifPresent(pathAction -> {
            this.log.debug("pathAction {}", path);
            this.lambdas(this.loader, owner, (MethodNode)pathAction).stream().filter(Lambda.class::isInstance).map(Lambda.class::cast).forEach(lambda -> result.add(lambda.prefix((String)path).tag((String)path)));
        }))));
        this.log.debug("pathOperator: {}", result);
        return result;
    }

    private List<Object> lambdas(ClassLoader loader, ClassNode owner) {
        List<Object> compiled = this.read(owner.name);
        if (compiled != null) {
            return compiled;
        }
        if (owner.sourceFile.endsWith(".kt")) {
            return this.kotlinSource(loader, owner);
        }
        List<MethodNode> methods = owner.methods;
        List<Object> handles = methods.stream().filter(Filters.access(4096).negate()).flatMap(method -> this.lambdas(loader, owner, (MethodNode)method).stream()).collect(Collectors.toList());
        return handles;
    }

    private void mvcRoutes(String path, Class type, Consumer<RouteMethod> callback) {
        Env env = Env.DEFAULT.build(ConfigFactory.empty().withValue("application.env", ConfigValueFactory.fromAnyRef((Object)"dev")));
        MvcRoutes.routes((Env)env, (RouteMetadata)new RouteMetadata(env), (String)"", (boolean)true, (Class)type).forEach(r -> {
            Path rootPath;
            RouteMethod method = BytecodeRouteParser.toRouteMethod(r);
            this.javadoc(method, this.javadoc.pop(type.getName(), r.method(), r.pattern()));
            if (path.length() > 0) {
                method.pattern(Route.normalize((String)path) + method.pattern());
            }
            if ((rootPath = type.getAnnotation(Path.class)) != null) {
                method.attribute("route.tag", this.mvcRouteTag(type.getSimpleName()));
            }
            callback.accept(method);
        });
    }

    private String mvcRouteTag(String name) {
        return name.replace("Controller", "").replace("Manager", "").replace("Api", "").replace("API", "").replace("Mvc", "").replace("MVC", "");
    }

    private List<Object> kotlinSource(ClassLoader loader, ClassNode owner) {
        List<Object> result = this.kotlinLambdas(loader, owner);
        if (result.size() == 0) {
            List<MethodNode> methods = owner.methods;
            methods.stream().filter(Filters.method("main", String.class.getName() + "[]")).findFirst().ifPresent(main -> {
                this.log.debug("found main method: {}.main", (Object)owner.name);
                new Insns((MethodNode)main).on(Filters.joobyRun(loader), n -> {
                    this.log.debug("found run(::Type, *args)");
                    n.prev().filter(Filters.and(Filters.is(FieldInsnNode.class), Filters.opcode(178))).findFirst().map(FieldInsnNode.class::cast).ifPresent(f -> {
                        ClassNode mainOwner = this.loadClass(f.owner);
                        this.log.debug("found ::{}", (Object)mainOwner.name);
                        mainOwner.methods.stream().filter(Filters.kotlinRouteHandler()).findFirst().ifPresent(m -> {
                            this.log.debug("{}.invoke({})", (Object)mainOwner.name, (Object)m.desc);
                            new Insns((MethodNode)m).on(Filters.is(TypeInsnNode.class).and(Filters.opcode(187)), it -> {
                                ClassNode lambda = this.loadClass(((TypeInsnNode)it.node).desc);
                                this.log.debug("source {}", (Object)lambda.name);
                                result.addAll(this.kotlinLambdas(loader, lambda));
                            }).forEach();
                        });
                    });
                }).forEach();
            });
        }
        return result;
    }

    private List<Object> kotlinLambdas(ClassLoader loader, ClassNode owner) {
        ArrayList<Object> result = new ArrayList<Object>();
        List<InnerClassNode> innerClasses = owner.innerClasses;
        for (InnerClassNode innerClass : innerClasses) {
            ClassNode innerNode = this.loadClass(innerClass.name);
            result.addAll(this.kotlinLambda(loader, innerNode));
        }
        return result;
    }

    private List<Object> kotlinLambda(ClassLoader loader, ClassNode owner, MethodNode method) {
        ArrayList<Object> result = new ArrayList<Object>();
        new Insns(method).on(this.scriptRoute, it -> {
            this.log.debug("  lambda candidate: {}", it.node);
            String lambdaOwner = it.prev().filter(Filters.and(Filters.is(FieldInsnNode.class), Filters.opcode(178))).findFirst().map(FieldInsnNode.class::cast).map(f -> f.owner).orElseGet(() -> new Insn<AbstractInsnNode>(method, ((MethodInsnNode)it.node).getPrevious()).prev().filter(Filters.is(MethodInsnNode.class)).findFirst().map(MethodInsnNode.class::cast).map(m -> m.owner).orElse(null));
            if (lambdaOwner != null) {
                ClassNode lambda = this.loadClass(lambdaOwner);
                this.log.debug("  lambda: {}", (Object)lambdaOwner);
                lambda.methods.stream().filter(Filters.kotlinRouteHandler()).forEach(e -> {
                    MethodNode m = e;
                    this.log.debug("    implementation: {}.{}()", new Object[]{lambda.name, m.name, m.desc});
                    Lambda.create(lambdaOwner, Optional.empty(), (MethodInsnNode)it.node, m).forEach(result::add);
                });
            }
        }).on(Filters.use(loader, "org.jooby.Kooby"), it -> this.mvc((Insn<MethodInsnNode>)it, result::add)).on(Filters.mount(loader, Jooby.class.getName()), it -> it.prev().filter(Filters.and(Filters.is(MethodInsnNode.class), Filters.opcode(183))).findFirst().map(MethodInsnNode.class::cast).ifPresent(n -> {
            List<Object> rlist = this.lambdas(loader, this.loadClass(n.owner));
            Insn.ldcFor(n).stream().map(e -> e.cst.toString()).findFirst().ifPresent(prefix -> IntStream.range(0, rlist.size()).forEach(i -> {
                Object o = rlist.get(i);
                if (o instanceof Lambda) {
                    rlist.set(i, ((Lambda)o).prefix((String)prefix));
                } else {
                    RouteMethod r = (RouteMethod)o;
                    r.pattern(prefix + r.pattern());
                }
            }));
            result.addAll(rlist);
        })).on(Filters.path(loader, "org.jooby.Kooby"), it -> result.addAll(this.kotlinPathOperator(owner, owner.methods, (Insn<MethodInsnNode>)it))).forEach();
        return result;
    }

    private void mvc(Insn<MethodInsnNode> it, Consumer<Object> consumer) {
        this.log.debug("found mvc {}", it);
        it.prev().filter(Filters.is(LdcInsnNode.class)).findFirst().map(LdcInsnNode.class::cast).filter(ldc -> ldc.cst instanceof Type).ifPresent(ldc -> {
            String arg0 = Type.getArgumentTypes(((MethodInsnNode)it.node).desc)[0].getClassName();
            String prefix = "";
            if (arg0.equals(String.class.getName())) {
                prefix = new Insn<AbstractInsnNode>(it.method, ldc.getPrevious()).prev().filter(Filters.is(LdcInsnNode.class)).findFirst().map(LdcInsnNode.class::cast).map(n -> n.cst.toString()).orElse("");
            }
            String mvcClass = ((Type)ldc.cst).getClassName();
            this.mvcRoutes(prefix, BytecodeRouteParser.loadType(this.loader, mvcClass), consumer::accept);
        });
    }

    private List<Object> kotlinLambda(ClassLoader loader, ClassNode owner) {
        ArrayList<Object> result = new ArrayList<Object>();
        this.log.debug("visiting lambda class: {}", (Object)owner.name);
        List<MethodNode> methods = owner.methods;
        methods.stream().filter(Filters.method("invoke", "org.jooby.Jooby").or(Filters.method("invoke", "org.jooby.Kooby"))).findFirst().ifPresent(method -> {
            this.log.debug("  invoke: {}", (Object)method.desc);
            result.addAll(this.kotlinLambda(loader, owner, (MethodNode)method));
        });
        return result;
    }

    private List<Lambda> kotlinPathOperator(ClassNode owner, List<MethodNode> methods, Insn<MethodInsnNode> it) {
        ArrayList<Lambda> result = new ArrayList<Lambda>();
        it.prev().filter(Filters.and(Filters.is(MethodInsnNode.class), Filters.opcode(183))).findFirst().map(MethodInsnNode.class::cast).ifPresent(node -> Insn.ldcFor(node).stream().map(e -> e.cst.toString()).findFirst().ifPresent(path -> it.prev().filter(Filters.and(Filters.is(MethodInsnNode.class), Filters.opcode(183))).findFirst().map(MethodInsnNode.class::cast).ifPresent(n -> {
            ClassNode classNode = this.loadClass(n.owner);
            classNode.methods.stream().map(MethodNode.class::cast).filter(Filters.methodName("run")).findFirst().ifPresent(runMethod -> this.kotlinLambda(this.loader, owner, (MethodNode)runMethod).stream().filter(Lambda.class::isInstance).map(Lambda.class::cast).map(lambda -> lambda.prefix((String)path).tag((String)path)).forEach(result::add));
        })));
        return result;
    }

    private List<RouteParameter> params(ClassLoader loader, ClassNode owner, String pattern, MethodNode lambda) {
        ArrayList<RouteParameter> result = new ArrayList<RouteParameter>();
        new Insns(lambda).on(Filters.param(loader), it -> {
            String name = this.parameterName((MethodInsnNode)it.node).orElse("arg" + result.size());
            AbstractInsnNode next = ((MethodInsnNode)it.node).getNext();
            Object value = this.paramValue(loader, owner, lambda, next);
            if (value != next) {
                next = next.getNext();
            } else {
                value = null;
            }
            java.lang.reflect.Type parameterType = this.parameterType(loader, next);
            if (Boolean.TYPE.equals(parameterType) && Integer.class.isInstance(value)) {
                value = (Integer)value == 1;
            }
            result.add(new RouteParameter(name, this.kind(pattern, ((MethodInsnNode)it.node).name, name), BytecodeRouteParser.simplifyType(parameterType), value));
        }).forEach();
        return result;
    }

    private RouteParameter.Kind kind(String pattern, String method, String name) {
        if (method.equals("header")) {
            return RouteParameter.Kind.HEADER;
        }
        if (method.equals("param") || method.equals("params")) {
            return BytecodeRouteParser.isPathParam(pattern, name) ? RouteParameter.Kind.PATH : RouteParameter.Kind.QUERY;
        }
        if (method.equals("form")) {
            return RouteParameter.Kind.FORM;
        }
        if (method.equals("file") || method.equals("files")) {
            return RouteParameter.Kind.FILE;
        }
        return RouteParameter.Kind.BODY;
    }

    private static boolean isPathParam(String pattern, String name) {
        return pattern.contains("{" + name + "}") || pattern.contains(":" + name);
    }

    private Object paramValue(ClassLoader loader, ClassNode owner, MethodNode method, AbstractInsnNode n) {
        if (n instanceof LdcInsnNode) {
            Object cst = ((LdcInsnNode)n).cst;
            if (cst instanceof Type) {
                boolean typePresent = new Insn<AbstractInsnNode>(method, n).next().filter(Filters.is(MethodInsnNode.class)).findFirst().map(MethodInsnNode.class::cast).filter(Filters.mutantToSomething().or(Filters.getOrCreateKotlinClass())).isPresent();
                if (typePresent) {
                    return null;
                }
                return BytecodeRouteParser.loadType(loader, ((Type)cst).getClassName());
            }
            return cst;
        }
        if (n instanceof InsnNode) {
            InsnNode insn = (InsnNode)n;
            switch (insn.getOpcode()) {
                case 3: {
                    return 0;
                }
                case 4: {
                    return 1;
                }
                case 5: {
                    return 2;
                }
                case 6: {
                    return 3;
                }
                case 7: {
                    return 4;
                }
                case 8: {
                    return 5;
                }
                case 9: {
                    return 0L;
                }
                case 10: {
                    return 1L;
                }
                case 11: {
                    return Float.valueOf(0.0f);
                }
                case 12: {
                    return Float.valueOf(1.0f);
                }
                case 13: {
                    return Float.valueOf(2.0f);
                }
                case 14: {
                    return 0.0;
                }
                case 15: {
                    return 1.0;
                }
                case 2: {
                    return -1;
                }
                case 1: {
                    return null;
                }
            }
        } else {
            Class possibleEnum;
            FieldInsnNode finsn;
            if (n instanceof IntInsnNode) {
                IntInsnNode intinsn = (IntInsnNode)n;
                return intinsn.operand;
            }
            if (n instanceof FieldInsnNode && (finsn = (FieldInsnNode)n).getOpcode() == 178 && MoreTypes.getRawType((java.lang.reflect.Type)(possibleEnum = BytecodeRouteParser.loadType(loader, finsn.owner))).isEnum()) {
                return finsn.name;
            }
        }
        return n;
    }

    private java.lang.reflect.Type parameterType(ClassLoader loader, AbstractInsnNode n) {
        if (n instanceof MethodInsnNode) {
            MethodInsnNode node = (MethodInsnNode)n;
            if (Filters.mutantValue().test(node)) {
                return TypeDescriptorParser.parse(loader, node.desc);
            }
            if (Filters.mutantToSomething().test(node) || Filters.getOrCreateKotlinClass().test(node)) {
                ImmutableSet skipOwners;
                String owner = Type.getReturnType(node.desc).getClassName();
                AbstractInsnNode prev = node.getPrevious();
                if (prev instanceof FieldInsnNode && ((MethodInsnNode)n).name.equals("toEnum")) {
                    return BytecodeRouteParser.loadType(loader, ((FieldInsnNode)prev).owner);
                }
                Class toType = String.class;
                if (prev instanceof LdcInsnNode) {
                    Object cst = ((LdcInsnNode)prev).cst;
                    if (cst instanceof Type) {
                        toType = BytecodeRouteParser.loadType(loader, ((Type)cst).getClassName());
                    }
                } else if (prev instanceof FieldInsnNode) {
                    toType = BytecodeRouteParser.loadType(loader, ((FieldInsnNode)prev).owner);
                }
                AbstractInsnNode next = node.getNext();
                if (next instanceof MethodInsnNode) {
                    String joobyKt = ((MethodInsnNode)next).owner;
                    String methodName = ((MethodInsnNode)next).name;
                    if ("toOptional".equals(methodName) && "org/jooby/JoobyKt".equals(joobyKt)) {
                        owner = Optional.class.getName();
                    }
                }
                if ((skipOwners = ImmutableSet.of((Object)Object.class.getName(), (Object)Enum.class.getName(), (Object)"kotlin.reflect.KClass")).contains(owner)) {
                    return toType;
                }
                return Types.newParameterizedType((java.lang.reflect.Type)BytecodeRouteParser.loadType(loader, owner), (java.lang.reflect.Type[])new java.lang.reflect.Type[]{toType});
            }
        } else {
            if (n instanceof VarInsnNode) {
                return (java.lang.reflect.Type)((Object)new Insn<AbstractInsnNode>(null, n).prev().filter(Filters.is(MethodInsnNode.class)).findFirst().map(MethodInsnNode.class::cast).filter(Filters.file()).map(m -> m.name.equals("files") ? Types.newParameterizedType(List.class, (java.lang.reflect.Type[])new java.lang.reflect.Type[]{File.class}) : File.class).orElse((java.lang.reflect.Type)((Object)Object.class)));
            }
            if (n instanceof TypeInsnNode) {
                TypeInsnNode typeInsn = (TypeInsnNode)n;
                if (typeInsn.getOpcode() == 192) {
                    return BytecodeRouteParser.loadType(loader, typeInsn.desc);
                }
            } else {
                AbstractInsnNode next;
                if (n != null && 89 == n.getOpcode()) {
                    AbstractInsnNode next2 = new Insn<AbstractInsnNode>(null, n).next().filter(MethodInsnNode.class::isInstance).skip(1L).findFirst().orElse(null);
                    java.lang.reflect.Type result = this.parameterType(loader, next2);
                    if (result == Object.class) {
                        next2 = new Insn<AbstractInsnNode>(null, n).next().filter(TypeInsnNode.class::isInstance).findFirst().orElse(null);
                        result = this.parameterType(loader, next2);
                    }
                    return result;
                }
                if (n instanceof FieldInsnNode && (next = n.getNext()) instanceof MethodInsnNode) {
                    if (((MethodInsnNode)next).name.equals("toOptional")) {
                        return Types.newParameterizedType(Optional.class, (java.lang.reflect.Type[])new java.lang.reflect.Type[]{BytecodeRouteParser.loadType(loader, ((FieldInsnNode)n).owner)});
                    }
                    if (((MethodInsnNode)next).name.equals("getOrCreateKotlinClass")) {
                        return BytecodeRouteParser.loadType(loader, ((FieldInsnNode)n).owner);
                    }
                }
            }
        }
        return Object.class;
    }

    private Optional<String> parameterName(MethodInsnNode node) {
        if (node.name.equals("body") || node.name.equals("form") || node.name.equals("params")) {
            return Optional.of(node.name);
        }
        List<LdcInsnNode> ldc = Insn.ldcFor(node);
        return ldc.size() > 0 ? Optional.of((String)ldc.get((int)0).cst) : Optional.empty();
    }

    private java.lang.reflect.Type returnType(ClassLoader loader, MethodNode m) throws Exception {
        return new Insns(m).last().prev().filter(Filters.and(Filters.is(InsnNode.class), Filters.opcode(176))).findFirst().map(AbstractInsnNode::getPrevious).map(previous -> this.handleReturnType(loader, m, (AbstractInsnNode)previous)).orElseGet(() -> this.sendReturnType(loader, m));
    }

    private java.lang.reflect.Type handleReturnType(ClassLoader loader, MethodNode m, AbstractInsnNode previous) {
        if (previous instanceof MethodInsnNode) {
            MethodInsnNode minnsn = (MethodInsnNode)previous;
            if (minnsn.name.equals("<init>")) {
                return BytecodeRouteParser.loadType(loader, minnsn.owner);
            }
            String desc = minnsn.desc;
            java.lang.reflect.Type type = TypeDescriptorParser.parse(loader, desc);
            if (type.getTypeName().equals(Result.class.getName())) {
                return new TypeWithStatus(type, this.statusCodeFor(minnsn));
            }
            return type;
        }
        if (previous instanceof LdcInsnNode) {
            Object cst = ((LdcInsnNode)previous).cst;
            if (cst instanceof Type) {
                return TypeDescriptorParser.parse(loader, ((Type)cst).getDescriptor());
            }
            return cst.getClass();
        }
        if (previous instanceof VarInsnNode) {
            VarInsnNode varInsn = (VarInsnNode)previous;
            return BytecodeRouteParser.localVariable(loader, m, varInsn);
        }
        return Object.class;
    }

    private java.lang.reflect.Type sendReturnType(ClassLoader loader, MethodNode m) {
        return new Insns(m).last().prev().filter(MethodInsnNode.class::isInstance).map(MethodInsnNode.class::cast).filter(Filters.sendObject()).findFirst().map(AbstractInsnNode::getPrevious).map(node -> this.handleReturnType(loader, m, (AbstractInsnNode)node)).orElse(Void.TYPE);
    }

    private Integer statusCodeFor(MethodInsnNode node) {
        if (node.name.equals("noContent")) {
            return 204;
        }
        if (node.name.equals("with")) {
            String owner;
            AbstractInsnNode previous = node.getPrevious();
            if (previous instanceof IntInsnNode) {
                return ((IntInsnNode)previous).operand;
            }
            if (previous instanceof FieldInsnNode && (owner = ((FieldInsnNode)previous).owner.replace("/", ".")).equals(Status.class.getName())) {
                String statusName = ((FieldInsnNode)previous).name;
                return (Integer)Try.apply(() -> Status.class.getDeclaredField(statusName).get(null)).map(it -> ((Status)it).value()).orElse(null);
            }
        }
        return null;
    }

    static java.lang.reflect.Type localVariable(ClassLoader loader, MethodNode m, VarInsnNode varInsn) {
        List<LocalVariableNode> vars;
        LocalVariableNode var;
        if (varInsn.getOpcode() == 25 && (var = (LocalVariableNode)(vars = m.localVariables).stream().filter(v -> v.index == varInsn.var).findFirst().orElse(null)) != null) {
            String signature = "()" + Optional.ofNullable(var.signature).orElse(var.desc);
            return TypeDescriptorParser.parse(loader, signature);
        }
        return Object.class;
    }

    static Class loadType(ClassLoader loader, String name) {
        return (Class)When.when((Object)name).is((Object)"boolean", Boolean.TYPE).is((Object)"char", Character.TYPE).is((Object)"byte", Byte.TYPE).is((Object)"short", Short.TYPE).is((Object)"int", Integer.TYPE).is((Object)"long", Long.TYPE).is((Object)"float", Float.TYPE).is((Object)"double", Double.TYPE).orElseGet(() -> loader.loadClass(name.replace("/", ".")));
    }

    static java.lang.reflect.Type simplifyType(java.lang.reflect.Type type) {
        Class rawType = MoreTypes.getRawType((java.lang.reflect.Type)type);
        if (Primitives.isWrapperType((Class)rawType)) {
            return Primitives.unwrap((Class)rawType);
        }
        return type;
    }

    static Writer writer(final Logger log, final String owner) {
        return new Writer(){
            StringBuilder buff = new StringBuilder();

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                this.buff.append(cbuf, off, len);
            }

            @Override
            public void flush() throws IOException {
                log.info("{}:\n{}", (Object)owner, (Object)this.buff);
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    private ClassNode loadClass(String name) {
        return (ClassNode)Try.apply(() -> {
            String cname = name.replace("/", ".");
            ClassNode node = this.cache.get(cname);
            if (node == null) {
                String rname = cname.replace(".", "/") + ".class";
                try (InputStream in = this.loader.getResourceAsStream(rname);){
                    if (in == null) {
                        throw new FileNotFoundException(rname + " using " + this.loader);
                    }
                    ClassReader reader = new ClassReader(ByteStreams.toByteArray((InputStream)in));
                    node = new ClassNode();
                    reader.accept(node, 0);
                    this.cache.put(cname, node);
                    if (this.log.isDebugEnabled()) {
                        this.log.info("Source: {}; Class: {}", (Object)node.sourceFile, (Object)node.name);
                        reader.accept(new TraceClassVisitor(null, new ASMifier(), new PrintWriter(BytecodeRouteParser.writer(this.log, name))), 0);
                    }
                }
            }
            return node;
        }).get();
    }

    private static RouteMethod toRouteMethod(Route.Definition route) {
        Method handler = ((Route.MethodHandler)route.filter()).method();
        return new RouteMethod(route.method(), route.pattern(), new RouteResponse(handler.getGenericReturnType())).name(route.name()).parameters(Arrays.asList(handler.getParameters()).stream().filter(SKIP).map(it -> BytecodeRouteParser.toRouteParameter(route.pattern(), it)).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private static RouteParameter toRouteParameter(String pattern, Parameter p) {
        Annotation[] annotations = p.getAnnotations();
        Supplier<String> name = () -> {
            for (int i = 0; i < annotations.length; ++i) {
                Class<? extends Annotation> annotationType = annotations[i].annotationType();
                if (annotationType == Named.class) {
                    return ((Named)annotations[i]).value();
                }
                if (annotationType != Header.class) continue;
                return ((Header)annotations[i]).value();
            }
            return p.getName();
        };
        String pname = name.get();
        Supplier<RouteParameter.Kind> kind = () -> {
            boolean formLike;
            if (p.getType() == Upload.class) {
                return RouteParameter.Kind.FILE;
            }
            for (int i = 0; i < annotations.length; ++i) {
                Class<? extends Annotation> annotationType = annotations[i].annotationType();
                if (annotationType == Header.class) {
                    return RouteParameter.Kind.HEADER;
                }
                if (annotationType != Body.class) continue;
                return RouteParameter.Kind.BODY;
            }
            boolean hasBody = Arrays.asList(p.getDeclaringExecutable().getParameters()).stream().filter(it -> Stream.of(it.getAnnotations()).filter(e -> e.annotationType() == Body.class).findFirst().isPresent()).findFirst().isPresent();
            if (BytecodeRouteParser.isPathParam(pattern, pname)) {
                return RouteParameter.Kind.PATH;
            }
            boolean bl = formLike = !hasBody && p.getDeclaringExecutable().getAnnotation(POST.class) != null;
            if (formLike) {
                return RouteParameter.Kind.FORM;
            }
            return RouteParameter.Kind.QUERY;
        };
        ApiParam apiParam = p.getAnnotation(ApiParam.class);
        String descrition = null;
        String value = null;
        if (apiParam != null) {
            if (apiParam.hidden()) {
                return null;
            }
            descrition = Strings.emptyToNull((String)apiParam.value());
            value = Strings.emptyToNull((String)apiParam.defaultValue());
        }
        return new RouteParameter(pname, kind.get(), p.getParameterizedType(), value).description(descrition);
    }

    static {
        mapper.setVisibility(mapper.getVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE));
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        SimpleModule module = new SimpleModule();
        module.addSerializer(java.lang.reflect.Type.class, (JsonSerializer)new TypeJsonSerializer());
        module.addDeserializer(java.lang.reflect.Type.class, (JsonDeserializer)new TypeJsonDeserializer());
        mapper.registerModule((Module)module);
    }

    private static class TypeWithStatus
    implements java.lang.reflect.Type {
        private final java.lang.reflect.Type forwarding;
        final Integer status;

        TypeWithStatus(java.lang.reflect.Type forwarding, Integer status) {
            this.forwarding = forwarding;
            this.status = status;
        }

        public java.lang.reflect.Type type() {
            if (this.status != null && this.status == 204 && this.forwarding.getTypeName().equals(Result.class.getName())) {
                return Void.TYPE;
            }
            return this.forwarding;
        }

        @Override
        public String getTypeName() {
            return this.forwarding.getTypeName();
        }
    }
}

