/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.apitool.raml;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.inject.internal.MoreTypes;
import io.swagger.converter.ModelConverters;
import io.swagger.models.Model;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooby.MediaType;
import org.jooby.apitool.RouteMethod;
import org.jooby.apitool.RouteParameter;
import org.jooby.apitool.RouteResponse;
import org.jooby.apitool.raml.RamlMethod;
import org.jooby.apitool.raml.RamlParameter;
import org.jooby.apitool.raml.RamlPath;
import org.jooby.apitool.raml.RamlResponse;
import org.jooby.apitool.raml.RamlType;
import org.jooby.internal.apitool.FriendlyTypeName;

public class Raml {
    private String title;
    private String version;
    private String baseUri;
    private List<String> mediaType;
    private List<String> protocols;
    private Map<String, RamlType> types;
    private Map<String, RamlPath> resources = new LinkedHashMap<String, RamlPath>();

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public List<String> getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(List<String> mediaType) {
        this.mediaType = mediaType;
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<String> protocols) {
        this.protocols = protocols;
    }

    public Map<String, RamlType> getTypes() {
        return this.types;
    }

    @JsonAnyGetter
    public Map<String, RamlPath> getResources() {
        return this.resources;
    }

    public RamlPath path(String pattern) {
        RamlPath path = this.resources.get(pattern);
        if (path == null) {
            path = new RamlPath();
            this.resources.put(pattern, path);
        }
        return path;
    }

    public RamlType define(Type javaType, RamlType baseType) {
        Objects.requireNonNull(javaType, "Java type required.");
        Objects.requireNonNull(baseType, "Raml type required.");
        if (this.types == null) {
            this.types = new LinkedHashMap<String, RamlType>();
        }
        String typeName = MoreTypes.getRawType((Type)javaType).getSimpleName();
        RamlType ramlType = new RamlType(baseType.getType(), typeName);
        this.types.put(typeName, ramlType);
        return ramlType;
    }

    public RamlType define(Type type) {
        Type componentType;
        String typeName;
        RamlType ramlType;
        if (this.types == null) {
            this.types = new LinkedHashMap<String, RamlType>();
        }
        if ((ramlType = RamlType.valueOf(typeName = MoreTypes.getRawType((Type)(componentType = this.componentType(type))).getSimpleName())).isObject()) {
            RamlType existing = this.types.get(typeName);
            if (existing == null) {
                ModelConverters converter = ModelConverters.getInstance();
                Property property = converter.readAsProperty(componentType);
                EnumMap args = new EnumMap(PropertyBuilder.PropertyId.class);
                for (Map.Entry entry : converter.readAll(componentType).entrySet()) {
                    this.define((String)entry.getKey(), (Model)entry.getValue());
                }
                ramlType = this.define(typeName, PropertyBuilder.toModel((Property)PropertyBuilder.merge((Property)property, args)));
            } else {
                ramlType = existing;
            }
        }
        return type != componentType ? ramlType.toArray() : ramlType;
    }

    private Type componentType(Type type) {
        Class rawType = MoreTypes.getRawType((Type)type);
        if (rawType.isArray()) {
            return rawType.getComponentType();
        }
        if (Collection.class.isAssignableFrom(rawType) && type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return type;
    }

    private RamlType define(String type, Model model) {
        RamlType definition = this.types.get(type);
        if (definition == null) {
            RamlType object = new RamlType("object", type);
            this.types.put(type, object);
            LinkedHashMap example = new LinkedHashMap();
            Optional.ofNullable(model.getProperties()).ifPresent(properties -> properties.forEach((name, property) -> {
                if (property instanceof RefProperty) {
                    String propertyType = this.propertyType((Property)property);
                    object.newProperty((String)name, propertyType, false, new String[0]);
                } else if (property instanceof ArrayProperty) {
                    String propertyType = this.propertyType(((ArrayProperty)property).getItems()) + "[]";
                    object.newProperty((String)name, propertyType, false, new String[0]);
                } else {
                    String propertyType = this.propertyType((Property)property);
                    List enums = null;
                    if (property instanceof StringProperty) {
                        enums = ((StringProperty)property).getEnum();
                    }
                    RamlType ramlType = RamlType.valueOf(propertyType);
                    object.newProperty((String)name, propertyType, false, Optional.ofNullable(enums).map(it -> it.toArray(new String[it.size()])).orElse(new String[0]));
                    example.put(name, Optional.ofNullable(enums).map(it -> (String)it.get(0)).orElse(ramlType.getExample()));
                }
            }));
            definition = object;
            if (example.values().stream().filter(Objects::nonNull).count() > 0L) {
                object.setExample(example);
            }
        }
        return definition;
    }

    private String propertyType(Property property) {
        RamlType ramlType;
        if (property instanceof RefProperty) {
            return ((RefProperty)property).getSimpleRef();
        }
        String type = property.getType();
        if (property instanceof UUIDProperty) {
            type = UUID.class.getSimpleName();
        }
        return (ramlType = this.types.get(type)) == null ? property.getType() : ramlType.getRef().getType();
    }

    public void setResources(Map<String, RamlPath> resources) {
        this.resources = resources;
    }

    public String toYaml() throws IOException {
        YAMLMapper mapper = new YAMLMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS, false);
        mapper.configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, true);
        return "#%RAML 1.0\n" + mapper.writer().withDefaultPrettyPrinter().writeValueAsString((Object)this);
    }

    public static Raml build(Raml base, List<RouteMethod> routes) {
        Raml raml = Optional.ofNullable(base).orElseGet(Raml::new);
        BiFunction<RamlPath, String, RamlPath> pathFactory = (path, segment) -> path == null ? raml.path((String)segment) : path.path((String)segment);
        BiConsumer<Function, RouteParameter> parameterFactory = (factory, parameter) -> {
            RamlParameter p = (RamlParameter)factory.apply(parameter.name());
            p.setDescription(parameter.description().map(Raml::yamlText).orElse(null));
            List<String> enums = parameter.enums();
            if (enums.size() > 0) {
                p.setType(RamlType.STRING);
                p.setEnum(enums);
            } else {
                p.setType(raml.define(parameter.type()));
            }
            p.setRequired(!parameter.optional());
            p.setDefault(parameter.defaultValue());
        };
        LinkedHashSet alltypes = new LinkedHashSet();
        Consumer<Function> mediaTypes = types -> routes.stream().forEach(r -> ((List)types.apply(r)).forEach(alltypes::add));
        mediaTypes.accept(RouteMethod::consumes);
        mediaTypes.accept(RouteMethod::produces);
        boolean defaultMediaType = false;
        if (alltypes.size() == 0) {
            raml.setMediaType((List<String>)ImmutableList.of((Object)MediaType.json.name()));
            defaultMediaType = true;
        } else if (alltypes.size() == 1) {
            raml.setMediaType((List<String>)ImmutableList.of(alltypes.iterator().next()));
            defaultMediaType = true;
        }
        for (RouteMethod route : routes) {
            List segments = Splitter.on((String)"/").trimResults().omitEmptyStrings().splitToList((CharSequence)route.pattern());
            RamlPath path2 = null;
            for (String segment2 : segments) {
                RamlPath newPath = pathFactory.apply(path2, "/" + segment2);
                if (segment2.startsWith("{") && segment2.endsWith("}")) {
                    String pathvar = segment2.substring(1, segment2.length() - 1);
                    route.parameters().stream().filter(it -> it.kind() == RouteParameter.Kind.PATH).filter(it -> it.name().equals(pathvar)).findFirst().ifPresent(it -> parameterFactory.accept(newPath::uriParameter, (RouteParameter)it));
                }
                path2 = newPath;
            }
            path2 = Optional.ofNullable(path2).orElseGet(() -> raml.path("/"));
            path2.setDescription(route.summary().map(Raml::yamlText).orElse(null));
            RamlMethod method = path2.method(route.method());
            method.setDescription(route.description().map(Raml::yamlText).orElse(null));
            List<RouteParameter> files = route.parameters().stream().filter(it -> it.kind() == RouteParameter.Kind.FILE).collect(Collectors.toList());
            if (files.size() > 0) {
                route.parameters().stream().filter(it -> it.kind() == RouteParameter.Kind.QUERY).forEach(it -> parameterFactory.accept(method::formParameter, (RouteParameter)it));
                files.forEach(it -> {
                    parameterFactory.accept(method::formParameter, (RouteParameter)it);
                    method.setMediaType((List<String>)ImmutableList.of((Object)MediaType.multipart.name()));
                });
            } else {
                route.parameters().stream().filter(it -> it.kind() == RouteParameter.Kind.QUERY).forEach(it -> parameterFactory.accept(method::queryParameter, (RouteParameter)it));
            }
            ImmutableList consumes = route.consumes();
            if (consumes.size() == 0 && !defaultMediaType) {
                consumes = ImmutableList.of((Object)MediaType.json.name());
            }
            method.setMediaType((List<String>)consumes);
            route.parameters().stream().filter(it -> it.kind() == RouteParameter.Kind.HEADER).forEach(it -> parameterFactory.accept(method::headerParameter, (RouteParameter)it));
            route.parameters().stream().filter(it -> it.kind() == RouteParameter.Kind.BODY).forEach(it -> {
                method.setMediaType(route.consumes());
                method.setBody(raml.define(it.type()));
            });
            ImmutableList produces = route.produces();
            if (produces.size() == 0) {
                produces = ImmutableList.of((Object)MediaType.json.name());
            }
            RouteResponse returns = route.response();
            Map<Integer, String> status = returns.status();
            Integer statusCode = returns.statusCode();
            RamlResponse response = method.response(statusCode);
            response.setDescription(Raml.yamlText(returns.description().orElseGet(() -> FriendlyTypeName.name(returns.type()))));
            produces.forEach(type -> response.setMediaType((String)type, raml.define(returns.type())));
            status.entrySet().stream().filter(it -> !statusCode.equals(it.getKey())).forEach(it -> method.response((Integer)it.getKey()).setDescription((String)it.getValue()));
        }
        return raml;
    }

    static String yamlText(String text) {
        return Optional.ofNullable(text).map(lines -> Splitter.on((String)"\n").trimResults().omitEmptyStrings().splitToList((CharSequence)lines).stream().collect(Collectors.joining("\n"))).orElse(null);
    }
}

