/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.apitool;

import com.google.common.base.Strings;
import com.google.inject.internal.MoreTypes;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class RouteParameter {
    private Kind kind;
    private String name;
    private Type type;
    private Object value;
    private String description;
    private List<Object> enums;

    public RouteParameter(String name, Kind kind, Type type, Object value) {
        this.name(name);
        this.kind(kind);
        this.type(type);
        this.defaultValue(value);
    }

    protected RouteParameter() {
    }

    public <T> T accept(Visitor<T> visitor) {
        return this.kind.accept(this, visitor);
    }

    public String name() {
        return this.name;
    }

    public RouteParameter name(String name) {
        this.name = Objects.requireNonNull(name, "Name required.");
        return this;
    }

    public Type type() {
        return this.type;
    }

    public RouteParameter type(Type type) {
        this.type = Objects.requireNonNull(type, "Type required.");
        return this;
    }

    public List<String> enums() {
        return Optional.ofNullable(MoreTypes.getRawType((Type)this.type)).map(Class::getEnumConstants).filter(Objects::nonNull).map(values -> Arrays.asList(values).stream().map(value -> ((Enum)value).name()).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public Object defaultValue() {
        return this.value;
    }

    public RouteParameter defaultValue(Object value) {
        this.value = value;
        return this;
    }

    public Kind kind() {
        return this.kind;
    }

    public RouteParameter kind(Kind kind) {
        this.kind = Objects.requireNonNull(kind, "Kind required.");
        return this;
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public RouteParameter description(String description) {
        this.description = Strings.emptyToNull((String)description);
        return this;
    }

    public boolean optional() {
        return this.value != null || MoreTypes.getRawType((Type)this.type) == Optional.class;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("@").append(this.kind.name().toLowerCase()).append(" ");
        buff.append(this.name);
        buff.append(": ").append(this.type.getTypeName());
        if (this.value != null) {
            buff.append(" = ").append(this.value);
        }
        return buff.toString();
    }

    public static enum Kind {
        QUERY{

            @Override
            public <T> T accept(RouteParameter parameter, Visitor<T> visitor) {
                return visitor.visitQuery(parameter);
            }
        }
        ,
        PATH{

            @Override
            public <T> T accept(RouteParameter parameter, Visitor<T> visitor) {
                return visitor.visitPath(parameter);
            }
        }
        ,
        FORM{

            @Override
            public <T> T accept(RouteParameter parameter, Visitor<T> visitor) {
                return visitor.visitForm(parameter);
            }
        }
        ,
        BODY{

            @Override
            public <T> T accept(RouteParameter parameter, Visitor<T> visitor) {
                return visitor.visitBody(parameter);
            }
        }
        ,
        FILE{

            @Override
            public <T> T accept(RouteParameter parameter, Visitor<T> visitor) {
                return visitor.visitFile(parameter);
            }
        }
        ,
        HEADER{

            @Override
            public <T> T accept(RouteParameter parameter, Visitor<T> visitor) {
                return visitor.visitHeader(parameter);
            }
        };


        public abstract <T> T accept(RouteParameter var1, Visitor<T> var2);
    }

    public static interface Visitor<T> {
        public T visitQuery(RouteParameter var1);

        public T visitPath(RouteParameter var1);

        public T visitForm(RouteParameter var1);

        public T visitBody(RouteParameter var1);

        public T visitFile(RouteParameter var1);

        public T visitHeader(RouteParameter var1);
    }
}

