/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.apitool;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jooby.Route;
import org.jooby.apitool.RouteParameter;
import org.jooby.apitool.RouteResponse;

public class RouteMethod {
    private static final Pattern VAR = Pattern.compile("\\:((?:[^/]+)+?)");
    private RouteResponse response;
    private String method;
    private String pattern;
    private String summary;
    private String name;
    private String description;
    private List<RouteParameter> parameters;
    private List<String> consumes;
    private List<String> produces;
    private Map<String, Object> attributes;

    public RouteMethod(String method, String pattern, RouteResponse returns) {
        this.method(method);
        this.pattern(pattern);
        this.response(returns);
    }

    protected RouteMethod() {
    }

    public String method() {
        return this.method;
    }

    public RouteMethod method(String method) {
        this.method = Objects.requireNonNull(method, "Method required").toUpperCase();
        return this;
    }

    public String pattern() {
        return this.pattern;
    }

    public RouteMethod pattern(String pattern) {
        this.pattern = RouteMethod.rewritePattern(Route.normalize((String)pattern));
        return this;
    }

    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    public RouteMethod name(String name) {
        this.name = Strings.emptyToNull((String)name);
        return this;
    }

    public List<RouteParameter> parameters() {
        return Optional.ofNullable(this.parameters).orElse(Collections.emptyList());
    }

    public RouteMethod parameters(List<RouteParameter> parameters) {
        this.parameters = Objects.requireNonNull(parameters, "Parameters required");
        return this;
    }

    public Optional<String> summary() {
        return Optional.ofNullable(this.summary);
    }

    public RouteMethod summary(String summary) {
        this.summary = Strings.emptyToNull((String)summary);
        return this;
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public RouteMethod description(String description) {
        this.description = Strings.emptyToNull((String)description);
        return this;
    }

    public List<String> consumes() {
        return Optional.ofNullable(this.consumes).orElse(Collections.emptyList());
    }

    public RouteMethod consumes(List<String> consumes) {
        this.consumes = consumes;
        return this;
    }

    public List<String> produces() {
        return Optional.ofNullable(this.produces).orElse(Collections.emptyList());
    }

    public RouteMethod produces(List<String> produces) {
        this.produces = produces;
        return this;
    }

    public RouteResponse response() {
        return this.response;
    }

    public RouteMethod response(RouteResponse response) {
        this.response = Objects.requireNonNull(response, "Response required.");
        return this;
    }

    public Map<String, Object> attributes() {
        return Optional.ofNullable(this.attributes).orElse((Map<String, Object>)ImmutableMap.of());
    }

    public RouteMethod attributes(Map<String, Object> attributes) {
        if (attributes != null) {
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, Object>();
            }
            this.attributes.putAll(attributes);
        }
        return this;
    }

    public RouteMethod attribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, Object>();
        }
        this.attributes.put(name, value);
        return this;
    }

    public RouteMethod param(String name, Consumer<RouteParameter> customizer) {
        this.parameters().stream().filter(p -> name.equals(p.name())).findFirst().ifPresent(customizer);
        return this;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        StringBuilder desc = new StringBuilder();
        buff.append(this.method).append(" ").append(this.pattern);
        if (this.description != null) {
            desc.append("\n    ").append(this.description.replace("\n", "\\n"));
        }
        if (this.parameters != null) {
            buff.append(this.parameters.stream().map(RouteParameter::toString).collect(Collectors.joining(", ", " (", ")")));
            this.parameters.forEach(p -> desc.append("\n      ").append(p.name()).append(": ").append(p.description().orElse("").replace("\n", "\\n")));
        } else {
            buff.append("()");
        }
        buff.append(": ").append(this.response.type().getTypeName());
        buff.append((CharSequence)desc);
        return buff.toString().trim();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RouteMethod) {
            RouteMethod that = (RouteMethod)obj;
            return this.method.equals(that.method) && this.pattern.equals(that.pattern);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.method, this.pattern);
    }

    private static String rewritePattern(String pattern) {
        Matcher matcher = VAR.matcher(pattern);
        StringBuilder result = new StringBuilder();
        int end = 0;
        while (matcher.find()) {
            result.append(pattern, end, matcher.start());
            result.append("{").append(matcher.group(1)).append("}");
            end = matcher.end();
        }
        result.append(pattern, end, pattern.length());
        return result.toString();
    }
}

