/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.apitool;

import com.google.common.io.ByteStreams;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.MediaType;
import org.jooby.Results;
import org.jooby.Route;
import org.jooby.Router;
import org.jooby.apitool.ApiParser;
import org.jooby.apitool.RouteMethod;
import org.jooby.apitool.raml.Raml;
import org.jooby.funzy.Throwing;
import org.jooby.internal.apitool.SwaggerBuilder;

public class ApiTool
implements Jooby.Module {
    static final Function<RouteMethod, String> DEFAULT_TAGGER = r -> {
        Map<String, Object> attributes = r.attributes();
        if (attributes == null) {
            return r.pattern();
        }
        return Stream.of(attributes.get("swagger.tag"), attributes.get("route.tag")).filter(Objects::nonNull).findFirst().map(Objects::toString).orElse(r.pattern());
    };
    private static final TypeLiteral<Set<Route.Definition>> M = new TypeLiteral<Set<Route.Definition>>(){};
    private static final String REDOC = "<!DOCTYPE html>\n<html>\n  <head>\n    <title>%s</title>\n    <!-- needed for adaptive design -->\n    <meta charset=\"utf-8\"/>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\n    <link href=\"https://fonts.googleapis.com/css?family=Montserrat:300,400,700|Roboto:300,400,700\" rel=\"stylesheet\">\n    <style>\n      body {\n        margin: 0;\n        padding: 0;\n      }\n    </style>\n  </head>\n  <body>\n    <redoc spec-url=\"%s\"></redoc>\n    <script src=\"%s\"> </script>\n  </body>\n</html>";
    private static final String RAML_STATIC = "/META-INF/resources/webjars/api-console/3.0.17/dist/";
    private static final String SWAGGER_STATIC = "/META-INF/resources/webjars/swagger-ui/3.17.1/";
    private static final String SWAGGER_THEME = "/META-INF/resources/webjars/swagger-ui-themes/3.0.0/themes/3.x/";
    protected Predicate<RouteMethod> filter = r -> true;
    private Options options = new Options();
    private Options swaggerOptions;
    private Consumer<Swagger> swagger;
    private Options ramlOptions;
    private Consumer<Raml> raml;
    private final Map<Predicate<RouteMethod>, Consumer<RouteMethod>> customizer = new LinkedHashMap<Predicate<RouteMethod>, Consumer<RouteMethod>>();
    private Path basedir;

    public ApiTool(Path basedir) {
        this.basedir = basedir;
    }

    public ApiTool() {
        this(null);
    }

    public void configure(Env env, Config conf, Binder binder) throws Exception {
        boolean useFile = Stream.of(this.swaggerOptions, this.ramlOptions).filter(Objects::nonNull).filter((? super T it) -> it.file != null).findFirst().isPresent();
        Throwing.Function provider = null;
        if (!useFile) {
            Path dir = Optional.ofNullable(this.basedir).orElse(Paths.get(conf.getString("user.dir"), new String[0]));
            ApiParser parser = new ApiParser(dir, this.filter);
            this.customizer.forEach(parser::modify);
            provider = routes -> parser.parseFully(conf.getString("application.class"), new ArrayList<Route.Definition>((Collection<Route.Definition>)routes));
            if (!env.name().equals("dev")) {
                provider = provider.memoized();
            }
            binder.bind(ApiParser.class).toInstance((Object)parser);
        }
        String contextPath = conf.getString("application.path");
        if (this.swaggerOptions != null) {
            ApiTool.swagger(contextPath, env.router(), this.swaggerOptions, conf, this.swagger, provider);
        }
        if (this.ramlOptions != null) {
            ApiTool.raml(contextPath, env.router(), this.ramlOptions, this.raml, provider);
        }
    }

    public Config config() {
        return ConfigFactory.parseResources(ApiTool.class, (String)"apitool.conf");
    }

    public ApiTool filter(Predicate<RouteMethod> predicate) {
        this.filter = predicate;
        return this;
    }

    public ApiTool disableUI() {
        this.options.disableUI();
        return this;
    }

    public ApiTool disableTryIt() {
        this.options.disableTryIt();
        return this;
    }

    public ApiTool swagger() {
        return this.swagger("/swagger");
    }

    public ApiTool redoc() {
        return this.redoc("/redoc");
    }

    public ApiTool redoc(String path) {
        return this.swagger(new Options("/swagger").disableUI().redoc(path));
    }

    public ApiTool swagger(String path) {
        return this.swagger(path, null);
    }

    public ApiTool swagger(Consumer<Swagger> swagger) {
        return this.swagger("/swagger", swagger);
    }

    public ApiTool swagger(String path, Consumer<Swagger> swagger) {
        return this.swagger(new Options(path, this.options), swagger);
    }

    public ApiTool swagger(Options options) {
        return this.swagger(options, null);
    }

    public ApiTool swagger(Options options, Consumer<Swagger> swagger) {
        this.swaggerOptions = Objects.requireNonNull(options, "Options required.");
        this.swagger = swagger;
        return this;
    }

    public ApiTool raml() {
        return this.raml("/raml");
    }

    public ApiTool raml(String path) {
        return this.raml(path, null);
    }

    public ApiTool raml(String path, Consumer<Raml> raml) {
        return this.raml(new Options(path, this.options), raml);
    }

    public ApiTool raml(Options options) {
        return this.raml(options, null);
    }

    public ApiTool raml(Options options, Consumer<Raml> raml) {
        this.ramlOptions = Objects.requireNonNull(options, "Options required.");
        this.raml = raml;
        return this;
    }

    public ApiTool modify(Predicate<RouteMethod> matcher, Consumer<RouteMethod> customizer) {
        this.customizer.put(matcher, customizer);
        return this;
    }

    private static void raml(String contextPath, Router router, Options options, Consumer<Raml> configurer, Throwing.Function<Set<Route.Definition>, List<RouteMethod>> provider) throws IOException {
        String api = options.path + "/api.raml";
        if (options.file == null) {
            router.get(api, req -> {
                Config conf = (Config)req.require(Config.class);
                Map hash = conf.getConfig("raml").root().unwrapped();
                Raml base = (Raml)Json.mapper().convertValue((Object)hash, Raml.class);
                Raml raml = Raml.build(base, (List)provider.apply(req.require(M)));
                if (configurer != null) {
                    configurer.accept(raml);
                }
                return Results.ok((Object)raml.toYaml()).type("text/yml");
            });
        } else {
            byte[] ramlString = ApiTool.readRaml(options.file);
            router.get(api, req -> Results.ok((Object)ramlString).type("text/yml"));
        }
        if (options.showUI) {
            router.assets(options.path + "/static/**", "/META-INF/resources/webjars/api-console/3.0.17/dist/{0}");
            String staticPath = Route.normalize((String)(contextPath + options.path));
            String ramlPath = Route.normalize((String)(contextPath + api));
            String index = ApiTool.fileString("/META-INF/resources/webjars/api-console/3.0.17/dist/index.html").replace("styles/", staticPath + "/static/styles/").replace("scripts/", staticPath + "/static/scripts/").replace("<raml-initializer></raml-initializer>", "<raml-console-loader options=\"{ disableRamlClientGenerator: true, disableThemeSwitcher: true, disableTryIt: " + !options.tryIt + " }\" src=\"" + ramlPath + "\"></raml-console-loader>");
            router.get(options.path, req -> {
                String page = Optional.ofNullable(req.param("theme").value(options.theme)).map(theme -> index.replace("api-console-light-theme.css", "api-console-" + theme + "-theme.css")).orElse(index);
                return Results.ok((Object)page).type(MediaType.html);
            });
        }
    }

    private static void swagger(String contextPath, Router router, Options options, Config conf, Consumer<Swagger> configurer, Throwing.Function<Set<Route.Definition>, List<RouteMethod>> provider) throws IOException {
        if (options.file == null) {
            router.get(options.path + "/swagger.json", options.path + "/swagger.yml", req -> {
                Map hash = conf.getConfig("swagger").root().unwrapped();
                Swagger base = (Swagger)Json.mapper().convertValue((Object)hash, Swagger.class);
                Swagger swagger = new SwaggerBuilder(options.tagger).build(base, (List)provider.apply(req.require(M)));
                boolean json = req.path().endsWith(".json");
                if (configurer != null) {
                    configurer.accept(swagger);
                }
                if (json) {
                    return Results.json((Object)Json.mapper().writer().writeValueAsBytes((Object)swagger));
                }
                return Results.ok((Object)Yaml.mapper().writer().writeValueAsBytes((Object)swagger)).type("text/yml");
            });
        } else {
            Swagger swagger = ApiTool.parseSwagger(options.file);
            if (configurer != null) {
                configurer.accept(swagger);
            }
            router.get(options.path + "/swagger.json", options.path + "/swagger.yml", req -> {
                boolean json = req.path().endsWith(".json");
                if (json) {
                    return Results.json((Object)Json.mapper().writer().writeValueAsBytes((Object)swagger));
                }
                return Results.ok((Object)Yaml.mapper().writer().writeValueAsBytes((Object)swagger)).type("text/yml");
            });
        }
        String swaggerJsonPath = Route.normalize((String)(contextPath + options.path)) + "/swagger.json";
        if (options.showUI) {
            String staticPath = options.path + "/static/";
            router.assets(staticPath + "**", "/META-INF/resources/webjars/swagger-ui/3.17.1/{0}");
            router.assets(staticPath + "**", "/META-INF/resources/webjars/swagger-ui-themes/3.0.0/themes/3.x/{0}");
            String fullStaticPath = Route.normalize((String)(contextPath + staticPath)) + "/";
            String index = ApiTool.fileString("/META-INF/resources/webjars/swagger-ui/3.17.1/index.html").replace("./", fullStaticPath).replace("https://petstore.swagger.io/v2/swagger.json\",", swaggerJsonPath + "\", validatorUrl: null,").replace("</head>", options.tryIt ? "</head>" : "<style> .try-out {display: none;}</style></head>");
            router.get(options.path, req -> {
                String page = Optional.ofNullable(req.param("theme").value(options.theme)).map(theme -> index.replace("<style>", "<link rel=\"stylesheet\" type=\"text/css\" href=\"" + fullStaticPath + "theme-" + theme.toLowerCase() + ".css\">\n<style>")).orElse(index);
                return Results.ok((Object)page).type(MediaType.html);
            });
        }
        if (options.redoc != null) {
            String redocjs = "/redoc-2.0.0-alpha.28.js";
            String redocjsfull = Route.normalize((String)(contextPath + options.redoc + redocjs));
            String redoc = String.format(REDOC, conf.getString("swagger.info.title"), swaggerJsonPath, redocjsfull);
            router.assets(options.redoc + redocjs, "/redoc/" + redocjs);
            router.get(options.redoc, () -> Results.ok((Object)redoc).type(MediaType.html));
        }
    }

    private static Swagger parseSwagger(String location) {
        SwaggerParser parser = new SwaggerParser();
        return parser.read(location);
    }

    private static byte[] readRaml(String location) throws IOException {
        Path path = Paths.get(location, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return Files.readAllBytes(path);
        }
        return ApiTool.fileBytes(location);
    }

    private static String fileString(String name) throws IOException {
        return new String(ApiTool.fileBytes(name), StandardCharsets.UTF_8);
    }

    private static byte[] fileBytes(String name) throws IOException {
        try (InputStream in = ApiTool.class.getResourceAsStream(name);){
            byte[] byArray = ByteStreams.toByteArray((InputStream)in);
            return byArray;
        }
    }

    public static class Options {
        boolean showUI = true;
        boolean tryIt = true;
        String path;
        String theme;
        String file;
        Function<RouteMethod, String> tagger = DEFAULT_TAGGER;
        String redoc;

        private Options() {
        }

        private Options(String path, Options defaults) {
            this(path);
            this.showUI = defaults.showUI;
            this.tryIt = defaults.tryIt;
            this.theme = defaults.theme;
        }

        public Options(String path) {
            this.path = Route.normalize((String)Objects.requireNonNull(path, "Path required."));
        }

        public Options disableUI() {
            this.showUI = false;
            return this;
        }

        public Options disableTryIt() {
            this.tryIt = false;
            return this;
        }

        public Options theme(String theme) {
            this.theme = Objects.requireNonNull(theme, "Theme required.");
            return this;
        }

        public Options use(String file) {
            Objects.requireNonNull(file, "File location required.");
            this.file = file.startsWith("/") ? file : "/" + file;
            return this;
        }

        public Options use(Path file) {
            this.file = Objects.requireNonNull(file, "File location required.").toString();
            return this;
        }

        public Options tagger(Function<RouteMethod, String> tagger) {
            this.tagger = Objects.requireNonNull(tagger, "Swagger tagger required.");
            return this;
        }

        public Options redoc(String path) {
            this.redoc = Route.normalize((String)path);
            return this;
        }

        public Options redoc() {
            return this.redoc("/redoc");
        }
    }
}

